-- MySQL dump 10.13  Distrib 5.6.42, for Linux (x86_64)
--
-- Host: localhost    Database: locabox
-- ------------------------------------------------------
-- Server version	5.6.42

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `llx_accounting_account`
--

DROP TABLE IF EXISTS `llx_accounting_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_account` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_pcg_version` varchar(32) NOT NULL,
  `pcg_type` varchar(20) NOT NULL,
  `pcg_subtype` varchar(20) NOT NULL,
  `account_number` varchar(32) NOT NULL,
  `account_parent` varchar(32) DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `fk_accounting_category` int(11) DEFAULT '0',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_account` (`account_number`,`entity`,`fk_pcg_version`),
  KEY `idx_accounting_account_fk_pcg_version` (`fk_pcg_version`),
  CONSTRAINT `fk_accounting_account_fk_pcg_version` FOREIGN KEY (`fk_pcg_version`) REFERENCES `llx_accounting_system` (`pcg_version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_accounting_account`
--

LOCK TABLES `llx_accounting_account` WRITE;
/*!40000 ALTER TABLE `llx_accounting_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_accounting_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accounting_bookkeeping`
--

DROP TABLE IF EXISTS `llx_accounting_bookkeeping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_bookkeeping` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `doc_date` date NOT NULL,
  `doc_type` varchar(30) NOT NULL,
  `doc_ref` varchar(300) NOT NULL,
  `fk_doc` int(11) NOT NULL,
  `fk_docdet` int(11) NOT NULL,
  `thirdparty_code` varchar(32) DEFAULT NULL,
  `subledger_account` varchar(32) DEFAULT NULL,
  `subledger_label` varchar(255) DEFAULT NULL,
  `numero_compte` varchar(32) NOT NULL,
  `label_compte` varchar(255) NOT NULL,
  `label_operation` varchar(255) DEFAULT NULL,
  `debit` double(24,8) NOT NULL,
  `credit` double(24,8) NOT NULL,
  `montant` double(24,8) NOT NULL,
  `sens` varchar(1) DEFAULT NULL,
  `multicurrency_amount` double(24,8) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `lettering_code` varchar(255) DEFAULT NULL,
  `date_lettering` datetime DEFAULT NULL,
  `date_lim_reglement` datetime DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user` int(11) DEFAULT NULL,
  `code_journal` varchar(32) NOT NULL,
  `journal_label` varchar(255) DEFAULT NULL,
  `piece_num` int(11) NOT NULL,
  `validated` tinyint(4) NOT NULL DEFAULT '0',
  `date_validated` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_accounting_bookkeeping_doc_date` (`doc_date`),
  KEY `idx_accounting_bookkeeping_fk_doc` (`fk_doc`),
  KEY `idx_accounting_bookkeeping_fk_docdet` (`fk_docdet`),
  KEY `idx_accounting_bookkeeping_numero_compte` (`numero_compte`),
  KEY `idx_accounting_bookkeeping_code_journal` (`code_journal`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_accounting_bookkeeping`
--

LOCK TABLES `llx_accounting_bookkeeping` WRITE;
/*!40000 ALTER TABLE `llx_accounting_bookkeeping` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_accounting_bookkeeping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accounting_bookkeeping_tmp`
--

DROP TABLE IF EXISTS `llx_accounting_bookkeeping_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_bookkeeping_tmp` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `doc_date` date NOT NULL,
  `doc_type` varchar(30) NOT NULL,
  `doc_ref` varchar(300) NOT NULL,
  `fk_doc` int(11) NOT NULL,
  `fk_docdet` int(11) NOT NULL,
  `thirdparty_code` varchar(32) DEFAULT NULL,
  `subledger_account` varchar(32) DEFAULT NULL,
  `subledger_label` varchar(255) DEFAULT NULL,
  `numero_compte` varchar(32) DEFAULT NULL,
  `label_compte` varchar(255) NOT NULL,
  `label_operation` varchar(255) DEFAULT NULL,
  `debit` double(24,8) NOT NULL,
  `credit` double(24,8) NOT NULL,
  `montant` double(24,8) NOT NULL,
  `sens` varchar(1) DEFAULT NULL,
  `multicurrency_amount` double(24,8) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `lettering_code` varchar(255) DEFAULT NULL,
  `date_lettering` datetime DEFAULT NULL,
  `date_lim_reglement` datetime DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user` int(11) DEFAULT NULL,
  `code_journal` varchar(32) NOT NULL,
  `journal_label` varchar(255) DEFAULT NULL,
  `piece_num` int(11) NOT NULL,
  `validated` tinyint(4) NOT NULL DEFAULT '0',
  `date_validated` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_accounting_bookkeeping_tmp_doc_date` (`doc_date`),
  KEY `idx_accounting_bookkeeping_tmp_fk_docdet` (`fk_docdet`),
  KEY `idx_accounting_bookkeeping_tmp_numero_compte` (`numero_compte`),
  KEY `idx_accounting_bookkeeping_tmp_code_journal` (`code_journal`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_accounting_bookkeeping_tmp`
--

LOCK TABLES `llx_accounting_bookkeeping_tmp` WRITE;
/*!40000 ALTER TABLE `llx_accounting_bookkeeping_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_accounting_bookkeeping_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accounting_fiscalyear`
--

DROP TABLE IF EXISTS `llx_accounting_fiscalyear`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_fiscalyear` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(128) NOT NULL,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `statut` tinyint(4) NOT NULL DEFAULT '0',
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_accounting_fiscalyear`
--

LOCK TABLES `llx_accounting_fiscalyear` WRITE;
/*!40000 ALTER TABLE `llx_accounting_fiscalyear` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_accounting_fiscalyear` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accounting_journal`
--

DROP TABLE IF EXISTS `llx_accounting_journal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_journal` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `code` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `nature` smallint(6) NOT NULL DEFAULT '1',
  `active` smallint(6) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_journal_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_accounting_journal`
--

LOCK TABLES `llx_accounting_journal` WRITE;
/*!40000 ALTER TABLE `llx_accounting_journal` DISABLE KEYS */;
INSERT INTO `llx_accounting_journal` VALUES (1,1,'VT','Sale Journal',2,1),(2,1,'AC','Purchase Journal',3,1),(3,1,'BQ','Bank Journal',4,1),(4,1,'OD','Other Journal',1,1),(5,1,'AN','Has new Journal',9,1),(6,1,'ER','Expense Report Journal',5,1);
/*!40000 ALTER TABLE `llx_accounting_journal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_accounting_system`
--

DROP TABLE IF EXISTS `llx_accounting_system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_accounting_system` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_country` int(11) DEFAULT NULL,
  `pcg_version` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `active` smallint(6) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_accounting_system_pcg_version` (`pcg_version`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_accounting_system`
--

LOCK TABLES `llx_accounting_system` WRITE;
/*!40000 ALTER TABLE `llx_accounting_system` DISABLE KEYS */;
INSERT INTO `llx_accounting_system` VALUES (1,1,'PCG99-ABREGE','The simple accountancy french plan',1),(2,1,'PCG99-BASE','The base accountancy french plan',1),(3,1,'PCG14-DEV','The developed accountancy french plan 2014',1),(4,2,'PCMN-BASE','The base accountancy belgium plan',1),(5,4,'PCG08-PYME','The PYME accountancy spanish plan',1),(6,6,'PCG_SUISSE','Switzerland plan',1),(7,7,'ENG-BASE','England plan',1),(8,10,'PCT','The Tunisia plan',1),(9,67,'PC-MIPYME','The PYME accountancy Chile plan',1),(10,80,'DK-STD','Standardkontoplan fra SKAT',1),(11,140,'PCN-LUXEMBURG','Plan comptable normalisé Luxembourgeois',1),(12,12,'PCG','The Moroccan chart of accounts',1),(13,49,'SYSCOHADA-BJ','Plan comptable Ouest-Africain',1),(14,60,'SYSCOHADA-BF','Plan comptable Ouest-Africain',1),(15,24,'SYSCOHADA-CM','Plan comptable Ouest-Africain',1),(16,65,'SYSCOHADA-CF','Plan comptable Ouest-Africain',1),(17,71,'SYSCOHADA-KM','Plan comptable Ouest-Africain',1),(18,72,'SYSCOHADA-CG','Plan comptable Ouest-Africain',1),(19,21,'SYSCOHADA-CI','Plan comptable Ouest-Africain',1),(20,16,'SYSCOHADA-GA','Plan comptable Ouest-Africain',1),(21,87,'SYSCOHADA-GQ','Plan comptable Ouest-Africain',1),(22,147,'SYSCOHADA-ML','Plan comptable Ouest-Africain',1),(23,168,'SYSCOHADA-NE','Plan comptable Ouest-Africain',1),(24,73,'SYSCOHADA-CD','Plan comptable Ouest-Africain',1),(25,22,'SYSCOHADA-SN','Plan comptable Ouest-Africain',1),(26,66,'SYSCOHADA-TD','Plan comptable Ouest-Africain',1),(27,15,'SYSCOHADA-TG','Plan comptable Ouest-Africain',1);
/*!40000 ALTER TABLE `llx_accounting_system` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_actioncomm`
--

DROP TABLE IF EXISTS `llx_actioncomm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_actioncomm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datep` datetime DEFAULT NULL,
  `datep2` datetime DEFAULT NULL,
  `fk_action` int(11) DEFAULT NULL,
  `code` varchar(32) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_mod` int(11) DEFAULT NULL,
  `fk_project` int(11) DEFAULT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `fk_contact` int(11) DEFAULT NULL,
  `fk_parent` int(11) NOT NULL DEFAULT '0',
  `fk_user_action` int(11) DEFAULT NULL,
  `fk_user_done` int(11) DEFAULT NULL,
  `transparency` int(11) DEFAULT NULL,
  `priority` smallint(6) DEFAULT NULL,
  `fulldayevent` smallint(6) NOT NULL DEFAULT '0',
  `punctual` smallint(6) NOT NULL DEFAULT '1',
  `percent` smallint(6) NOT NULL DEFAULT '0',
  `location` varchar(128) DEFAULT NULL,
  `durationp` double DEFAULT NULL,
  `label` varchar(255) NOT NULL,
  `note` text,
  `email_subject` varchar(255) DEFAULT NULL,
  `email_msgid` varchar(255) DEFAULT NULL,
  `email_from` varchar(255) DEFAULT NULL,
  `email_sender` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `email_tocc` varchar(255) DEFAULT NULL,
  `email_tobcc` varchar(255) DEFAULT NULL,
  `errors_to` varchar(255) DEFAULT NULL,
  `recurid` varchar(128) DEFAULT NULL,
  `recurrule` varchar(128) DEFAULT NULL,
  `recurdateend` datetime DEFAULT NULL,
  `fk_element` int(11) DEFAULT NULL,
  `elementtype` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_actioncomm_fk_soc` (`fk_soc`),
  KEY `idx_actioncomm_fk_contact` (`fk_contact`),
  KEY `idx_actioncomm_code` (`code`),
  KEY `idx_actioncomm_fk_element` (`fk_element`),
  KEY `idx_actioncomm_fk_user_action` (`fk_user_action`),
  KEY `idx_actioncomm_fk_project` (`fk_project`),
  KEY `idx_actioncomm_datep` (`datep`),
  KEY `idx_actioncomm_datep2` (`datep2`),
  KEY `idx_actioncomm_recurid` (`recurid`),
  KEY `idx_actioncomm_ref_ext` (`ref_ext`)
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_actioncomm`
--

LOCK TABLES `llx_actioncomm` WRITE;
/*!40000 ALTER TABLE `llx_actioncomm` DISABLE KEYS */;
INSERT INTO `llx_actioncomm` VALUES (1,NULL,1,'2018-05-22 06:08:53','2018-05-22 06:08:53',40,'AC_OTH_AUTO','2018-05-22 06:08:53','2018-05-22 06:08:53',1,NULL,NULL,NULL,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Produit A_1_Box37 créé','Produit A_1_Box37 créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'product',NULL,NULL),(2,NULL,1,'2018-05-22 06:11:43','2018-05-22 06:11:43',40,'AC_OTH_AUTO','2018-05-22 06:11:43','2018-05-22 06:11:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_1_Box37 modifié','Produit A_1_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'product',NULL,NULL),(3,NULL,1,'2018-05-22 06:12:14','2018-05-22 06:12:14',40,'AC_OTH_AUTO','2018-05-22 06:12:14','2018-05-22 06:12:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_3_Box37 créé','Produit A_3_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,'product',NULL,NULL),(4,NULL,1,'2018-05-22 06:12:47','2018-05-22 06:12:47',40,'AC_OTH_AUTO','2018-05-22 06:12:47','2018-05-22 06:12:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_3_Box37 modifié','Produit A_3_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,'product',NULL,NULL),(5,NULL,1,'2018-05-22 06:13:19','2018-05-22 06:13:19',40,'AC_OTH_AUTO','2018-05-22 06:13:19','2018-05-22 06:13:19',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_1_Box37 modifié','Produit A_1_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'product',NULL,NULL),(6,NULL,1,'2018-05-22 06:13:32','2018-05-22 06:13:32',40,'AC_OTH_AUTO','2018-05-22 06:13:32','2018-05-22 06:13:32',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_3_Box37 modifié','Produit A_3_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,'product',NULL,NULL),(7,NULL,1,'2018-05-22 06:13:37','2018-05-22 06:13:37',40,'AC_OTH_AUTO','2018-05-22 06:13:37','2018-05-22 06:13:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_3_Box37 modifié','Produit A_3_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,'product',NULL,NULL),(8,NULL,1,'2018-05-22 06:14:04','2018-05-22 06:14:04',40,'AC_OTH_AUTO','2018-05-22 06:14:04','2018-05-22 06:14:04',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_5_Box37 créé','Produit A_5_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,'product',NULL,NULL),(9,NULL,1,'2018-05-22 06:14:19','2018-05-22 06:14:19',40,'AC_OTH_AUTO','2018-05-22 06:14:19','2018-05-22 06:14:19',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_5_Box37 modifié','Produit A_5_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,'product',NULL,NULL),(10,NULL,1,'2018-05-22 06:14:35','2018-05-22 06:14:35',40,'AC_OTH_AUTO','2018-05-22 06:14:35','2018-05-22 06:14:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_7_Box37 créé','Produit A_7_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'product',NULL,NULL),(11,NULL,1,'2018-05-22 06:14:49','2018-05-22 06:14:49',40,'AC_OTH_AUTO','2018-05-22 06:14:49','2018-05-22 06:14:49',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_7_Box37 modifié','Produit A_7_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'product',NULL,NULL),(12,NULL,1,'2018-05-22 06:15:26','2018-05-22 06:15:26',40,'AC_OTH_AUTO','2018-05-22 06:15:26','2018-05-22 06:15:26',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_9_Box37 créé','Produit A_9_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'product',NULL,NULL),(13,NULL,1,'2018-05-22 06:15:35','2018-05-22 06:15:35',40,'AC_OTH_AUTO','2018-05-22 06:15:35','2018-05-22 06:15:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_9_Box37 modifié','Produit A_9_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'product',NULL,NULL),(14,NULL,1,'2018-05-22 06:15:46','2018-05-22 06:15:46',40,'AC_OTH_AUTO','2018-05-22 06:15:46','2018-05-22 06:15:46',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_11_Box37 créé','Produit A_11_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'product',NULL,NULL),(15,NULL,1,'2018-05-22 06:16:02','2018-05-22 06:16:02',40,'AC_OTH_AUTO','2018-05-22 06:16:02','2018-05-22 06:16:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_11_Box37 modifié','Produit A_11_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'product',NULL,NULL),(16,NULL,1,'2018-05-22 06:16:14','2018-05-22 06:16:14',40,'AC_OTH_AUTO','2018-05-22 06:16:14','2018-05-22 06:16:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_13_Box37 créé','Produit A_13_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,'product',NULL,NULL),(17,NULL,1,'2018-05-22 06:16:24','2018-05-22 06:16:24',40,'AC_OTH_AUTO','2018-05-22 06:16:24','2018-05-22 06:16:24',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_13_Box37 modifié','Produit A_13_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,'product',NULL,NULL),(18,NULL,1,'2018-05-22 06:16:34','2018-05-22 06:16:34',40,'AC_OTH_AUTO','2018-05-22 06:16:34','2018-05-22 06:16:34',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_15_Box37 créé','Produit A_15_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8,'product',NULL,NULL),(19,NULL,1,'2018-05-22 06:16:45','2018-05-22 06:16:45',40,'AC_OTH_AUTO','2018-05-22 06:16:45','2018-05-22 06:16:45',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_15_Box37 modifié','Produit A_15_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8,'product',NULL,NULL),(20,NULL,1,'2018-05-22 06:16:58','2018-05-22 06:16:58',40,'AC_OTH_AUTO','2018-05-22 06:16:58','2018-05-22 06:16:58',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_17_Box37 créé','Produit A_17_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,'product',NULL,NULL),(21,NULL,1,'2018-05-22 06:17:08','2018-05-22 06:17:08',40,'AC_OTH_AUTO','2018-05-22 06:17:08','2018-05-22 06:17:08',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_17_Box37 modifié','Produit A_17_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,'product',NULL,NULL),(22,NULL,1,'2018-05-22 06:17:18','2018-05-22 06:17:18',40,'AC_OTH_AUTO','2018-05-22 06:17:18','2018-05-22 06:17:18',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_19_Box37 créé','Produit A_19_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,'product',NULL,NULL),(23,NULL,1,'2018-05-22 06:17:35','2018-05-22 06:17:35',40,'AC_OTH_AUTO','2018-05-22 06:17:35','2018-05-22 06:17:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_19_Box37 modifié','Produit A_19_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,'product',NULL,NULL),(24,NULL,1,'2018-05-22 06:17:44','2018-05-22 06:17:44',40,'AC_OTH_AUTO','2018-05-22 06:17:44','2018-05-22 06:17:44',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_21_Box37 créé','Produit A_21_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11,'product',NULL,NULL),(25,NULL,1,'2018-05-22 06:17:56','2018-05-22 06:17:56',40,'AC_OTH_AUTO','2018-05-22 06:17:56','2018-05-22 06:17:56',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_21_Box37 modifié','Produit A_21_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11,'product',NULL,NULL),(26,NULL,1,'2018-05-22 06:18:08','2018-05-22 06:18:08',40,'AC_OTH_AUTO','2018-05-22 06:18:08','2018-05-22 06:18:08',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_23_Box37 créé','Produit A_23_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12,'product',NULL,NULL),(27,NULL,1,'2018-05-22 06:18:19','2018-05-22 06:18:19',40,'AC_OTH_AUTO','2018-05-22 06:18:19','2018-05-22 06:18:19',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_23_Box37 modifié','Produit A_23_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12,'product',NULL,NULL),(28,NULL,1,'2018-05-22 06:20:00','2018-05-22 06:20:00',40,'AC_OTH_AUTO','2018-05-22 06:20:00','2018-05-22 06:20:00',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_25_Box37 créé','Produit A_25_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13,'product',NULL,NULL),(29,NULL,1,'2018-05-22 06:20:10','2018-05-22 06:20:10',40,'AC_OTH_AUTO','2018-05-22 06:20:10','2018-05-22 06:20:10',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_25_Box37 modifié','Produit A_25_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13,'product',NULL,NULL),(30,NULL,1,'2018-05-22 06:21:22','2018-05-22 06:21:22',40,'AC_OTH_AUTO','2018-05-22 06:21:22','2018-05-22 06:21:22',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_27_Box37 créé','Produit A_27_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14,'product',NULL,NULL),(31,NULL,1,'2018-05-22 06:21:35','2018-05-22 06:21:35',40,'AC_OTH_AUTO','2018-05-22 06:21:35','2018-05-22 06:21:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_27_Box37 modifié','Produit A_27_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14,'product',NULL,NULL),(32,NULL,1,'2018-05-22 06:21:45','2018-05-22 06:21:45',40,'AC_OTH_AUTO','2018-05-22 06:21:45','2018-05-22 06:21:45',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_29_Box37 créé','Produit A_29_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,'product',NULL,NULL),(33,NULL,1,'2018-05-22 06:21:54','2018-05-22 06:21:54',40,'AC_OTH_AUTO','2018-05-22 06:21:54','2018-05-22 06:21:54',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_29_Box37 modifié','Produit A_29_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,'product',NULL,NULL),(34,NULL,1,'2018-05-22 06:24:41','2018-05-22 06:24:41',40,'AC_OTH_AUTO','2018-05-22 06:24:41','2018-05-22 06:24:41',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_31_Box37 créé','Produit A_31_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,'product',NULL,NULL),(35,NULL,1,'2018-05-22 06:25:24','2018-05-22 06:25:24',40,'AC_OTH_AUTO','2018-05-22 06:25:24','2018-05-22 06:25:24',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_31_Box37 modifié','Produit A_31_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,'product',NULL,NULL),(36,NULL,1,'2018-05-22 06:25:37','2018-05-22 06:25:37',40,'AC_OTH_AUTO','2018-05-22 06:25:37','2018-05-22 06:25:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_33_Box37 créé','Produit A_33_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17,'product',NULL,NULL),(37,NULL,1,'2018-05-22 06:25:46','2018-05-22 06:25:46',40,'AC_OTH_AUTO','2018-05-22 06:25:46','2018-05-22 06:25:46',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_33_Box37 modifié','Produit A_33_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17,'product',NULL,NULL),(38,NULL,1,'2018-05-22 06:25:55','2018-05-22 06:25:55',40,'AC_OTH_AUTO','2018-05-22 06:25:55','2018-05-22 06:25:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_35_Box37 créé','Produit A_35_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'product',NULL,NULL),(39,NULL,1,'2018-05-22 06:26:08','2018-05-22 06:26:08',40,'AC_OTH_AUTO','2018-05-22 06:26:08','2018-05-22 06:26:08',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_35_Box37 modifié','Produit A_35_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'product',NULL,NULL),(40,NULL,1,'2018-05-22 06:26:16','2018-05-22 06:26:16',40,'AC_OTH_AUTO','2018-05-22 06:26:16','2018-05-22 06:26:16',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_37_Box37 créé','Produit A_37_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,19,'product',NULL,NULL),(41,NULL,1,'2018-05-22 06:26:28','2018-05-22 06:26:28',40,'AC_OTH_AUTO','2018-05-22 06:26:28','2018-05-22 06:26:28',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_37_Box37 modifié','Produit A_37_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,19,'product',NULL,NULL),(42,NULL,1,'2018-05-22 06:26:36','2018-05-22 06:26:36',40,'AC_OTH_AUTO','2018-05-22 06:26:36','2018-05-22 06:26:36',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_39_Box37 créé','Produit A_39_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,20,'product',NULL,NULL),(43,NULL,1,'2018-05-22 06:26:47','2018-05-22 06:26:47',40,'AC_OTH_AUTO','2018-05-22 06:26:47','2018-05-22 06:26:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_39_Box37 modifié','Produit A_39_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,20,'product',NULL,NULL),(44,NULL,1,'2018-05-22 06:27:51','2018-05-22 06:27:51',40,'AC_OTH_AUTO','2018-05-22 06:27:51','2018-05-22 06:27:51',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_2_Box37 créé','Produit A_2_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,21,'product',NULL,NULL),(45,NULL,1,'2018-05-22 06:28:02','2018-05-22 06:28:02',40,'AC_OTH_AUTO','2018-05-22 06:28:02','2018-05-22 06:28:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_2_Box37 modifié','Produit A_2_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,21,'product',NULL,NULL),(46,NULL,1,'2018-05-22 06:30:01','2018-05-22 06:30:01',40,'AC_OTH_AUTO','2018-05-22 06:30:01','2018-05-22 06:30:01',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_4_Box37 créé','Produit A_4_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,22,'product',NULL,NULL),(47,NULL,1,'2018-05-22 06:30:14','2018-05-22 06:30:14',40,'AC_OTH_AUTO','2018-05-22 06:30:14','2018-05-22 06:30:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_4_Box37 modifié','Produit A_4_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,22,'product',NULL,NULL),(48,NULL,1,'2018-05-22 06:30:23','2018-05-22 06:30:23',40,'AC_OTH_AUTO','2018-05-22 06:30:23','2018-05-22 06:30:23',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_6_Box37 créé','Produit A_6_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,23,'product',NULL,NULL),(49,NULL,1,'2018-05-22 06:30:33','2018-05-22 06:30:33',40,'AC_OTH_AUTO','2018-05-22 06:30:33','2018-05-22 06:30:33',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_6_Box37 modifié','Produit A_6_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,23,'product',NULL,NULL),(50,NULL,1,'2018-05-22 06:30:48','2018-05-22 06:30:48',40,'AC_OTH_AUTO','2018-05-22 06:30:48','2018-05-22 06:30:48',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_8_Box37 créé','Produit A_8_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,24,'product',NULL,NULL),(51,NULL,1,'2018-05-22 06:30:58','2018-05-22 06:30:58',40,'AC_OTH_AUTO','2018-05-22 06:30:58','2018-05-22 06:30:58',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_8_Box37 modifié','Produit A_8_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,24,'product',NULL,NULL),(52,NULL,1,'2018-05-22 06:31:09','2018-05-22 06:31:09',40,'AC_OTH_AUTO','2018-05-22 06:31:09','2018-05-22 06:31:09',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_10_Box37 créé','Produit A_10_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,'product',NULL,NULL),(53,NULL,1,'2018-05-22 06:31:20','2018-05-22 06:31:20',40,'AC_OTH_AUTO','2018-05-22 06:31:20','2018-05-22 06:31:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_10_Box37 modifié','Produit A_10_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,'product',NULL,NULL),(54,NULL,1,'2018-05-22 06:33:17','2018-05-22 06:33:17',40,'AC_OTH_AUTO','2018-05-22 06:33:17','2018-05-22 06:33:17',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_12_Box37 créé','Produit A_12_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,26,'product',NULL,NULL),(55,NULL,1,'2018-05-22 06:33:25','2018-05-22 06:33:25',40,'AC_OTH_AUTO','2018-05-22 06:33:25','2018-05-22 06:33:25',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_12_Box37 modifié','Produit A_12_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,26,'product',NULL,NULL),(56,NULL,1,'2018-05-22 06:33:37','2018-05-22 06:33:37',40,'AC_OTH_AUTO','2018-05-22 06:33:37','2018-05-22 06:33:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_14_Box37 créé','Produit A_14_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,27,'product',NULL,NULL),(57,NULL,1,'2018-05-22 06:33:46','2018-05-22 06:33:46',40,'AC_OTH_AUTO','2018-05-22 06:33:46','2018-05-22 06:33:46',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_14_Box37 modifié','Produit A_14_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,27,'product',NULL,NULL),(58,NULL,1,'2018-05-22 06:33:55','2018-05-22 06:33:55',40,'AC_OTH_AUTO','2018-05-22 06:33:55','2018-05-22 06:33:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_16_Box37 créé','Produit A_16_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,28,'product',NULL,NULL),(59,NULL,1,'2018-05-22 06:34:07','2018-05-22 06:34:07',40,'AC_OTH_AUTO','2018-05-22 06:34:07','2018-05-22 06:34:07',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_16_Box37 modifié','Produit A_16_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,28,'product',NULL,NULL),(60,NULL,1,'2018-05-22 06:34:17','2018-05-22 06:34:17',40,'AC_OTH_AUTO','2018-05-22 06:34:17','2018-05-22 06:34:17',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_18_Box37 créé','Produit A_18_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,'product',NULL,NULL),(61,NULL,1,'2018-05-22 06:34:27','2018-05-22 06:34:27',40,'AC_OTH_AUTO','2018-05-22 06:34:27','2018-05-22 06:34:27',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_18_Box37 modifié','Produit A_18_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,'product',NULL,NULL),(62,NULL,1,'2018-05-22 06:34:36','2018-05-22 06:34:36',40,'AC_OTH_AUTO','2018-05-22 06:34:36','2018-05-22 06:34:36',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_20_Box37 créé','Produit A_20_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,30,'product',NULL,NULL),(63,NULL,1,'2018-05-22 06:37:54','2018-05-22 06:37:54',40,'AC_OTH_AUTO','2018-05-22 06:37:54','2018-05-22 06:37:54',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_20_Box37 modifié','Produit A_20_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,30,'product',NULL,NULL),(64,NULL,1,'2018-05-22 06:38:10','2018-05-22 06:38:10',40,'AC_OTH_AUTO','2018-05-22 06:38:10','2018-05-22 06:38:10',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_22_Box37 créé','Produit A_22_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,'product',NULL,NULL),(65,NULL,1,'2018-05-22 06:38:20','2018-05-22 06:38:20',40,'AC_OTH_AUTO','2018-05-22 06:38:20','2018-05-22 06:38:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_22_Box37 modifié','Produit A_22_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,'product',NULL,NULL),(66,NULL,1,'2018-05-22 06:38:49','2018-05-22 06:38:49',40,'AC_OTH_AUTO','2018-05-22 06:38:49','2018-05-22 06:38:49',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_24_Box37 créé','Produit A_24_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,'product',NULL,NULL),(67,NULL,1,'2018-05-22 06:38:57','2018-05-22 06:38:57',40,'AC_OTH_AUTO','2018-05-22 06:38:57','2018-05-22 06:38:57',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_24_Box37 modifié','Produit A_24_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,'product',NULL,NULL),(68,NULL,1,'2018-05-22 06:39:17','2018-05-22 06:39:17',40,'AC_OTH_AUTO','2018-05-22 06:39:17','2018-05-22 06:39:17',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_26_Box37 créé','Produit A_26_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,33,'product',NULL,NULL),(69,NULL,1,'2018-05-22 06:39:28','2018-05-22 06:39:28',40,'AC_OTH_AUTO','2018-05-22 06:39:28','2018-05-22 06:39:28',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_26_Box37 modifié','Produit A_26_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,33,'product',NULL,NULL),(70,NULL,1,'2018-05-22 06:39:40','2018-05-22 06:39:40',40,'AC_OTH_AUTO','2018-05-22 06:39:40','2018-05-22 06:39:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_28_Box37 créé','Produit A_28_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34,'product',NULL,NULL),(71,NULL,1,'2018-05-22 06:39:51','2018-05-22 06:39:51',40,'AC_OTH_AUTO','2018-05-22 06:39:51','2018-05-22 06:39:51',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_28_Box37 modifié','Produit A_28_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34,'product',NULL,NULL),(72,NULL,1,'2018-05-22 06:40:30','2018-05-22 06:40:30',40,'AC_OTH_AUTO','2018-05-22 06:40:30','2018-05-22 06:40:30',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_30_Box37 créé','Produit A_30_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,'product',NULL,NULL),(73,NULL,1,'2018-05-22 06:40:41','2018-05-22 06:40:41',40,'AC_OTH_AUTO','2018-05-22 06:40:41','2018-05-22 06:40:41',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_30_Box37 modifié','Produit A_30_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,'product',NULL,NULL),(74,NULL,1,'2018-05-22 06:41:20','2018-05-22 06:41:20',40,'AC_OTH_AUTO','2018-05-22 06:41:20','2018-05-22 06:41:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_32_Box37 créé','Produit A_32_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,'product',NULL,NULL),(75,NULL,1,'2018-05-22 06:41:31','2018-05-22 06:41:31',40,'AC_OTH_AUTO','2018-05-22 06:41:31','2018-05-22 06:41:31',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_32_Box37 modifié','Produit A_32_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,'product',NULL,NULL),(76,NULL,1,'2018-05-22 06:41:43','2018-05-22 06:41:43',40,'AC_OTH_AUTO','2018-05-22 06:41:43','2018-05-22 06:41:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_34_Box37 créé','Produit A_34_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,'product',NULL,NULL),(77,NULL,1,'2018-05-22 06:41:58','2018-05-22 06:41:58',40,'AC_OTH_AUTO','2018-05-22 06:41:58','2018-05-22 06:41:58',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_34_Box37 modifié','Produit A_34_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,'product',NULL,NULL),(78,NULL,1,'2018-05-22 06:42:35','2018-05-22 06:42:35',40,'AC_OTH_AUTO','2018-05-22 06:42:35','2018-05-22 06:42:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_36_Box37 créé','Produit A_36_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,'product',NULL,NULL),(79,NULL,1,'2018-05-22 06:42:48','2018-05-22 06:42:48',40,'AC_OTH_AUTO','2018-05-22 06:42:48','2018-05-22 06:42:48',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_36_Box37 modifié','Produit A_36_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,'product',NULL,NULL),(80,NULL,1,'2018-05-22 06:43:13','2018-05-22 06:43:13',40,'AC_OTH_AUTO','2018-05-22 06:43:13','2018-05-22 06:43:13',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_38_Box37 créé','Produit A_38_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,'product',NULL,NULL),(81,NULL,1,'2018-05-22 06:43:22','2018-05-22 06:43:22',40,'AC_OTH_AUTO','2018-05-22 06:43:22','2018-05-22 06:43:22',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_38_Box37 modifié','Produit A_38_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,'product',NULL,NULL),(82,NULL,1,'2018-05-22 06:45:12','2018-05-22 06:45:12',40,'AC_OTH_AUTO','2018-05-22 06:45:12','2018-05-22 06:45:12',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_2_Box40 modifié','Produit A_2_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,21,'product',NULL,NULL),(83,NULL,1,'2018-05-22 06:46:01','2018-05-22 06:46:01',40,'AC_OTH_AUTO','2018-05-22 06:46:01','2018-05-22 06:46:01',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_4_Box40 modifié','Produit A_4_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,22,'product',NULL,NULL),(84,NULL,1,'2018-05-22 06:46:27','2018-05-22 06:46:27',40,'AC_OTH_AUTO','2018-05-22 06:46:27','2018-05-22 06:46:27',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_2_Box40 modifié','Produit A_2_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,21,'product',NULL,NULL),(85,NULL,1,'2018-05-22 06:50:37','2018-05-22 06:50:37',40,'AC_OTH_AUTO','2018-05-22 06:50:37','2018-05-22 06:50:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_6_Box40 modifié','Produit A_6_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,23,'product',NULL,NULL),(86,NULL,1,'2018-05-22 06:51:14','2018-05-22 06:51:14',40,'AC_OTH_AUTO','2018-05-22 06:51:14','2018-05-22 06:51:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_8_Box40 modifié','Produit A_8_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,24,'product',NULL,NULL),(87,NULL,1,'2018-05-22 06:51:25','2018-05-22 06:51:25',40,'AC_OTH_AUTO','2018-05-22 06:51:25','2018-05-22 06:51:25',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_8_Box40 modifié','Produit A_8_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,24,'product',NULL,NULL),(88,NULL,1,'2018-05-22 06:54:02','2018-05-22 06:54:02',40,'AC_OTH_AUTO','2018-05-22 06:54:02','2018-05-22 06:54:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_2_Box40 modifié','Produit A_2_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,21,'product',NULL,NULL),(89,NULL,1,'2018-05-22 06:54:27','2018-05-22 06:54:27',40,'AC_OTH_AUTO','2018-05-22 06:54:27','2018-05-22 06:54:27',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_4_Box40 modifié','Produit A_4_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,22,'product',NULL,NULL),(90,NULL,1,'2018-05-22 06:54:55','2018-05-22 06:54:55',40,'AC_OTH_AUTO','2018-05-22 06:54:55','2018-05-22 06:54:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_6_Box40 modifié','Produit A_6_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,23,'product',NULL,NULL),(91,NULL,1,'2018-05-22 07:19:00','2018-05-22 07:19:00',40,'AC_OTH_AUTO','2018-05-22 07:19:00','2018-05-22 07:19:00',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_10_Box40 modifié','Produit A_10_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,'product',NULL,NULL),(92,NULL,1,'2018-05-22 07:19:07','2018-05-22 07:19:07',40,'AC_OTH_AUTO','2018-05-22 07:19:07','2018-05-22 07:19:07',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_10_Box40 modifié','Produit A_10_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,'product',NULL,NULL),(93,NULL,1,'2018-05-22 07:19:32','2018-05-22 07:19:32',40,'AC_OTH_AUTO','2018-05-22 07:19:32','2018-05-22 07:19:32',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_12_Box40 modifié','Produit A_12_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,26,'product',NULL,NULL),(94,NULL,1,'2018-05-22 07:19:40','2018-05-22 07:19:40',40,'AC_OTH_AUTO','2018-05-22 07:19:40','2018-05-22 07:19:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_12_Box40 modifié','Produit A_12_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,26,'product',NULL,NULL),(95,NULL,1,'2018-05-22 07:19:58','2018-05-22 07:19:58',40,'AC_OTH_AUTO','2018-05-22 07:19:58','2018-05-22 07:19:58',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_10_Box40 modifié','Produit A_10_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,'product',NULL,NULL),(96,NULL,1,'2018-05-22 07:20:25','2018-05-22 07:20:25',40,'AC_OTH_AUTO','2018-05-22 07:20:25','2018-05-22 07:20:25',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_14_Box40 modifié','Produit A_14_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,27,'product',NULL,NULL),(97,NULL,1,'2018-05-22 07:20:32','2018-05-22 07:20:32',40,'AC_OTH_AUTO','2018-05-22 07:20:32','2018-05-22 07:20:32',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_14_Box40 modifié','Produit A_14_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,27,'product',NULL,NULL),(98,NULL,1,'2018-05-22 07:21:02','2018-05-22 07:21:02',40,'AC_OTH_AUTO','2018-05-22 07:21:02','2018-05-22 07:21:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_16_Box40 modifié','Produit A_16_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,28,'product',NULL,NULL),(99,NULL,1,'2018-05-22 07:21:10','2018-05-22 07:21:10',40,'AC_OTH_AUTO','2018-05-22 07:21:10','2018-05-22 07:21:10',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_16_Box40 modifié','Produit A_16_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,28,'product',NULL,NULL),(100,NULL,1,'2018-05-22 07:21:40','2018-05-22 07:21:40',40,'AC_OTH_AUTO','2018-05-22 07:21:40','2018-05-22 07:21:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_18_Box40 modifié','Produit A_18_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,'product',NULL,NULL),(101,NULL,1,'2018-05-22 07:21:47','2018-05-22 07:21:47',40,'AC_OTH_AUTO','2018-05-22 07:21:47','2018-05-22 07:21:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_18_Box40 modifié','Produit A_18_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,'product',NULL,NULL),(102,NULL,1,'2018-05-22 07:22:40','2018-05-22 07:22:40',40,'AC_OTH_AUTO','2018-05-22 07:22:40','2018-05-22 07:22:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_20_Box40 modifié','Produit A_20_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,30,'product',NULL,NULL),(103,NULL,1,'2018-05-22 07:22:47','2018-05-22 07:22:47',40,'AC_OTH_AUTO','2018-05-22 07:22:47','2018-05-22 07:22:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_20_Box40 modifié','Produit A_20_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,30,'product',NULL,NULL),(104,NULL,1,'2018-05-22 07:23:14','2018-05-22 07:23:14',40,'AC_OTH_AUTO','2018-05-22 07:23:14','2018-05-22 07:23:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_22_Box40 modifié','Produit A_22_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,'product',NULL,NULL),(105,NULL,1,'2018-05-22 07:23:20','2018-05-22 07:23:20',40,'AC_OTH_AUTO','2018-05-22 07:23:20','2018-05-22 07:23:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_22_Box40 modifié','Produit A_22_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,'product',NULL,NULL),(106,NULL,1,'2018-05-22 07:23:47','2018-05-22 07:23:47',40,'AC_OTH_AUTO','2018-05-22 07:23:47','2018-05-22 07:23:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_24_Box40 modifié','Produit A_24_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,'product',NULL,NULL),(107,NULL,1,'2018-05-22 07:23:58','2018-05-22 07:23:58',40,'AC_OTH_AUTO','2018-05-22 07:23:58','2018-05-22 07:23:58',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_24_Box40 modifié','Produit A_24_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,'product',NULL,NULL),(108,NULL,1,'2018-05-22 07:24:22','2018-05-22 07:24:22',40,'AC_OTH_AUTO','2018-05-22 07:24:22','2018-05-22 07:24:22',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_26_Box40 modifié','Produit A_26_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,33,'product',NULL,NULL),(109,NULL,1,'2018-05-22 07:24:29','2018-05-22 07:24:29',40,'AC_OTH_AUTO','2018-05-22 07:24:29','2018-05-22 07:24:29',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_26_Box40 modifié','Produit A_26_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,33,'product',NULL,NULL),(110,NULL,1,'2018-05-22 07:24:55','2018-05-22 07:24:55',40,'AC_OTH_AUTO','2018-05-22 07:24:55','2018-05-22 07:24:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_28_Box40 modifié','Produit A_28_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34,'product',NULL,NULL),(111,NULL,1,'2018-05-22 07:25:03','2018-05-22 07:25:03',40,'AC_OTH_AUTO','2018-05-22 07:25:03','2018-05-22 07:25:03',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_28_Box40 modifié','Produit A_28_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34,'product',NULL,NULL),(112,NULL,1,'2018-05-22 07:25:33','2018-05-22 07:25:33',40,'AC_OTH_AUTO','2018-05-22 07:25:33','2018-05-22 07:25:33',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_30_Box40 modifié','Produit A_30_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,'product',NULL,NULL),(113,NULL,1,'2018-05-22 07:25:40','2018-05-22 07:25:40',40,'AC_OTH_AUTO','2018-05-22 07:25:40','2018-05-22 07:25:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_30_Box40 modifié','Produit A_30_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,'product',NULL,NULL),(114,NULL,1,'2018-05-22 07:26:07','2018-05-22 07:26:07',40,'AC_OTH_AUTO','2018-05-22 07:26:07','2018-05-22 07:26:07',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_32_Box40 modifié','Produit A_32_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,'product',NULL,NULL),(115,NULL,1,'2018-05-22 07:26:13','2018-05-22 07:26:13',40,'AC_OTH_AUTO','2018-05-22 07:26:13','2018-05-22 07:26:13',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_32_Box40 modifié','Produit A_32_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,'product',NULL,NULL),(116,NULL,1,'2018-05-22 07:26:40','2018-05-22 07:26:40',40,'AC_OTH_AUTO','2018-05-22 07:26:40','2018-05-22 07:26:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_34_Box40 modifié','Produit A_34_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,'product',NULL,NULL),(117,NULL,1,'2018-05-22 07:26:47','2018-05-22 07:26:47',40,'AC_OTH_AUTO','2018-05-22 07:26:47','2018-05-22 07:26:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_34_Box40 modifié','Produit A_34_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,'product',NULL,NULL),(118,NULL,1,'2018-05-22 07:27:10','2018-05-22 07:27:10',40,'AC_OTH_AUTO','2018-05-22 07:27:10','2018-05-22 07:27:10',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_36_Box40 modifié','Produit A_36_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,'product',NULL,NULL),(119,NULL,1,'2018-05-22 07:27:21','2018-05-22 07:27:21',40,'AC_OTH_AUTO','2018-05-22 07:27:21','2018-05-22 07:27:21',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_36_Box40 modifié','Produit A_36_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,'product',NULL,NULL),(120,NULL,1,'2018-05-22 07:27:47','2018-05-22 07:27:47',40,'AC_OTH_AUTO','2018-05-22 07:27:47','2018-05-22 07:27:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_38_Box40 modifié','Produit A_38_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,'product',NULL,NULL),(121,NULL,1,'2018-05-22 07:27:55','2018-05-22 07:27:55',40,'AC_OTH_AUTO','2018-05-22 07:27:55','2018-05-22 07:27:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit A_38_Box40 modifié','Produit A_38_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,'product',NULL,NULL),(122,NULL,1,'2018-05-22 07:28:47','2018-05-22 07:28:47',40,'AC_OTH_AUTO','2018-05-22 07:28:47','2018-05-22 07:28:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_1_Box40 créé','Produit B_1_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40,'product',NULL,NULL),(123,NULL,1,'2018-05-22 07:29:02','2018-05-22 07:29:02',40,'AC_OTH_AUTO','2018-05-22 07:29:02','2018-05-22 07:29:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_1_Box40 modifié','Produit B_1_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40,'product',NULL,NULL),(124,NULL,1,'2018-05-22 07:29:27','2018-05-22 07:29:27',40,'AC_OTH_AUTO','2018-05-22 07:29:27','2018-05-22 07:29:27',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_3_Box40 créé','Produit B_3_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,'product',NULL,NULL),(125,NULL,1,'2018-05-22 07:29:38','2018-05-22 07:29:38',40,'AC_OTH_AUTO','2018-05-22 07:29:38','2018-05-22 07:29:38',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_3_Box40 modifié','Produit B_3_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,'product',NULL,NULL),(126,NULL,1,'2018-05-22 07:30:30','2018-05-22 07:30:30',40,'AC_OTH_AUTO','2018-05-22 07:30:30','2018-05-22 07:30:30',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_5_Box40 créé','Produit B_5_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42,'product',NULL,NULL),(127,NULL,1,'2018-05-22 07:30:41','2018-05-22 07:30:41',40,'AC_OTH_AUTO','2018-05-22 07:30:41','2018-05-22 07:30:41',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_5_Box40 modifié','Produit B_5_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42,'product',NULL,NULL),(128,NULL,1,'2018-05-22 07:30:58','2018-05-22 07:30:58',40,'AC_OTH_AUTO','2018-05-22 07:30:58','2018-05-22 07:30:58',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_7_Box40 créé','Produit B_7_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,43,'product',NULL,NULL),(129,NULL,1,'2018-05-22 07:31:09','2018-05-22 07:31:09',40,'AC_OTH_AUTO','2018-05-22 07:31:09','2018-05-22 07:31:09',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_7_Box40 modifié','Produit B_7_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,43,'product',NULL,NULL),(130,NULL,1,'2018-05-22 07:31:17','2018-05-22 07:31:17',40,'AC_OTH_AUTO','2018-05-22 07:31:17','2018-05-22 07:31:17',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_9_Box40 créé','Produit B_9_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44,'product',NULL,NULL),(131,NULL,1,'2018-05-22 07:31:29','2018-05-22 07:31:29',40,'AC_OTH_AUTO','2018-05-22 07:31:29','2018-05-22 07:31:29',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_9_Box40 modifié','Produit B_9_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44,'product',NULL,NULL),(132,NULL,1,'2018-05-22 07:31:37','2018-05-22 07:31:37',40,'AC_OTH_AUTO','2018-05-22 07:31:37','2018-05-22 07:31:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_11_Box40 créé','Produit B_11_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45,'product',NULL,NULL),(133,NULL,1,'2018-05-22 07:31:45','2018-05-22 07:31:45',40,'AC_OTH_AUTO','2018-05-22 07:31:45','2018-05-22 07:31:45',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_11_Box40 modifié','Produit B_11_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45,'product',NULL,NULL),(134,NULL,1,'2018-05-22 07:31:54','2018-05-22 07:31:54',40,'AC_OTH_AUTO','2018-05-22 07:31:54','2018-05-22 07:31:54',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_13_Box40 créé','Produit B_13_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46,'product',NULL,NULL),(135,NULL,1,'2018-05-22 07:32:05','2018-05-22 07:32:05',40,'AC_OTH_AUTO','2018-05-22 07:32:05','2018-05-22 07:32:05',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_13_Box40 modifié','Produit B_13_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46,'product',NULL,NULL),(136,NULL,1,'2018-05-22 07:32:17','2018-05-22 07:32:17',40,'AC_OTH_AUTO','2018-05-22 07:32:17','2018-05-22 07:32:17',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_15_Box40 créé','Produit B_15_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47,'product',NULL,NULL),(137,NULL,1,'2018-05-22 07:32:26','2018-05-22 07:32:26',40,'AC_OTH_AUTO','2018-05-22 07:32:26','2018-05-22 07:32:26',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_15_Box40 modifié','Produit B_15_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47,'product',NULL,NULL),(138,NULL,1,'2018-05-22 07:32:37','2018-05-22 07:32:37',40,'AC_OTH_AUTO','2018-05-22 07:32:37','2018-05-22 07:32:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_17_Box40 créé','Produit B_17_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48,'product',NULL,NULL),(139,NULL,1,'2018-05-22 07:32:48','2018-05-22 07:32:48',40,'AC_OTH_AUTO','2018-05-22 07:32:48','2018-05-22 07:32:48',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_17_Box40 modifié','Produit B_17_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48,'product',NULL,NULL),(140,NULL,1,'2018-05-22 07:33:00','2018-05-22 07:33:00',40,'AC_OTH_AUTO','2018-05-22 07:33:00','2018-05-22 07:33:00',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_19_Box40 créé','Produit B_19_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49,'product',NULL,NULL),(141,NULL,1,'2018-05-22 07:33:10','2018-05-22 07:33:10',40,'AC_OTH_AUTO','2018-05-22 07:33:10','2018-05-22 07:33:10',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_19_Box40 modifié','Produit B_19_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49,'product',NULL,NULL),(142,NULL,1,'2018-05-22 07:33:35','2018-05-22 07:33:35',40,'AC_OTH_AUTO','2018-05-22 07:33:35','2018-05-22 07:33:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_21_Box40 créé','Produit B_21_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50,'product',NULL,NULL),(143,NULL,1,'2018-05-22 07:33:45','2018-05-22 07:33:45',40,'AC_OTH_AUTO','2018-05-22 07:33:45','2018-05-22 07:33:45',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_21_Box40 modifié','Produit B_21_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50,'product',NULL,NULL),(144,NULL,1,'2018-05-22 07:33:54','2018-05-22 07:33:54',40,'AC_OTH_AUTO','2018-05-22 07:33:54','2018-05-22 07:33:54',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_23_Box40 créé','Produit B_23_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51,'product',NULL,NULL),(145,NULL,1,'2018-05-22 07:34:02','2018-05-22 07:34:02',40,'AC_OTH_AUTO','2018-05-22 07:34:02','2018-05-22 07:34:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_23_Box40 modifié','Produit B_23_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51,'product',NULL,NULL),(146,NULL,1,'2018-05-22 07:34:13','2018-05-22 07:34:13',40,'AC_OTH_AUTO','2018-05-22 07:34:13','2018-05-22 07:34:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_25_Box40 créé','Produit B_25_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52,'product',NULL,NULL),(147,NULL,1,'2018-05-22 07:34:25','2018-05-22 07:34:25',40,'AC_OTH_AUTO','2018-05-22 07:34:25','2018-05-22 07:34:25',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_25_Box40 modifié','Produit B_25_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52,'product',NULL,NULL),(148,NULL,1,'2018-05-22 07:34:36','2018-05-22 07:34:36',40,'AC_OTH_AUTO','2018-05-22 07:34:36','2018-05-22 07:34:36',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_27_Box40 créé','Produit B_27_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53,'product',NULL,NULL),(149,NULL,1,'2018-05-22 07:34:43','2018-05-22 07:34:43',40,'AC_OTH_AUTO','2018-05-22 07:34:43','2018-05-22 07:34:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_27_Box40 modifié','Produit B_27_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53,'product',NULL,NULL),(150,NULL,1,'2018-05-22 07:34:53','2018-05-22 07:34:53',40,'AC_OTH_AUTO','2018-05-22 07:34:53','2018-05-22 07:34:53',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_29_Box40 créé','Produit B_29_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54,'product',NULL,NULL),(151,NULL,1,'2018-05-22 07:35:06','2018-05-22 07:35:06',40,'AC_OTH_AUTO','2018-05-22 07:35:06','2018-05-22 07:35:06',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_29_Box40 modifié','Produit B_29_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54,'product',NULL,NULL),(152,NULL,1,'2018-05-22 07:35:14','2018-05-22 07:35:14',40,'AC_OTH_AUTO','2018-05-22 07:35:15','2018-05-22 07:35:15',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_31_Box40 créé','Produit B_31_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,55,'product',NULL,NULL),(153,NULL,1,'2018-05-22 07:35:23','2018-05-22 07:35:23',40,'AC_OTH_AUTO','2018-05-22 07:35:23','2018-05-22 07:35:23',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_31_Box40 modifié','Produit B_31_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,55,'product',NULL,NULL),(154,NULL,1,'2018-05-22 07:35:32','2018-05-22 07:35:32',40,'AC_OTH_AUTO','2018-05-22 07:35:32','2018-05-22 07:35:32',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_33_Box40 créé','Produit B_33_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56,'product',NULL,NULL),(155,NULL,1,'2018-05-22 07:35:40','2018-05-22 07:35:40',40,'AC_OTH_AUTO','2018-05-22 07:35:40','2018-05-22 07:35:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_33_Box40 modifié','Produit B_33_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56,'product',NULL,NULL),(156,NULL,1,'2018-05-22 07:35:52','2018-05-22 07:35:52',40,'AC_OTH_AUTO','2018-05-22 07:35:52','2018-05-22 07:35:52',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_35_Box40 créé','Produit B_35_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,57,'product',NULL,NULL),(157,NULL,1,'2018-05-22 07:36:02','2018-05-22 07:36:02',40,'AC_OTH_AUTO','2018-05-22 07:36:02','2018-05-22 07:36:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_35_Box40 modifié','Produit B_35_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,57,'product',NULL,NULL),(158,NULL,1,'2018-05-22 07:36:17','2018-05-22 07:36:17',40,'AC_OTH_AUTO','2018-05-22 07:36:17','2018-05-22 07:36:17',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_37_Box40 créé','Produit B_37_Box40 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,58,'product',NULL,NULL),(159,NULL,1,'2018-05-22 07:36:31','2018-05-22 07:36:31',40,'AC_OTH_AUTO','2018-05-22 07:36:31','2018-05-22 07:36:31',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_37_Box40 modifié','Produit B_37_Box40 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,58,'product',NULL,NULL),(160,NULL,1,'2018-05-22 07:37:19','2018-05-22 07:37:19',40,'AC_OTH_AUTO','2018-05-22 07:37:19','2018-05-22 07:37:19',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_2_Box37 créé','Produit B_2_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59,'product',NULL,NULL),(161,NULL,1,'2018-05-22 07:37:33','2018-05-22 07:37:33',40,'AC_OTH_AUTO','2018-05-22 07:37:33','2018-05-22 07:37:33',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_2_Box37 modifié','Produit B_2_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59,'product',NULL,NULL),(162,NULL,1,'2018-05-22 07:37:42','2018-05-22 07:37:42',40,'AC_OTH_AUTO','2018-05-22 07:37:42','2018-05-22 07:37:42',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_4_Box37 créé','Produit B_4_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60,'product',NULL,NULL),(163,NULL,1,'2018-05-22 07:37:52','2018-05-22 07:37:52',40,'AC_OTH_AUTO','2018-05-22 07:37:52','2018-05-22 07:37:52',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_4_Box37 modifié','Produit B_4_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60,'product',NULL,NULL),(164,NULL,1,'2018-05-22 07:37:59','2018-05-22 07:37:59',40,'AC_OTH_AUTO','2018-05-22 07:37:59','2018-05-22 07:37:59',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_6_Box37 créé','Produit B_6_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,61,'product',NULL,NULL),(165,NULL,1,'2018-05-22 07:38:09','2018-05-22 07:38:09',40,'AC_OTH_AUTO','2018-05-22 07:38:09','2018-05-22 07:38:09',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_6_Box37 modifié','Produit B_6_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,61,'product',NULL,NULL),(166,NULL,1,'2018-05-22 07:38:20','2018-05-22 07:38:20',40,'AC_OTH_AUTO','2018-05-22 07:38:20','2018-05-22 07:38:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_8_Box37 créé','Produit B_8_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62,'product',NULL,NULL),(167,NULL,1,'2018-05-22 07:38:29','2018-05-22 07:38:29',40,'AC_OTH_AUTO','2018-05-22 07:38:29','2018-05-22 07:38:29',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_8_Box37 modifié','Produit B_8_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62,'product',NULL,NULL),(168,NULL,1,'2018-05-22 07:38:37','2018-05-22 07:38:37',40,'AC_OTH_AUTO','2018-05-22 07:38:37','2018-05-22 07:38:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_10_Box37 créé','Produit B_10_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63,'product',NULL,NULL),(169,NULL,1,'2018-05-22 07:38:46','2018-05-22 07:38:46',40,'AC_OTH_AUTO','2018-05-22 07:38:46','2018-05-22 07:38:46',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_10_Box37 modifié','Produit B_10_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63,'product',NULL,NULL),(170,NULL,1,'2018-05-22 07:39:02','2018-05-22 07:39:02',40,'AC_OTH_AUTO','2018-05-22 07:39:02','2018-05-22 07:39:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_12_Box37 créé','Produit B_12_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,'product',NULL,NULL),(171,NULL,1,'2018-05-22 07:39:11','2018-05-22 07:39:11',40,'AC_OTH_AUTO','2018-05-22 07:39:11','2018-05-22 07:39:11',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_12_Box37 modifié','Produit B_12_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,'product',NULL,NULL),(172,NULL,1,'2018-05-22 07:39:19','2018-05-22 07:39:19',40,'AC_OTH_AUTO','2018-05-22 07:39:19','2018-05-22 07:39:19',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_14_Box37 créé','Produit B_14_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65,'product',NULL,NULL),(173,NULL,1,'2018-05-22 07:39:27','2018-05-22 07:39:27',40,'AC_OTH_AUTO','2018-05-22 07:39:27','2018-05-22 07:39:27',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_14_Box37 modifié','Produit B_14_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65,'product',NULL,NULL),(174,NULL,1,'2018-05-22 07:39:35','2018-05-22 07:39:35',40,'AC_OTH_AUTO','2018-05-22 07:39:35','2018-05-22 07:39:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_16_Box37 créé','Produit B_16_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66,'product',NULL,NULL),(175,NULL,1,'2018-05-22 07:39:43','2018-05-22 07:39:43',40,'AC_OTH_AUTO','2018-05-22 07:39:43','2018-05-22 07:39:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_16_Box37 modifié','Produit B_16_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66,'product',NULL,NULL),(176,NULL,1,'2018-05-22 07:39:51','2018-05-22 07:39:51',40,'AC_OTH_AUTO','2018-05-22 07:39:51','2018-05-22 07:39:51',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_18_Box37 créé','Produit B_18_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67,'product',NULL,NULL),(177,NULL,1,'2018-05-22 07:40:01','2018-05-22 07:40:01',40,'AC_OTH_AUTO','2018-05-22 07:40:01','2018-05-22 07:40:01',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_18_Box37 modifié','Produit B_18_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67,'product',NULL,NULL),(178,NULL,1,'2018-05-22 07:40:24','2018-05-22 07:40:24',40,'AC_OTH_AUTO','2018-05-22 07:40:24','2018-05-22 07:40:24',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_20_Box37 créé','Produit B_20_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68,'product',NULL,NULL),(179,NULL,1,'2018-05-22 07:40:33','2018-05-22 07:40:33',40,'AC_OTH_AUTO','2018-05-22 07:40:33','2018-05-22 07:40:33',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_20_Box37 modifié','Produit B_20_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68,'product',NULL,NULL),(180,NULL,1,'2018-05-22 07:40:41','2018-05-22 07:40:41',40,'AC_OTH_AUTO','2018-05-22 07:40:41','2018-05-22 07:40:41',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_22_Box37 créé','Produit B_22_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,69,'product',NULL,NULL),(181,NULL,1,'2018-05-22 07:40:49','2018-05-22 07:40:49',40,'AC_OTH_AUTO','2018-05-22 07:40:49','2018-05-22 07:40:49',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_22_Box37 modifié','Produit B_22_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,69,'product',NULL,NULL),(182,NULL,1,'2018-05-22 07:40:59','2018-05-22 07:40:59',40,'AC_OTH_AUTO','2018-05-22 07:40:59','2018-05-22 07:40:59',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_24_Box37 créé','Produit B_24_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,70,'product',NULL,NULL),(183,NULL,1,'2018-05-22 07:41:07','2018-05-22 07:41:07',40,'AC_OTH_AUTO','2018-05-22 07:41:07','2018-05-22 07:41:07',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_24_Box37 modifié','Produit B_24_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,70,'product',NULL,NULL),(184,NULL,1,'2018-05-22 07:41:18','2018-05-22 07:41:18',40,'AC_OTH_AUTO','2018-05-22 07:41:18','2018-05-22 07:41:18',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_26_Box37 créé','Produit B_26_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,71,'product',NULL,NULL),(185,NULL,1,'2018-05-22 07:41:24','2018-05-22 07:41:24',40,'AC_OTH_AUTO','2018-05-22 07:41:24','2018-05-22 07:41:24',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_26_Box37 modifié','Produit B_26_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,71,'product',NULL,NULL),(186,NULL,1,'2018-05-22 07:41:33','2018-05-22 07:41:33',40,'AC_OTH_AUTO','2018-05-22 07:41:33','2018-05-22 07:41:33',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_28_Box37 créé','Produit B_28_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,72,'product',NULL,NULL),(187,NULL,1,'2018-05-22 07:41:40','2018-05-22 07:41:40',40,'AC_OTH_AUTO','2018-05-22 07:41:40','2018-05-22 07:41:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_28_Box37 modifié','Produit B_28_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,72,'product',NULL,NULL),(188,NULL,1,'2018-05-22 07:41:49','2018-05-22 07:41:49',40,'AC_OTH_AUTO','2018-05-22 07:41:49','2018-05-22 07:41:49',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_30_Box37 créé','Produit B_30_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,73,'product',NULL,NULL),(189,NULL,1,'2018-05-22 07:41:59','2018-05-22 07:41:59',40,'AC_OTH_AUTO','2018-05-22 07:41:59','2018-05-22 07:41:59',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_30_Box37 modifié','Produit B_30_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,73,'product',NULL,NULL),(190,NULL,1,'2018-05-22 07:42:07','2018-05-22 07:42:07',40,'AC_OTH_AUTO','2018-05-22 07:42:07','2018-05-22 07:42:07',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_32_Box37 créé','Produit B_32_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,74,'product',NULL,NULL),(191,NULL,1,'2018-05-22 07:42:14','2018-05-22 07:42:14',40,'AC_OTH_AUTO','2018-05-22 07:42:14','2018-05-22 07:42:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_32_Box37 modifié','Produit B_32_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,74,'product',NULL,NULL),(192,NULL,1,'2018-05-22 07:42:23','2018-05-22 07:42:23',40,'AC_OTH_AUTO','2018-05-22 07:42:23','2018-05-22 07:42:24',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_34_Box37 créé','Produit B_34_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,75,'product',NULL,NULL),(193,NULL,1,'2018-05-22 07:42:35','2018-05-22 07:42:35',40,'AC_OTH_AUTO','2018-05-22 07:42:35','2018-05-22 07:42:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_34_Box37 modifié','Produit B_34_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,75,'product',NULL,NULL),(194,NULL,1,'2018-05-22 07:42:47','2018-05-22 07:42:47',40,'AC_OTH_AUTO','2018-05-22 07:42:47','2018-05-22 07:42:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_36_Box37 créé','Produit B_36_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,76,'product',NULL,NULL),(195,NULL,1,'2018-05-22 07:42:55','2018-05-22 07:42:55',40,'AC_OTH_AUTO','2018-05-22 07:42:55','2018-05-22 07:42:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_36_Box37 modifié','Produit B_36_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,76,'product',NULL,NULL),(196,NULL,1,'2018-05-22 07:43:10','2018-05-22 07:43:10',40,'AC_OTH_AUTO','2018-05-22 07:43:10','2018-05-22 07:43:10',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_38_Box37 créé','Produit B_38_Box37 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,77,'product',NULL,NULL),(197,NULL,1,'2018-05-22 07:43:19','2018-05-22 07:43:19',40,'AC_OTH_AUTO','2018-05-22 07:43:19','2018-05-22 07:43:19',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit B_38_Box37 modifié','Produit B_38_Box37 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,77,'product',NULL,NULL),(198,NULL,1,'2018-05-22 07:54:02','2018-05-22 07:54:02',40,'AC_OTH_AUTO','2018-05-22 07:54:02','2018-05-22 07:54:02',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_1_Box11 créé','Produit C_1_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,78,'product',NULL,NULL),(199,NULL,1,'2018-05-22 07:54:32','2018-05-22 07:54:32',40,'AC_OTH_AUTO','2018-05-22 07:54:32','2018-05-22 07:54:32',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_1_Box11 modifié','Produit C_1_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,78,'product',NULL,NULL),(200,NULL,1,'2018-05-22 07:54:42','2018-05-22 07:54:42',40,'AC_OTH_AUTO','2018-05-22 07:54:42','2018-05-22 07:54:42',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_1_Box11 modifié','Produit C_1_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,78,'product',NULL,NULL),(201,NULL,1,'2018-05-22 07:56:21','2018-05-22 07:56:21',40,'AC_OTH_AUTO','2018-05-22 07:56:21','2018-05-22 07:56:21',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_3_Box11 créé','Produit C_3_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,79,'product',NULL,NULL),(202,NULL,1,'2018-05-22 07:56:35','2018-05-22 07:56:35',40,'AC_OTH_AUTO','2018-05-22 07:56:35','2018-05-22 07:56:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_3_Box11 modifié','Produit C_3_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,79,'product',NULL,NULL),(203,NULL,1,'2018-05-22 07:56:52','2018-05-22 07:56:52',40,'AC_OTH_AUTO','2018-05-22 07:56:52','2018-05-22 07:56:52',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_2_Box11 créé','Produit C_2_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,80,'product',NULL,NULL),(204,NULL,1,'2018-05-22 07:57:01','2018-05-22 07:57:01',40,'AC_OTH_AUTO','2018-05-22 07:57:01','2018-05-22 07:57:01',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_2_Box11 modifié','Produit C_2_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,80,'product',NULL,NULL),(205,NULL,1,'2018-05-22 07:57:09','2018-05-22 07:57:09',40,'AC_OTH_AUTO','2018-05-22 07:57:09','2018-05-22 07:57:09',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_4_Box11 créé','Produit C_4_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,81,'product',NULL,NULL),(206,NULL,1,'2018-05-22 07:57:18','2018-05-22 07:57:18',40,'AC_OTH_AUTO','2018-05-22 07:57:18','2018-05-22 07:57:18',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_4_Box11 modifié','Produit C_4_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,81,'product',NULL,NULL),(207,NULL,1,'2018-05-22 07:57:35','2018-05-22 07:57:35',40,'AC_OTH_AUTO','2018-05-22 07:57:35','2018-05-22 07:57:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_1_Box11 créé','Produit D_1_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,82,'product',NULL,NULL),(208,NULL,1,'2018-05-22 07:57:46','2018-05-22 07:57:46',40,'AC_OTH_AUTO','2018-05-22 07:57:46','2018-05-22 07:57:46',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_1_Box11 modifié','Produit D_1_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,82,'product',NULL,NULL),(209,NULL,1,'2018-05-22 07:57:56','2018-05-22 07:57:56',40,'AC_OTH_AUTO','2018-05-22 07:57:56','2018-05-22 07:57:56',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_3_Box11 créé','Produit D_3_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,83,'product',NULL,NULL),(210,NULL,1,'2018-05-22 07:58:04','2018-05-22 07:58:04',40,'AC_OTH_AUTO','2018-05-22 07:58:04','2018-05-22 07:58:04',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_3_Box11 modifié','Produit D_3_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,83,'product',NULL,NULL),(211,NULL,1,'2018-05-22 07:58:18','2018-05-22 07:58:18',40,'AC_OTH_AUTO','2018-05-22 07:58:18','2018-05-22 07:58:18',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_2_Box11 créé','Produit D_2_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,84,'product',NULL,NULL),(212,NULL,1,'2018-05-22 07:58:27','2018-05-22 07:58:27',40,'AC_OTH_AUTO','2018-05-22 07:58:27','2018-05-22 07:58:27',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_2_Box11 modifié','Produit D_2_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,84,'product',NULL,NULL),(213,NULL,1,'2018-05-22 07:58:35','2018-05-22 07:58:35',40,'AC_OTH_AUTO','2018-05-22 07:58:35','2018-05-22 07:58:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_4_Box11 créé','Produit D_4_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,85,'product',NULL,NULL),(214,NULL,1,'2018-05-22 07:58:43','2018-05-22 07:58:43',40,'AC_OTH_AUTO','2018-05-22 07:58:43','2018-05-22 07:58:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_4_Box11 modifié','Produit D_4_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,85,'product',NULL,NULL),(215,NULL,1,'2018-05-22 07:58:56','2018-05-22 07:58:56',40,'AC_OTH_AUTO','2018-05-22 07:58:56','2018-05-22 07:58:56',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_1_Box11 créé','Produit E_1_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,86,'product',NULL,NULL),(216,NULL,1,'2018-05-22 07:59:08','2018-05-22 07:59:08',40,'AC_OTH_AUTO','2018-05-22 07:59:08','2018-05-22 07:59:08',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_1_Box11 modifié','Produit E_1_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,86,'product',NULL,NULL),(217,NULL,1,'2018-05-22 07:59:18','2018-05-22 07:59:18',40,'AC_OTH_AUTO','2018-05-22 07:59:18','2018-05-22 07:59:18',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_3_Box11 créé','Produit E_3_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,87,'product',NULL,NULL),(218,NULL,1,'2018-05-22 07:59:26','2018-05-22 07:59:26',40,'AC_OTH_AUTO','2018-05-22 07:59:26','2018-05-22 07:59:26',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_3_Box11 modifié','Produit E_3_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,87,'product',NULL,NULL),(219,NULL,1,'2018-05-22 07:59:40','2018-05-22 07:59:40',40,'AC_OTH_AUTO','2018-05-22 07:59:40','2018-05-22 07:59:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_2_Box11 créé','Produit E_2_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,88,'product',NULL,NULL),(220,NULL,1,'2018-05-22 07:59:46','2018-05-22 07:59:46',40,'AC_OTH_AUTO','2018-05-22 07:59:46','2018-05-22 07:59:46',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_2_Box11 modifié','Produit E_2_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,88,'product',NULL,NULL),(221,NULL,1,'2018-05-22 07:59:54','2018-05-22 07:59:54',40,'AC_OTH_AUTO','2018-05-22 07:59:54','2018-05-22 07:59:54',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_4_Box11 créé','Produit E_4_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,89,'product',NULL,NULL),(222,NULL,1,'2018-05-22 08:00:01','2018-05-22 08:00:01',40,'AC_OTH_AUTO','2018-05-22 08:00:01','2018-05-22 08:00:01',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_4_Box11 modifié','Produit E_4_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,89,'product',NULL,NULL),(223,NULL,1,'2018-05-22 08:00:16','2018-05-22 08:00:16',40,'AC_OTH_AUTO','2018-05-22 08:00:16','2018-05-22 08:00:16',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_1_Box11 créé','Produit F_1_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,90,'product',NULL,NULL),(224,NULL,1,'2018-05-22 08:00:26','2018-05-22 08:00:26',40,'AC_OTH_AUTO','2018-05-22 08:00:26','2018-05-22 08:00:26',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_1_Box11 modifié','Produit F_1_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,90,'product',NULL,NULL),(225,NULL,1,'2018-05-22 08:00:35','2018-05-22 08:00:35',40,'AC_OTH_AUTO','2018-05-22 08:00:35','2018-05-22 08:00:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_3_Box11 créé','Produit F_3_Box11 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,91,'product',NULL,NULL),(226,NULL,1,'2018-05-22 08:00:43','2018-05-22 08:00:43',40,'AC_OTH_AUTO','2018-05-22 08:00:43','2018-05-22 08:00:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_3_Box11 modifié','Produit F_3_Box11 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,91,'product',NULL,NULL),(227,NULL,1,'2018-05-22 08:01:24','2018-05-22 08:01:24',40,'AC_OTH_AUTO','2018-05-22 08:01:24','2018-05-22 08:01:24',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_5_Box18 créé','Produit C_5_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,92,'product',NULL,NULL),(228,NULL,1,'2018-05-22 08:01:43','2018-05-22 08:01:43',40,'AC_OTH_AUTO','2018-05-22 08:01:43','2018-05-22 08:01:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_5_Box18 modifié','Produit C_5_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,92,'product',NULL,NULL),(229,NULL,1,'2018-05-22 08:01:55','2018-05-22 08:01:55',40,'AC_OTH_AUTO','2018-05-22 08:01:55','2018-05-22 08:01:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_5_Box18 modifié','Produit C_5_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,92,'product',NULL,NULL),(230,NULL,1,'2018-05-22 08:02:11','2018-05-22 08:02:11',40,'AC_OTH_AUTO','2018-05-22 08:02:11','2018-05-22 08:02:11',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_7_Box18 créé','Produit C_7_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,93,'product',NULL,NULL),(231,NULL,1,'2018-05-22 08:02:20','2018-05-22 08:02:20',40,'AC_OTH_AUTO','2018-05-22 08:02:20','2018-05-22 08:02:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_7_Box18 modifié','Produit C_7_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,93,'product',NULL,NULL),(232,NULL,1,'2018-05-22 08:02:30','2018-05-22 08:02:30',40,'AC_OTH_AUTO','2018-05-22 08:02:30','2018-05-22 08:02:30',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_9_Box18 créé','Produit C_9_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,94,'product',NULL,NULL),(233,NULL,1,'2018-05-22 08:02:37','2018-05-22 08:02:37',40,'AC_OTH_AUTO','2018-05-22 08:02:37','2018-05-22 08:02:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_9_Box18 modifié','Produit C_9_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,94,'product',NULL,NULL),(234,NULL,1,'2018-05-22 08:02:44','2018-05-22 08:02:44',40,'AC_OTH_AUTO','2018-05-22 08:02:44','2018-05-22 08:02:44',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_11_Box18 créé','Produit C_11_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,95,'product',NULL,NULL),(235,NULL,1,'2018-05-22 08:02:52','2018-05-22 08:02:52',40,'AC_OTH_AUTO','2018-05-22 08:02:52','2018-05-22 08:02:52',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_11_Box18 modifié','Produit C_11_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,95,'product',NULL,NULL),(236,NULL,1,'2018-05-22 08:03:03','2018-05-22 08:03:03',40,'AC_OTH_AUTO','2018-05-22 08:03:03','2018-05-22 08:03:03',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_13_Box18 créé','Produit C_13_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,96,'product',NULL,NULL),(237,NULL,1,'2018-05-22 08:03:12','2018-05-22 08:03:12',40,'AC_OTH_AUTO','2018-05-22 08:03:12','2018-05-22 08:03:12',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_13_Box18 modifié','Produit C_13_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,96,'product',NULL,NULL),(238,NULL,1,'2018-05-22 08:03:39','2018-05-22 08:03:39',40,'AC_OTH_AUTO','2018-05-22 08:03:39','2018-05-22 08:03:39',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_6_Box18 créé','Produit C_6_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,97,'product',NULL,NULL),(239,NULL,1,'2018-05-22 08:03:47','2018-05-22 08:03:47',40,'AC_OTH_AUTO','2018-05-22 08:03:47','2018-05-22 08:03:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_6_Box18 modifié','Produit C_6_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,97,'product',NULL,NULL),(240,NULL,1,'2018-05-22 08:03:53','2018-05-22 08:03:53',40,'AC_OTH_AUTO','2018-05-22 08:03:53','2018-05-22 08:03:53',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_8_Box18 créé','Produit C_8_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,98,'product',NULL,NULL),(241,NULL,1,'2018-05-22 08:04:03','2018-05-22 08:04:03',40,'AC_OTH_AUTO','2018-05-22 08:04:03','2018-05-22 08:04:03',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_8_Box18 modifié','Produit C_8_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,98,'product',NULL,NULL),(242,NULL,1,'2018-05-22 08:04:13','2018-05-22 08:04:13',40,'AC_OTH_AUTO','2018-05-22 08:04:13','2018-05-22 08:04:13',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_10_Box18 créé','Produit C_10_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,99,'product',NULL,NULL),(243,NULL,1,'2018-05-22 08:04:21','2018-05-22 08:04:21',40,'AC_OTH_AUTO','2018-05-22 08:04:21','2018-05-22 08:04:21',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_10_Box18 modifié','Produit C_10_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,99,'product',NULL,NULL),(244,NULL,1,'2018-05-22 08:04:42','2018-05-22 08:04:42',40,'AC_OTH_AUTO','2018-05-22 08:04:42','2018-05-22 08:04:42',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_12_Box18 créé','Produit C_12_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100,'product',NULL,NULL),(245,NULL,1,'2018-05-22 08:04:50','2018-05-22 08:04:50',40,'AC_OTH_AUTO','2018-05-22 08:04:50','2018-05-22 08:04:50',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_12_Box18 modifié','Produit C_12_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100,'product',NULL,NULL),(246,NULL,1,'2018-05-22 08:05:00','2018-05-22 08:05:00',40,'AC_OTH_AUTO','2018-05-22 08:05:00','2018-05-22 08:05:00',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_14_Box18 créé','Produit C_14_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,101,'product',NULL,NULL),(247,NULL,1,'2018-05-22 08:05:07','2018-05-22 08:05:07',40,'AC_OTH_AUTO','2018-05-22 08:05:07','2018-05-22 08:05:07',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit C_14_Box18 modifié','Produit C_14_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,101,'product',NULL,NULL),(248,NULL,1,'2018-05-22 08:05:36','2018-05-22 08:05:36',40,'AC_OTH_AUTO','2018-05-22 08:05:36','2018-05-22 08:05:36',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_5_Box18 créé','Produit D_5_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,102,'product',NULL,NULL),(249,NULL,1,'2018-05-22 08:05:47','2018-05-22 08:05:47',40,'AC_OTH_AUTO','2018-05-22 08:05:47','2018-05-22 08:05:47',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_5_Box18 modifié','Produit D_5_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,102,'product',NULL,NULL),(250,NULL,1,'2018-05-22 08:05:59','2018-05-22 08:05:59',40,'AC_OTH_AUTO','2018-05-22 08:05:59','2018-05-22 08:05:59',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_7_Box18 créé','Produit D_7_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,103,'product',NULL,NULL),(251,NULL,1,'2018-05-22 08:06:08','2018-05-22 08:06:08',40,'AC_OTH_AUTO','2018-05-22 08:06:08','2018-05-22 08:06:08',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_7_Box18 modifié','Produit D_7_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,103,'product',NULL,NULL),(252,NULL,1,'2018-05-22 08:06:16','2018-05-22 08:06:16',40,'AC_OTH_AUTO','2018-05-22 08:06:16','2018-05-22 08:06:16',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_9_Box18 créé','Produit D_9_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,104,'product',NULL,NULL),(253,NULL,1,'2018-05-22 08:06:24','2018-05-22 08:06:24',40,'AC_OTH_AUTO','2018-05-22 08:06:24','2018-05-22 08:06:24',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_9_Box18 modifié','Produit D_9_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,104,'product',NULL,NULL),(254,NULL,1,'2018-05-22 08:06:31','2018-05-22 08:06:31',40,'AC_OTH_AUTO','2018-05-22 08:06:31','2018-05-22 08:06:31',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_11_Box18 créé','Produit D_11_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,105,'product',NULL,NULL),(255,NULL,1,'2018-05-22 08:06:40','2018-05-22 08:06:40',40,'AC_OTH_AUTO','2018-05-22 08:06:40','2018-05-22 08:06:40',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_11_Box18 modifié','Produit D_11_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,105,'product',NULL,NULL),(256,NULL,1,'2018-05-22 08:06:49','2018-05-22 08:06:49',40,'AC_OTH_AUTO','2018-05-22 08:06:49','2018-05-22 08:06:49',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_13_Box18 créé','Produit D_13_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,106,'product',NULL,NULL),(257,NULL,1,'2018-05-22 08:06:57','2018-05-22 08:06:57',40,'AC_OTH_AUTO','2018-05-22 08:06:57','2018-05-22 08:06:57',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_13_Box18 modifié','Produit D_13_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,106,'product',NULL,NULL),(258,NULL,1,'2018-05-22 08:15:41','2018-05-22 08:15:41',40,'AC_OTH_AUTO','2018-05-22 08:15:41','2018-05-22 08:15:41',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_6_Box18 créé','Produit D_6_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,107,'product',NULL,NULL),(259,NULL,1,'2018-05-22 08:15:50','2018-05-22 08:15:50',40,'AC_OTH_AUTO','2018-05-22 08:15:50','2018-05-22 08:15:50',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_6_Box18 modifié','Produit D_6_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,107,'product',NULL,NULL),(260,NULL,1,'2018-05-22 08:15:57','2018-05-22 08:15:57',40,'AC_OTH_AUTO','2018-05-22 08:15:57','2018-05-22 08:15:57',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_8_Box18 créé','Produit D_8_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,108,'product',NULL,NULL),(261,NULL,1,'2018-05-22 08:16:05','2018-05-22 08:16:05',40,'AC_OTH_AUTO','2018-05-22 08:16:05','2018-05-22 08:16:05',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_8_Box18 modifié','Produit D_8_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,108,'product',NULL,NULL),(262,NULL,1,'2018-05-22 08:16:13','2018-05-22 08:16:13',40,'AC_OTH_AUTO','2018-05-22 08:16:13','2018-05-22 08:16:13',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_10_Box18 créé','Produit D_10_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,109,'product',NULL,NULL),(263,NULL,1,'2018-05-22 08:16:20','2018-05-22 08:16:20',40,'AC_OTH_AUTO','2018-05-22 08:16:20','2018-05-22 08:16:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_10_Box18 modifié','Produit D_10_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,109,'product',NULL,NULL),(264,NULL,1,'2018-05-22 08:16:30','2018-05-22 08:16:30',40,'AC_OTH_AUTO','2018-05-22 08:16:30','2018-05-22 08:16:30',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_12_Box18 créé','Produit D_12_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,110,'product',NULL,NULL),(265,NULL,1,'2018-05-22 08:16:39','2018-05-22 08:16:39',40,'AC_OTH_AUTO','2018-05-22 08:16:39','2018-05-22 08:16:39',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_12_Box18 modifié','Produit D_12_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,110,'product',NULL,NULL),(266,NULL,1,'2018-05-22 08:16:56','2018-05-22 08:16:56',40,'AC_OTH_AUTO','2018-05-22 08:16:56','2018-05-22 08:16:56',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_14_Box18 créé','Produit D_14_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,111,'product',NULL,NULL),(267,NULL,1,'2018-05-22 08:17:05','2018-05-22 08:17:05',40,'AC_OTH_AUTO','2018-05-22 08:17:05','2018-05-22 08:17:05',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit D_14_Box18 modifié','Produit D_14_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,111,'product',NULL,NULL),(268,NULL,1,'2018-05-22 08:17:28','2018-05-22 08:17:28',40,'AC_OTH_AUTO','2018-05-22 08:17:28','2018-05-22 08:17:28',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_5_Box18 créé','Produit E_5_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,112,'product',NULL,NULL),(269,NULL,1,'2018-05-22 08:17:37','2018-05-22 08:17:37',40,'AC_OTH_AUTO','2018-05-22 08:17:37','2018-05-22 08:17:37',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_5_Box18 modifié','Produit E_5_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,112,'product',NULL,NULL),(270,NULL,1,'2018-05-22 08:17:45','2018-05-22 08:17:45',40,'AC_OTH_AUTO','2018-05-22 08:17:45','2018-05-22 08:17:45',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_7_Box18 créé','Produit E_7_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,113,'product',NULL,NULL),(271,NULL,1,'2018-05-22 08:17:53','2018-05-22 08:17:53',40,'AC_OTH_AUTO','2018-05-22 08:17:53','2018-05-22 08:17:53',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_7_Box18 modifié','Produit E_7_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,113,'product',NULL,NULL),(272,NULL,1,'2018-05-22 08:17:56','2018-05-22 08:17:56',40,'AC_OTH_AUTO','2018-05-22 08:17:56','2018-05-22 08:17:56',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_7_Box18 modifié','Produit E_7_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,113,'product',NULL,NULL),(273,NULL,1,'2018-05-22 08:18:05','2018-05-22 08:18:05',40,'AC_OTH_AUTO','2018-05-22 08:18:05','2018-05-22 08:18:05',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_9_Box18 créé','Produit E_9_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,114,'product',NULL,NULL),(274,NULL,1,'2018-05-22 08:18:11','2018-05-22 08:18:11',40,'AC_OTH_AUTO','2018-05-22 08:18:11','2018-05-22 08:18:11',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_9_Box18 modifié','Produit E_9_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,114,'product',NULL,NULL),(275,NULL,1,'2018-05-22 08:18:18','2018-05-22 08:18:18',40,'AC_OTH_AUTO','2018-05-22 08:18:18','2018-05-22 08:18:18',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_11_Box18 créé','Produit E_11_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,115,'product',NULL,NULL),(276,NULL,1,'2018-05-22 08:18:25','2018-05-22 08:18:25',40,'AC_OTH_AUTO','2018-05-22 08:18:25','2018-05-22 08:18:25',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_11_Box18 modifié','Produit E_11_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,115,'product',NULL,NULL),(277,NULL,1,'2018-05-22 08:18:35','2018-05-22 08:18:35',40,'AC_OTH_AUTO','2018-05-22 08:18:35','2018-05-22 08:18:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_13_Box18 créé','Produit E_13_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,116,'product',NULL,NULL),(278,NULL,1,'2018-05-22 08:18:44','2018-05-22 08:18:44',40,'AC_OTH_AUTO','2018-05-22 08:18:44','2018-05-22 08:18:44',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_13_Box18 modifié','Produit E_13_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,116,'product',NULL,NULL),(279,NULL,1,'2018-05-22 08:19:03','2018-05-22 08:19:03',40,'AC_OTH_AUTO','2018-05-22 08:19:03','2018-05-22 08:19:03',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_6_Box18 créé','Produit E_6_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,117,'product',NULL,NULL),(280,NULL,1,'2018-05-22 08:19:12','2018-05-22 08:19:12',40,'AC_OTH_AUTO','2018-05-22 08:19:12','2018-05-22 08:19:12',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_6_Box18 modifié','Produit E_6_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,117,'product',NULL,NULL),(281,NULL,1,'2018-05-22 08:20:29','2018-05-22 08:20:29',40,'AC_OTH_AUTO','2018-05-22 08:20:29','2018-05-22 08:20:29',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_8_Box18 créé','Produit E_8_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,118,'product',NULL,NULL),(282,NULL,1,'2018-05-22 08:20:42','2018-05-22 08:20:42',40,'AC_OTH_AUTO','2018-05-22 08:20:42','2018-05-22 08:20:42',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_8_Box18 modifié','Produit E_8_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,118,'product',NULL,NULL),(283,NULL,1,'2018-05-22 08:20:58','2018-05-22 08:20:58',40,'AC_OTH_AUTO','2018-05-22 08:20:58','2018-05-22 08:20:58',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_10_Box18 créé','Produit E_10_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,119,'product',NULL,NULL),(284,NULL,1,'2018-05-22 08:21:05','2018-05-22 08:21:05',40,'AC_OTH_AUTO','2018-05-22 08:21:05','2018-05-22 08:21:05',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_10_Box18 modifié','Produit E_10_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,119,'product',NULL,NULL),(285,NULL,1,'2018-05-22 08:21:14','2018-05-22 08:21:14',40,'AC_OTH_AUTO','2018-05-22 08:21:14','2018-05-22 08:21:14',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_12_Box18 créé','Produit E_12_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,120,'product',NULL,NULL),(286,NULL,1,'2018-05-22 08:21:25','2018-05-22 08:21:25',40,'AC_OTH_AUTO','2018-05-22 08:21:25','2018-05-22 08:21:25',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_12_Box18 modifié','Produit E_12_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,120,'product',NULL,NULL),(287,NULL,1,'2018-05-22 08:21:35','2018-05-22 08:21:35',40,'AC_OTH_AUTO','2018-05-22 08:21:35','2018-05-22 08:21:35',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_14_Box18 créé','Produit E_14_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,121,'product',NULL,NULL),(288,NULL,1,'2018-05-22 08:21:43','2018-05-22 08:21:43',40,'AC_OTH_AUTO','2018-05-22 08:21:43','2018-05-22 08:21:43',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit E_14_Box18 modifié','Produit E_14_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,121,'product',NULL,NULL),(289,NULL,1,'2018-05-22 08:22:03','2018-05-22 08:22:03',40,'AC_OTH_AUTO','2018-05-22 08:22:03','2018-05-22 08:22:03',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_3_Box18 créé','Produit F_3_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,122,'product',NULL,NULL),(290,NULL,1,'2018-05-22 08:22:13','2018-05-22 08:22:13',40,'AC_OTH_AUTO','2018-05-22 08:22:13','2018-05-22 08:22:13',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_3_Box18 modifié','Produit F_3_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,122,'product',NULL,NULL),(291,NULL,1,'2018-05-22 08:22:20','2018-05-22 08:22:20',40,'AC_OTH_AUTO','2018-05-22 08:22:20','2018-05-22 08:22:20',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_5_Box18 créé','Produit F_5_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,123,'product',NULL,NULL),(292,NULL,1,'2018-05-22 08:22:29','2018-05-22 08:22:29',40,'AC_OTH_AUTO','2018-05-22 08:22:29','2018-05-22 08:22:29',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_5_Box18 modifié','Produit F_5_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,123,'product',NULL,NULL),(293,NULL,1,'2018-05-22 08:22:38','2018-05-22 08:22:38',40,'AC_OTH_AUTO','2018-05-22 08:22:38','2018-05-22 08:22:38',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_7_Box18 créé','Produit F_7_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,124,'product',NULL,NULL),(294,NULL,1,'2018-05-22 08:22:46','2018-05-22 08:22:46',40,'AC_OTH_AUTO','2018-05-22 08:22:46','2018-05-22 08:22:46',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_7_Box18 modifié','Produit F_7_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,124,'product',NULL,NULL),(295,NULL,1,'2018-05-22 08:22:55','2018-05-22 08:22:55',40,'AC_OTH_AUTO','2018-05-22 08:22:55','2018-05-22 08:22:55',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_9_Box18 créé','Produit F_9_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,125,'product',NULL,NULL),(296,NULL,1,'2018-05-22 08:23:01','2018-05-22 08:23:01',40,'AC_OTH_AUTO','2018-05-22 08:23:01','2018-05-22 08:23:01',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_9_Box18 modifié','Produit F_9_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,125,'product',NULL,NULL),(297,NULL,1,'2018-05-22 08:23:10','2018-05-22 08:23:10',40,'AC_OTH_AUTO','2018-05-22 08:23:10','2018-05-22 08:23:10',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_11_Box18 créé','Produit F_11_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,126,'product',NULL,NULL),(298,NULL,1,'2018-05-22 08:23:19','2018-05-22 08:23:19',40,'AC_OTH_AUTO','2018-05-22 08:23:19','2018-05-22 08:23:19',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_11_Box18 modifié','Produit F_11_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,126,'product',NULL,NULL),(299,NULL,1,'2018-05-22 08:24:08','2018-05-22 08:24:08',40,'AC_OTH_AUTO','2018-05-22 08:24:08','2018-05-22 08:24:08',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_13_Box18 créé','Produit F_13_Box18 créé\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,127,'product',NULL,NULL),(300,NULL,1,'2018-05-22 08:24:15','2018-05-22 08:24:15',40,'AC_OTH_AUTO','2018-05-22 08:24:15','2018-05-22 08:24:15',2,NULL,NULL,NULL,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Produit F_13_Box18 modifié','Produit F_13_Box18 modifié\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,127,'product',NULL,NULL),(301,NULL,1,'2018-06-08 09:40:03','2018-06-08 09:40:03',40,'AC_OTH_AUTO','2018-06-08 09:40:03','2018-06-08 09:40:03',1,NULL,NULL,1,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers vidal créé','Tiers vidal créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'societe',NULL,NULL),(302,NULL,1,'2018-06-12 09:57:50','2018-06-12 09:57:50',40,'AC_OTH_AUTO','2018-06-12 09:57:50','2018-06-12 09:57:50',1,NULL,NULL,2,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers AAB sprl créé','Tiers AAB sprl créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,'societe',NULL,NULL),(303,NULL,1,'2018-06-12 11:51:46','2018-06-12 11:51:46',40,'AC_OTH_AUTO','2018-06-12 11:51:46','2018-06-12 11:51:46',2,NULL,NULL,2,NULL,0,2,NULL,0,0,0,1,-1,'',NULL,'Facture FA1806-0001 validée','Facture FA1806-0001 validée\nAuteur: callsoft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,'invoice',NULL,NULL),(304,NULL,1,'2018-07-06 09:23:45','2018-07-06 09:23:45',40,'AC_OTH_AUTO','2018-07-06 09:23:45','2018-07-06 09:23:45',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers Alves et Andrade renov créé','Tiers Alves et Andrade renov créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,'societe',NULL,NULL),(305,NULL,1,'2018-07-06 09:24:41','2018-07-06 09:24:41',40,'AC_OTH_AUTO','2018-07-06 09:24:41','2018-07-06 09:24:41',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0002 validée','Facture FA1807-0002 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,'invoice',NULL,NULL),(306,NULL,1,'2018-07-06 09:38:54','2018-07-06 09:38:54',40,'AC_OTH_AUTO','2018-07-06 09:38:54','2018-07-06 09:38:54',1,NULL,NULL,4,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers Monsieur Allali Mohamed créé','Tiers Monsieur Allali Mohamed créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'societe',NULL,NULL),(307,NULL,1,'2018-07-06 09:41:00','2018-07-06 09:41:00',40,'AC_OTH_AUTO','2018-07-06 09:41:00','2018-07-06 09:41:00',1,NULL,NULL,4,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0003 validée','Facture FA1807-0003 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'invoice',NULL,NULL),(308,NULL,1,'2018-07-06 09:43:11','2018-07-06 09:43:11',40,'AC_OTH_AUTO','2018-07-06 09:43:11','2018-07-06 09:43:11',1,NULL,NULL,4,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0003 retour à l\'état de brouillon','Facture FA1807-0003 retour à l\'état de brouillon\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'invoice',NULL,NULL),(309,NULL,1,'2018-07-06 09:43:24','2018-07-06 09:43:24',40,'AC_OTH_AUTO','2018-07-06 09:43:24','2018-07-06 09:43:24',1,NULL,NULL,4,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0003 validée','Facture FA1807-0003 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'invoice',NULL,NULL),(310,NULL,1,'2018-07-06 09:45:20','2018-07-06 09:45:20',40,'AC_OTH_AUTO','2018-07-06 09:45:20','2018-07-06 09:45:20',1,NULL,NULL,2,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1806-0001 passée à payée','Facture FA1806-0001 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,'invoice',NULL,NULL),(311,NULL,1,'2018-07-06 09:45:37','2018-07-06 09:45:37',40,'AC_OTH_AUTO','2018-07-06 09:45:37','2018-07-06 09:45:37',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0002 passée à payée','Facture FA1807-0002 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,'invoice',NULL,NULL),(312,NULL,1,'2018-07-20 06:42:14','2018-07-20 06:42:14',40,'AC_OTH_AUTO','2018-07-20 06:42:14','2018-07-20 06:42:14',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers 2A Group sprl créé','Tiers 2A Group sprl créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'societe',NULL,NULL),(313,NULL,1,'2018-07-20 06:42:56','2018-07-20 06:42:56',40,'AC_OTH_AUTO','2018-07-20 06:42:56','2018-07-20 06:42:56',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0004 validée','Facture FA1807-0004 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'invoice',NULL,NULL),(314,NULL,1,'2018-07-20 06:43:33','2018-07-20 06:43:33',40,'AC_OTH_AUTO','2018-07-20 06:43:33','2018-07-20 06:43:33',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Mail envoyé par Loca Box To 2A Group sprl','Émetteur: Loca Box &lt;info@loca-box.be&gt;<br>\nDestinataire(s): 2A Group sprl &lt;business2a@yahoo.com&gt;<br>\nObjet: Envoi de la facture FA1807-0004<br>\nCorps du message:<br>\nBonjour<br />\r\n<br />\r\nVous trouverez ci-joint la facture FA1807-0004<br />\r\n<br />\r\nMerci pour votre bon paiement<br />\r\n<br />\r\nCordialement&nbsp;<br />\r\n<br />\r\nLe secretariat\nAuteur: locabox<br>\n<br>\nFichiers et documents joints: FA1807-0004.pdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'invoice',NULL,NULL),(315,NULL,1,'2018-07-20 06:44:17','2018-07-20 06:44:17',40,'AC_OTH_AUTO','2018-07-20 06:44:17','2018-07-20 06:44:17',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0005 validée','Facture FA1807-0005 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'invoice',NULL,NULL),(316,NULL,1,'2018-07-20 06:44:38','2018-07-20 06:44:38',40,'AC_OTH_AUTO','2018-07-20 06:44:38','2018-07-20 06:44:38',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Mail envoyé par Loca Box To 2A Group sprl','Émetteur: Loca Box &lt;info@loca-box.be&gt;<br>\nDestinataire(s): 2A Group sprl &lt;business2a@yahoo.com&gt;<br>\nObjet: Envoi de la facture FA1807-0005<br>\nCorps du message:<br>\nBonjour<br />\r\n<br />\r\nVous trouverez ci-joint la facture FA1807-0005<br />\r\n<br />\r\n<br />\r\nCordialement&nbsp;<br />\r\n<br />\r\nLe secretariat\nAuteur: locabox<br>\n<br>\nFichiers et documents joints: FA1807-0005.pdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'invoice',NULL,NULL),(317,NULL,1,'2018-07-20 06:45:20','2018-07-20 06:45:20',40,'AC_OTH_AUTO','2018-07-20 06:45:20','2018-07-20 06:45:20',1,NULL,NULL,4,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0003 passée à payée','Facture FA1807-0003 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'invoice',NULL,NULL),(318,NULL,1,'2018-07-30 10:08:27','2018-07-30 10:08:27',40,'AC_OTH_AUTO','2018-07-30 10:08:27','2018-07-30 10:08:27',1,NULL,NULL,6,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers eagle express sprl créé','Tiers eagle express sprl créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'societe',NULL,NULL),(319,NULL,1,'2018-07-30 10:09:48','2018-07-30 10:09:48',40,'AC_OTH_AUTO','2018-07-30 10:09:48','2018-07-30 10:09:48',1,NULL,NULL,6,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0006 validée','Facture FA1807-0006 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,'invoice',NULL,NULL),(320,NULL,1,'2018-07-30 10:11:12','2018-07-30 10:11:12',40,'AC_OTH_AUTO','2018-07-30 10:11:12','2018-07-30 10:11:12',1,NULL,NULL,6,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Mail envoyé par Loca Box To coralie@delta-relay.com','Émetteur: Loca Box &lt;info@loca-box.be&gt;<br>\nDestinataire(s): coralie@delta-relay.com<br>\nObjet: Envoi de la facture FA1807-0006<br>\nCorps du message:<br>\nBonjour<br />\r\n<br />\r\nVous trouverez ci-joint la facture FA1807-0006<br />\r\n<br />\r\nVoici le lien pour effectuer votre paiement en ligne si elle n&#39;est pas d&eacute;j&agrave; &eacute;t&eacute; pay&eacute;e:<br />\r\nhttp://facturation.loca-box.be/public/payment/newpayment.php?source=invoice&amp;ref=FA1807-0006&amp;entity=1<br />\r\n<br />\r\nSinc&egrave;rement\nAuteur: locabox<br>\n<br>\nFichiers et documents joints: FA1807-0006.pdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,'invoice',NULL,NULL),(321,NULL,1,'2018-08-24 08:59:34','2018-08-24 08:59:34',40,'AC_OTH_AUTO','2018-08-24 08:59:34','2018-08-24 08:59:34',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture AV1808-0001 validée','Facture AV1808-0001 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,'invoice',NULL,NULL),(322,NULL,1,'2018-08-24 09:03:34','2018-08-24 09:03:34',40,'AC_OTH_AUTO','2018-08-24 09:03:34','2018-08-24 09:03:34',1,NULL,NULL,7,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers AA BISNESS créé','Tiers AA BISNESS créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,'societe',NULL,NULL),(323,NULL,1,'2018-08-24 09:04:54','2018-08-24 09:04:54',40,'AC_OTH_AUTO','2018-08-24 09:04:54','2018-08-24 09:04:54',1,NULL,NULL,7,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1808-0007 validée','Facture FA1808-0007 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,'invoice',NULL,NULL),(324,NULL,1,'2018-08-24 09:06:38','2018-08-24 09:06:38',40,'AC_OTH_AUTO','2018-08-24 09:06:38','2018-08-24 09:06:38',1,NULL,NULL,7,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1808-0007 retour à l\'état de brouillon','Facture FA1808-0007 retour à l\'état de brouillon\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,'invoice',NULL,NULL),(325,NULL,1,'2018-08-24 09:06:43','2018-08-24 09:06:43',40,'AC_OTH_AUTO','2018-08-24 09:06:43','2018-08-24 09:06:43',1,NULL,NULL,7,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1808-0007 validée','Facture FA1808-0007 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,'invoice',NULL,NULL),(326,NULL,1,'2018-08-24 09:08:46','2018-08-24 09:08:46',40,'AC_OTH_AUTO','2018-08-24 09:08:46','2018-08-24 09:08:46',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0004 passée à payée','Facture FA1807-0004 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'invoice',NULL,NULL),(327,NULL,1,'2018-08-24 09:08:47','2018-08-24 09:08:47',40,'AC_OTH_AUTO','2018-08-24 09:08:47','2018-08-24 09:08:47',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0005 passée à payée','Facture FA1807-0005 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'invoice',NULL,NULL),(328,NULL,1,'2018-08-24 09:09:03','2018-08-24 09:09:03',40,'AC_OTH_AUTO','2018-08-24 09:09:03','2018-08-24 09:09:03',1,NULL,NULL,5,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture AV1808-0001 passée à payée','Facture AV1808-0001 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,'invoice',NULL,NULL),(329,NULL,1,'2018-09-10 10:54:20','2018-09-10 10:54:20',40,'AC_OTH_AUTO','2018-09-10 10:54:20','2018-09-10 10:54:20',1,NULL,NULL,7,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0008 validée','Facture FA1809-0008 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11,'invoice',NULL,NULL),(330,NULL,1,'2018-09-19 11:32:24','2018-09-19 11:32:24',40,'AC_OTH_AUTO','2018-09-19 11:32:24','2018-09-19 11:32:24',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1807-0002 passée à payée','Facture FA1807-0002 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,'invoice',NULL,NULL),(331,NULL,1,'2018-09-19 11:32:39','2018-09-19 11:32:39',40,'AC_OTH_AUTO','2018-09-19 11:32:39','2018-09-19 11:32:39',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture AV1809-0002 validée','Facture AV1809-0002 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,'invoice',NULL,NULL),(332,NULL,1,'2018-09-19 11:35:18','2018-09-19 11:35:18',40,'AC_OTH_AUTO','2018-09-19 11:35:18','2018-09-19 11:35:18',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0008 validée','Facture FA1809-0008 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14,'invoice',NULL,NULL),(333,NULL,1,'2018-09-19 11:35:51','2018-09-19 11:35:51',40,'AC_OTH_AUTO','2018-09-19 11:35:51','2018-09-19 11:35:51',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0009 validée','Facture FA1809-0009 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,'invoice',NULL,NULL),(334,NULL,1,'2018-09-19 11:36:27','2018-09-19 11:36:27',40,'AC_OTH_AUTO','2018-09-19 11:36:27','2018-09-19 11:36:27',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0010 validée','Facture FA1809-0010 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17,'invoice',NULL,NULL),(335,NULL,1,'2018-09-19 11:36:34','2018-09-19 11:36:34',40,'AC_OTH_AUTO','2018-09-19 11:36:34','2018-09-19 11:36:34',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0009 retour à l\'état de brouillon','Facture FA1809-0009 retour à l\'état de brouillon\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,'invoice',NULL,NULL),(336,NULL,1,'2018-09-19 11:37:09','2018-09-19 11:37:09',40,'AC_OTH_AUTO','2018-09-19 11:37:09','2018-09-19 11:37:09',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0009 validée','Facture FA1809-0009 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,'invoice',NULL,NULL),(337,NULL,1,'2018-09-20 12:21:22','2018-09-20 12:21:22',40,'AC_OTH_AUTO','2018-09-20 12:21:22','2018-09-20 12:21:22',1,NULL,NULL,8,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers Delta-relay ,sprl créé','Tiers Delta-relay ,sprl créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8,'societe',NULL,NULL),(338,NULL,1,'2018-09-20 12:22:37','2018-09-20 12:22:37',40,'AC_OTH_AUTO','2018-09-20 12:22:37','2018-09-20 12:22:37',1,NULL,NULL,8,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0011 validée','Facture FA1809-0011 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'invoice',NULL,NULL),(339,NULL,1,'2018-10-04 09:26:36','2018-10-04 09:26:36',40,'AC_OTH_AUTO','2018-10-04 09:26:37','2018-10-04 09:26:37',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1810-0012 validée','Facture FA1810-0012 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,19,'invoice',NULL,NULL),(340,NULL,1,'2018-10-04 09:34:50','2018-10-04 09:34:50',40,'AC_OTH_AUTO','2018-10-04 09:34:50','2018-10-04 09:34:50',1,NULL,NULL,8,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0011 passée à payée','Facture FA1809-0011 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,18,'invoice',NULL,NULL),(341,NULL,1,'2018-10-04 09:35:44','2018-10-04 09:35:44',40,'AC_OTH_AUTO','2018-10-04 09:35:44','2018-10-04 09:35:44',1,NULL,NULL,7,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1808-0007 passée à payée','Facture FA1808-0007 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,'invoice',NULL,NULL),(342,NULL,1,'2018-10-04 09:36:33','2018-10-04 09:36:33',40,'AC_OTH_AUTO','2018-10-04 09:36:33','2018-10-04 09:36:33',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1809-0008 passée à payée','Facture FA1809-0008 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14,'invoice',NULL,NULL),(343,NULL,1,'2018-10-04 09:36:50','2018-10-04 09:36:50',40,'AC_OTH_AUTO','2018-10-04 09:36:50','2018-10-04 09:36:50',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture AV1809-0002 passée à payée','Facture AV1809-0002 passée à payée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,'invoice',NULL,NULL),(344,NULL,1,'2018-11-12 08:51:22','2018-11-12 08:51:22',40,'AC_OTH_AUTO','2018-11-12 08:51:22','2018-11-12 08:51:22',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1810-0013 validée','Facture FA1810-0013 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,20,'invoice',NULL,NULL),(345,NULL,1,'2018-11-12 08:58:17','2018-11-12 08:58:17',40,'AC_OTH_AUTO','2018-11-12 08:58:17','2018-11-12 08:58:17',1,NULL,NULL,9,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers Verhaverbeke créé','Tiers Verhaverbeke créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,'societe',NULL,NULL),(346,NULL,1,'2018-11-12 08:59:39','2018-11-12 08:59:39',40,'AC_OTH_AUTO','2018-11-12 08:59:39','2018-11-12 08:59:39',1,NULL,NULL,9,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1810-0014 validée','Facture FA1810-0014 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,21,'invoice',NULL,NULL),(347,NULL,1,'2018-11-12 09:01:47','2018-11-12 09:01:47',40,'AC_OTH_AUTO','2018-11-12 09:01:47','2018-11-12 09:01:47',1,NULL,NULL,8,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1810-0015 validée','Facture FA1810-0015 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,22,'invoice',NULL,NULL),(348,NULL,1,'2018-11-20 11:18:57','2018-11-20 11:18:57',40,'AC_OTH_AUTO','2018-11-20 11:18:57','2018-11-20 11:18:57',1,NULL,NULL,10,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers Darchambeau  Florence créé','Tiers Darchambeau  Florence créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,'societe',NULL,NULL),(349,NULL,1,'2018-11-20 11:20:30','2018-11-20 11:20:30',40,'AC_OTH_AUTO','2018-11-20 11:20:30','2018-11-20 11:20:30',1,NULL,NULL,10,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1811-0016 validée','Facture FA1811-0016 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,23,'invoice',NULL,NULL),(350,NULL,1,'2018-11-21 10:46:10','2018-11-21 10:46:10',40,'AC_OTH_AUTO','2018-11-21 10:46:10','2018-11-21 10:46:10',1,NULL,NULL,11,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers EL MOSSALLI Mohamed créé','Tiers EL MOSSALLI Mohamed créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11,'societe',NULL,NULL),(351,NULL,1,'2018-11-21 10:47:23','2018-11-21 10:47:23',40,'AC_OTH_AUTO','2018-11-21 10:47:23','2018-11-21 10:47:23',1,NULL,NULL,11,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1811-0017 validée','Facture FA1811-0017 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,24,'invoice',NULL,NULL),(352,NULL,1,'2018-11-21 10:50:18','2018-11-21 10:50:18',40,'AC_OTH_AUTO','2018-11-21 10:50:18','2018-11-21 10:50:18',1,NULL,NULL,11,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1811-0017 retour à l\'état de brouillon','Facture FA1811-0017 retour à l\'état de brouillon\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,24,'invoice',NULL,NULL),(353,NULL,1,'2018-11-21 10:50:28','2018-11-21 10:50:28',40,'AC_OTH_AUTO','2018-11-21 10:50:28','2018-11-21 10:50:28',1,NULL,NULL,11,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1811-0017 validée','Facture FA1811-0017 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,24,'invoice',NULL,NULL),(354,NULL,1,'2018-12-07 09:13:16','2018-12-07 09:13:16',40,'AC_OTH_AUTO','2018-12-07 09:13:16','2018-12-07 09:13:16',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1812-0018 validée','Facture FA1812-0018 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,'invoice',NULL,NULL),(355,NULL,1,'2018-12-07 09:17:11','2018-12-07 09:17:11',40,'AC_OTH_AUTO','2018-12-07 09:17:11','2018-12-07 09:17:11',1,NULL,NULL,9,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1812-0019 validée','Facture FA1812-0019 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,26,'invoice',NULL,NULL),(356,NULL,1,'2018-12-07 11:00:04','2018-12-07 11:00:04',40,'AC_OTH_AUTO','2018-12-07 11:00:04','2018-12-07 11:00:04',1,NULL,NULL,12,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers <resto group créé','Tiers <resto group créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12,'societe',NULL,NULL),(357,NULL,1,'2018-12-07 11:00:47','2018-12-07 11:00:47',40,'AC_OTH_AUTO','2018-12-07 11:00:47','2018-12-07 11:00:47',1,NULL,NULL,12,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1812-0020 validée','Facture FA1812-0020 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,27,'invoice',NULL,NULL),(358,NULL,1,'2018-12-07 11:39:05','2018-12-07 11:39:05',40,'AC_OTH_AUTO','2018-12-07 11:39:05','2018-12-07 11:39:05',1,NULL,NULL,8,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1812-0021 validée','Facture FA1812-0021 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,28,'invoice',NULL,NULL),(359,NULL,1,'2019-01-07 11:12:27','2019-01-07 11:12:27',40,'AC_OTH_AUTO','2019-01-07 11:12:27','2019-01-07 11:12:27',1,NULL,NULL,10,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1901-0022 validée','Facture FA1901-0022 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,'invoice',NULL,NULL),(360,NULL,1,'2019-01-07 11:20:46','2019-01-07 11:20:46',40,'AC_OTH_AUTO','2019-01-07 11:20:46','2019-01-07 11:20:46',1,NULL,NULL,13,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers Toiture THIELEMANS créé','Tiers Toiture THIELEMANS créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13,'societe',NULL,NULL),(361,NULL,1,'2019-01-07 11:21:24','2019-01-07 11:21:24',40,'AC_OTH_AUTO','2019-01-07 11:21:24','2019-01-07 11:21:24',1,NULL,NULL,13,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1901-0023 validée','Facture FA1901-0023 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,30,'invoice',NULL,NULL),(362,NULL,1,'2019-01-07 11:26:17','2019-01-07 11:26:17',40,'AC_OTH_AUTO','2019-01-07 11:26:17','2019-01-07 11:26:17',1,NULL,NULL,9,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1901-0024 validée','Facture FA1901-0024 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,'invoice',NULL,NULL),(363,NULL,1,'2019-01-07 11:26:58','2019-01-07 11:26:58',40,'AC_OTH_AUTO','2019-01-07 11:26:58','2019-01-07 11:26:58',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1901-0025 validée','Facture FA1901-0025 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,'invoice',NULL,NULL),(364,NULL,1,'2019-01-10 10:57:18','2019-01-10 10:57:18',40,'AC_OTH_AUTO','2019-01-10 10:57:18','2019-01-10 10:57:18',1,NULL,NULL,14,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers BRACHE Fabian créé','Tiers BRACHE Fabian créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14,'societe',NULL,NULL),(365,NULL,1,'2019-01-10 10:58:41','2019-01-10 10:58:41',40,'AC_OTH_AUTO','2019-01-10 10:58:41','2019-01-10 10:58:41',1,NULL,NULL,14,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1901-0026 validée','Facture FA1901-0026 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,33,'invoice',NULL,NULL),(366,NULL,1,'2019-01-15 08:23:42','2019-01-15 08:23:42',40,'AC_OTH_AUTO','2019-01-15 08:23:42','2019-01-15 08:23:42',1,NULL,NULL,8,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1901-0027 validée','Facture FA1901-0027 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34,'invoice',NULL,NULL),(367,NULL,1,'2019-02-05 11:40:56','2019-02-05 11:40:56',40,'AC_OTH_AUTO','2019-02-05 11:40:56','2019-02-05 11:40:56',1,NULL,NULL,10,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0028 validée','Facture FA1902-0028 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,'invoice',NULL,NULL),(368,NULL,1,'2019-02-05 11:42:19','2019-02-05 11:42:19',40,'AC_OTH_AUTO','2019-02-05 11:42:19','2019-02-05 11:42:19',1,NULL,NULL,13,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0029 validée','Facture FA1902-0029 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,'invoice',NULL,NULL),(369,NULL,1,'2019-02-05 11:43:11','2019-02-05 11:43:11',40,'AC_OTH_AUTO','2019-02-05 11:43:11','2019-02-05 11:43:11',1,NULL,NULL,9,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0030 validée','Facture FA1902-0030 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,'invoice',NULL,NULL),(370,NULL,1,'2019-02-05 11:44:08','2019-02-05 11:44:08',40,'AC_OTH_AUTO','2019-02-05 11:44:08','2019-02-05 11:44:08',1,NULL,NULL,3,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0031 validée','Facture FA1902-0031 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,'invoice',NULL,NULL),(371,NULL,1,'2019-02-05 11:48:59','2019-02-05 11:48:59',40,'AC_OTH_AUTO','2019-02-05 11:48:59','2019-02-05 11:48:59',1,NULL,NULL,14,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0032 validée','Facture FA1902-0032 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,'invoice',NULL,NULL),(372,NULL,1,'2019-02-05 11:55:34','2019-02-05 11:55:34',40,'AC_OTH_AUTO','2019-02-05 11:55:34','2019-02-05 11:55:34',1,NULL,NULL,14,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0032 retour à l\'état de brouillon','Facture FA1902-0032 retour à l\'état de brouillon\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,'invoice',NULL,NULL),(373,NULL,1,'2019-02-05 11:55:55','2019-02-05 11:55:55',40,'AC_OTH_AUTO','2019-02-05 11:55:55','2019-02-05 11:55:55',1,NULL,NULL,14,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0032 validée','Facture FA1902-0032 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,'invoice',NULL,NULL),(374,NULL,1,'2019-02-05 12:34:06','2019-02-05 12:34:06',40,'AC_OTH_AUTO','2019-02-05 12:34:06','2019-02-05 12:34:06',1,NULL,NULL,15,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Tiers DEBROUX Annick créé','Tiers DEBROUX Annick créé\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15,'societe',NULL,NULL),(375,NULL,1,'2019-02-05 12:36:13','2019-02-05 12:36:13',40,'AC_OTH_AUTO','2019-02-05 12:36:13','2019-02-05 12:36:13',1,NULL,NULL,15,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0033 validée','Facture FA1902-0033 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40,'invoice',NULL,NULL),(376,NULL,1,'2019-02-05 12:37:45','2019-02-05 12:37:45',40,'AC_OTH_AUTO','2019-02-05 12:37:45','2019-02-05 12:37:45',1,NULL,NULL,15,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0034 validée','Facture FA1902-0034 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,'invoice',NULL,NULL),(377,NULL,1,'2019-02-05 12:40:50','2019-02-05 12:40:50',40,'AC_OTH_AUTO','2019-02-05 12:40:50','2019-02-05 12:40:50',1,NULL,NULL,15,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0034 retour à l\'état de brouillon','Facture FA1902-0034 retour à l\'état de brouillon\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,'invoice',NULL,NULL),(378,NULL,1,'2019-02-05 12:41:10','2019-02-05 12:41:10',40,'AC_OTH_AUTO','2019-02-05 12:41:10','2019-02-05 12:41:10',1,NULL,NULL,15,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0034 validée','Facture FA1902-0034 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,'invoice',NULL,NULL),(379,NULL,1,'2019-02-05 12:43:27','2019-02-05 12:43:27',40,'AC_OTH_AUTO','2019-02-05 12:43:27','2019-02-05 12:43:27',1,NULL,NULL,15,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0034 retour à l\'état de brouillon','Facture FA1902-0034 retour à l\'état de brouillon\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,'invoice',NULL,NULL),(380,NULL,1,'2019-02-05 12:43:48','2019-02-05 12:43:48',40,'AC_OTH_AUTO','2019-02-05 12:43:48','2019-02-05 12:43:48',1,NULL,NULL,15,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0034 validée','Facture FA1902-0034 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,'invoice',NULL,NULL),(381,NULL,1,'2019-02-14 11:54:51','2019-02-14 11:54:51',40,'AC_OTH_AUTO','2019-02-14 11:54:51','2019-02-14 11:54:51',1,NULL,NULL,8,NULL,0,1,NULL,0,0,0,1,-1,'',NULL,'Facture FA1902-0035 validée','Facture FA1902-0035 validée\nAuteur: locabox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42,'invoice',NULL,NULL);
/*!40000 ALTER TABLE `llx_actioncomm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_actioncomm_extrafields`
--

DROP TABLE IF EXISTS `llx_actioncomm_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_actioncomm_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_actioncomm_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_actioncomm_extrafields`
--

LOCK TABLES `llx_actioncomm_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_actioncomm_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_actioncomm_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_actioncomm_reminder`
--

DROP TABLE IF EXISTS `llx_actioncomm_reminder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_actioncomm_reminder` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `dateremind` datetime NOT NULL,
  `typeremind` varchar(32) NOT NULL,
  `fk_user` int(11) NOT NULL,
  `offsetvalue` int(11) NOT NULL,
  `offsetunit` varchar(1) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_actioncomm_reminder_unique` (`fk_user`,`typeremind`,`offsetvalue`,`offsetunit`),
  KEY `idx_actioncomm_reminder_rowid` (`rowid`),
  KEY `idx_actioncomm_reminder_dateremind` (`dateremind`),
  KEY `idx_actioncomm_reminder_fk_user` (`fk_user`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_actioncomm_reminder`
--

LOCK TABLES `llx_actioncomm_reminder` WRITE;
/*!40000 ALTER TABLE `llx_actioncomm_reminder` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_actioncomm_reminder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_actioncomm_resources`
--

DROP TABLE IF EXISTS `llx_actioncomm_resources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_actioncomm_resources` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_actioncomm` int(11) NOT NULL,
  `element_type` varchar(50) NOT NULL,
  `fk_element` int(11) NOT NULL,
  `answer_status` varchar(50) DEFAULT NULL,
  `mandatory` smallint(6) DEFAULT NULL,
  `transparency` smallint(6) DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_actioncomm_resources` (`fk_actioncomm`,`element_type`,`fk_element`),
  KEY `idx_actioncomm_resources_fk_element` (`fk_element`)
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_actioncomm_resources`
--

LOCK TABLES `llx_actioncomm_resources` WRITE;
/*!40000 ALTER TABLE `llx_actioncomm_resources` DISABLE KEYS */;
INSERT INTO `llx_actioncomm_resources` VALUES (1,1,'user',1,'0',0,0),(2,2,'user',2,'0',0,0),(3,3,'user',2,'0',0,0),(4,4,'user',2,'0',0,0),(5,5,'user',2,'0',0,0),(6,6,'user',2,'0',0,0),(7,7,'user',2,'0',0,0),(8,8,'user',2,'0',0,0),(9,9,'user',2,'0',0,0),(10,10,'user',2,'0',0,0),(11,11,'user',2,'0',0,0),(12,12,'user',2,'0',0,0),(13,13,'user',2,'0',0,0),(14,14,'user',2,'0',0,0),(15,15,'user',2,'0',0,0),(16,16,'user',2,'0',0,0),(17,17,'user',2,'0',0,0),(18,18,'user',2,'0',0,0),(19,19,'user',2,'0',0,0),(20,20,'user',2,'0',0,0),(21,21,'user',2,'0',0,0),(22,22,'user',2,'0',0,0),(23,23,'user',2,'0',0,0),(24,24,'user',2,'0',0,0),(25,25,'user',2,'0',0,0),(26,26,'user',2,'0',0,0),(27,27,'user',2,'0',0,0),(28,28,'user',2,'0',0,0),(29,29,'user',2,'0',0,0),(30,30,'user',2,'0',0,0),(31,31,'user',2,'0',0,0),(32,32,'user',2,'0',0,0),(33,33,'user',2,'0',0,0),(34,34,'user',2,'0',0,0),(35,35,'user',2,'0',0,0),(36,36,'user',2,'0',0,0),(37,37,'user',2,'0',0,0),(38,38,'user',2,'0',0,0),(39,39,'user',2,'0',0,0),(40,40,'user',2,'0',0,0),(41,41,'user',2,'0',0,0),(42,42,'user',2,'0',0,0),(43,43,'user',2,'0',0,0),(44,44,'user',2,'0',0,0),(45,45,'user',2,'0',0,0),(46,46,'user',2,'0',0,0),(47,47,'user',2,'0',0,0),(48,48,'user',2,'0',0,0),(49,49,'user',2,'0',0,0),(50,50,'user',2,'0',0,0),(51,51,'user',2,'0',0,0),(52,52,'user',2,'0',0,0),(53,53,'user',2,'0',0,0),(54,54,'user',2,'0',0,0),(55,55,'user',2,'0',0,0),(56,56,'user',2,'0',0,0),(57,57,'user',2,'0',0,0),(58,58,'user',2,'0',0,0),(59,59,'user',2,'0',0,0),(60,60,'user',2,'0',0,0),(61,61,'user',2,'0',0,0),(62,62,'user',2,'0',0,0),(63,63,'user',2,'0',0,0),(64,64,'user',2,'0',0,0),(65,65,'user',2,'0',0,0),(66,66,'user',2,'0',0,0),(67,67,'user',2,'0',0,0),(68,68,'user',2,'0',0,0),(69,69,'user',2,'0',0,0),(70,70,'user',2,'0',0,0),(71,71,'user',2,'0',0,0),(72,72,'user',2,'0',0,0),(73,73,'user',2,'0',0,0),(74,74,'user',2,'0',0,0),(75,75,'user',2,'0',0,0),(76,76,'user',2,'0',0,0),(77,77,'user',2,'0',0,0),(78,78,'user',2,'0',0,0),(79,79,'user',2,'0',0,0),(80,80,'user',2,'0',0,0),(81,81,'user',2,'0',0,0),(82,82,'user',2,'0',0,0),(83,83,'user',2,'0',0,0),(84,84,'user',2,'0',0,0),(85,85,'user',2,'0',0,0),(86,86,'user',2,'0',0,0),(87,87,'user',2,'0',0,0),(88,88,'user',2,'0',0,0),(89,89,'user',2,'0',0,0),(90,90,'user',2,'0',0,0),(91,91,'user',2,'0',0,0),(92,92,'user',2,'0',0,0),(93,93,'user',2,'0',0,0),(94,94,'user',2,'0',0,0),(95,95,'user',2,'0',0,0),(96,96,'user',2,'0',0,0),(97,97,'user',2,'0',0,0),(98,98,'user',2,'0',0,0),(99,99,'user',2,'0',0,0),(100,100,'user',2,'0',0,0),(101,101,'user',2,'0',0,0),(102,102,'user',2,'0',0,0),(103,103,'user',2,'0',0,0),(104,104,'user',2,'0',0,0),(105,105,'user',2,'0',0,0),(106,106,'user',2,'0',0,0),(107,107,'user',2,'0',0,0),(108,108,'user',2,'0',0,0),(109,109,'user',2,'0',0,0),(110,110,'user',2,'0',0,0),(111,111,'user',2,'0',0,0),(112,112,'user',2,'0',0,0),(113,113,'user',2,'0',0,0),(114,114,'user',2,'0',0,0),(115,115,'user',2,'0',0,0),(116,116,'user',2,'0',0,0),(117,117,'user',2,'0',0,0),(118,118,'user',2,'0',0,0),(119,119,'user',2,'0',0,0),(120,120,'user',2,'0',0,0),(121,121,'user',2,'0',0,0),(122,122,'user',2,'0',0,0),(123,123,'user',2,'0',0,0),(124,124,'user',2,'0',0,0),(125,125,'user',2,'0',0,0),(126,126,'user',2,'0',0,0),(127,127,'user',2,'0',0,0),(128,128,'user',2,'0',0,0),(129,129,'user',2,'0',0,0),(130,130,'user',2,'0',0,0),(131,131,'user',2,'0',0,0),(132,132,'user',2,'0',0,0),(133,133,'user',2,'0',0,0),(134,134,'user',2,'0',0,0),(135,135,'user',2,'0',0,0),(136,136,'user',2,'0',0,0),(137,137,'user',2,'0',0,0),(138,138,'user',2,'0',0,0),(139,139,'user',2,'0',0,0),(140,140,'user',2,'0',0,0),(141,141,'user',2,'0',0,0),(142,142,'user',2,'0',0,0),(143,143,'user',2,'0',0,0),(144,144,'user',2,'0',0,0),(145,145,'user',2,'0',0,0),(146,146,'user',2,'0',0,0),(147,147,'user',2,'0',0,0),(148,148,'user',2,'0',0,0),(149,149,'user',2,'0',0,0),(150,150,'user',2,'0',0,0),(151,151,'user',2,'0',0,0),(152,152,'user',2,'0',0,0),(153,153,'user',2,'0',0,0),(154,154,'user',2,'0',0,0),(155,155,'user',2,'0',0,0),(156,156,'user',2,'0',0,0),(157,157,'user',2,'0',0,0),(158,158,'user',2,'0',0,0),(159,159,'user',2,'0',0,0),(160,160,'user',2,'0',0,0),(161,161,'user',2,'0',0,0),(162,162,'user',2,'0',0,0),(163,163,'user',2,'0',0,0),(164,164,'user',2,'0',0,0),(165,165,'user',2,'0',0,0),(166,166,'user',2,'0',0,0),(167,167,'user',2,'0',0,0),(168,168,'user',2,'0',0,0),(169,169,'user',2,'0',0,0),(170,170,'user',2,'0',0,0),(171,171,'user',2,'0',0,0),(172,172,'user',2,'0',0,0),(173,173,'user',2,'0',0,0),(174,174,'user',2,'0',0,0),(175,175,'user',2,'0',0,0),(176,176,'user',2,'0',0,0),(177,177,'user',2,'0',0,0),(178,178,'user',2,'0',0,0),(179,179,'user',2,'0',0,0),(180,180,'user',2,'0',0,0),(181,181,'user',2,'0',0,0),(182,182,'user',2,'0',0,0),(183,183,'user',2,'0',0,0),(184,184,'user',2,'0',0,0),(185,185,'user',2,'0',0,0),(186,186,'user',2,'0',0,0),(187,187,'user',2,'0',0,0),(188,188,'user',2,'0',0,0),(189,189,'user',2,'0',0,0),(190,190,'user',2,'0',0,0),(191,191,'user',2,'0',0,0),(192,192,'user',2,'0',0,0),(193,193,'user',2,'0',0,0),(194,194,'user',2,'0',0,0),(195,195,'user',2,'0',0,0),(196,196,'user',2,'0',0,0),(197,197,'user',2,'0',0,0),(198,198,'user',2,'0',0,0),(199,199,'user',2,'0',0,0),(200,200,'user',2,'0',0,0),(201,201,'user',2,'0',0,0),(202,202,'user',2,'0',0,0),(203,203,'user',2,'0',0,0),(204,204,'user',2,'0',0,0),(205,205,'user',2,'0',0,0),(206,206,'user',2,'0',0,0),(207,207,'user',2,'0',0,0),(208,208,'user',2,'0',0,0),(209,209,'user',2,'0',0,0),(210,210,'user',2,'0',0,0),(211,211,'user',2,'0',0,0),(212,212,'user',2,'0',0,0),(213,213,'user',2,'0',0,0),(214,214,'user',2,'0',0,0),(215,215,'user',2,'0',0,0),(216,216,'user',2,'0',0,0),(217,217,'user',2,'0',0,0),(218,218,'user',2,'0',0,0),(219,219,'user',2,'0',0,0),(220,220,'user',2,'0',0,0),(221,221,'user',2,'0',0,0),(222,222,'user',2,'0',0,0),(223,223,'user',2,'0',0,0),(224,224,'user',2,'0',0,0),(225,225,'user',2,'0',0,0),(226,226,'user',2,'0',0,0),(227,227,'user',2,'0',0,0),(228,228,'user',2,'0',0,0),(229,229,'user',2,'0',0,0),(230,230,'user',2,'0',0,0),(231,231,'user',2,'0',0,0),(232,232,'user',2,'0',0,0),(233,233,'user',2,'0',0,0),(234,234,'user',2,'0',0,0),(235,235,'user',2,'0',0,0),(236,236,'user',2,'0',0,0),(237,237,'user',2,'0',0,0),(238,238,'user',2,'0',0,0),(239,239,'user',2,'0',0,0),(240,240,'user',2,'0',0,0),(241,241,'user',2,'0',0,0),(242,242,'user',2,'0',0,0),(243,243,'user',2,'0',0,0),(244,244,'user',2,'0',0,0),(245,245,'user',2,'0',0,0),(246,246,'user',2,'0',0,0),(247,247,'user',2,'0',0,0),(248,248,'user',2,'0',0,0),(249,249,'user',2,'0',0,0),(250,250,'user',2,'0',0,0),(251,251,'user',2,'0',0,0),(252,252,'user',2,'0',0,0),(253,253,'user',2,'0',0,0),(254,254,'user',2,'0',0,0),(255,255,'user',2,'0',0,0),(256,256,'user',2,'0',0,0),(257,257,'user',2,'0',0,0),(258,258,'user',2,'0',0,0),(259,259,'user',2,'0',0,0),(260,260,'user',2,'0',0,0),(261,261,'user',2,'0',0,0),(262,262,'user',2,'0',0,0),(263,263,'user',2,'0',0,0),(264,264,'user',2,'0',0,0),(265,265,'user',2,'0',0,0),(266,266,'user',2,'0',0,0),(267,267,'user',2,'0',0,0),(268,268,'user',2,'0',0,0),(269,269,'user',2,'0',0,0),(270,270,'user',2,'0',0,0),(271,271,'user',2,'0',0,0),(272,272,'user',2,'0',0,0),(273,273,'user',2,'0',0,0),(274,274,'user',2,'0',0,0),(275,275,'user',2,'0',0,0),(276,276,'user',2,'0',0,0),(277,277,'user',2,'0',0,0),(278,278,'user',2,'0',0,0),(279,279,'user',2,'0',0,0),(280,280,'user',2,'0',0,0),(281,281,'user',2,'0',0,0),(282,282,'user',2,'0',0,0),(283,283,'user',2,'0',0,0),(284,284,'user',2,'0',0,0),(285,285,'user',2,'0',0,0),(286,286,'user',2,'0',0,0),(287,287,'user',2,'0',0,0),(288,288,'user',2,'0',0,0),(289,289,'user',2,'0',0,0),(290,290,'user',2,'0',0,0),(291,291,'user',2,'0',0,0),(292,292,'user',2,'0',0,0),(293,293,'user',2,'0',0,0),(294,294,'user',2,'0',0,0),(295,295,'user',2,'0',0,0),(296,296,'user',2,'0',0,0),(297,297,'user',2,'0',0,0),(298,298,'user',2,'0',0,0),(299,299,'user',2,'0',0,0),(300,300,'user',2,'0',0,0),(301,301,'user',1,'0',0,0),(302,302,'user',1,'0',0,0),(303,303,'user',2,'0',0,0),(304,304,'user',1,'0',0,0),(305,305,'user',1,'0',0,0),(306,306,'user',1,'0',0,0),(307,307,'user',1,'0',0,0),(308,308,'user',1,'0',0,0),(309,309,'user',1,'0',0,0),(310,310,'user',1,'0',0,0),(311,311,'user',1,'0',0,0),(312,312,'user',1,'0',0,0),(313,313,'user',1,'0',0,0),(314,314,'user',1,'0',0,0),(315,315,'user',1,'0',0,0),(316,316,'user',1,'0',0,0),(317,317,'user',1,'0',0,0),(318,318,'user',1,'0',0,0),(319,319,'user',1,'0',0,0),(320,320,'user',1,'0',0,0),(321,321,'user',1,'0',0,0),(322,322,'user',1,'0',0,0),(323,323,'user',1,'0',0,0),(324,324,'user',1,'0',0,0),(325,325,'user',1,'0',0,0),(326,326,'user',1,'0',0,0),(327,327,'user',1,'0',0,0),(328,328,'user',1,'0',0,0),(329,329,'user',1,'0',0,0),(330,330,'user',1,'0',0,0),(331,331,'user',1,'0',0,0),(332,332,'user',1,'0',0,0),(333,333,'user',1,'0',0,0),(334,334,'user',1,'0',0,0),(335,335,'user',1,'0',0,0),(336,336,'user',1,'0',0,0),(337,337,'user',1,'0',0,0),(338,338,'user',1,'0',0,0),(339,339,'user',1,'0',0,0),(340,340,'user',1,'0',0,0),(341,341,'user',1,'0',0,0),(342,342,'user',1,'0',0,0),(343,343,'user',1,'0',0,0),(344,344,'user',1,'0',0,0),(345,345,'user',1,'0',0,0),(346,346,'user',1,'0',0,0),(347,347,'user',1,'0',0,0),(348,348,'user',1,'0',0,0),(349,349,'user',1,'0',0,0),(350,350,'user',1,'0',0,0),(351,351,'user',1,'0',0,0),(352,352,'user',1,'0',0,0),(353,353,'user',1,'0',0,0),(354,354,'user',1,'0',0,0),(355,355,'user',1,'0',0,0),(356,356,'user',1,'0',0,0),(357,357,'user',1,'0',0,0),(358,358,'user',1,'0',0,0),(359,359,'user',1,'0',0,0),(360,360,'user',1,'0',0,0),(361,361,'user',1,'0',0,0),(362,362,'user',1,'0',0,0),(363,363,'user',1,'0',0,0),(364,364,'user',1,'0',0,0),(365,365,'user',1,'0',0,0),(366,366,'user',1,'0',0,0),(367,367,'user',1,'0',0,0),(368,368,'user',1,'0',0,0),(369,369,'user',1,'0',0,0),(370,370,'user',1,'0',0,0),(371,371,'user',1,'0',0,0),(372,372,'user',1,'0',0,0),(373,373,'user',1,'0',0,0),(374,374,'user',1,'0',0,0),(375,375,'user',1,'0',0,0),(376,376,'user',1,'0',0,0),(377,377,'user',1,'0',0,0),(378,378,'user',1,'0',0,0),(379,379,'user',1,'0',0,0),(380,380,'user',1,'0',0,0),(381,381,'user',1,'0',0,0);
/*!40000 ALTER TABLE `llx_actioncomm_resources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_adherent`
--

DROP TABLE IF EXISTS `llx_adherent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_adherent` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `ref_ext` varchar(128) DEFAULT NULL,
  `civility` varchar(6) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `firstname` varchar(50) DEFAULT NULL,
  `login` varchar(50) DEFAULT NULL,
  `pass` varchar(50) DEFAULT NULL,
  `pass_crypted` varchar(128) DEFAULT NULL,
  `fk_adherent_type` int(11) NOT NULL,
  `morphy` varchar(3) NOT NULL,
  `societe` varchar(128) DEFAULT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `address` text,
  `zip` varchar(30) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `country` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `skype` varchar(255) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone_perso` varchar(30) DEFAULT NULL,
  `phone_mobile` varchar(30) DEFAULT NULL,
  `birth` date DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `statut` smallint(6) NOT NULL DEFAULT '0',
  `public` smallint(6) NOT NULL DEFAULT '0',
  `datefin` datetime DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `datevalid` datetime DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_mod` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `canvas` varchar(32) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_adherent_login` (`login`,`entity`),
  UNIQUE KEY `uk_adherent_fk_soc` (`fk_soc`),
  KEY `idx_adherent_fk_adherent_type` (`fk_adherent_type`),
  CONSTRAINT `adherent_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_adherent_adherent_type` FOREIGN KEY (`fk_adherent_type`) REFERENCES `llx_adherent_type` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_adherent`
--

LOCK TABLES `llx_adherent` WRITE;
/*!40000 ALTER TABLE `llx_adherent` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_adherent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_adherent_extrafields`
--

DROP TABLE IF EXISTS `llx_adherent_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_adherent_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_adherent_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_adherent_extrafields`
--

LOCK TABLES `llx_adherent_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_adherent_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_adherent_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_adherent_type`
--

DROP TABLE IF EXISTS `llx_adherent_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_adherent_type` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `statut` smallint(6) NOT NULL DEFAULT '0',
  `libelle` varchar(50) NOT NULL,
  `subscription` varchar(3) NOT NULL DEFAULT 'yes',
  `vote` varchar(3) NOT NULL DEFAULT 'yes',
  `note` text,
  `mail_valid` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_adherent_type_libelle` (`libelle`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_adherent_type`
--

LOCK TABLES `llx_adherent_type` WRITE;
/*!40000 ALTER TABLE `llx_adherent_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_adherent_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_adherent_type_extrafields`
--

DROP TABLE IF EXISTS `llx_adherent_type_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_adherent_type_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_adherent_type_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_adherent_type_extrafields`
--

LOCK TABLES `llx_adherent_type_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_adherent_type_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_adherent_type_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_advtargetemailing`
--

DROP TABLE IF EXISTS `llx_advtargetemailing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_advtargetemailing` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(180) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_mailing` int(11) NOT NULL,
  `filtervalue` text,
  `fk_user_author` int(11) NOT NULL,
  `datec` datetime NOT NULL,
  `fk_user_mod` int(11) NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_advtargetemailing_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_advtargetemailing`
--

LOCK TABLES `llx_advtargetemailing` WRITE;
/*!40000 ALTER TABLE `llx_advtargetemailing` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_advtargetemailing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank`
--

DROP TABLE IF EXISTS `llx_bank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bank` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datev` date DEFAULT NULL,
  `dateo` date DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `label` varchar(255) DEFAULT NULL,
  `fk_account` int(11) DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_rappro` int(11) DEFAULT NULL,
  `fk_type` varchar(6) DEFAULT NULL,
  `num_releve` varchar(50) DEFAULT NULL,
  `num_chq` varchar(50) DEFAULT NULL,
  `numero_compte` varchar(32) DEFAULT NULL,
  `rappro` tinyint(4) DEFAULT '0',
  `note` text,
  `fk_bordereau` int(11) DEFAULT '0',
  `banque` varchar(255) DEFAULT NULL,
  `emetteur` varchar(255) DEFAULT NULL,
  `author` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_bank_datev` (`datev`),
  KEY `idx_bank_dateo` (`dateo`),
  KEY `idx_bank_fk_account` (`fk_account`),
  KEY `idx_bank_rappro` (`rappro`),
  KEY `idx_bank_num_releve` (`num_releve`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bank`
--

LOCK TABLES `llx_bank` WRITE;
/*!40000 ALTER TABLE `llx_bank` DISABLE KEYS */;
INSERT INTO `llx_bank` VALUES (1,'2018-06-12 09:44:29','2018-06-12 09:44:29','2018-06-12','2018-06-12',0.00000000,'(Solde initial)',1,2,NULL,'SOLD',NULL,NULL,'',0,NULL,0,NULL,NULL,NULL),(2,'2018-07-06 09:45:21','2018-07-06 09:45:21','2018-07-06','2018-07-06',4840.00000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'AAB sprl',NULL),(3,'2018-07-06 09:45:37','2018-07-06 09:45:37','2018-07-06','2018-07-06',242.00000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'Alves et Andrade renov',NULL),(4,'2018-07-20 06:45:20','2018-07-20 06:45:20','2018-07-20','2018-07-20',80.00000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'Monsieur Allali Mohamed',NULL),(5,'2018-08-24 09:08:47','2018-08-24 09:08:47','2018-08-24','2018-08-24',1633.50000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'2A Group sprl',NULL),(6,'2018-08-24 09:09:04','2018-08-24 09:09:04','2018-08-24','2018-08-24',-1089.00000000,'(CustomerInvoicePaymentBack)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'Loca Box',NULL),(7,'2018-10-04 09:34:50','2018-10-04 09:34:50','2018-10-04','2018-10-04',5000.00000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'Delta-relay ,sprl',NULL),(8,'2018-10-04 09:35:44','2018-10-04 09:35:44','2018-10-04','2018-10-04',544.50000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'AA BUSINESS',NULL),(9,'2018-10-04 09:36:33','2018-10-04 09:36:33','2018-10-04','2018-10-04',642.00000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'Alves et Andrade renov',NULL),(10,'2018-10-04 09:36:50','2018-10-04 09:36:50','2018-10-04','2018-10-04',-242.00000000,'(CustomerInvoicePaymentBack)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'Loca Box',NULL),(11,'2018-12-07 10:21:46','2018-12-07 10:21:46','2018-12-07','2018-12-07',556.00000000,'(CustomerInvoicePayment)',1,1,NULL,'VIR',NULL,NULL,'',0,NULL,0,NULL,'Darchambeau  Florence',NULL);
/*!40000 ALTER TABLE `llx_bank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_account`
--

DROP TABLE IF EXISTS `llx_bank_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bank_account` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ref` varchar(12) NOT NULL,
  `label` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `bank` varchar(60) DEFAULT NULL,
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `bic` varchar(11) DEFAULT NULL,
  `iban_prefix` varchar(34) DEFAULT NULL,
  `country_iban` varchar(2) DEFAULT NULL,
  `cle_iban` varchar(2) DEFAULT NULL,
  `domiciliation` varchar(255) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `fk_pays` int(11) NOT NULL,
  `proprio` varchar(60) DEFAULT NULL,
  `owner_address` varchar(255) DEFAULT NULL,
  `courant` smallint(6) NOT NULL DEFAULT '0',
  `clos` smallint(6) NOT NULL DEFAULT '0',
  `rappro` smallint(6) DEFAULT '1',
  `url` varchar(128) DEFAULT NULL,
  `account_number` varchar(32) DEFAULT NULL,
  `fk_accountancy_journal` int(11) DEFAULT NULL,
  `currency_code` varchar(3) NOT NULL,
  `min_allowed` int(11) DEFAULT '0',
  `min_desired` int(11) DEFAULT '0',
  `comment` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bank_account_label` (`label`,`entity`),
  KEY `idx_fk_accountancy_journal` (`fk_accountancy_journal`),
  CONSTRAINT `fk_bank_account_accountancy_journal` FOREIGN KEY (`fk_accountancy_journal`) REFERENCES `llx_accounting_journal` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bank_account`
--

LOCK TABLES `llx_bank_account` WRITE;
/*!40000 ALTER TABLE `llx_bank_account` DISABLE KEYS */;
INSERT INTO `llx_bank_account` VALUES (1,'2018-06-12 09:44:29','2018-06-12 09:44:29','BNP4929','BNP4929',1,NULL,NULL,'BNP Parisbas Fortis','','','BE26001838734929','','GEBABEBB09A','BE26001838734929',NULL,NULL,'',NULL,2,'Loca Box','',1,0,1,NULL,'BQ',NULL,'EUR',NULL,NULL,'',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `llx_bank_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_account_extrafields`
--

DROP TABLE IF EXISTS `llx_bank_account_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bank_account_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_bank_account_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bank_account_extrafields`
--

LOCK TABLES `llx_bank_account_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_bank_account_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bank_account_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_categ`
--

DROP TABLE IF EXISTS `llx_bank_categ`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bank_categ` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(255) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bank_categ`
--

LOCK TABLES `llx_bank_categ` WRITE;
/*!40000 ALTER TABLE `llx_bank_categ` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bank_categ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_class`
--

DROP TABLE IF EXISTS `llx_bank_class`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bank_class` (
  `lineid` int(11) NOT NULL,
  `fk_categ` int(11) NOT NULL,
  UNIQUE KEY `uk_bank_class_lineid` (`lineid`,`fk_categ`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bank_class`
--

LOCK TABLES `llx_bank_class` WRITE;
/*!40000 ALTER TABLE `llx_bank_class` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bank_class` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bank_url`
--

DROP TABLE IF EXISTS `llx_bank_url`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bank_url` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_bank` int(11) DEFAULT NULL,
  `url_id` int(11) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `type` varchar(24) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bank_url` (`fk_bank`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bank_url`
--

LOCK TABLES `llx_bank_url` WRITE;
/*!40000 ALTER TABLE `llx_bank_url` DISABLE KEYS */;
INSERT INTO `llx_bank_url` VALUES (1,2,1,'/compta/paiement/card.php?id=','(paiement)','payment'),(2,2,2,'/comm/card.php?socid=','AAB sprl','company'),(3,3,2,'/compta/paiement/card.php?id=','(paiement)','payment'),(4,3,3,'/comm/card.php?socid=','Alves et Andrade renov','company'),(5,4,3,'/compta/paiement/card.php?id=','(paiement)','payment'),(6,4,4,'/comm/card.php?socid=','Monsieur Allali Mohamed','company'),(7,5,4,'/compta/paiement/card.php?id=','(paiement)','payment'),(8,5,5,'/comm/card.php?socid=','2A Group sprl','company'),(9,6,5,'/compta/paiement/card.php?id=','(paiement)','payment'),(10,6,5,'/comm/card.php?socid=','2A Group sprl','company'),(11,7,6,'/compta/paiement/card.php?id=','(paiement)','payment'),(12,7,8,'/comm/card.php?socid=','Delta-relay ,sprl','company'),(13,8,7,'/compta/paiement/card.php?id=','(paiement)','payment'),(14,8,7,'/comm/card.php?socid=','AA BUSINESS','company'),(15,9,8,'/compta/paiement/card.php?id=','(paiement)','payment'),(16,9,3,'/comm/card.php?socid=','Alves et Andrade renov','company'),(17,10,9,'/compta/paiement/card.php?id=','(paiement)','payment'),(18,10,3,'/comm/card.php?socid=','Alves et Andrade renov','company'),(19,11,10,'/compta/paiement/card.php?id=','(paiement)','payment'),(20,11,10,'/comm/card.php?socid=','Darchambeau  Florence','company');
/*!40000 ALTER TABLE `llx_bank_url` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_blockedlog`
--

DROP TABLE IF EXISTS `llx_blockedlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_blockedlog` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `action` varchar(50) DEFAULT NULL,
  `amounts` double(24,8) NOT NULL,
  `element` varchar(50) DEFAULT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `user_fullname` varchar(255) DEFAULT NULL,
  `fk_object` int(11) DEFAULT NULL,
  `ref_object` varchar(255) DEFAULT NULL,
  `date_object` datetime DEFAULT NULL,
  `signature` varchar(100) NOT NULL,
  `signature_line` varchar(100) NOT NULL,
  `object_data` text,
  `certified` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `signature` (`signature`),
  KEY `fk_object_element` (`fk_object`,`element`),
  KEY `entity` (`entity`),
  KEY `fk_user` (`fk_user`),
  KEY `entity_action` (`entity`,`action`),
  KEY `entity_action_certified` (`entity`,`action`,`certified`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_blockedlog`
--

LOCK TABLES `llx_blockedlog` WRITE;
/*!40000 ALTER TABLE `llx_blockedlog` DISABLE KEYS */;
INSERT INTO `llx_blockedlog` VALUES (1,1,'2018-05-18 19:21:14','2018-05-18 19:21:14','MODULE_SET',0.00000000,'module',1,'SuperAdmin',1,'systemevent','2018-05-18 19:21:14','e707f335a67dec89886ab399b67df4ec518cb146385ff565b6140472a3a90a08','9490dd182550ffdc4b004ba459821f70d17adce2f294c146c9073ebc6647217b','O:8:\"stdClass\":6:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:0:\"\";s:3:\"zip\";s:0:\"\";s:4:\"town\";s:0:\"\";s:10:\"state_code\";N;s:5:\"phone\";s:0:\"\";s:3:\"fax\";s:0:\"\";s:5:\"email\";s:0:\"\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:0:\"\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:0:\"\";s:4:\"name\";s:0:\"\";}s:2:\"id\";i:1;s:7:\"element\";s:6:\"module\";s:3:\"ref\";s:11:\"systemevent\";s:6:\"entity\";i:1;s:4:\"date\";i:1526671274;}',0),(2,1,'2018-06-08 09:52:01','2018-06-08 09:52:01','BILL_DELETE',0.00000000,'facture',1,'SuperAdmin',1,'(PROV1)','2018-06-08 00:00:00','1d2a588b65ff153403896cbd919f0a809e6330e772cbe204c5b07430041a4942','0dcb4706025fd9139b23b862c2c64423f49525ac7a5a13fab86d902c1c60f050','O:8:\"stdClass\":11:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:13:\"1410 Waterloo\";s:3:\"zip\";N;s:4:\"town\";N;s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1806-0001\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:5:\"vidal\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1528416000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:10:\"0.00000000\";s:9:\"total_tva\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:10:\"0.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:7:\"(PROV1)\";s:11:\"note_public\";N;}',0),(3,1,'2018-06-12 11:51:46','2018-06-12 11:51:46','BILL_VALIDATE',4840.00000000,'facture',2,'callsoft callsoft',2,'FA1806-0001','2018-06-12 00:00:00','5261a1a697fc0fbbecba15edf6cfd521ed9fccab9a7b0e6a0d1feb5850947b19','7fc72953540a1ce975969fd1f05679d4e6a0431b7216f1b64aca66bcc8244d99','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:28:\"Rue des Vétérinaires 29-31\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:14:\"be0459.006.473\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1806-0002\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"AAB sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1528761600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:4000;s:9:\"total_tva\";d:840;s:9:\"total_ttc\";d:4840;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4000.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"840.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"4840.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1806-0001\";s:11:\"note_public\";N;}',0),(4,1,'2018-06-12 11:51:54','2018-06-12 11:51:54','DOC_DOWNLOAD',4840.00000000,'facture',2,'callsoft callsoft',2,'FA1806-0001','2018-06-12 00:00:00','f7f630b7c7bdc12e0d88799f2e235cab7159bfd934db50985adc34ddb3357624','a48d455a89d35a1db9a0c046df31531aa86fbb014abd04ff108e0a0deb7f6c8f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:28:\"Rue des Vétérinaires 29-31\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:14:\"be0459.006.473\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1806-0002\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"AAB sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1528761600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4000.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"840.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"4840.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1806-0001\";s:11:\"note_public\";N;}',0),(5,1,'2018-07-06 09:22:00','2018-07-06 09:22:00','DOC_DOWNLOAD',4840.00000000,'facture',1,'SuperAdmin',2,'FA1806-0001','2018-06-12 00:00:00','7afc885b2230474863be277455d12350671922011ca845c26aaa97de27124a0f','d76b1b7663f16ba56d5c9860ef8442351c38725cf72e1f13f3fee474500fe100','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:28:\"Rue des Vétérinaires 29-31\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:14:\"be0459.006.473\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1806-0002\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"AAB sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1528761600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4000.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"840.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"4840.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1806-0001\";s:11:\"note_public\";N;}',0),(6,1,'2018-07-06 09:24:41','2018-07-06 09:24:41','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',3,'FA1807-0002','2018-07-06 00:00:00','fe9aa10cf2c08740d542f8eb2a39bc8b6ffcdb962a963bb46e1eec70e1a2225a','1e95d2c46f24ae4f19b4a89db862721eb782c27634c4673f1481f8024161abdc','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0002\";s:11:\"note_public\";N;}',0),(7,1,'2018-07-06 09:24:47','2018-07-06 09:24:47','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',3,'FA1807-0002','2018-07-06 00:00:00','98215363b70980dd9cdbd07def21fdae5e873533e60f9c48133720bec1016ef0','0a2d3162babc246416a5d865264a2d146e90c5fd522f953556bd916e942e557e','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0002\";s:11:\"note_public\";N;}',0),(8,1,'2018-07-06 09:25:05','2018-07-06 09:25:05','DOC_DOWNLOAD',4840.00000000,'facture',1,'SuperAdmin',2,'FA1806-0001','2018-06-12 00:00:00','6bdd9aa06aae71c8832f78dbf9e6c1784c4609fc47d65bce69691f00cda9055a','b64e853bd9a48fbab7122ecfb101bd19098bfcc240eb1735fdca68e891a01a1d','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:28:\"Rue des Vétérinaires 29-31\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:14:\"be0459.006.473\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1806-0002\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"AAB sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1528761600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4000.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"840.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"4840.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1806-0001\";s:11:\"note_public\";N;}',0),(9,1,'2018-07-06 09:41:00','2018-07-06 09:41:00','BILL_VALIDATE',80.00000000,'facture',1,'SuperAdmin',4,'FA1807-0003','2018-07-06 00:00:00','937a8808bf326b466d91ea5ebbf186a2d64767994c0119fa3cd32d68c2f127d4','a7ed8fa4e52419fa2e7346088fd7bb37f38df8e55d6f604e34ec02f6439d629f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"Square Henry 5\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0004\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:23:\"Monsieur Allali Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:66.12;s:9:\"total_tva\";d:13.88;s:9:\"total_ttc\";d:80;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"66.12000000\";s:23:\"multicurrency_total_tva\";s:11:\"13.88000000\";s:23:\"multicurrency_total_ttc\";s:11:\"80.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0003\";s:11:\"note_public\";N;}',0),(10,1,'2018-07-06 09:41:02','2018-07-06 09:41:02','DOC_DOWNLOAD',80.00000000,'facture',1,'SuperAdmin',4,'FA1807-0003','2018-07-06 00:00:00','9bc85f67a798b4683b692a283fe838a3b5eadeea751d812fdd362aa637633aea','a90112db5545812946024e8ae25dff7d6da257bb70b661ce6657b168abe2af6d','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"Square Henry 5\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0004\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:23:\"Monsieur Allali Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"66.12000000\";s:23:\"multicurrency_total_tva\";s:11:\"13.88000000\";s:23:\"multicurrency_total_ttc\";s:11:\"80.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0003\";s:11:\"note_public\";N;}',0),(11,1,'2018-07-06 09:41:06','2018-07-06 09:41:06','DOC_DOWNLOAD',80.00000000,'facture',1,'SuperAdmin',4,'FA1807-0003','2018-07-06 00:00:00','2196bbed7970b5659813edf77aec30e32c6c48c715e69eaac0ef791f137f75b2','863369389f7e3d5ca4fa50171659c5f112d7efb3fcba4a58815374d098b2ad6e','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"Square Henry 5\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0004\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:23:\"Monsieur Allali Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"66.12000000\";s:23:\"multicurrency_total_tva\";s:11:\"13.88000000\";s:23:\"multicurrency_total_ttc\";s:11:\"80.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0003\";s:11:\"note_public\";N;}',0),(12,1,'2018-07-06 09:43:24','2018-07-06 09:43:24','BILL_VALIDATE',80.00000000,'facture',1,'SuperAdmin',4,'FA1807-0003','2018-07-06 00:00:00','c71cb562c34ed5dfd67c2a762684a616e73f149230ef129d7adb3653f094de7c','b51fdf3dfda371c9c9a4e635954c03b6081986324bc0d9c4ecb5ee5d59bd4da2','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"Square Henry 5\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0004\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:23:\"Monsieur Allali Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:66.12;s:9:\"total_tva\";d:13.88;s:9:\"total_ttc\";d:80;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"66.12000000\";s:23:\"multicurrency_total_tva\";s:11:\"13.88000000\";s:23:\"multicurrency_total_ttc\";s:11:\"80.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0003\";s:11:\"note_public\";N;}',0),(13,1,'2018-07-06 09:43:26','2018-07-06 09:43:26','DOC_DOWNLOAD',80.00000000,'facture',1,'SuperAdmin',4,'FA1807-0003','2018-07-06 00:00:00','acd8e66b0c6176959c820a41d0ee9d1004adf90c6e5548e6ee603dbfe0530ca2','86330b7e3bbf621163af28eb4840e9c7587b2707848436bc1247b322e69464b5','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"Square Henry 5\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0004\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:23:\"Monsieur Allali Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"66.12000000\";s:23:\"multicurrency_total_tva\";s:11:\"13.88000000\";s:23:\"multicurrency_total_ttc\";s:11:\"80.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0003\";s:11:\"note_public\";N;}',0),(14,1,'2018-07-06 09:45:21','2018-07-06 09:45:21','PAYMENT_CUSTOMER_CREATE',4840.00000000,'payment',1,'SuperAdmin',1,'PAY1807-0001','2018-07-06 12:00:00','09795566be043e2ed4061a934e263b4578c5c0005f6122ccff5ab9929ca587e7','78e7c4b7c2b50d8ab82175db928996ce91d88df1ba9dd408874aa4fa8ddbb6e9','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1807-0001\";s:4:\"date\";i:1530878400;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:4:\"4840\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:28:\"Rue des Vétérinaires 29-31\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:14:\"be0459.006.473\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1806-0002\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"AAB sprl\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1528761600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1806-0001\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:4840;}',0),(15,1,'2018-07-06 09:45:37','2018-07-06 09:45:37','PAYMENT_CUSTOMER_CREATE',242.00000000,'payment',1,'SuperAdmin',2,'PAY1807-0002','2018-07-06 12:00:00','cfada89e1b3aa238a36e4a37e0c543296ec25b6b1c967b29791db12256995569','cf9df9ef7f6af6227f2050e601ddd3b4b9b125b42375363ebf7ba8e8d2f3a840','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1807-0002\";s:4:\"date\";i:1530878400;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:3:\"242\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1807-0002\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:242;}',0),(16,1,'2018-07-06 09:45:41','2018-07-06 09:45:41','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',3,'FA1807-0002','2018-07-06 00:00:00','b878c7403fef6a7e8d7e9b07fbbfd004706b097ae4367a90363b4ab7e9233224','10cac91aaa6d96e3c8944d795718b7809593e73d10da6b523ce34c81d035f3d3','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0002\";s:11:\"note_public\";N;}',0),(17,1,'2018-07-06 09:45:51','2018-07-06 09:45:51','DOC_DOWNLOAD',4840.00000000,'facture',1,'SuperAdmin',2,'FA1806-0001','2018-06-12 00:00:00','e049e3c0acfb6d1c79d3540c8616494085ebe0a8532b6a0157dfefcb4a75f4ea','947c64c451a5598abe9ce759bda66d9e512cebf1276ad390a9afbe188740c309','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:28:\"Rue des Vétérinaires 29-31\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:14:\"be0459.006.473\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1806-0002\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"AAB sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1528761600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4000.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"840.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"4840.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4000.00000000\";s:9:\"total_tva\";s:12:\"840.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"4840.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1806-0001\";s:11:\"note_public\";N;}',0),(18,1,'2018-07-20 06:42:56','2018-07-20 06:42:56','BILL_VALIDATE',1089.00000000,'facture',1,'SuperAdmin',5,'FA1807-0004','2018-07-20 00:00:00','65ab5a1de88a0719aae09302ae3acd8d46cfaff8d1e56ac76cc0f71365935680','2286578d46ca3feddf2b9b2fd36fca13ba4b3b10c415f0084ecde7665b1ed61c','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:900;s:9:\"total_tva\";d:189;s:9:\"total_ttc\";d:1089;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"900.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"189.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0004\";s:11:\"note_public\";N;}',0),(19,1,'2018-07-20 06:43:33','2018-07-20 06:43:33','BILL_SENTBYMAIL',1089.00000000,'facture',1,'SuperAdmin',5,'FA1807-0004','2018-07-20 00:00:00','4157d210197ddf6395b6d43d80828bfd0314ff9fd3cb4769a31a028c3358ad98','609e2d71070321d003bbed1026cad7610812cfd0f5ee037b7227dee6b3945916','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"900.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"189.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0004\";s:11:\"note_public\";N;}',0),(20,1,'2018-07-20 06:44:17','2018-07-20 06:44:17','BILL_VALIDATE',544.50000000,'facture',1,'SuperAdmin',6,'FA1807-0005','2018-07-20 00:00:00','c51516152b547a196c18c41653dc47da87749d1b63b2b03efc882fad8dcdf013','3628aba4b741e0973e3fd0941090d456491d926f242dfc7153664b7d0e06e3d5','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:450;s:9:\"total_tva\";d:94.5;s:9:\"total_ttc\";d:544.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0005\";s:11:\"note_public\";N;}',0),(21,1,'2018-07-20 06:44:38','2018-07-20 06:44:38','BILL_SENTBYMAIL',544.50000000,'facture',1,'SuperAdmin',6,'FA1807-0005','2018-07-20 00:00:00','141aacf7e3ebb04bd5f2b5a4c182519c26b130b4fb67543a2231dd1364f8b9e8','9aa6b9dade649877a3bfd2e0305c3b49fccae3cf0c86fa626fee4f46c1c51438','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0005\";s:11:\"note_public\";N;}',0),(22,1,'2018-07-20 06:45:20','2018-07-20 06:45:20','PAYMENT_CUSTOMER_CREATE',80.00000000,'payment',1,'SuperAdmin',3,'PAY1807-0003','2018-07-20 12:00:00','98854d52b6f4780ccc60bc143a68b380b07376e226a612d450fd03f1d180a80f','2cdb5e31812811c192e60807b4bd15e10c4d925108d9633ba1611a13ddc38988','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1807-0003\";s:4:\"date\";i:1532088000;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:2:\"80\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"Square Henry 5\";s:3:\"zip\";s:4:\"1070\";s:4:\"town\";s:10:\"Anderlecht\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0004\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:23:\"Monsieur Allali Mohamed\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"66.12000000\";s:9:\"total_tva\";s:11:\"13.88000000\";s:9:\"total_ttc\";s:11:\"80.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1807-0003\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:80;}',0),(23,1,'2018-07-20 06:46:16','2018-07-20 06:46:16','DOC_DOWNLOAD',1089.00000000,'facture',1,'SuperAdmin',5,'FA1807-0004','2018-07-20 00:00:00','8c297127ef0df7acd34d7710dbcd6c7d6cf454729e7d8d01fd7417aa58e04f31','dd77def396eed08a1edc52b66b8f4ec68269360e392ccdc301d6da2f48d9994a','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"900.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"189.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0004\";s:11:\"note_public\";N;}',0),(24,1,'2018-07-20 06:46:28','2018-07-20 06:46:28','DOC_DOWNLOAD',544.50000000,'facture',1,'SuperAdmin',6,'FA1807-0005','2018-07-20 00:00:00','c1c2be5660e15ec93b816e23f9ef8d282d47e6286a08c0db02cfb177339af281','846071fdfe196be0ed08d701fd1f2b5ee1b098b4c46f3109b6b8222c08167d92','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0005\";s:11:\"note_public\";N;}',0),(25,1,'2018-07-30 10:09:48','2018-07-30 10:09:48','BILL_VALIDATE',96.80000000,'facture',1,'SuperAdmin',7,'FA1807-0006','2018-07-30 00:00:00','76b1e63697f35e4abd22e41603b1aeb6a4bdbc55e555baf8e30b9a61a774aaae','bfacf687831865677dd5b0bbcc94fa3e9b603a00aeac586b9ebf9f842972d30c','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:0:\"\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"uCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0459258178\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0006\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"eagle express sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532908800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:80;s:9:\"total_tva\";d:16.8;s:9:\"total_ttc\";d:96.8;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"80.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"16.80000000\";s:23:\"multicurrency_total_ttc\";s:11:\"96.80000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"80.00000000\";s:9:\"total_tva\";s:11:\"16.80000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"96.80000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0006\";s:11:\"note_public\";N;}',0),(26,1,'2018-07-30 10:11:12','2018-07-30 10:11:12','BILL_SENTBYMAIL',96.80000000,'facture',1,'SuperAdmin',7,'FA1807-0006','2018-07-30 00:00:00','64dd78df4fdf5076ea856abbf717afab8dc29f0ce214687ce25620999eb54c06','fa676a6be11d8c098a64546aa51cf0c9b3f8ac608a25766a4aa7da41a9d1e570','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:0:\"\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"uCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0459258178\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0006\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"eagle express sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532908800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"80.00000000\";s:9:\"total_tva\";s:11:\"16.80000000\";s:9:\"total_ttc\";s:11:\"96.80000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"80.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"16.80000000\";s:23:\"multicurrency_total_ttc\";s:11:\"96.80000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"80.00000000\";s:9:\"total_tva\";s:11:\"16.80000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"96.80000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0006\";s:11:\"note_public\";N;}',0),(27,1,'2018-08-17 07:58:48','2018-08-17 07:58:48','BILL_DELETE',544.50000000,'facture',1,'SuperAdmin',8,'(PROV8)','2018-08-17 00:00:00','b8857ed0e6ab2a3cd3313e38c06eb7a4877ca8a395495c32b72aaa41e857df14','6b298dde3a53012a7d9d2b9d079550112d72efad2aa42231e28fd1a716f98427','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1534464000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:7:\"(PROV8)\";s:11:\"note_public\";N;}',0),(28,1,'2018-08-24 08:59:34','2018-08-24 08:59:34','BILL_VALIDATE',-1089.00000000,'facture',1,'SuperAdmin',9,'AV1808-0001','2018-08-24 00:00:00','94fa838d46774b37e0bcf1cf55e405783b00c7f714d2482da388983260065ad6','1f4d9ccc159bde62a5d49a9a4f7fcfc852f2de918906144370eddba8e981796c','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";d:-900;s:9:\"total_tva\";d:-189;s:9:\"total_ttc\";d:-1089;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"-900.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"-189.00000000\";s:23:\"multicurrency_total_ttc\";s:14:\"-1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"-900.00000000\";s:9:\"total_tva\";s:13:\"-189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:14:\"-1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"AV1808-0001\";s:11:\"note_public\";N;}',0),(29,1,'2018-08-24 08:59:41','2018-08-24 08:59:41','DOC_DOWNLOAD',-1089.00000000,'facture',1,'SuperAdmin',9,'AV1808-0001','2018-08-24 00:00:00','12f69f37bed1fc52784f0dc2b063e770526574b499a174018136811bde80e8ec','b5fd269e8584d2da84c8c32a1c2129ce54def58ecffb232abdd7adca0ab1725e','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:13:\"-900.00000000\";s:9:\"total_tva\";s:13:\"-189.00000000\";s:9:\"total_ttc\";s:14:\"-1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"-900.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"-189.00000000\";s:23:\"multicurrency_total_ttc\";s:14:\"-1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"-900.00000000\";s:9:\"total_tva\";s:13:\"-189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:14:\"-1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"AV1808-0001\";s:11:\"note_public\";N;}',0),(30,1,'2018-08-24 09:00:02','2018-08-24 09:00:02','DOC_DOWNLOAD',-1089.00000000,'facture',1,'SuperAdmin',9,'AV1808-0001','2018-08-24 00:00:00','7e6c6144f572f30dae299f5ba78c583179dd5f9a247945be423ae670f07e8856','9cd6eb3d633b427e20df2567c3a5a8eb2e02bd09dbe7c8b4d6d5efee92bf1708','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:13:\"-900.00000000\";s:9:\"total_tva\";s:13:\"-189.00000000\";s:9:\"total_ttc\";s:14:\"-1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"-900.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"-189.00000000\";s:23:\"multicurrency_total_ttc\";s:14:\"-1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"-900.00000000\";s:9:\"total_tva\";s:13:\"-189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:14:\"-1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"AV1808-0001\";s:11:\"note_public\";N;}',0),(31,1,'2018-08-24 09:04:54','2018-08-24 09:04:54','BILL_VALIDATE',544.50000000,'facture',1,'SuperAdmin',10,'FA1808-0007','2018-08-24 00:00:00','abe3e6827b136bb3ac2d5edb186b71c8cd7ca3cefbb360c854bd335c71da91de','ade6d6afcc84991cb13dff999857af5910a3811a67cb1d828269fff984351da7','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"rue du Ham v47\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"UCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:19:\"bisness2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0633696248\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1808-0007\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:10:\"AA BISNESS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:450;s:9:\"total_tva\";d:94.5;s:9:\"total_ttc\";d:544.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1808-0007\";s:11:\"note_public\";N;}',0),(32,1,'2018-08-24 09:04:59','2018-08-24 09:04:59','DOC_DOWNLOAD',544.50000000,'facture',1,'SuperAdmin',10,'FA1808-0007','2018-08-24 00:00:00','4525a58746ae1139c22d29975e85a094492d4a02f9257c2abefea197d8b5f77a','dc548c3608cf4ca7d1f3a30afce1822777ccffdfae5f4b1ae6505ecbeb7f57ba','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"rue du Ham v47\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"UCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:19:\"bisness2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0633696248\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1808-0007\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:10:\"AA BISNESS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1808-0007\";s:11:\"note_public\";N;}',0),(33,1,'2018-08-24 09:05:21','2018-08-24 09:05:21','DOC_DOWNLOAD',1089.00000000,'facture',1,'SuperAdmin',5,'FA1807-0004','2018-07-20 00:00:00','0fedbf2252bd42e0915eed84b5295d8632384ebce505fedc655ec91144bee9e4','34e3869bff7693b0cff93c2a91f9264a736597a9f8a7f6ff0330f5babe0133a1','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"900.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"189.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0004\";s:11:\"note_public\";N;}',0),(34,1,'2018-08-24 09:06:43','2018-08-24 09:06:43','BILL_VALIDATE',544.50000000,'facture',1,'SuperAdmin',10,'FA1808-0007','2018-08-24 00:00:00','b94f606aa6b69b66e8141d8c653c4f598ecb2f3fbe1b868e52830f42e120d252','2c788ddf45cb1646062d3e4dcd835861d9155e98aa880d244f92cb757f5bcb42','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"rue du Ham v47\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"UCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:19:\"bisness2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0633696248\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";s:10:\"0.00000000\";s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1808-0007\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:11:\"AA BUSINESS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:450;s:9:\"total_tva\";d:94.5;s:9:\"total_ttc\";d:544.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1808-0007\";s:11:\"note_public\";N;}',0),(35,1,'2018-08-24 09:06:45','2018-08-24 09:06:45','DOC_DOWNLOAD',544.50000000,'facture',1,'SuperAdmin',10,'FA1808-0007','2018-08-24 00:00:00','a0ab893941d58de224273a80f36452b923c04bb7b56b7c1397749d517212493d','ef9349bf75bcc1dd6987b329d34ab590b439e5357674d94284dd6ffd18d10897','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"rue du Ham v47\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"UCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:19:\"bisness2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0633696248\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";s:10:\"0.00000000\";s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1808-0007\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:11:\"AA BUSINESS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"450.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"94.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"544.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1808-0007\";s:11:\"note_public\";N;}',0),(36,1,'2018-08-24 09:07:26','2018-08-24 09:07:26','DOC_DOWNLOAD',1089.00000000,'facture',1,'SuperAdmin',5,'FA1807-0004','2018-07-20 00:00:00','932708caa83a936b47459a1198d890ee4ffc4c280ec9b23f9611c0b96ba068d4','5c910ee0ad3418362508e3b4562c8314e6d1dbb521fffbdcfbe92c67f79623af','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"900.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"189.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0004\";s:11:\"note_public\";N;}',0),(37,1,'2018-08-24 09:07:35','2018-08-24 09:07:35','DOC_DOWNLOAD',1089.00000000,'facture',1,'SuperAdmin',5,'FA1807-0004','2018-07-20 00:00:00','51c6b7d3d8cb4a16f99dc2a954522e3455fc71af81ea6eaf79c54e6983b2a212','ade7c8123d3ee17be6b260781047c2187fcd72d050c1b1b72a1e7a1a1d04a1b0','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"900.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"189.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1089.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0004\";s:11:\"note_public\";N;}',0),(38,1,'2018-08-24 09:08:47','2018-08-24 09:08:47','PAYMENT_CUSTOMER_CREATE',1633.50000000,'payment',1,'SuperAdmin',4,'PAY1808-0004','2018-08-24 12:00:00','e499c6abeb95b2a1cf764fd5245f3fb3e975b0a006eb5bdc4a4a8b989fe4974c','322dc20ab800ea615e442633d2beb182df4f072adaa58d96dced5f170682a980','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1808-0004\";s:4:\"date\";i:1535112000;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:2:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:4:\"1089\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"900.00000000\";s:9:\"total_tva\";s:12:\"189.00000000\";s:9:\"total_ttc\";s:13:\"1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1807-0004\";s:11:\"note_public\";N;}}i:2;O:8:\"stdClass\":3:{s:6:\"amount\";s:5:\"544.5\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1532044800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1807-0005\";s:11:\"note_public\";N;}}}s:6:\"amount\";d:1633.5;}',0),(39,1,'2018-08-24 09:09:04','2018-08-24 09:09:04','PAYMENT_CUSTOMER_CREATE',-1089.00000000,'payment',1,'SuperAdmin',5,'PAY1808-0005','2018-08-24 12:00:00','482da96ff40df8b1f33882c1cb6b409d343dfed089b7f3da30394690be671f8d','4178aa99550370af7646a54084ea1fc6475996bba0e1b0a9ab20d6269c6c966e','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1808-0005\";s:4:\"date\";i:1535112000;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:5:\"-1089\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"avenue Louise 149/24\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"Ixelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"business2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:15:\"BE 0667.493.226\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0005\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"2A Group sprl\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:13:\"-900.00000000\";s:9:\"total_tva\";s:13:\"-189.00000000\";s:9:\"total_ttc\";s:14:\"-1089.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"AV1808-0001\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:-1089;}',0),(40,1,'2018-08-24 09:09:53','2018-08-24 09:09:53','DOC_DOWNLOAD',96.80000000,'facture',1,'SuperAdmin',7,'FA1807-0006','2018-07-30 00:00:00','ce303386849cd4fc79be0c2fe67d94f6240348233ea62dee634aa1ad0834f771','65b670ef6cd19bb3c8fb7bc91242eda2e56a734284c91e7028b60b343febf491','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:0:\"\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"uCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0459258178\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0006\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"eagle express sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1532908800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"80.00000000\";s:9:\"total_tva\";s:11:\"16.80000000\";s:9:\"total_ttc\";s:11:\"96.80000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"80.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"16.80000000\";s:23:\"multicurrency_total_ttc\";s:11:\"96.80000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"80.00000000\";s:9:\"total_tva\";s:11:\"16.80000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"96.80000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0006\";s:11:\"note_public\";N;}',0),(41,1,'2018-09-10 10:54:20','2018-09-10 10:54:20','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',11,'FA1809-0008','2018-09-10 00:00:00','5d428863914995af1badce693a81c59be12b41bea68a43f6df72559ac4f67949','d4050ed9dcc13d742f47a0e12eba9b435e3aa4f42cba72cf60e207e6452fb8b6','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"rue du Ham v47\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"UCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:19:\"bisness2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0633696248\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";s:10:\"0.00000000\";s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1808-0007\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:11:\"AA BUSINESS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1536537600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0008\";s:11:\"note_public\";N;}',0),(42,1,'2018-09-10 10:54:53','2018-09-10 10:54:53','BILL_DELETE',242.00000000,'facture',1,'SuperAdmin',11,'FA1809-0008','2018-09-10 00:00:00','271ff0cdb014e000a0e4207349d01c72b86770a18268dba0510f44fe7035c681','dec18afcb5ef37d589c7dd7ee652dcfd6c993f36309f8eae39c80b74ed784ac9','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"rue du Ham v47\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"UCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:19:\"bisness2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0633696248\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";s:10:\"0.00000000\";s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1808-0007\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:11:\"AA BUSINESS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1536537600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0008\";s:11:\"note_public\";N;}',0),(43,1,'2018-09-10 11:00:33','2018-09-10 11:00:33','BILL_DELETE',0.00000000,'facture',1,'SuperAdmin',13,'(PROV13)','2018-09-10 00:00:00','264dd1d28a09c5bd4690c076bc305a40a2d8db2434cdca5c594f808bd81c30b6','8584edbbf4dfe2167af863d93f5c34a9af666f5f144d7110abf2532dbdcfad75','O:8:\"stdClass\":11:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:0:\"\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"uCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0459258178\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0006\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"eagle express sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1536537600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:10:\"0.00000000\";s:9:\"total_tva\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:10:\"0.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:8:\"(PROV13)\";s:11:\"note_public\";N;}',0),(44,1,'2018-09-10 11:00:49','2018-09-10 11:00:49','BILL_DELETE',-96.80000000,'facture',1,'SuperAdmin',12,'(PROV12)','2018-09-10 00:00:00','36b33be1679000da869276628f7e5f01601b4e8eff456bcbe5b1ec2903a388d4','9bf1610284dbf3dc45855b7e354fbbcafcfd3005b5075b1553733f106c865877','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:0:\"\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"uCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0459258178\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0006\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"eagle express sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1536537600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:12:\"-80.00000000\";s:9:\"total_tva\";s:12:\"-16.80000000\";s:9:\"total_ttc\";s:12:\"-96.80000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"-80.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"-16.80000000\";s:23:\"multicurrency_total_ttc\";s:12:\"-96.80000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"-80.00000000\";s:9:\"total_tva\";s:12:\"-16.80000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"-96.80000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:8:\"(PROV12)\";s:11:\"note_public\";N;}',0),(45,1,'2018-09-19 11:28:29','2018-09-19 11:28:29','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',3,'FA1807-0002','2018-07-06 00:00:00','c5cee25a8d63b3b62590aa33447eb90218176e7b9ab3dca231d691723b8f8075','54ad27805596420a53e7584b0fe7509d86265c8a805822b47c16438fb9afc90b','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0002\";s:11:\"note_public\";N;}',0),(46,1,'2018-09-19 11:32:39','2018-09-19 11:32:39','BILL_VALIDATE',-242.00000000,'facture',1,'SuperAdmin',15,'AV1809-0002','2018-09-19 00:00:00','29bde070f0fee6639483e0891aeacec3b1acb7bf3a383be956deeb3373ae6340','c811d950da1658c1fc68c882b796adc669a3ec8661b4b89e33388c4075f28c89','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";d:-200;s:9:\"total_tva\";d:-42;s:9:\"total_ttc\";d:-242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"-200.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"-42.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"-242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"-200.00000000\";s:9:\"total_tva\";s:12:\"-42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"-242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"AV1809-0002\";s:11:\"note_public\";N;}',0),(47,1,'2018-09-19 11:32:48','2018-09-19 11:32:48','DOC_DOWNLOAD',-242.00000000,'facture',1,'SuperAdmin',15,'AV1809-0002','2018-09-19 00:00:00','af516d9a2f625bdcb4352e0f066cd4144c24d0f5cbfc534501446faa83798501','53b90116656acce8526a27fe4dadb0abbdbf6f917ee566865c2955735230b714','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:13:\"-200.00000000\";s:9:\"total_tva\";s:12:\"-42.00000000\";s:9:\"total_ttc\";s:13:\"-242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"-200.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"-42.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"-242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"-200.00000000\";s:9:\"total_tva\";s:12:\"-42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"-242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"AV1809-0002\";s:11:\"note_public\";N;}',0),(48,1,'2018-09-19 11:33:07','2018-09-19 11:33:07','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',3,'FA1807-0002','2018-07-06 00:00:00','7de43bccffd6d213d42047031a34833e8e2f25db064e9de68c20119f41a1db07','7a2ab73f5630f3e232153877398166c4424f087607a8080e38283865b1d800a8','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1530835200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1807-0002\";s:11:\"note_public\";N;}',0),(49,1,'2018-09-19 11:35:18','2018-09-19 11:35:18','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',14,'FA1809-0008','2018-09-19 00:00:00','84f3034847a15989cd375fa7e3a7acd1b915f6b8add471281cb4e93f6ef0c5f7','be0d8609bb5961ad3c2e5862f5aa2307da52c622b5f96407d419987739d3f9c9','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0008\";s:11:\"note_public\";N;}',0),(50,1,'2018-09-19 11:35:20','2018-09-19 11:35:20','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',14,'FA1809-0008','2018-09-19 00:00:00','f978d14cc253c66b17f6e8c4b0967326638e248ecb80cb4988191e73f62fc6bd','9ac6d673b8ce27d392e315375420c1c0b8d8b1b067f7ad00079076e522607757','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0008\";s:11:\"note_public\";N;}',0),(51,1,'2018-09-19 11:35:51','2018-09-19 11:35:51','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',16,'FA1809-0009','2018-09-19 00:00:00','94c42d0546712d6b703974fd0e76b4f37e5fc5afe84d2d4aadb6c972e4d76cdd','f337add5cc7111b698c03529feac68c98a237eb6fab433a6272928dca41ad876','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0009\";s:11:\"note_public\";N;}',0),(52,1,'2018-09-19 11:35:54','2018-09-19 11:35:54','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',16,'FA1809-0009','2018-09-19 00:00:00','57d6d04939a24cc797abbaa659c21abfc55177ec9c1025ce374849dc1ea64da5','059efee4b56c5131f38dbe4acf98702c8677cb20765b5fb6e3dfbdf00d5b7a2f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0009\";s:11:\"note_public\";N;}',0),(53,1,'2018-09-19 11:36:27','2018-09-19 11:36:27','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',17,'FA1809-0010','2018-09-19 00:00:00','45548bdf1ceba286afab7ddf8bf8c8d6ba6a8d29b85b0f0fc3e11ee4d783a086','59d597f19663b97a97ddf928671f7eb57f03d572c4ad25be36fea4c1c1bba59f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0010\";s:11:\"note_public\";N;}',0),(54,1,'2018-09-19 11:37:09','2018-09-19 11:37:09','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',16,'FA1809-0009','2018-09-19 00:00:00','8e5487a6d61f41ad659397397f4d1dfa8f31cd974753b6f0ee3649d828f899f1','33143d6036fd573484e6fac6d4de415ac55bd80c2552dac5a2f36980ec84bcda','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0009\";s:11:\"note_public\";N;}',0),(55,1,'2018-09-19 11:37:20','2018-09-19 11:37:20','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',16,'FA1809-0009','2018-09-19 00:00:00','774af9e02cdccdd701e8e4ed09b8497e364b81ef023c5bd8b87ba3195469fb64','6aaa4e1057ac4a99d6e0f7701787bb36ffd75b104082b2befef2f2461206e321','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0009\";s:11:\"note_public\";N;}',0),(56,1,'2018-09-19 11:37:39','2018-09-19 11:37:39','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',17,'FA1809-0010','2018-09-19 00:00:00','ec80351042b94e1959f32426f93e0355ed03fea96b6db75aa6a18b9ed4334d38','fe0fa8e6c4929994e72e0b8d79a46e150ab19214b967a3a371e9d739c5dc3055','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0010\";s:11:\"note_public\";N;}',0),(57,1,'2018-09-20 12:22:37','2018-09-20 12:22:37','BILL_VALIDATE',5000.00000000,'facture',1,'SuperAdmin',18,'FA1809-0011','2018-09-20 00:00:00','1326ffba49350fae2c4fb1f2802cc7817e48d59b04522dfa7e3d08f4e31a1ccc','803192517bc777f4b7251e5cefa8fb4a932bd57627fdca0f40f55a38c3b5368d','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537401600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:4132.23;s:9:\"total_tva\";d:867.77;s:9:\"total_ttc\";d:5000;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4132.23000000\";s:23:\"multicurrency_total_tva\";s:12:\"867.77000000\";s:23:\"multicurrency_total_ttc\";s:13:\"5000.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0011\";s:11:\"note_public\";N;}',0),(58,1,'2018-09-20 12:23:10','2018-09-20 12:23:10','DOC_DOWNLOAD',5000.00000000,'facture',1,'SuperAdmin',18,'FA1809-0011','2018-09-20 00:00:00','93c5c3b4784ecbc0cf54adf3818055b5fbd96b0108a837395484ac89caf0f5fc','625436419ae7d1ad91321b5b04426856e976a165bcd6e162227e884708009df9','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537401600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4132.23000000\";s:23:\"multicurrency_total_tva\";s:12:\"867.77000000\";s:23:\"multicurrency_total_ttc\";s:13:\"5000.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0011\";s:11:\"note_public\";N;}',0),(59,1,'2018-10-04 09:26:37','2018-10-04 09:26:37','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',19,'FA1810-0012','2018-10-04 00:00:00','98eb1248ea1cf64481e063948350f7f7eb67002ec34b587f77156df024a847a0','6bee534c275c6343cb8648fcf2d45cd265924265d5b3ea4565ff6636f833b7ad','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1538611200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0012\";s:11:\"note_public\";N;}',0),(60,1,'2018-10-04 09:27:10','2018-10-04 09:27:10','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',19,'FA1810-0012','2018-10-04 00:00:00','d3807d39ce44f1ef14cdde7672bb724b7ee3292f910e1a00d5251d3b15254f41','c4c4342c94ac3eb165191e7d676d97b6a0e166908158aa00f901794934f8e8b8','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1538611200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0012\";s:11:\"note_public\";N;}',0),(61,1,'2018-10-04 09:34:50','2018-10-04 09:34:50','PAYMENT_CUSTOMER_CREATE',5000.00000000,'payment',1,'SuperAdmin',6,'PAY1810-0006','2018-10-04 12:00:00','240389a3e80d55d9feaf20304d0f659604fdefd78c38d3f60dddb12fca3710f5','3b59d39755049a4810e52b330cfa62d89ca0a2017cec977925164fc976568495','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1810-0006\";s:4:\"date\";i:1538654400;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:4:\"5000\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1537401600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1809-0011\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:5000;}',0),(62,1,'2018-10-04 09:35:44','2018-10-04 09:35:44','PAYMENT_CUSTOMER_CREATE',544.50000000,'payment',1,'SuperAdmin',7,'PAY1810-0007','2018-10-04 12:00:00','9884f53a39367312c88475b50ba638a8d1504ac0ea8ca2c3adfcf2f540c9a82c','659464c9daf433a11b5167528b0fa71ca6b5c4a82093db28132521744b57c30a','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1810-0007\";s:4:\"date\";i:1538654400;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:5:\"544.5\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:14:\"rue du Ham v47\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:5:\"UCCLE\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:19:\"bisness2a@yahoo.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0633696248\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";s:10:\"0.00000000\";s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1808-0007\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:11:\"AA BUSINESS\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1535068800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"450.00000000\";s:9:\"total_tva\";s:11:\"94.50000000\";s:9:\"total_ttc\";s:12:\"544.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1808-0007\";s:11:\"note_public\";N;}}}s:6:\"amount\";d:544.5;}',0),(63,1,'2018-10-04 09:36:33','2018-10-04 09:36:33','PAYMENT_CUSTOMER_CREATE',642.00000000,'payment',1,'SuperAdmin',8,'PAY1810-0008','2018-10-04 12:00:00','924ff93ef215ae539d00b0b4aab4da610cc3b226ce441bea210cfa606a0afc40','a364d5205edda24a902ea3bddf8c086450a49dcfe95c1591b1b3ebb220760c8d','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1810-0008\";s:4:\"date\";i:1538654400;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:3:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:3:\"242\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1809-0008\";s:11:\"note_public\";N;}}i:2;O:8:\"stdClass\":3:{s:6:\"amount\";s:3:\"200\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1809-0009\";s:11:\"note_public\";N;}}i:3;O:8:\"stdClass\":3:{s:6:\"amount\";s:3:\"200\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1809-0010\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:642;}',0),(64,1,'2018-10-04 09:36:50','2018-10-04 09:36:50','PAYMENT_CUSTOMER_CREATE',-242.00000000,'payment',1,'SuperAdmin',9,'PAY1810-0009','2018-10-04 12:00:00','dcbceb6f953faa3ee1cbded3b6fa285a230ed874daf615959a677960b229c3f0','8f61b25c9f604dcc75be5b52942b48ac317c3ad0c38aea0f5d080f404b8039b7','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1810-0009\";s:4:\"date\";i:1538654400;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:4:\"-242\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:13:\"-200.00000000\";s:9:\"total_tva\";s:12:\"-42.00000000\";s:9:\"total_ttc\";s:13:\"-242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"AV1809-0002\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:-242;}',0),(65,1,'2018-11-12 08:51:22','2018-11-12 08:51:22','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',20,'FA1810-0013','2018-10-31 00:00:00','db99243cb51637faabe530b633fdd85b3508a176865f81e260da6fca6b0706a7','d2183222cd14cca7d024dfb8f32162bf738f66b5903386c2ec30f16b91a5e02d','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0013\";s:11:\"note_public\";N;}',0),(66,1,'2018-11-12 08:55:52','2018-11-12 08:55:52','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',20,'FA1810-0013','2018-10-31 00:00:00','c8e967b6fc89b1a4220d0b4968d6c6ff296060fe957b5ab2dde22c8b2b39cbeb','4587254604efb0d88b7c8339880cd6b87fda0a30898fcdc0769977f95bcbf1e7','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0013\";s:11:\"note_public\";N;}',0),(67,1,'2018-11-12 08:59:39','2018-11-12 08:59:39','BILL_VALIDATE',302.50000000,'facture',1,'SuperAdmin',21,'FA1810-0014','2018-10-31 00:00:00','2082c5c909f57ff422ccf4a4738df342b9515b5c0412fd3d12ea7f33e4a81d43','56344ce58025f3917d940831ef03d2459339f77b25dea7e9274a23fc6d3e82a0','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:250;s:9:\"total_tva\";d:52.5;s:9:\"total_ttc\";d:302.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0014\";s:11:\"note_public\";N;}',0),(68,1,'2018-11-12 08:59:42','2018-11-12 08:59:42','DOC_DOWNLOAD',302.50000000,'facture',1,'SuperAdmin',21,'FA1810-0014','2018-10-31 00:00:00','a5a0b45c196e215ce7e8c57449ec2fd948cfbdf72b19196151f43c262246b935','a680d92ff142c3ce1e69b46eaf991cb63e70be7e2e7a64a5b30a37a972b9d3f2','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0014\";s:11:\"note_public\";N;}',0),(69,1,'2018-11-12 09:01:47','2018-11-12 09:01:47','BILL_VALIDATE',3146.00000000,'facture',1,'SuperAdmin',22,'FA1810-0015','2018-10-31 00:00:00','a5176716fea5994c897a7136f1a88aa6328c22130a298b86fdf5cd7a6d738b31','f8fcff4bfdc3906065456f6af13cbb20d7aa3d8901ee23dddbd16e0c32bb86a3','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:2600;s:9:\"total_tva\";d:546;s:9:\"total_ttc\";d:3146;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"2600.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"546.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"3146.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"2600.00000000\";s:9:\"total_tva\";s:12:\"546.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"3146.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0015\";s:11:\"note_public\";N;}',0),(70,1,'2018-11-12 09:01:49','2018-11-12 09:01:49','DOC_DOWNLOAD',3146.00000000,'facture',1,'SuperAdmin',22,'FA1810-0015','2018-10-31 00:00:00','2d617f9c096a530c8ec36db4c87e29ee79e45bd526972e920aaa8fc89ddfac10','0193189798021e64b523dc1e372553c35c6ab278c3e9d59fe17bdfd5616c69dd','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"2600.00000000\";s:9:\"total_tva\";s:12:\"546.00000000\";s:9:\"total_ttc\";s:13:\"3146.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"2600.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"546.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"3146.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"2600.00000000\";s:9:\"total_tva\";s:12:\"546.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"3146.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0015\";s:11:\"note_public\";N;}',0),(71,1,'2018-11-12 09:03:30','2018-11-12 09:03:30','DOC_DOWNLOAD',-242.00000000,'facture',1,'SuperAdmin',15,'AV1809-0002','2018-09-19 00:00:00','b598d5c828004982495a23d29253593efb4e2d1813d3a0e55795ef7c13c3d128','09015bebfaee06361b8fa0a71cbdaad8f05ae376ab60b9486d11766aa29508f1','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"2\";s:8:\"total_ht\";s:13:\"-200.00000000\";s:9:\"total_tva\";s:12:\"-42.00000000\";s:9:\"total_ttc\";s:13:\"-242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"-200.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"-42.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"-242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"-200.00000000\";s:9:\"total_tva\";s:12:\"-42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"-242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"AV1809-0002\";s:11:\"note_public\";N;}',0),(72,1,'2018-11-12 09:03:57','2018-11-12 09:03:57','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',14,'FA1809-0008','2018-09-19 00:00:00','1dd572be92de1f6ef9bb2437d3794e05765d2a07620051625241d5c0bba12ad6','af972be3c4a5f38e1b1784260bcbdc81b83e6efe1b46982321fff27d4b264fa1','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0008\";s:11:\"note_public\";N;}',0),(73,1,'2018-11-12 09:04:00','2018-11-12 09:04:00','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',14,'FA1809-0008','2018-09-19 00:00:00','60ff397414c75eecd35329a909bfa10673751e35525a15d4a6008978e7e493c7','5871cc976b422bc1ca9f07a676f6e4761f3ec3238a42883d7e39227f8a4b2643','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0008\";s:11:\"note_public\";N;}',0),(74,1,'2018-11-12 09:04:14','2018-11-12 09:04:14','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',16,'FA1809-0009','2018-09-19 00:00:00','9d0871c75a5cde804194a74a32e3d332830f741480c76b4f3952954e4235020c','70a1c7ecf420fedc702366ac065bbabad9e2bfbbbbd4b6353d7b51c5df254431','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0009\";s:11:\"note_public\";N;}',0),(75,1,'2018-11-12 09:04:26','2018-11-12 09:04:26','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',17,'FA1809-0010','2018-09-19 00:00:00','3f5537949107d9655d81e073306047a18c06179fb89e5b1476fd5ce86d41bfcd','83042701aa7d9b049eacfd453da1bd29da06582c57992807d52f88319c0b73b7','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537315200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0010\";s:11:\"note_public\";N;}',0),(76,1,'2018-11-12 09:04:41','2018-11-12 09:04:41','DOC_DOWNLOAD',5000.00000000,'facture',1,'SuperAdmin',18,'FA1809-0011','2018-09-20 00:00:00','4702224380d6be25fa97af0ff577190ec9e42b78270863f2c7523d696643b6ab','aea7864b2d914b79900728d49098632994b4dfd1db2f221bf79926e94f513a41','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1537401600;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4132.23000000\";s:23:\"multicurrency_total_tva\";s:12:\"867.77000000\";s:23:\"multicurrency_total_ttc\";s:13:\"5000.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1809-0011\";s:11:\"note_public\";N;}',0),(77,1,'2018-11-12 09:05:03','2018-11-12 09:05:03','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',19,'FA1810-0012','2018-10-04 00:00:00','3ecb1a11931ed7e1ffe138ccd3f58f3dc2dd486cbf035995a4aa5f9f7f783c18','552b3a1e7e733fe68dc39ab0e84353d7c15b98133c38435820f58cabf97877e8','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1538611200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0012\";s:11:\"note_public\";N;}',0),(78,1,'2018-11-12 09:05:11','2018-11-12 09:05:11','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',20,'FA1810-0013','2018-10-31 00:00:00','ff24238f6b07396ece6ef5182ffc352cf2057ee1a8cfab6ca6e54caf2613c46b','4e9433c061bd649dd5f3c361fd869770cc25da4823af1c9bd55a4df9883043f2','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0013\";s:11:\"note_public\";N;}',0),(79,1,'2018-11-12 09:05:18','2018-11-12 09:05:18','DOC_DOWNLOAD',302.50000000,'facture',1,'SuperAdmin',21,'FA1810-0014','2018-10-31 00:00:00','c88e3e6c1f14562c59c56031fb516da2887cc79121e9a6047760f4b64272fe91','ed64cd459908ab749a26ec7ecea037bb4b0b6f8ba3f90a3f07d48c8e81d66feb','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0014\";s:11:\"note_public\";N;}',0),(80,1,'2018-11-12 09:05:28','2018-11-12 09:05:28','DOC_DOWNLOAD',3146.00000000,'facture',1,'SuperAdmin',22,'FA1810-0015','2018-10-31 00:00:00','3e8370fabeae294f37c7122153d6d4b5571c2d94f71b02d6047701a0b4a04877','c9dbaffcba48f3f00ded849d2d60353cb26ad450dbe338fe6b46032cc3aca85e','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1540944000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"2600.00000000\";s:9:\"total_tva\";s:12:\"546.00000000\";s:9:\"total_ttc\";s:13:\"3146.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"2600.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"546.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"3146.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"2600.00000000\";s:9:\"total_tva\";s:12:\"546.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"3146.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1810-0015\";s:11:\"note_public\";N;}',0),(81,1,'2018-11-20 11:20:30','2018-11-20 11:20:30','BILL_VALIDATE',556.60000000,'facture',1,'SuperAdmin',23,'FA1811-0016','2018-11-20 00:00:00','8910fef8116a620223f0e78bb6f5aaa1ed2eea4b244c5ff246b5c3a7f222d27a','682dedafbc30d4e206e8ae05997847131dbc044ed33d4fb1d70bb789046ab7e8','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1542672000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:460;s:9:\"total_tva\";d:96.6;s:9:\"total_ttc\";d:556.6;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"460.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"96.60000000\";s:23:\"multicurrency_total_ttc\";s:12:\"556.60000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"460.00000000\";s:9:\"total_tva\";s:11:\"96.60000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"556.60000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1811-0016\";s:11:\"note_public\";N;}',0),(82,1,'2018-11-20 11:20:46','2018-11-20 11:20:46','DOC_DOWNLOAD',556.60000000,'facture',1,'SuperAdmin',23,'FA1811-0016','2018-11-20 00:00:00','4c61f77bdd349071f0dabf439a3f2cf9fd746e955c0d12ae7f02693b50d19dc5','f5a0ecdd50dc1ea18fcadc2900b07a629a9e35cb5246558fddf0194428eb096c','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1542672000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"460.00000000\";s:9:\"total_tva\";s:11:\"96.60000000\";s:9:\"total_ttc\";s:12:\"556.60000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"460.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"96.60000000\";s:23:\"multicurrency_total_ttc\";s:12:\"556.60000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"460.00000000\";s:9:\"total_tva\";s:11:\"96.60000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"556.60000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1811-0016\";s:11:\"note_public\";N;}',0),(83,1,'2018-11-21 10:47:23','2018-11-21 10:47:23','BILL_VALIDATE',193.60000000,'facture',1,'SuperAdmin',24,'FA1811-0017','2018-11-21 00:00:00','9bf8e810a2cf6a7dfb4dba076e43aaca50cb26199a2c10ba1af7409208954464','e7572e964c1338e402a5d726fc435f5eb660522cd7d4c41983909d35db267582','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Koning Albertstraat 113\";s:3:\"zip\";s:4:\"1600\";s:4:\"town\";s:15:\"st pieters leew\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:22:\"melmossali@hotmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:10:\"0890716158\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0011\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:19:\"EL MOSSALLI Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1542758400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:160;s:9:\"total_tva\";d:33.6;s:9:\"total_ttc\";d:193.6;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"160.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"33.60000000\";s:23:\"multicurrency_total_ttc\";s:12:\"193.60000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"160.00000000\";s:9:\"total_tva\";s:11:\"33.60000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"193.60000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1811-0017\";s:11:\"note_public\";N;}',0),(84,1,'2018-11-21 10:47:25','2018-11-21 10:47:25','DOC_DOWNLOAD',193.60000000,'facture',1,'SuperAdmin',24,'FA1811-0017','2018-11-21 00:00:00','0e57fca532f5fe998a9a43c64bb705c45149e103981905f7a030f54552ebbed6','9397f6f85c1bc21096d2a7324af5132cf05365ff33bccdc3d286b3371301be86','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Koning Albertstraat 113\";s:3:\"zip\";s:4:\"1600\";s:4:\"town\";s:15:\"st pieters leew\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:22:\"melmossali@hotmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:10:\"0890716158\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0011\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:19:\"EL MOSSALLI Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1542758400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"160.00000000\";s:9:\"total_tva\";s:11:\"33.60000000\";s:9:\"total_ttc\";s:12:\"193.60000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"160.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"33.60000000\";s:23:\"multicurrency_total_ttc\";s:12:\"193.60000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"160.00000000\";s:9:\"total_tva\";s:11:\"33.60000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"193.60000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1811-0017\";s:11:\"note_public\";N;}',0),(85,1,'2018-11-21 10:50:28','2018-11-21 10:50:28','BILL_VALIDATE',181.50000000,'facture',1,'SuperAdmin',24,'FA1811-0017','2018-11-21 00:00:00','202b0624892f99fc55197806d69365ed9a8f1b5f0ec90bf8c5d394c5c738050d','fe2ddfd79ad850fe6ce753b54c2a33a5f52a5db35815035622488ee69dcc8542','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Koning Albertstraat 113\";s:3:\"zip\";s:4:\"1600\";s:4:\"town\";s:15:\"st pieters leew\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:22:\"melmossali@hotmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:10:\"0890716158\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0011\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:19:\"EL MOSSALLI Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1542758400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:150;s:9:\"total_tva\";d:31.5;s:9:\"total_ttc\";d:181.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"150.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"31.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"181.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"150.00000000\";s:9:\"total_tva\";s:11:\"31.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"181.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1811-0017\";s:11:\"note_public\";N;}',0),(86,1,'2018-11-21 10:50:31','2018-11-21 10:50:31','DOC_DOWNLOAD',181.50000000,'facture',1,'SuperAdmin',24,'FA1811-0017','2018-11-21 00:00:00','8f55f08aebc1a6e46bb7e7b9cfc2aa170903633d6093783105207d9d75d9b683','ef9eb74153631ce5c878bdda5c6e87b38c08b12711b65c8dc94f276998ec42b9','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Koning Albertstraat 113\";s:3:\"zip\";s:4:\"1600\";s:4:\"town\";s:15:\"st pieters leew\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:22:\"melmossali@hotmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:10:\"0890716158\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0011\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:19:\"EL MOSSALLI Mohamed\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1542758400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"150.00000000\";s:9:\"total_tva\";s:11:\"31.50000000\";s:9:\"total_ttc\";s:12:\"181.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"150.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"31.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"181.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"150.00000000\";s:9:\"total_tva\";s:11:\"31.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"181.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1811-0017\";s:11:\"note_public\";N;}',0),(87,1,'2018-12-07 09:13:16','2018-12-07 09:13:16','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',25,'FA1812-0018','2018-12-07 00:00:00','595abb60f4e08fc5f36a5aff25532c1592698248e7e61b3ef60836ed0f1499c0','e4edca1709b12a278430715bbab55461713690febf255432e6a1cc61ee82f6f8','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0018\";s:11:\"note_public\";N;}',0),(88,1,'2018-12-07 09:14:05','2018-12-07 09:14:05','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',25,'FA1812-0018','2018-12-07 00:00:00','1214f72c470ecf27d6867e6f37ce2ec408b9de9aa216dcea1ca363195a24250c','d12a72b58c5ce964004ff5552caf47374ae5e607e0685eb369c270ac6fbe1458','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0018\";s:11:\"note_public\";N;}',0),(89,1,'2018-12-07 09:17:11','2018-12-07 09:17:11','BILL_VALIDATE',302.50000000,'facture',1,'SuperAdmin',26,'FA1812-0019','2018-12-07 00:00:00','d745073e513f4f152f0777318020afaaf554e65bb85393c8f9237c1e5caca8e1','b796380aec5a749b5a6fd54648d77f85a2d446f1b9741ddd51e0941c23883d2f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:250;s:9:\"total_tva\";d:52.5;s:9:\"total_ttc\";d:302.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0019\";s:11:\"note_public\";N;}',0),(90,1,'2018-12-07 09:17:12','2018-12-07 09:17:12','DOC_DOWNLOAD',302.50000000,'facture',1,'SuperAdmin',26,'FA1812-0019','2018-12-07 00:00:00','cd529b693ad3fe8bf31e60cd04de2fa40570133b508b2a692cb7648da41dfd96','393c1831c4dfe4a9f4244b60ed1a42ec36a9e4e08780773653652b7565a72e37','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0019\";s:11:\"note_public\";N;}',0),(91,1,'2018-12-07 10:21:46','2018-12-07 10:21:46','PAYMENT_CUSTOMER_CREATE',556.00000000,'payment',1,'SuperAdmin',10,'PAY1812-0010','2018-12-07 12:00:00','4663a1be44de9ce6d5361658e02254ed40452bd8cb3334cec6a28541244c563c','a41def6b18452d64a165333462cf0f05c6dcc846d524b8c77f644486a6204f5d','O:8:\"stdClass\":8:{s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:3:\"ref\";s:12:\"PAY1812-0010\";s:4:\"date\";i:1544184000;s:9:\"type_code\";s:3:\"VIR\";s:11:\"payment_num\";N;s:4:\"note\";s:0:\"\";s:12:\"payment_part\";a:1:{i:1;O:8:\"stdClass\":3:{s:6:\"amount\";s:3:\"556\";s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:7:\"invoice\";O:8:\"stdClass\":9:{s:4:\"date\";i:1542672000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"460.00000000\";s:9:\"total_tva\";s:11:\"96.60000000\";s:9:\"total_ttc\";s:12:\"556.60000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:3:\"ref\";s:11:\"FA1811-0016\";s:11:\"note_public\";N;}}}s:6:\"amount\";i:556;}',0),(92,1,'2018-12-07 10:40:21','2018-12-07 10:40:21','DOC_DOWNLOAD',556.60000000,'facture',1,'SuperAdmin',23,'FA1811-0016','2018-11-20 00:00:00','9f47b44b21472b2b235acc2fb68828e089e5b1f36cb5de27bd22d2ea796f90b4','624278661af92bb332fc7b4bd6f3ea0327076d0572f100caf626fdfe499205c2','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1542672000;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"460.00000000\";s:9:\"total_tva\";s:11:\"96.60000000\";s:9:\"total_ttc\";s:12:\"556.60000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"460.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"96.60000000\";s:23:\"multicurrency_total_ttc\";s:12:\"556.60000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"460.00000000\";s:9:\"total_tva\";s:11:\"96.60000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"556.60000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1811-0016\";s:11:\"note_public\";N;}',0),(93,1,'2018-12-07 10:43:07','2018-12-07 10:43:07','DOC_DOWNLOAD',302.50000000,'facture',1,'SuperAdmin',26,'FA1812-0019','2018-12-07 00:00:00','f3beb94c43ab3175704abc0f55efc6368c19df3b8205edb0485689ed0cb51cc5','7cf377c43e7dc59d435a25cb3b37db0cc3c34fd45ba8524c2ecce48d603784a1','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0019\";s:11:\"note_public\";N;}',0),(94,1,'2018-12-07 10:57:44','2018-12-07 10:57:44','DOC_DOWNLOAD',302.50000000,'facture',1,'SuperAdmin',26,'FA1812-0019','2018-12-07 00:00:00','92aa2e70c2a6e56610e193422e846d217b95a34dfd2f6db3713d3df20537d8c4','7d353b909833662cd1737b8390f0736d8222ec41c4bd9972688220addd33d13f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0019\";s:11:\"note_public\";N;}',0),(95,1,'2018-12-07 11:00:47','2018-12-07 11:00:47','BILL_VALIDATE',145.20000000,'facture',1,'SuperAdmin',27,'FA1812-0020','2018-12-07 00:00:00','bca1f352e0501e7b7d7ceaf2515b3ca8733505886b61c43fad05ab559ec02687','fb4222f458492a4c742c55cb1d2848cc8a5da8e801218efcb8145f95f52d6c31','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"rue Americaine 85\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"IXelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0470963407\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1812-0012\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"<resto group\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:120;s:9:\"total_tva\";d:25.2;s:9:\"total_ttc\";d:145.2;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"120.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"25.20000000\";s:23:\"multicurrency_total_ttc\";s:12:\"145.20000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0020\";s:11:\"note_public\";N;}',0),(96,1,'2018-12-07 11:00:49','2018-12-07 11:00:49','DOC_DOWNLOAD',145.20000000,'facture',1,'SuperAdmin',27,'FA1812-0020','2018-12-07 00:00:00','7ad01cb681145013c822713e934f6d799b8004dfcc46c0aa0d4187bfa0349c9c','4216f3d0797d1f7b6e667c2df8d788b093d6e48e7f0c2ebdb6a26b4bbd4e5d3f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"rue Americaine 85\";s:3:\"zip\";s:4:\"1050\";s:4:\"town\";s:7:\"IXelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0470963407\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1812-0012\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"<resto group\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"120.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"25.20000000\";s:23:\"multicurrency_total_ttc\";s:12:\"145.20000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0020\";s:11:\"note_public\";N;}',0),(97,1,'2018-12-07 11:39:05','2018-12-07 11:39:05','BILL_VALIDATE',6231.50000000,'facture',1,'SuperAdmin',28,'FA1812-0021','2018-12-07 00:00:00','771f1dba1c0cf503615d0c922ab02b2241353a6f5946614b818f45cc8029b6f2','bb9d6ffeb43333fd3e5e8cc3738740ea7eee0536bd9af04e8a2cac8fd221b9d8','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:5150;s:9:\"total_tva\";d:1081.5;s:9:\"total_ttc\";d:6231.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"5150.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"1081.50000000\";s:23:\"multicurrency_total_ttc\";s:13:\"6231.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"5150.00000000\";s:9:\"total_tva\";s:13:\"1081.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"6231.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0021\";s:11:\"note_public\";N;}',0),(98,1,'2018-12-07 11:39:07','2018-12-07 11:39:07','DOC_DOWNLOAD',6231.50000000,'facture',1,'SuperAdmin',28,'FA1812-0021','2018-12-07 00:00:00','e17b6589b8e4b43aa82cfebdb10ea853f74f4c4e48bd7cc5eca30f65a522d2e5','13113097dc17b6ac4dc38ce3198fecea2bc6f92072f68a0e08ff104548d541dd','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1544140800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"5150.00000000\";s:9:\"total_tva\";s:13:\"1081.50000000\";s:9:\"total_ttc\";s:13:\"6231.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"5150.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"1081.50000000\";s:23:\"multicurrency_total_ttc\";s:13:\"6231.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"5150.00000000\";s:9:\"total_tva\";s:13:\"1081.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"6231.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1812-0021\";s:11:\"note_public\";N;}',0),(99,1,'2019-01-07 11:12:28','2019-01-07 11:12:28','BILL_VALIDATE',145.20000000,'facture',1,'SuperAdmin',29,'FA1901-0022','2019-01-07 00:00:00','a28bf824888eac3efc359fc0f818ae3a7f6c3cf2e374417d816169071e824bb8','4dc88a4e0b823f695b699aa55f424101936de898c629526ead442d9569579c70','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:120;s:9:\"total_tva\";d:25.2;s:9:\"total_ttc\";d:145.2;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"120.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"25.20000000\";s:23:\"multicurrency_total_ttc\";s:12:\"145.20000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0022\";s:11:\"note_public\";N;}',0),(100,1,'2019-01-07 11:21:24','2019-01-07 11:21:24','BILL_VALIDATE',726.00000000,'facture',1,'SuperAdmin',30,'FA1901-0023','2019-01-07 00:00:00','f597a656ab478bfc55ac45b26fa34b412f61786cea08d25076926c81ef20d13e','fbdd0743ab06825de9b0ff10f9d28e00b826f7f108c0623a686414d7bf687df5','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:21:\"Avenue van volxem 302\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"713975428\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0013\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"Toiture THIELEMANS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:600;s:9:\"total_tva\";d:126;s:9:\"total_ttc\";d:726;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"600.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"126.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"726.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"600.00000000\";s:9:\"total_tva\";s:12:\"126.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"726.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0023\";s:11:\"note_public\";N;}',0),(101,1,'2019-01-07 11:21:29','2019-01-07 11:21:29','DOC_DOWNLOAD',726.00000000,'facture',1,'SuperAdmin',30,'FA1901-0023','2019-01-07 00:00:00','2ad6e58183b1202b17ce393cd942fc45096cbcd7e067e7741d1ebbbcc57b7c46','72b9748ff470a74affbeeb3368823f4160765cb6e9dc079e74906df8609d85bf','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:21:\"Avenue van volxem 302\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"713975428\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0013\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"Toiture THIELEMANS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"600.00000000\";s:9:\"total_tva\";s:12:\"126.00000000\";s:9:\"total_ttc\";s:12:\"726.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"600.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"126.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"726.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"600.00000000\";s:9:\"total_tva\";s:12:\"126.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"726.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0023\";s:11:\"note_public\";N;}',0),(102,1,'2019-01-07 11:24:22','2019-01-07 11:24:22','DOC_DOWNLOAD',145.20000000,'facture',1,'SuperAdmin',29,'FA1901-0022','2019-01-07 00:00:00','2daf35a7e4b808bcfb25ebd967253db3909084db2f25aadf26050a11a9f55553','de21aaae600e9218df85ab99342e70d5ebc8d9a3caa74e7c6b8ebb3f749d82fe','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"120.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"25.20000000\";s:23:\"multicurrency_total_ttc\";s:12:\"145.20000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0022\";s:11:\"note_public\";N;}',0),(103,1,'2019-01-07 11:26:17','2019-01-07 11:26:17','BILL_VALIDATE',302.50000000,'facture',1,'SuperAdmin',31,'FA1901-0024','2019-01-07 00:00:00','2ec72ddf0887c7810fee05443257be15f9ed2dc6704ab323fa6b00377dfab62b','c6b3ca3c28bc7a71bc3d26849689d826962d052f11252e2bfb4c909558702de6','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:250;s:9:\"total_tva\";d:52.5;s:9:\"total_ttc\";d:302.5;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0024\";s:11:\"note_public\";N;}',0),(104,1,'2019-01-07 11:26:19','2019-01-07 11:26:19','DOC_DOWNLOAD',302.50000000,'facture',1,'SuperAdmin',31,'FA1901-0024','2019-01-07 00:00:00','b517c13c2d00e36505e749be92d8fd6cb7fe7c85b3a87bfa68ff5d0bc982aef4','332950b6ee6c0923f77738036632ee097b187861317da838160b78481009d543','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"250.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"52.50000000\";s:23:\"multicurrency_total_ttc\";s:12:\"302.50000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"250.00000000\";s:9:\"total_tva\";s:11:\"52.50000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"302.50000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0024\";s:11:\"note_public\";N;}',0),(105,1,'2019-01-07 11:26:58','2019-01-07 11:26:58','BILL_VALIDATE',242.00000000,'facture',1,'SuperAdmin',32,'FA1901-0025','2019-01-07 00:00:00','7d74689c1be7f75cfa2efcfca700bf0923df0c7ca28c2fda5c68adbb7edcc5ed','4ba39cdc76655ba93ca146a786e36d4d5be4cb3900e475514d53864521379a7f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:200;s:9:\"total_tva\";d:42;s:9:\"total_ttc\";d:242;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0025\";s:11:\"note_public\";N;}',0),(106,1,'2019-01-07 11:27:00','2019-01-07 11:27:00','DOC_DOWNLOAD',242.00000000,'facture',1,'SuperAdmin',32,'FA1901-0025','2019-01-07 00:00:00','f6cec37d6c408e010808246954675053e505a94ce3f7acdad7034b0084226dea','fb01f0f8abe06a3c628dadfc2a029beeb14a0d1b7027147ace32602c0c3e9ccb','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1546819200;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"200.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"42.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"242.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"200.00000000\";s:9:\"total_tva\";s:11:\"42.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"242.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0025\";s:11:\"note_public\";N;}',0),(107,1,'2019-01-10 10:58:41','2019-01-10 10:58:41','BILL_VALIDATE',282.33000000,'facture',1,'SuperAdmin',33,'FA1901-0026','2019-01-10 00:00:00','d1adcf1c0a25046d6d60da30389c4f13c3aed8acfad0c2dd5fd0a5522eecdf10','feaf91396dcd2a00c88b30223d9d6e85b0a28a570fa18b3fc4b5b5814d693001','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"hovevisstraat 115\";s:3:\"zip\";s:4:\"1800\";s:4:\"town\";s:9:\"bilvoorde\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"542262266\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0014\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"BRACHE Fabian\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1547078400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:233.33;s:9:\"total_tva\";d:49;s:9:\"total_ttc\";d:282.33;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"233.33000000\";s:23:\"multicurrency_total_tva\";s:11:\"49.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"282.33000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"233.33000000\";s:9:\"total_tva\";s:11:\"49.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"282.33000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0026\";s:11:\"note_public\";N;}',0),(108,1,'2019-01-10 10:58:45','2019-01-10 10:58:45','DOC_DOWNLOAD',282.33000000,'facture',1,'SuperAdmin',33,'FA1901-0026','2019-01-10 00:00:00','5c3f20536bf4b3d7266c13a16ffce79ade9d2926b5bddb1497c28ad5f324b3a0','7dd3af4a4282ae2d45b444e4fe877c2fee5c7d2ec6c502ff5b57387709de790b','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"hovevisstraat 115\";s:3:\"zip\";s:4:\"1800\";s:4:\"town\";s:9:\"bilvoorde\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"542262266\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0014\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"BRACHE Fabian\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1547078400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"233.33000000\";s:9:\"total_tva\";s:11:\"49.00000000\";s:9:\"total_ttc\";s:12:\"282.33000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"233.33000000\";s:23:\"multicurrency_total_tva\";s:11:\"49.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"282.33000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"233.33000000\";s:9:\"total_tva\";s:11:\"49.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"282.33000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0026\";s:11:\"note_public\";N;}',0),(109,1,'2019-01-15 08:23:42','2019-01-15 08:23:42','BILL_VALIDATE',5000.00000000,'facture',1,'SuperAdmin',34,'FA1901-0027','2019-01-15 00:00:00','61f60cadf98504615fec2e902249727c5ee73eccd5cebe97c6a1e89db8c09e67','7119abae0b427e67fc1e063cf1e8299bd8f901f158fd5190d9166623b66a8dc7','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1547510400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:4132.23;s:9:\"total_tva\";d:867.77;s:9:\"total_ttc\";d:5000;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4132.23000000\";s:23:\"multicurrency_total_tva\";s:12:\"867.77000000\";s:23:\"multicurrency_total_ttc\";s:13:\"5000.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0027\";s:11:\"note_public\";N;}',0),(110,1,'2019-01-15 08:23:45','2019-01-15 08:23:45','DOC_DOWNLOAD',5000.00000000,'facture',1,'SuperAdmin',34,'FA1901-0027','2019-01-15 00:00:00','15f615b75a44fcdac5147a8100fa122b451d23d7979697cb14c46cd17653a029','6c44e76e91dc0fbe90d4341b421dce0243df3b04e30fb4a83d41c1d59a250e24','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1547510400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"4132.23000000\";s:23:\"multicurrency_total_tva\";s:12:\"867.77000000\";s:23:\"multicurrency_total_ttc\";s:13:\"5000.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"4132.23000000\";s:9:\"total_tva\";s:12:\"867.77000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"5000.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1901-0027\";s:11:\"note_public\";N;}',0),(111,1,'2019-02-05 11:40:56','2019-02-05 11:40:56','BILL_VALIDATE',290.40000000,'facture',1,'SuperAdmin',35,'FA1902-0028','2019-02-05 00:00:00','2bef4ff78a514590d487c7dbfa8d1e0cf08a73e01b01a00d9ab78ca841c2881a','17c8b6b6859ac4d71726e7b6c58199d8cb4d4680530ef6e9051fc2ce69ab56ef','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:240;s:9:\"total_tva\";d:50.4;s:9:\"total_ttc\";d:290.4;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"240.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"50.40000000\";s:23:\"multicurrency_total_ttc\";s:12:\"290.40000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"240.00000000\";s:9:\"total_tva\";s:11:\"50.40000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"290.40000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0028\";s:11:\"note_public\";N;}',0),(112,1,'2019-02-05 11:41:01','2019-02-05 11:41:01','DOC_DOWNLOAD',290.40000000,'facture',1,'SuperAdmin',35,'FA1902-0028','2019-02-05 00:00:00','527cb75c0bd5dbe0f215bf1b8e7492cd7ab9d2a07ce00194af9b08f22b176871','b01d0ba7c177ac9fb1f6e1fd446e75fd517d30ebd39b717be6dddebc1265a35d','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"240.00000000\";s:9:\"total_tva\";s:11:\"50.40000000\";s:9:\"total_ttc\";s:12:\"290.40000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"240.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"50.40000000\";s:23:\"multicurrency_total_ttc\";s:12:\"290.40000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"240.00000000\";s:9:\"total_tva\";s:11:\"50.40000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"290.40000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0028\";s:11:\"note_public\";N;}',0),(113,1,'2019-02-05 11:41:30','2019-02-05 11:41:30','DOC_DOWNLOAD',290.40000000,'facture',1,'SuperAdmin',35,'FA1902-0028','2019-02-05 00:00:00','e887357d7b29c3c2509ce5a97f781972eec53ee0e1d5e79cb5c0ece30a2a8764','b290815ebf02dc0f49cbbf6ff33a73c6a48e8cf7f2ae5593f39de235bd5ab420','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"Rue de Brabant 128\";s:3:\"zip\";s:4:\"1030\";s:4:\"town\";s:10:\"schaerbeek\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:30:\"florence.darchambeau@gmail.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0010\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:21:\"Darchambeau  Florence\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"240.00000000\";s:9:\"total_tva\";s:11:\"50.40000000\";s:9:\"total_ttc\";s:12:\"290.40000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"240.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"50.40000000\";s:23:\"multicurrency_total_ttc\";s:12:\"290.40000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"240.00000000\";s:9:\"total_tva\";s:11:\"50.40000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"290.40000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0028\";s:11:\"note_public\";N;}',0),(114,1,'2019-02-05 11:42:19','2019-02-05 11:42:19','BILL_VALIDATE',1452.00000000,'facture',1,'SuperAdmin',36,'FA1902-0029','2019-02-05 00:00:00','b8515fd72cd52a0d2c57da815c6410b6639274694f133a1f3ba8c6f2c15c90fb','b32f45abc5b2cf358dff410a2bd95fcc507d33acd81eade0febe6ad70e1939f6','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:21:\"Avenue van volxem 302\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"713975428\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0013\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"Toiture THIELEMANS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:1200;s:9:\"total_tva\";d:252;s:9:\"total_ttc\";d:1452;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"1200.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"252.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1452.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"1200.00000000\";s:9:\"total_tva\";s:12:\"252.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1452.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0029\";s:11:\"note_public\";N;}',0),(115,1,'2019-02-05 11:42:22','2019-02-05 11:42:22','DOC_DOWNLOAD',1452.00000000,'facture',1,'SuperAdmin',36,'FA1902-0029','2019-02-05 00:00:00','8f12a031cf060a74720dee9edd7a3653f71d87cefa85c384fce2310b2469b37e','67c2a99df9c8653e2cf703adeba02e01134b1c9d23c46b74e7885852d923e73b','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:21:\"Avenue van volxem 302\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"713975428\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0013\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"Toiture THIELEMANS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"1200.00000000\";s:9:\"total_tva\";s:12:\"252.00000000\";s:9:\"total_ttc\";s:13:\"1452.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"1200.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"252.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1452.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"1200.00000000\";s:9:\"total_tva\";s:12:\"252.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1452.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0029\";s:11:\"note_public\";N;}',0),(116,1,'2019-02-05 11:43:11','2019-02-05 11:43:11','BILL_VALIDATE',605.00000000,'facture',1,'SuperAdmin',37,'FA1902-0030','2019-02-05 00:00:00','ffb64821fabe4adb36a96512b48c251a7f703c83a2d89be229af63542ef86c2c','4c29afce69a5bcbdcbab3d247104d5730c1c66b4aa6258e2fd00a85632c3108f','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:500;s:9:\"total_tva\";d:105;s:9:\"total_ttc\";d:605;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"500.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"105.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"605.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"500.00000000\";s:9:\"total_tva\";s:12:\"105.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"605.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0030\";s:11:\"note_public\";N;}',0),(117,1,'2019-02-05 11:43:13','2019-02-05 11:43:13','DOC_DOWNLOAD',605.00000000,'facture',1,'SuperAdmin',37,'FA1902-0030','2019-02-05 00:00:00','fe127c4223d455ff004ccfb22463a5de99de0a17a5de205e1fce5ad29c54c025','f1da14c65ea66d5b33f5f262dd15eda60c9f06905e2268bdaf351ef041eccd40','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"500.00000000\";s:9:\"total_tva\";s:12:\"105.00000000\";s:9:\"total_ttc\";s:12:\"605.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"500.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"105.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"605.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"500.00000000\";s:9:\"total_tva\";s:12:\"105.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"605.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0030\";s:11:\"note_public\";N;}',0),(118,1,'2019-02-05 11:44:08','2019-02-05 11:44:08','BILL_VALIDATE',484.00000000,'facture',1,'SuperAdmin',38,'FA1902-0031','2019-02-05 00:00:00','8b57e2aa76a3972a2216c1617acdbf9ffb4eecfea072c0a8f1d4c9d9c38d3609','ad365dc2ac75946317298f0dc87c0053d5f8054fa430776499af2f3f54306fdf','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:400;s:9:\"total_tva\";d:84;s:9:\"total_ttc\";d:484;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"400.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"84.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"484.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"400.00000000\";s:9:\"total_tva\";s:11:\"84.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"484.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0031\";s:11:\"note_public\";N;}',0),(119,1,'2019-02-05 11:44:13','2019-02-05 11:44:13','DOC_DOWNLOAD',484.00000000,'facture',1,'SuperAdmin',38,'FA1902-0031','2019-02-05 00:00:00','cd0744b36855368661ae9619c45c285891fcbda0419094b3b2f5d3cbf83dcbf8','ae6d940abd649e30730bd3e597f1487e14e36efb38f572076c62c5e7aa2f0e02','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"400.00000000\";s:9:\"total_tva\";s:11:\"84.00000000\";s:9:\"total_ttc\";s:12:\"484.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"400.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"84.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"484.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"400.00000000\";s:9:\"total_tva\";s:11:\"84.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"484.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0031\";s:11:\"note_public\";N;}',0),(120,1,'2019-02-05 11:45:32','2019-02-05 11:45:32','DOC_DOWNLOAD',1452.00000000,'facture',1,'SuperAdmin',36,'FA1902-0029','2019-02-05 00:00:00','160e7ebc4dd7ad030192230239884b400275dec663cfd2807a34700fb74cdff9','d4cc29da1df9df631b20161f45269917a43a344ed968dde4d79778c097914bc2','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:21:\"Avenue van volxem 302\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"713975428\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0013\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:18:\"Toiture THIELEMANS\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"1200.00000000\";s:9:\"total_tva\";s:12:\"252.00000000\";s:9:\"total_ttc\";s:13:\"1452.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"1200.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"252.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"1452.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"1200.00000000\";s:9:\"total_tva\";s:12:\"252.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"1452.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0029\";s:11:\"note_public\";N;}',0),(121,1,'2019-02-05 11:45:41','2019-02-05 11:45:41','DOC_DOWNLOAD',605.00000000,'facture',1,'SuperAdmin',37,'FA1902-0030','2019-02-05 00:00:00','d61563ff292ff5240fba13b57b7941ee67e29c36c3299f3df100e3f95167f4cb','de00353458cfc5532697ac8c6ef087f931b3e0aed8ad6cf1bfec8895c8db3637','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:20:\"rue du bon pasteur 9\";s:3:\"zip\";s:4:\"1080\";s:4:\"town\";s:9:\"bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:11:\"be056708579\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1811-0009\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:12:\"Verhaverbeke\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"500.00000000\";s:9:\"total_tva\";s:12:\"105.00000000\";s:9:\"total_ttc\";s:12:\"605.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"500.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"105.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"605.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"500.00000000\";s:9:\"total_tva\";s:12:\"105.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"605.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0030\";s:11:\"note_public\";N;}',0),(122,1,'2019-02-05 11:47:46','2019-02-05 11:47:46','DOC_DOWNLOAD',484.00000000,'facture',1,'SuperAdmin',38,'FA1902-0031','2019-02-05 00:00:00','d04f7a7c7e30a613f5c582c6b355ae9e7334cf58507cd107227f12d176e10731','12cfdba3f904bb09f11f48ef3a437d77ba33c0ded0a045e863c6ee83e5cc9b88','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"400.00000000\";s:9:\"total_tva\";s:11:\"84.00000000\";s:9:\"total_ttc\";s:12:\"484.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"400.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"84.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"484.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"400.00000000\";s:9:\"total_tva\";s:11:\"84.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"484.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0031\";s:11:\"note_public\";N;}',0),(123,1,'2019-02-05 11:47:53','2019-02-05 11:47:53','DOC_DOWNLOAD',484.00000000,'facture',1,'SuperAdmin',38,'FA1902-0031','2019-02-05 00:00:00','cc6ba307dba14bc0d0ea260bfd144adc389c2c9fecc28b9523524631333c6e39','5feae047913bffe1f8966ec05aa95bd1f14144190efea58bbe2ef2ec01d76f84','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:23:\"Avenue Massenet 2 bte 7\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0645819565\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1807-0003\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:22:\"Alves et Andrade renov\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"400.00000000\";s:9:\"total_tva\";s:11:\"84.00000000\";s:9:\"total_ttc\";s:12:\"484.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"400.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"84.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"484.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"400.00000000\";s:9:\"total_tva\";s:11:\"84.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"484.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0031\";s:11:\"note_public\";N;}',0),(124,1,'2019-02-05 11:48:59','2019-02-05 11:48:59','BILL_VALIDATE',564.66000000,'facture',1,'SuperAdmin',39,'FA1902-0032','2019-02-05 00:00:00','533783d60397f433e2f1e1d544096f421ddb9149938c6b2ebb2568ebc8198507','6356990e4bc15fcb141b9bf4c48bcb2a840ef3da9fd56f9f7b524dba222fe618','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"hovevisstraat 115\";s:3:\"zip\";s:4:\"1800\";s:4:\"town\";s:9:\"bilvoorde\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"542262266\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0014\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"BRACHE Fabian\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:466.66;s:9:\"total_tva\";d:98;s:9:\"total_ttc\";d:564.66;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"466.66000000\";s:23:\"multicurrency_total_tva\";s:11:\"98.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"564.66000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"466.66000000\";s:9:\"total_tva\";s:11:\"98.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"564.66000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0032\";s:11:\"note_public\";N;}',0),(125,1,'2019-02-05 11:49:01','2019-02-05 11:49:01','DOC_DOWNLOAD',564.66000000,'facture',1,'SuperAdmin',39,'FA1902-0032','2019-02-05 00:00:00','c583b0771a09e512b21d3cb01cfad02349ff6a77d2ea60a15e273646d595ba04','8ee84e28501b86bac957ae60b513abe360693e3069346bd39e56c221b3b8141e','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"hovevisstraat 115\";s:3:\"zip\";s:4:\"1800\";s:4:\"town\";s:9:\"bilvoorde\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"542262266\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0014\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"BRACHE Fabian\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"466.66000000\";s:9:\"total_tva\";s:11:\"98.00000000\";s:9:\"total_ttc\";s:12:\"564.66000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"466.66000000\";s:23:\"multicurrency_total_tva\";s:11:\"98.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"564.66000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"466.66000000\";s:9:\"total_tva\";s:11:\"98.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"564.66000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0032\";s:11:\"note_public\";N;}',0),(126,1,'2019-02-05 11:55:55','2019-02-05 11:55:55','BILL_VALIDATE',847.00000000,'facture',1,'SuperAdmin',39,'FA1902-0032','2019-02-05 00:00:00','9607a6e68d16d572ac305cf27c8e20a62a9b16db52387208da4df7feb99a3f04','a4eef0358f24c58b136b9d5e0e3da49d66f20bf66767248af9c6f6c1dbc340b1','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"hovevisstraat 115\";s:3:\"zip\";s:4:\"1800\";s:4:\"town\";s:9:\"bilvoorde\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"542262266\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0014\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"BRACHE Fabian\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:700;s:9:\"total_tva\";d:147;s:9:\"total_ttc\";d:847;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"700.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"147.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"847.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"700.00000000\";s:9:\"total_tva\";s:12:\"147.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"847.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0032\";s:11:\"note_public\";N;}',0),(127,1,'2019-02-05 11:55:57','2019-02-05 11:55:57','DOC_DOWNLOAD',847.00000000,'facture',1,'SuperAdmin',39,'FA1902-0032','2019-02-05 00:00:00','7ad6c529520f286b7eca076092c1ad58713a66f4eaf7946a707b1eb36154c586','e94da047a4590ea5b811fae82ac637d2b4a307a595264717e9be0ad1d6302502','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:17:\"hovevisstraat 115\";s:3:\"zip\";s:4:\"1800\";s:4:\"town\";s:9:\"bilvoorde\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:9:\"542262266\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1901-0014\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:13:\"BRACHE Fabian\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"700.00000000\";s:9:\"total_tva\";s:12:\"147.00000000\";s:9:\"total_ttc\";s:12:\"847.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"700.00000000\";s:23:\"multicurrency_total_tva\";s:12:\"147.00000000\";s:23:\"multicurrency_total_ttc\";s:12:\"847.00000000\";s:3:\"qty\";s:1:\"2\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"700.00000000\";s:9:\"total_tva\";s:12:\"147.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"847.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0032\";s:11:\"note_public\";N;}',0),(128,1,'2019-02-05 12:36:13','2019-02-05 12:36:13','BILL_VALIDATE',145.20000000,'facture',1,'SuperAdmin',40,'FA1902-0033','2019-02-05 00:00:00','c02c6c1d80d0b982795e45d07853d4b5fb5459f2f2c87ec819270e31bb816764','e094d924c53c029a62340b7f3248b8f39b13acc254a68e4897b01f07cbe1bb26','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:120;s:9:\"total_tva\";d:25.2;s:9:\"total_ttc\";d:145.2;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"120.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"25.20000000\";s:23:\"multicurrency_total_ttc\";s:12:\"145.20000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0033\";s:11:\"note_public\";N;}',0),(129,1,'2019-02-05 12:36:16','2019-02-05 12:36:16','DOC_DOWNLOAD',145.20000000,'facture',1,'SuperAdmin',40,'FA1902-0033','2019-02-05 00:00:00','adf2a8b8eb3d4984d9e517dee810fade5a949dbf8b812a3f59bfc08239e6a092','27f0adf1fe41f2ef3fe56ac9de5f42a2d82b1ed04ac47b9cb40eb47c53b7eaac','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:12:\"120.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"25.20000000\";s:23:\"multicurrency_total_ttc\";s:12:\"145.20000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:12:\"120.00000000\";s:9:\"total_tva\";s:11:\"25.20000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:12:\"145.20000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0033\";s:11:\"note_public\";N;}',0),(130,1,'2019-02-05 12:37:45','2019-02-05 12:37:45','BILL_VALIDATE',84.70000000,'facture',1,'SuperAdmin',41,'FA1902-0034','2019-02-05 00:00:00','ac90b883823df251370360888525999597d0078e6c1141985c239b6916265df4','52278e557c90afcfc6484257740790494734b579273617a647dd671a00ae353b','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:70;s:9:\"total_tva\";d:14.7;s:9:\"total_ttc\";d:84.7;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"70.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"14.70000000\";s:23:\"multicurrency_total_ttc\";s:11:\"84.70000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"70.00000000\";s:9:\"total_tva\";s:11:\"14.70000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"84.70000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0034\";s:11:\"note_public\";N;}',0),(131,1,'2019-02-05 12:37:48','2019-02-05 12:37:48','DOC_DOWNLOAD',84.70000000,'facture',1,'SuperAdmin',41,'FA1902-0034','2019-02-05 00:00:00','923ba2750679cad0b244aa97833e0f73a6486db5ae0cdfd87ef00d3bffafd724','b0d78c5b818d5cc0f3b379b6254dde3407c3ff19a5d3953636bc576a36d31dc6','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"70.00000000\";s:9:\"total_tva\";s:11:\"14.70000000\";s:9:\"total_ttc\";s:11:\"84.70000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"70.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"14.70000000\";s:23:\"multicurrency_total_ttc\";s:11:\"84.70000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"70.00000000\";s:9:\"total_tva\";s:11:\"14.70000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"84.70000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0034\";s:11:\"note_public\";N;}',0),(132,1,'2019-02-05 12:41:10','2019-02-05 12:41:10','BILL_VALIDATE',78.65000000,'facture',1,'SuperAdmin',41,'FA1902-0034','2019-02-05 00:00:00','0dbd8eba1ce304fea55c9c24966197e5bab82140767916d095e2a1c39aa53e9b','c6385c034e6d79630725eeb4a10ca3bfa637b66edee5953c686c614c98129ced','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:65;s:9:\"total_tva\";d:13.65;s:9:\"total_ttc\";d:78.65;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"65.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"13.65000000\";s:23:\"multicurrency_total_ttc\";s:11:\"78.65000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"65.00000000\";s:9:\"total_tva\";s:11:\"13.65000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"78.65000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0034\";s:11:\"note_public\";N;}',0),(133,1,'2019-02-05 12:41:12','2019-02-05 12:41:12','DOC_DOWNLOAD',78.65000000,'facture',1,'SuperAdmin',41,'FA1902-0034','2019-02-05 00:00:00','08c25fd55d2e7f80521f60c5a2b964ba75185cadae758be79440e585184da88d','8c4fb3c4339264b41d0095a551d353bb0c6565d786d3d8ff4ae8833618cdbce9','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"65.00000000\";s:9:\"total_tva\";s:11:\"13.65000000\";s:9:\"total_ttc\";s:11:\"78.65000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"65.00000000\";s:23:\"multicurrency_total_tva\";s:11:\"13.65000000\";s:23:\"multicurrency_total_ttc\";s:11:\"78.65000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"65.00000000\";s:9:\"total_tva\";s:11:\"13.65000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"78.65000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0034\";s:11:\"note_public\";N;}',0),(134,1,'2019-02-05 12:43:48','2019-02-05 12:43:48','BILL_VALIDATE',70.00000000,'facture',1,'SuperAdmin',41,'FA1902-0034','2019-02-05 00:00:00','047075bc135d2e0ca645b19e26e93f05afbb1ef98515c08b1b4d77f1919faec5','dcc7198f2aa70200a86858133d662652a635eb8c2de3aca45e237765759a012d','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:57.85;s:9:\"total_tva\";d:12.15;s:9:\"total_ttc\";d:70;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"57.85000000\";s:23:\"multicurrency_total_tva\";s:11:\"12.15000000\";s:23:\"multicurrency_total_ttc\";s:11:\"70.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"57.85000000\";s:9:\"total_tva\";s:11:\"12.15000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"70.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0034\";s:11:\"note_public\";N;}',0),(135,1,'2019-02-05 12:43:50','2019-02-05 12:43:50','DOC_DOWNLOAD',70.00000000,'facture',1,'SuperAdmin',41,'FA1902-0034','2019-02-05 00:00:00','27cc0b36234000d958bf7b5ad5ddbd7c8d2f0e95fdcc58b21783564868ca690a','98f450a57ee7698c8362c8e36ad290ad9f9e9c6b485683fab6806a262c7dd85d','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:24:\"PLace du petit Sablon 13\";s:3:\"zip\";s:4:\"1000\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";N;s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:0:\"\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1902-0015\";s:16:\"code_fournisseur\";s:11:\"SU1902-0001\";s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:14:\"DEBROUX Annick\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1549324800;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:11:\"57.85000000\";s:9:\"total_tva\";s:11:\"12.15000000\";s:9:\"total_ttc\";s:11:\"70.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:11:\"57.85000000\";s:23:\"multicurrency_total_tva\";s:11:\"12.15000000\";s:23:\"multicurrency_total_ttc\";s:11:\"70.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:11:\"57.85000000\";s:9:\"total_tva\";s:11:\"12.15000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:11:\"70.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0034\";s:11:\"note_public\";N;}',0),(136,1,'2019-02-14 11:54:51','2019-02-14 11:54:51','BILL_VALIDATE',9922.00000000,'facture',1,'SuperAdmin',42,'FA1902-0035','2019-02-14 00:00:00','4d0963c21494f83bbc5556d9bb9b4a837a09b0b47efd7e982e79049fe54c969e','6b768d551459378ab6b6d009978dc2dbf322c50376095218e6cce0b778a1dfed','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1550102400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";d:8200;s:9:\"total_tva\";d:1722;s:9:\"total_ttc\";d:9922;s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"8200.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"1722.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"9922.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"8200.00000000\";s:9:\"total_tva\";s:13:\"1722.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"9922.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0035\";s:11:\"note_public\";N;}',0),(137,1,'2019-02-14 11:54:55','2019-02-14 11:54:55','DOC_DOWNLOAD',9922.00000000,'facture',1,'SuperAdmin',42,'FA1902-0035','2019-02-14 00:00:00','a1c3416a4fc3c787deaf7fb0e662b0f2361ec46e341b402e73025646a25ed200','b0b1b3fbdbd68bdf9be19952ff13f015f1117924c4b33db0c9a82b13e6429366','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1550102400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"8200.00000000\";s:9:\"total_tva\";s:13:\"1722.00000000\";s:9:\"total_ttc\";s:13:\"9922.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"8200.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"1722.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"9922.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"8200.00000000\";s:9:\"total_tva\";s:13:\"1722.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"9922.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0035\";s:11:\"note_public\";N;}',0),(138,1,'2019-02-14 11:55:07','2019-02-14 11:55:07','DOC_DOWNLOAD',9922.00000000,'facture',1,'SuperAdmin',42,'FA1902-0035','2019-02-14 00:00:00','1171ccb50a5a7ae757b5c1d507f5385f39e13dfb563d9817ea56904c55dea1f5','facb40f16b9444e09319478be54af459b0249b846d0302e707902873ab9c63be','O:8:\"stdClass\":12:{s:10:\"thirdparty\";O:8:\"stdClass\":29:{s:10:\"name_alias\";s:0:\"\";s:7:\"address\";s:18:\"avenue jupiter 178\";s:3:\"zip\";s:4:\"1190\";s:4:\"town\";s:6:\"Forest\";s:10:\"state_code\";N;s:5:\"phone\";N;s:3:\"fax\";N;s:5:\"email\";s:20:\"info@delta-relay.com\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"be0464107485\";s:15:\"localtax1_assuj\";N;s:15:\"localtax1_value\";s:5:\"0.000\";s:15:\"localtax2_assuj\";N;s:15:\"localtax2_value\";s:5:\"0.000\";s:8:\"managers\";N;s:7:\"capital\";N;s:11:\"typent_code\";s:10:\"TE_UNKNOWN\";s:20:\"forme_juridique_code\";N;s:11:\"code_client\";s:11:\"CU1809-0008\";s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:17:\"Delta-relay ,sprl\";}s:9:\"mycompany\";O:8:\"stdClass\":29:{s:10:\"name_alias\";N;s:7:\"address\";s:23:\"62 Rue des Trois Arbres\";s:3:\"zip\";s:4:\"1180\";s:4:\"town\";s:9:\"Bruxelles\";s:10:\"state_code\";N;s:5:\"phone\";s:11:\"+3228808440\";s:3:\"fax\";s:11:\"+3228808441\";s:5:\"email\";s:16:\"info@loca-box.be\";s:7:\"barcode\";N;s:7:\"idprof1\";s:0:\"\";s:7:\"idprof2\";s:0:\"\";s:7:\"idprof3\";s:0:\"\";s:7:\"idprof4\";s:0:\"\";s:7:\"idprof5\";s:0:\"\";s:7:\"idprof6\";s:0:\"\";s:9:\"tva_intra\";s:12:\"BE0689921012\";s:15:\"localtax1_assuj\";i:0;s:15:\"localtax1_value\";N;s:15:\"localtax2_assuj\";i:0;s:15:\"localtax2_value\";N;s:8:\"managers\";s:16:\"Chokri Abdelkafi\";s:7:\"capital\";s:0:\"\";s:11:\"typent_code\";N;s:20:\"forme_juridique_code\";s:0:\"\";s:11:\"code_client\";N;s:16:\"code_fournisseur\";N;s:7:\"ref_ext\";N;s:12:\"country_code\";s:2:\"BE\";s:4:\"name\";s:8:\"Loca Box\";}s:4:\"date\";i:1550102400;s:10:\"ref_client\";N;s:4:\"type\";s:1:\"0\";s:8:\"total_ht\";s:13:\"8200.00000000\";s:9:\"total_tva\";s:13:\"1722.00000000\";s:9:\"total_ttc\";s:13:\"9922.00000000\";s:12:\"revenuestamp\";s:10:\"0.00000000\";s:11:\"invoiceline\";a:1:{i:1;O:8:\"stdClass\":17:{s:3:\"ref\";N;s:18:\"multicurrency_code\";s:3:\"EUR\";s:22:\"multicurrency_total_ht\";s:13:\"8200.00000000\";s:23:\"multicurrency_total_tva\";s:13:\"1722.00000000\";s:23:\"multicurrency_total_ttc\";s:13:\"9922.00000000\";s:3:\"qty\";s:1:\"1\";s:12:\"product_type\";s:1:\"1\";s:12:\"vat_src_code\";s:2:\"BE\";s:6:\"tva_tx\";s:6:\"21.000\";s:12:\"localtax1_tx\";s:5:\"0.000\";s:12:\"localtax2_tx\";s:5:\"0.000\";s:8:\"total_ht\";s:13:\"8200.00000000\";s:9:\"total_tva\";s:13:\"1722.00000000\";s:15:\"total_localtax1\";s:10:\"0.00000000\";s:15:\"total_localtax2\";s:10:\"0.00000000\";s:9:\"total_ttc\";s:13:\"9922.00000000\";s:9:\"info_bits\";s:1:\"0\";}}s:3:\"ref\";s:11:\"FA1902-0035\";s:11:\"note_public\";N;}',0);
/*!40000 ALTER TABLE `llx_blockedlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_blockedlog_authority`
--

DROP TABLE IF EXISTS `llx_blockedlog_authority`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_blockedlog_authority` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `blockchain` longtext NOT NULL,
  `signature` varchar(100) NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  KEY `signature` (`signature`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_blockedlog_authority`
--

LOCK TABLES `llx_blockedlog_authority` WRITE;
/*!40000 ALTER TABLE `llx_blockedlog_authority` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_blockedlog_authority` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bookmark`
--

DROP TABLE IF EXISTS `llx_bookmark`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bookmark` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_user` int(11) NOT NULL,
  `dateb` datetime DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `target` varchar(16) DEFAULT NULL,
  `title` varchar(64) DEFAULT NULL,
  `favicon` varchar(24) DEFAULT NULL,
  `position` int(11) DEFAULT '0',
  `entity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bookmark_url` (`fk_user`,`url`),
  UNIQUE KEY `uk_bookmark_title` (`fk_user`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bookmark`
--

LOCK TABLES `llx_bookmark` WRITE;
/*!40000 ALTER TABLE `llx_bookmark` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bookmark` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_bordereau_cheque`
--

DROP TABLE IF EXISTS `llx_bordereau_cheque`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_bordereau_cheque` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `datec` datetime NOT NULL,
  `date_bordereau` date DEFAULT NULL,
  `amount` double(24,8) NOT NULL,
  `nbcheque` smallint(6) NOT NULL,
  `fk_bank_account` int(11) DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `statut` smallint(6) NOT NULL DEFAULT '0',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `note` text,
  `entity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_bordereau_cheque` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_bordereau_cheque`
--

LOCK TABLES `llx_bordereau_cheque` WRITE;
/*!40000 ALTER TABLE `llx_bordereau_cheque` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_bordereau_cheque` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_boxes`
--

DROP TABLE IF EXISTS `llx_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_boxes` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `box_id` int(11) NOT NULL,
  `position` smallint(6) NOT NULL,
  `box_order` varchar(3) NOT NULL,
  `fk_user` int(11) NOT NULL DEFAULT '0',
  `maxline` int(11) DEFAULT NULL,
  `params` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_boxes` (`entity`,`box_id`,`position`,`fk_user`),
  KEY `idx_boxes_boxid` (`box_id`),
  KEY `idx_boxes_fk_user` (`fk_user`),
  CONSTRAINT `fk_boxes_box_id` FOREIGN KEY (`box_id`) REFERENCES `llx_boxes_def` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_boxes`
--

LOCK TABLES `llx_boxes` WRITE;
/*!40000 ALTER TABLE `llx_boxes` DISABLE KEYS */;
INSERT INTO `llx_boxes` VALUES (1,1,1,0,'0',0,NULL,NULL),(2,1,2,0,'0',0,NULL,NULL),(3,1,3,0,'0',0,NULL,NULL),(4,1,4,0,'0',0,NULL,NULL),(5,1,5,0,'0',0,NULL,NULL),(6,1,6,0,'0',0,NULL,NULL),(7,1,7,0,'0',0,NULL,NULL),(8,1,8,0,'0',0,NULL,NULL),(9,1,9,0,'0',0,NULL,NULL),(10,1,10,0,'0',0,NULL,NULL),(11,1,11,0,'0',0,NULL,NULL),(12,1,12,0,'0',0,NULL,NULL),(13,1,13,0,'0',0,NULL,NULL),(14,1,14,0,'0',0,NULL,NULL),(15,1,15,0,'0',0,NULL,NULL),(16,1,16,0,'0',0,NULL,NULL),(17,1,17,0,'0',0,NULL,NULL),(18,1,18,0,'0',0,NULL,NULL),(19,1,19,0,'0',0,NULL,NULL),(21,1,21,0,'0',0,NULL,NULL),(22,1,22,0,'0',0,NULL,NULL),(23,1,23,0,'0',0,NULL,NULL),(24,1,24,0,'0',0,NULL,NULL),(25,1,25,0,'0',0,NULL,NULL),(26,1,26,0,'0',0,NULL,NULL),(27,1,27,0,'0',0,NULL,NULL),(28,1,28,0,'0',0,NULL,NULL),(29,1,29,0,'0',0,NULL,NULL),(30,1,30,0,'0',0,NULL,NULL),(31,1,31,0,'0',0,NULL,NULL),(32,1,32,0,'0',0,NULL,NULL);
/*!40000 ALTER TABLE `llx_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_boxes_def`
--

DROP TABLE IF EXISTS `llx_boxes_def`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_boxes_def` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(200) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `note` varchar(130) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_boxes_def` (`file`,`entity`,`note`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_boxes_def`
--

LOCK TABLES `llx_boxes_def` WRITE;
/*!40000 ALTER TABLE `llx_boxes_def` DISABLE KEYS */;
INSERT INTO `llx_boxes_def` VALUES (1,'box_lastlogin.php',1,'2018-05-18 18:28:06',NULL),(2,'box_clients.php',1,'2018-05-18 18:28:56',NULL),(3,'box_prospect.php',1,'2018-05-18 18:28:56',NULL),(4,'box_contacts.php',1,'2018-05-18 18:28:56',NULL),(5,'box_activity.php',1,'2018-05-18 18:28:56','(WarningUsingThisBoxSlowDown)'),(6,'box_goodcustomers.php',1,'2018-05-18 18:28:56','(WarningUsingThisBoxSlowDown)'),(7,'box_graph_propales_permonth.php',1,'2018-05-18 18:28:57',NULL),(8,'box_propales.php',1,'2018-05-18 18:28:57',NULL),(9,'box_commandes.php',1,'2018-05-18 18:28:58',NULL),(10,'box_graph_orders_permonth.php',1,'2018-05-18 18:28:58',NULL),(11,'box_contracts.php',1,'2018-05-18 18:29:02',NULL),(12,'box_services_expired.php',1,'2018-05-18 18:29:02',NULL),(13,'box_ficheinter.php',1,'2018-05-18 18:29:05',NULL),(14,'box_graph_invoices_supplier_permonth.php',1,'2018-05-18 19:18:03',NULL),(15,'box_graph_orders_supplier_permonth.php',1,'2018-05-18 19:18:03',NULL),(16,'box_fournisseurs.php',1,'2018-05-18 19:18:03',NULL),(17,'box_factures_fourn_imp.php',1,'2018-05-18 19:18:03',NULL),(18,'box_factures_fourn.php',1,'2018-05-18 19:18:03',NULL),(19,'box_supplier_orders.php',1,'2018-05-18 19:18:03',NULL),(21,'box_factures_imp.php',1,'2018-05-18 19:18:24',NULL),(22,'box_factures.php',1,'2018-05-18 19:18:24',NULL),(23,'box_graph_invoices_permonth.php',1,'2018-05-18 19:18:24',NULL),(24,'box_comptes.php',1,'2018-05-18 19:18:37',NULL),(25,'box_produits.php',1,'2018-05-18 19:18:41',NULL),(26,'box_produits_alerte_stock.php',1,'2018-05-18 19:18:41',NULL),(27,'box_graph_product_distribution.php',1,'2018-05-18 19:18:41',NULL),(28,'box_services_contracts.php',1,'2018-05-18 19:18:55',NULL),(29,'box_project.php',1,'2018-05-18 19:19:12',NULL),(30,'box_task.php',1,'2018-05-18 19:19:12',NULL),(31,'box_actions.php',1,'2018-05-18 19:19:14',NULL),(32,'box_bookmarks.php',1,'2018-05-18 19:19:38',NULL);
/*!40000 ALTER TABLE `llx_boxes_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_budget`
--

DROP TABLE IF EXISTS `llx_budget`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_budget` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `label` varchar(255) NOT NULL,
  `status` int(11) DEFAULT NULL,
  `note` text,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `import_key` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_budget`
--

LOCK TABLES `llx_budget` WRITE;
/*!40000 ALTER TABLE `llx_budget` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_budget` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_budget_lines`
--

DROP TABLE IF EXISTS `llx_budget_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_budget_lines` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_budget` int(11) NOT NULL,
  `fk_project_ids` varchar(180) NOT NULL,
  `amount` double(24,8) NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `import_key` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_budget_lines` (`fk_budget`,`fk_project_ids`),
  CONSTRAINT `fk_budget_lines_budget` FOREIGN KEY (`fk_budget`) REFERENCES `llx_budget` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_budget_lines`
--

LOCK TABLES `llx_budget_lines` WRITE;
/*!40000 ALTER TABLE `llx_budget_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_budget_lines` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_accounting_category`
--

DROP TABLE IF EXISTS `llx_c_accounting_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_accounting_category` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `label` varchar(255) NOT NULL,
  `range_account` varchar(255) NOT NULL,
  `sens` tinyint(4) NOT NULL DEFAULT '0',
  `category_type` tinyint(4) NOT NULL DEFAULT '0',
  `formula` varchar(255) NOT NULL,
  `position` int(11) DEFAULT '0',
  `fk_country` int(11) DEFAULT NULL,
  `active` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_accounting_category` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_accounting_category`
--

LOCK TABLES `llx_c_accounting_category` WRITE;
/*!40000 ALTER TABLE `llx_c_accounting_category` DISABLE KEYS */;
INSERT INTO `llx_c_accounting_category` VALUES (1,'INCOMES','Income of products/services','Example: 7xxxxx',0,0,'',10,0,1),(2,'EXPENSES','Expenses of products/services','Example: 6xxxxx',0,0,'',20,0,1),(3,'PROFIT','Balance','',0,1,'INCOMES+EXPENSES',30,0,1);
/*!40000 ALTER TABLE `llx_c_accounting_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_action_trigger`
--

DROP TABLE IF EXISTS `llx_c_action_trigger`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_action_trigger` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `elementtype` varchar(24) NOT NULL,
  `code` varchar(32) NOT NULL,
  `label` varchar(128) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `rang` int(11) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_action_trigger_code` (`code`),
  KEY `idx_action_trigger_rang` (`rang`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_action_trigger`
--

LOCK TABLES `llx_c_action_trigger` WRITE;
/*!40000 ALTER TABLE `llx_c_action_trigger` DISABLE KEYS */;
INSERT INTO `llx_c_action_trigger` VALUES (1,'societe','COMPANY_CREATE','Third party created','Executed when a third party is created',1),(2,'societe','COMPANY_SENTBYMAIL','Mails sent from third party card','Executed when you send email from third party card',1),(3,'propal','PROPAL_VALIDATE','Customer proposal validated','Executed when a commercial proposal is validated',2),(4,'propal','PROPAL_SENTBYMAIL','Commercial proposal sent by mail','Executed when a commercial proposal is sent by mail',3),(5,'propal','PROPAL_CLOSE_SIGNED','Customer proposal closed signed','Executed when a customer proposal is closed signed',2),(6,'propal','PROPAL_CLOSE_REFUSED','Customer proposal closed refused','Executed when a customer proposal is closed refused',2),(7,'propal','PROPAL_CLASSIFY_BILLED','Customer proposal set billed','Executed when a customer proposal is set to billed',2),(8,'commande','ORDER_VALIDATE','Customer order validate','Executed when a customer order is validated',4),(9,'commande','ORDER_CLOSE','Customer order classify delivered','Executed when a customer order is set delivered',5),(10,'commande','ORDER_CLASSIFY_BILLED','Customer order classify billed','Executed when a customer order is set to billed',5),(11,'commande','ORDER_CANCEL','Customer order canceled','Executed when a customer order is canceled',5),(12,'commande','ORDER_SENTBYMAIL','Customer order sent by mail','Executed when a customer order is sent by mail ',5),(13,'facture','BILL_VALIDATE','Customer invoice validated','Executed when a customer invoice is approved',6),(14,'facture','BILL_PAYED','Customer invoice payed','Executed when a customer invoice is payed',7),(15,'facture','BILL_CANCEL','Customer invoice canceled','Executed when a customer invoice is conceled',8),(16,'facture','BILL_SENTBYMAIL','Customer invoice sent by mail','Executed when a customer invoice is sent by mail',9),(17,'facture','BILL_UNVALIDATE','Customer invoice unvalidated','Executed when a customer invoice status set back to draft',9),(18,'proposal_supplier','PROPOSAL_SUPPLIER_VALIDATE','Price request validated','Executed when a commercial proposal is validated',10),(19,'proposal_supplier','PROPOSAL_SUPPLIER_SENTBYMAIL','Price request sent by mail','Executed when a commercial proposal is sent by mail',10),(20,'proposal_supplier','PROPOSAL_SUPPLIER_CLOSE_SIGNED','Price request closed signed','Executed when a customer proposal is closed signed',10),(21,'proposal_supplier','PROPOSAL_SUPPLIER_CLOSE_REFUSED','Price request closed refused','Executed when a customer proposal is closed refused',10),(22,'order_supplier','ORDER_SUPPLIER_VALIDATE','Supplier order validated','Executed when a supplier order is validated',12),(23,'order_supplier','ORDER_SUPPLIER_APPROVE','Supplier order request approved','Executed when a supplier order is approved',13),(24,'order_supplier','ORDER_SUPPLIER_SUBMIT','Supplier order request submited','Executed when a supplier order is approved',13),(25,'order_supplier','ORDER_SUPPLIER_RECEIVE','Supplier order request received','Executed when a supplier order is received',13),(26,'order_supplier','ORDER_SUPPLIER_REFUSE','Supplier order request refused','Executed when a supplier order is refused',13),(27,'order_supplier','ORDER_SUPPLIER_SENTBYMAIL','Supplier order sent by mail','Executed when a supplier order is sent by mail',14),(28,'order_supplier','ORDER_SUPPLIER_CLASSIFY_BILLED','Supplier order set billed','Executed when a supplier order is set as billed',14),(29,'invoice_supplier','BILL_SUPPLIER_VALIDATE','Supplier invoice validated','Executed when a supplier invoice is validated',15),(30,'invoice_supplier','BILL_SUPPLIER_UNVALIDATE','Supplier invoice unvalidated','Executed when a supplier invoice status is set back to draft',15),(31,'invoice_supplier','BILL_SUPPLIER_PAYED','Supplier invoice payed','Executed when a supplier invoice is payed',16),(32,'invoice_supplier','BILL_SUPPLIER_SENTBYMAIL','Supplier invoice sent by mail','Executed when a supplier invoice is sent by mail',17),(33,'invoice_supplier','BILL_SUPPLIER_CANCELED','Supplier invoice cancelled','Executed when a supplier invoice is cancelled',17),(34,'contrat','CONTRACT_VALIDATE','Contract validated','Executed when a contract is validated',18),(35,'contrat','CONTRACT_SENTBYMAIL','Contract sent by mail','Executed when a contract is sent by mail',18),(36,'shipping','SHIPPING_VALIDATE','Shipping validated','Executed when a shipping is validated',20),(37,'shipping','SHIPPING_SENTBYMAIL','Shipping sent by mail','Executed when a shipping is sent by mail',21),(38,'member','MEMBER_VALIDATE','Member validated','Executed when a member is validated',22),(39,'member','MEMBER_SENTBYMAIL','Mails sent from member card','Executed when you send email from member card',23),(40,'member','MEMBER_SUBSCRIPTION_CREATE','Member subscribtion recorded','Executed when a member subscribtion is deleted',24),(41,'member','MEMBER_SUBSCRIPTION_MODIFY','Member subscribtion modified','Executed when a member subscribtion is modified',24),(42,'member','MEMBER_SUBSCRIPTION_DELETE','Member subscribtion deleted','Executed when a member subscribtion is deleted',24),(43,'member','MEMBER_RESILIATE','Member resiliated','Executed when a member is resiliated',25),(44,'member','MEMBER_DELETE','Member deleted','Executed when a member is deleted',26),(45,'ficheinter','FICHINTER_VALIDATE','Intervention validated','Executed when a intervention is validated',30),(46,'ficheinter','FICHINTER_CLASSIFY_BILLED','Intervention set billed','Executed when a intervention is set to billed (when option FICHINTER_CLASSIFY_BILLED is set)',32),(47,'ficheinter','FICHINTER_CLASSIFY_UNBILLED','Intervention set unbilled','Executed when a intervention is set to unbilled (when option FICHINTER_CLASSIFY_BILLED is set)',33),(48,'ficheinter','FICHINTER_REOPEN','Intervention opened','Executed when a intervention is re-opened',34),(49,'ficheinter','FICHINTER_SENTBYMAIL','Intervention sent by mail','Executed when a intervention is sent by mail',35),(50,'product','PRODUCT_CREATE','Product or service created','Executed when a product or sevice is created',40),(51,'product','PRODUCT_DELETE','Product or service deleted','Executed when a product or sevice is deleted',42),(52,'expensereport','EXPENSE_REPORT_CREATE','Expense report created','Executed when an expense report is created',201),(53,'expensereport','EXPENSE_REPORT_VALIDATE','Expense report validated','Executed when an expense report is validated',202),(54,'expensereport','EXPENSE_REPORT_APPROVE','Expense report approved','Executed when an expense report is approved',203),(55,'expensereport','EXPENSE_REPORT_PAYED','Expense report billed','Executed when an expense report is set as billed',204),(56,'project','PROJECT_VALIDATE','Project validation','Executed when a project is validated',141),(57,'project','PROJECT_DELETE','Project deleted','Executed when a project is deleted',143),(58,'product','PRODUCT_MODIFY','Product or service modified','Executed when a product or sevice is modified',41),(59,'member','MEMBER_MODIFY','Member modified','Executed when a member is modified',23),(60,'ficheinter','FICHINTER_MODIFY','Intervention modified','Executed when a intervention is modified',31),(61,'project','PROJECT_CREATE','Project creation','Executed when a project is created',140),(62,'project','PROJECT_MODIFY','Project modified','Executed when a project is modified',142),(63,'project','TASK_CREATE','Task created','Executed when a project task is created',150),(64,'project','TASK_MODIFY','Task modified','Executed when a project task is modified',151),(65,'project','TASK_DELETE','Task deleted','Executed when a project task is deleted',152);
/*!40000 ALTER TABLE `llx_c_action_trigger` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_actioncomm`
--

DROP TABLE IF EXISTS `llx_c_actioncomm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_actioncomm` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `type` varchar(50) NOT NULL DEFAULT 'system',
  `libelle` varchar(48) NOT NULL,
  `module` varchar(16) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `todo` tinyint(4) DEFAULT NULL,
  `color` varchar(9) DEFAULT NULL,
  `picto` varchar(48) DEFAULT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_actioncomm` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_actioncomm`
--

LOCK TABLES `llx_c_actioncomm` WRITE;
/*!40000 ALTER TABLE `llx_c_actioncomm` DISABLE KEYS */;
INSERT INTO `llx_c_actioncomm` VALUES (1,'AC_TEL','system','Phone call',NULL,1,NULL,NULL,NULL,2),(2,'AC_FAX','system','Send Fax',NULL,1,NULL,NULL,NULL,3),(4,'AC_EMAIL','system','Send Email',NULL,1,NULL,NULL,NULL,4),(5,'AC_RDV','system','Rendez-vous',NULL,1,NULL,NULL,NULL,1),(11,'AC_INT','system','Intervention on site',NULL,1,NULL,NULL,NULL,4),(40,'AC_OTH_AUTO','systemauto','Other (automatically inserted events)',NULL,1,NULL,NULL,NULL,20),(50,'AC_OTH','system','Other (manually inserted events)',NULL,1,NULL,NULL,NULL,5);
/*!40000 ALTER TABLE `llx_c_actioncomm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_availability`
--

DROP TABLE IF EXISTS `llx_c_availability`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_availability` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(30) NOT NULL,
  `label` varchar(60) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_availability` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_availability`
--

LOCK TABLES `llx_c_availability` WRITE;
/*!40000 ALTER TABLE `llx_c_availability` DISABLE KEYS */;
INSERT INTO `llx_c_availability` VALUES (1,'AV_NOW','Immediate',1),(2,'AV_1W','1 week',1),(3,'AV_2W','2 weeks',1),(4,'AV_3W','3 weeks',1);
/*!40000 ALTER TABLE `llx_c_availability` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_barcode_type`
--

DROP TABLE IF EXISTS `llx_c_barcode_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_barcode_type` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `libelle` varchar(50) NOT NULL,
  `coder` varchar(16) NOT NULL,
  `example` varchar(16) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_barcode_type` (`code`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_barcode_type`
--

LOCK TABLES `llx_c_barcode_type` WRITE;
/*!40000 ALTER TABLE `llx_c_barcode_type` DISABLE KEYS */;
INSERT INTO `llx_c_barcode_type` VALUES (1,'EAN8',1,'EAN8','0','1234567'),(2,'EAN13',1,'EAN13','0','123456789012'),(3,'UPC',1,'UPC','0','123456789012'),(4,'ISBN',1,'ISBN','0','123456789'),(5,'C39',1,'Code 39','0','1234567890'),(6,'C128',1,'Code 128','0','ABCD1234567890'),(7,'DATAMATRIX',1,'Datamatrix','0','1234567xyz'),(8,'QRCODE',1,'Qr Code','0','www.dolibarr.org');
/*!40000 ALTER TABLE `llx_c_barcode_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_chargesociales`
--

DROP TABLE IF EXISTS `llx_c_chargesociales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_chargesociales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `libelle` varchar(80) DEFAULT NULL,
  `deductible` smallint(6) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `code` varchar(12) NOT NULL,
  `accountancy_code` varchar(32) DEFAULT NULL,
  `fk_pays` int(11) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4110 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_chargesociales`
--

LOCK TABLES `llx_c_chargesociales` WRITE;
/*!40000 ALTER TABLE `llx_c_chargesociales` DISABLE KEYS */;
INSERT INTO `llx_c_chargesociales` VALUES (1,'Allocations familiales',1,1,'TAXFAM',NULL,1,NULL),(2,'CSG Deductible',1,1,'TAXCSGD',NULL,1,NULL),(3,'CSG/CRDS NON Deductible',0,1,'TAXCSGND',NULL,1,NULL),(10,'Taxe apprentissage',0,1,'TAXAPP',NULL,1,NULL),(11,'Taxe professionnelle',0,1,'TAXPRO',NULL,1,NULL),(12,'Cotisation fonciere des entreprises',0,1,'TAXCFE',NULL,1,NULL),(13,'Cotisation sur la valeur ajoutee des entreprises',0,1,'TAXCVAE',NULL,1,NULL),(20,'Impots locaux/fonciers',0,1,'TAXFON',NULL,1,NULL),(25,'Impots revenus',0,1,'TAXREV',NULL,1,NULL),(30,'Assurance Sante',0,1,'TAXSECU',NULL,1,NULL),(40,'Mutuelle',0,1,'TAXMUT',NULL,1,NULL),(50,'Assurance vieillesse',0,1,'TAXRET',NULL,1,NULL),(60,'Assurance Chomage',0,1,'TAXCHOM',NULL,1,NULL),(201,'ONSS',1,1,'TAXBEONSS',NULL,2,NULL),(210,'Precompte professionnel',1,1,'TAXBEPREPRO',NULL,2,NULL),(220,'Prime existence',1,1,'TAXBEPRIEXI',NULL,2,NULL),(230,'Precompte immobilier',1,1,'TAXBEPREIMMO',NULL,2,NULL),(4101,'Krankenversicherung',1,1,'TAXATKV',NULL,41,NULL),(4102,'Unfallversicherung',1,1,'TAXATUV',NULL,41,NULL),(4103,'Pensionsversicherung',1,1,'TAXATPV',NULL,41,NULL),(4104,'Arbeitslosenversicherung',1,1,'TAXATAV',NULL,41,NULL),(4105,'Insolvenzentgeltsicherungsfond',1,1,'TAXATIESG',NULL,41,NULL),(4106,'Wohnbauförderung',1,1,'TAXATWF',NULL,41,NULL),(4107,'Arbeiterkammerumlage',1,1,'TAXATAK',NULL,41,NULL),(4108,'Mitarbeitervorsorgekasse',1,1,'TAXATMVK',NULL,41,NULL),(4109,'Familienlastenausgleichsfond',1,1,'TAXATFLAF',NULL,41,NULL);
/*!40000 ALTER TABLE `llx_c_chargesociales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_civility`
--

DROP TABLE IF EXISTS `llx_c_civility`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_civility` (
  `rowid` int(11) NOT NULL,
  `code` varchar(6) NOT NULL,
  `label` varchar(50) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_civility` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_civility`
--

LOCK TABLES `llx_c_civility` WRITE;
/*!40000 ALTER TABLE `llx_c_civility` DISABLE KEYS */;
INSERT INTO `llx_c_civility` VALUES (1,'MME','Madame',1,NULL),(3,'MR','Monsieur',1,NULL),(5,'MLE','Mademoiselle',1,NULL),(7,'MTRE','Maître',1,NULL),(8,'DR','Docteur',1,NULL);
/*!40000 ALTER TABLE `llx_c_civility` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_country`
--

DROP TABLE IF EXISTS `llx_c_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_country` (
  `rowid` int(11) NOT NULL,
  `code` varchar(2) NOT NULL,
  `code_iso` varchar(3) DEFAULT NULL,
  `label` varchar(50) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `favorite` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_c_country_code` (`code`),
  UNIQUE KEY `idx_c_country_label` (`label`),
  UNIQUE KEY `idx_c_country_code_iso` (`code_iso`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_country`
--

LOCK TABLES `llx_c_country` WRITE;
/*!40000 ALTER TABLE `llx_c_country` DISABLE KEYS */;
INSERT INTO `llx_c_country` VALUES (0,'',NULL,'-',1,1),(1,'FR','FRA','France',1,0),(2,'BE','BEL','Belgium',1,0),(3,'IT','ITA','Italy',1,0),(4,'ES','ESP','Spain',1,0),(5,'DE','DEU','Germany',1,0),(6,'CH','CHE','Switzerland',1,0),(7,'GB','GBR','United Kingdom',1,0),(8,'IE','IRL','Irland',1,0),(9,'CN','CHN','China',1,0),(10,'TN','TUN','Tunisia',1,0),(11,'US','USA','United States',1,0),(12,'MA','MAR','Maroc',1,0),(13,'DZ','DZA','Algeria',1,0),(14,'CA','CAN','Canada',1,0),(15,'TG','TGO','Togo',1,0),(16,'GA','GAB','Gabon',1,0),(17,'NL','NLD','Nederland',1,0),(18,'HU','HUN','Hongrie',1,0),(19,'RU','RUS','Russia',1,0),(20,'SE','SWE','Sweden',1,0),(21,'CI','CIV','Côte d\'Ivoire',1,0),(22,'SN','SEN','Senegal',1,0),(23,'AR','ARG','Argentine',1,0),(24,'CM','CMR','Cameroun',1,0),(25,'PT','PRT','Portugal',1,0),(26,'SA','SAU','Saudi Arabia',1,0),(27,'MC','MCO','Monaco',1,0),(28,'AU','AUS','Australia',1,0),(29,'SG','SGP','Singapour',1,0),(30,'AF','AFG','Afghanistan',1,0),(31,'AX','ALA','Iles Aland',1,0),(32,'AL','ALB','Albanie',1,0),(33,'AS','ASM','Samoa américaines',1,0),(34,'AD','AND','Andorre',1,0),(35,'AO','AGO','Angola',1,0),(36,'AI','AIA','Anguilla',1,0),(37,'AQ','ATA','Antarctique',1,0),(38,'AG','ATG','Antigua-et-Barbuda',1,0),(39,'AM','ARM','Arménie',1,0),(40,'AW','ABW','Aruba',1,0),(41,'AT','AUT','Autriche',1,0),(42,'AZ','AZE','Azerbaïdjan',1,0),(43,'BS','BHS','Bahamas',1,0),(44,'BH','BHR','Bahreïn',1,0),(45,'BD','BGD','Bangladesh',1,0),(46,'BB','BRB','Barbade',1,0),(47,'BY','BLR','Biélorussie',1,0),(48,'BZ','BLZ','Belize',1,0),(49,'BJ','BEN','Bénin',1,0),(50,'BM','BMU','Bermudes',1,0),(51,'BT','BTN','Bhoutan',1,0),(52,'BO','BOL','Bolivie',1,0),(53,'BA','BIH','Bosnie-Herzégovine',1,0),(54,'BW','BWA','Botswana',1,0),(55,'BV','BVT','Ile Bouvet',1,0),(56,'BR','BRA','Brazil',1,0),(57,'IO','IOT','Territoire britannique de l\'Océan Indien',1,0),(58,'BN','BRN','Brunei',1,0),(59,'BG','BGR','Bulgarie',1,0),(60,'BF','BFA','Burkina Faso',1,0),(61,'BI','BDI','Burundi',1,0),(62,'KH','KHM','Cambodge',1,0),(63,'CV','CPV','Cap-Vert',1,0),(64,'KY','CYM','Iles Cayman',1,0),(65,'CF','CAF','République centrafricaine',1,0),(66,'TD','TCD','Tchad',1,0),(67,'CL','CHL','Chili',1,0),(68,'CX','CXR','Ile Christmas',1,0),(69,'CC','CCK','Iles des Cocos (Keeling)',1,0),(70,'CO','COL','Colombie',1,0),(71,'KM','COM','Comores',1,0),(72,'CG','COG','Congo',1,0),(73,'CD','COD','République démocratique du Congo',1,0),(74,'CK','COK','Iles Cook',1,0),(75,'CR','CRI','Costa Rica',1,0),(76,'HR','HRV','Croatie',1,0),(77,'CU','CUB','Cuba',1,0),(78,'CY','CYP','Cyprus',1,0),(79,'CZ','CZE','République Tchèque',1,0),(80,'DK','DNK','Danemark',1,0),(81,'DJ','DJI','Djibouti',1,0),(82,'DM','DMA','Dominique',1,0),(83,'DO','DOM','République Dominicaine',1,0),(84,'EC','ECU','Equateur',1,0),(85,'EG','EGY','Egypte',1,0),(86,'SV','SLV','Salvador',1,0),(87,'GQ','GNQ','Guinée Equatoriale',1,0),(88,'ER','ERI','Erythrée',1,0),(89,'EE','EST','Estonia',1,0),(90,'ET','ETH','Ethiopie',1,0),(91,'FK','FLK','Iles Falkland',1,0),(92,'FO','FRO','Iles Féroé',1,0),(93,'FJ','FJI','Iles Fidji',1,0),(94,'FI','FIN','Finlande',1,0),(95,'GF','GUF','Guyane française',1,0),(96,'PF','PYF','Polynésie française',1,0),(97,'TF','ATF','Terres australes françaises',1,0),(98,'GM','GMB','Gambie',1,0),(99,'GE','GEO','Georgia',1,0),(100,'GH','GHA','Ghana',1,0),(101,'GI','GIB','Gibraltar',1,0),(102,'GR','GRC','Greece',1,0),(103,'GL','GRL','Groenland',1,0),(104,'GD','GRD','Grenade',1,0),(106,'GU','GUM','Guam',1,0),(107,'GT','GTM','Guatemala',1,0),(108,'GN','GIN','Guinea',1,0),(109,'GW','GNB','Guinea-Bissao',1,0),(111,'HT','HTI','Haiti',1,0),(112,'HM','HMD','Iles Heard et McDonald',1,0),(113,'VA','VAT','Saint-Siège (Vatican)',1,0),(114,'HN','HND','Honduras',1,0),(115,'HK','HKG','Hong Kong',1,0),(116,'IS','ISL','Islande',1,0),(117,'IN','IND','India',1,0),(118,'ID','IDN','Indonésie',1,0),(119,'IR','IRN','Iran',1,0),(120,'IQ','IRQ','Iraq',1,0),(121,'IL','ISR','Israel',1,0),(122,'JM','JAM','Jamaïque',1,0),(123,'JP','JPN','Japon',1,0),(124,'JO','JOR','Jordanie',1,0),(125,'KZ','KAZ','Kazakhstan',1,0),(126,'KE','KEN','Kenya',1,0),(127,'KI','KIR','Kiribati',1,0),(128,'KP','PRK','North Corea',1,0),(129,'KR','KOR','South Corea',1,0),(130,'KW','KWT','Koweït',1,0),(131,'KG','KGZ','Kirghizistan',1,0),(132,'LA','LAO','Laos',1,0),(133,'LV','LVA','Lettonie',1,0),(134,'LB','LBN','Liban',1,0),(135,'LS','LSO','Lesotho',1,0),(136,'LR','LBR','Liberia',1,0),(137,'LY','LBY','Libye',1,0),(138,'LI','LIE','Liechtenstein',1,0),(139,'LT','LTU','Lituanie',1,0),(140,'LU','LUX','Luxembourg',1,0),(141,'MO','MAC','Macao',1,0),(142,'MK','MKD','ex-République yougoslave de Macédoine',1,0),(143,'MG','MDG','Madagascar',1,0),(144,'MW','MWI','Malawi',1,0),(145,'MY','MYS','Malaisie',1,0),(146,'MV','MDV','Maldives',1,0),(147,'ML','MLI','Mali',1,0),(148,'MT','MLT','Malte',1,0),(149,'MH','MHL','Iles Marshall',1,0),(151,'MR','MRT','Mauritanie',1,0),(152,'MU','MUS','Maurice',1,0),(153,'YT','MYT','Mayotte',1,0),(154,'MX','MEX','Mexique',1,0),(155,'FM','FSM','Micronésie',1,0),(156,'MD','MDA','Moldavie',1,0),(157,'MN','MNG','Mongolie',1,0),(158,'MS','MSR','Monserrat',1,0),(159,'MZ','MOZ','Mozambique',1,0),(160,'MM','MMR','Birmanie (Myanmar)',1,0),(161,'NA','NAM','Namibie',1,0),(162,'NR','NRU','Nauru',1,0),(163,'NP','NPL','Népal',1,0),(165,'NC','NCL','Nouvelle-Calédonie',1,0),(166,'NZ','NZL','Nouvelle-Zélande',1,0),(167,'NI','NIC','Nicaragua',1,0),(168,'NE','NER','Niger',1,0),(169,'NG','NGA','Nigeria',1,0),(170,'NU','NIU','Nioué',1,0),(171,'NF','NFK','Ile Norfolk',1,0),(172,'MP','MNP','Mariannes du Nord',1,0),(173,'NO','NOR','Norvège',1,0),(174,'OM','OMN','Oman',1,0),(175,'PK','PAK','Pakistan',1,0),(176,'PW','PLW','Palaos',1,0),(177,'PS','PSE','Territoire Palestinien Occupé',1,0),(178,'PA','PAN','Panama',1,0),(179,'PG','PNG','Papouasie-Nouvelle-Guinée',1,0),(180,'PY','PRY','Paraguay',1,0),(181,'PE','PER','Peru',1,0),(182,'PH','PHL','Philippines',1,0),(183,'PN','PCN','Iles Pitcairn',1,0),(184,'PL','POL','Pologne',1,0),(185,'PR','PRI','Porto Rico',1,0),(186,'QA','QAT','Qatar',1,0),(188,'RO','ROU','Roumanie',1,0),(189,'RW','RWA','Rwanda',1,0),(190,'SH','SHN','Sainte-Hélène',1,0),(191,'KN','KNA','Saint-Christophe-et-Niévès',1,0),(192,'LC','LCA','Sainte-Lucie',1,0),(193,'PM','SPM','Saint-Pierre-et-Miquelon',1,0),(194,'VC','VCT','Saint-Vincent-et-les-Grenadines',1,0),(195,'WS','WSM','Samoa',1,0),(196,'SM','SMR','Saint-Marin',1,0),(197,'ST','STP','Sao Tomé-et-Principe',1,0),(198,'RS','SRB','Serbie',1,0),(199,'SC','SYC','Seychelles',1,0),(200,'SL','SLE','Sierra Leone',1,0),(201,'SK','SVK','Slovaquie',1,0),(202,'SI','SVN','Slovénie',1,0),(203,'SB','SLB','Iles Salomon',1,0),(204,'SO','SOM','Somalie',1,0),(205,'ZA','ZAF','Afrique du Sud',1,0),(206,'GS','SGS','Iles Géorgie du Sud et Sandwich du Sud',1,0),(207,'LK','LKA','Sri Lanka',1,0),(208,'SD','SDN','Soudan',1,0),(209,'SR','SUR','Suriname',1,0),(210,'SJ','SJM','Iles Svalbard et Jan Mayen',1,0),(211,'SZ','SWZ','Swaziland',1,0),(212,'SY','SYR','Syrie',1,0),(213,'TW','TWN','Taïwan',1,0),(214,'TJ','TJK','Tadjikistan',1,0),(215,'TZ','TZA','Tanzanie',1,0),(216,'TH','THA','Thaïlande',1,0),(217,'TL','TLS','Timor Oriental',1,0),(218,'TK','TKL','Tokélaou',1,0),(219,'TO','TON','Tonga',1,0),(220,'TT','TTO','Trinité-et-Tobago',1,0),(221,'TR','TUR','Turquie',1,0),(222,'TM','TKM','Turkménistan',1,0),(223,'TC','TCA','Iles Turks-et-Caicos',1,0),(224,'TV','TUV','Tuvalu',1,0),(225,'UG','UGA','Ouganda',1,0),(226,'UA','UKR','Ukraine',1,0),(227,'AE','ARE','United Arab Emirates',1,0),(228,'UM','UMI','Iles mineures éloignées des États-Unis',1,0),(229,'UY','URY','Uruguay',1,0),(230,'UZ','UZB','Ouzbékistan',1,0),(231,'VU','VUT','Vanuatu',1,0),(232,'VE','VEN','Vénézuela',1,0),(233,'VN','VNM','Viêt Nam',1,0),(234,'VG','VGB','Iles Vierges britanniques',1,0),(235,'VI','VIR','Iles Vierges américaines',1,0),(236,'WF','WLF','Wallis-et-Futuna',1,0),(237,'EH','ESH','Sahara occidental',1,0),(238,'YE','YEM','Yémen',1,0),(239,'ZM','ZMB','Zambie',1,0),(240,'ZW','ZWE','Zimbabwe',1,0),(241,'GG','GGY','Guernesey',1,0),(242,'IM','IMN','Ile de Man',1,0),(243,'JE','JEY','Jersey',1,0),(244,'ME','MNE','Monténégro',1,0),(245,'BL','BLM','Saint-Barthélemy',1,0),(246,'MF','MAF','Saint-Martin',1,0),(300,'CW','CUW','Curaçao',1,0),(301,'SX','SXM','Sint Maarten',1,0);
/*!40000 ALTER TABLE `llx_c_country` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_currencies`
--

DROP TABLE IF EXISTS `llx_c_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_currencies` (
  `code_iso` varchar(3) NOT NULL,
  `label` varchar(64) NOT NULL,
  `unicode` varchar(32) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`code_iso`),
  UNIQUE KEY `uk_c_currencies_code_iso` (`code_iso`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_currencies`
--

LOCK TABLES `llx_c_currencies` WRITE;
/*!40000 ALTER TABLE `llx_c_currencies` DISABLE KEYS */;
INSERT INTO `llx_c_currencies` VALUES ('AED','United Arab Emirates Dirham',NULL,1),('AFN','Afghanistan Afghani','[1547]',1),('ALL','Albania Lek','[76,101,107]',1),('ANG','Netherlands Antilles Guilder','[402]',1),('ARP','Pesos argentins',NULL,0),('ARS','Argentino Peso','[36]',1),('ATS','Shiliing autrichiens',NULL,0),('AUD','Australia Dollar','[36]',1),('AWG','Aruba Guilder','[402]',1),('AZN','Azerbaijan New Manat','[1084,1072,1085]',1),('BAM','Bosnia and Herzegovina Convertible Marka','[75,77]',1),('BBD','Barbados Dollar','[36]',1),('BDT','Bangladeshi Taka','[2547]',1),('BEF','Francs belges',NULL,0),('BGN','Bulgaria Lev','[1083,1074]',1),('BHD','Bahrain',NULL,1),('BMD','Bermuda Dollar','[36]',1),('BND','Brunei Darussalam Dollar','[36]',1),('BOB','Bolivia Boliviano','[36,98]',1),('BRL','Brazil Real','[82,36]',1),('BSD','Bahamas Dollar','[36]',1),('BWP','Botswana Pula','[80]',1),('BYR','Belarus Ruble','[112,46]',1),('BZD','Belize Dollar','[66,90,36]',1),('CAD','Canada Dollar','[36]',1),('CHF','Switzerland Franc','[67,72,70]',1),('CLP','Chile Peso','[36]',1),('CNY','China Yuan Renminbi','[165]',1),('COP','Colombia Peso','[36]',1),('CRC','Costa Rica Colon','[8353]',1),('CUP','Cuba Peso','[8369]',1),('CZK','Czech Republic Koruna','[75,269]',1),('DEM','Deutsch mark',NULL,0),('DKK','Denmark Krone','[107,114]',1),('DOP','Dominican Republic Peso','[82,68,36]',1),('DZD','Algeria Dinar',NULL,1),('EEK','Estonia Kroon','[107,114]',1),('EGP','Egypt Pound','[163]',1),('ESP','Pesete',NULL,0),('EUR','Euro Member Countries','[8364]',1),('FIM','Mark finlandais',NULL,0),('FJD','Fiji Dollar','[36]',1),('FKP','Falkland Islands (Malvinas) Pound','[163]',1),('FRF','Francs francais',NULL,0),('GBP','United Kingdom Pound','[163]',1),('GGP','Guernsey Pound','[163]',1),('GHC','Ghana Cedis','[162]',1),('GIP','Gibraltar Pound','[163]',1),('GNF','Franc Guinéen','[70,71]',1),('GRD','Drachme (grece)',NULL,0),('GTQ','Guatemala Quetzal','[81]',1),('GYD','Guyana Dollar','[36]',1),('HKD','Hong Kong Dollar','[36]',1),('HNL','Honduras Lempira','[76]',1),('HRK','Croatia Kuna','[107,110]',1),('HUF','Hungary Forint','[70,116]',1),('IDR','Indonesia Rupiah','[82,112]',1),('IEP','Livres irlandaises',NULL,0),('ILS','Israel Shekel','[8362]',1),('IMP','Isle of Man Pound','[163]',1),('INR','India Rupee',NULL,1),('IRR','Iran Rial','[65020]',1),('ISK','Iceland Krona','[107,114]',1),('ITL','Lires',NULL,0),('JEP','Jersey Pound','[163]',1),('JMD','Jamaica Dollar','[74,36]',1),('JPY','Japan Yen','[165]',1),('KES','Kenya Shilling',NULL,1),('KGS','Kyrgyzstan Som','[1083,1074]',1),('KHR','Cambodia Riel','[6107]',1),('KPW','Korea (North) Won','[8361]',1),('KRW','Korea (South) Won','[8361]',1),('KYD','Cayman Islands Dollar','[36]',1),('KZT','Kazakhstan Tenge','[1083,1074]',1),('LAK','Laos Kip','[8365]',1),('LBP','Lebanon Pound','[163]',1),('LKR','Sri Lanka Rupee','[8360]',1),('LRD','Liberia Dollar','[36]',1),('LTL','Lithuania Litas','[76,116]',1),('LUF','Francs luxembourgeois',NULL,0),('LVL','Latvia Lat','[76,115]',1),('MAD','Morocco Dirham',NULL,1),('MGA','Ariary',NULL,1),('MKD','Macedonia Denar','[1076,1077,1085]',1),('MNT','Mongolia Tughrik','[8366]',1),('MRO','Mauritania Ouguiya',NULL,1),('MUR','Mauritius Rupee','[8360]',1),('MXN','Mexico Peso','[36]',1),('MXP','Pesos Mexicans',NULL,0),('MYR','Malaysia Ringgit','[82,77]',1),('MZN','Mozambique Metical','[77,84]',1),('NAD','Namibia Dollar','[36]',1),('NGN','Nigeria Naira','[8358]',1),('NIO','Nicaragua Cordoba','[67,36]',1),('NLG','Florins',NULL,0),('NOK','Norway Krone','[107,114]',1),('NPR','Nepal Rupee','[8360]',1),('NZD','New Zealand Dollar','[36]',1),('OMR','Oman Rial','[65020]',1),('PAB','Panama Balboa','[66,47,46]',1),('PEN','Peru Nuevo Sol','[83,47,46]',1),('PHP','Philippines Peso','[8369]',1),('PKR','Pakistan Rupee','[8360]',1),('PLN','Poland Zloty','[122,322]',1),('PTE','Escudos',NULL,0),('PYG','Paraguay Guarani','[71,115]',1),('QAR','Qatar Riyal','[65020]',1),('RON','Romania New Leu','[108,101,105]',1),('RSD','Serbia Dinar','[1044,1080,1085,46]',1),('RUB','Russia Ruble','[1088,1091,1073]',1),('SAR','Saudi Arabia Riyal','[65020]',1),('SBD','Solomon Islands Dollar','[36]',1),('SCR','Seychelles Rupee','[8360]',1),('SEK','Sweden Krona','[107,114]',1),('SGD','Singapore Dollar','[36]',1),('SHP','Saint Helena Pound','[163]',1),('SKK','Couronnes slovaques',NULL,0),('SOS','Somalia Shilling','[83]',1),('SRD','Suriname Dollar','[36]',1),('SUR','Rouble',NULL,0),('SVC','El Salvador Colon','[36]',1),('SYP','Syria Pound','[163]',1),('THB','Thailand Baht','[3647]',1),('TND','Tunisia Dinar',NULL,1),('TRL','Turkey Lira','[84,76]',1),('TRY','Turkey Lira','[8356]',1),('TTD','Trinidad and Tobago Dollar','[84,84,36]',1),('TVD','Tuvalu Dollar','[36]',1),('TWD','Taiwan New Dollar','[78,84,36]',1),('UAH','Ukraine Hryvna','[8372]',1),('USD','United States Dollar','[36]',1),('UYU','Uruguay Peso','[36,85]',1),('UZS','Uzbekistan Som','[1083,1074]',1),('VEF','Venezuela Bolivar Fuerte','[66,115]',1),('VND','Viet Nam Dong','[8363]',1),('XAF','Communaute Financiere Africaine (BEAC) CFA Franc',NULL,1),('XCD','East Caribbean Dollar','[36]',1),('XEU','Ecus',NULL,0),('XOF','Communaute Financiere Africaine (BCEAO) Franc',NULL,1),('XPF','Franc CFP','[70]',1),('YER','Yemen Rial','[65020]',1),('ZAR','South Africa Rand','[82]',1),('ZWD','Zimbabwe Dollar','[90,36]',1);
/*!40000 ALTER TABLE `llx_c_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_departements`
--

DROP TABLE IF EXISTS `llx_c_departements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_departements` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code_departement` varchar(6) NOT NULL,
  `fk_region` int(11) DEFAULT NULL,
  `cheflieu` varchar(50) DEFAULT NULL,
  `tncc` int(11) DEFAULT NULL,
  `ncc` varchar(50) DEFAULT NULL,
  `nom` varchar(50) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_departements` (`code_departement`,`fk_region`),
  KEY `idx_departements_fk_region` (`fk_region`),
  CONSTRAINT `fk_departements_fk_region` FOREIGN KEY (`fk_region`) REFERENCES `llx_c_regions` (`code_region`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_departements`
--

LOCK TABLES `llx_c_departements` WRITE;
/*!40000 ALTER TABLE `llx_c_departements` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_departements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_ecotaxe`
--

DROP TABLE IF EXISTS `llx_c_ecotaxe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_ecotaxe` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `libelle` varchar(255) DEFAULT NULL,
  `price` double(24,8) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `fk_pays` int(11) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_ecotaxe` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_ecotaxe`
--

LOCK TABLES `llx_c_ecotaxe` WRITE;
/*!40000 ALTER TABLE `llx_c_ecotaxe` DISABLE KEYS */;
INSERT INTO `llx_c_ecotaxe` VALUES (1,'ER-A-A','Materiels electriques < 0,2kg',0.01000000,'ERP',1,1),(2,'ER-A-B','Materiels electriques >= 0,2 kg et < 0,5 kg',0.03000000,'ERP',1,1),(3,'ER-A-C','Materiels electriques >= 0,5 kg et < 1 kg',0.04000000,'ERP',1,1),(4,'ER-A-D','Materiels electriques >= 1 kg et < 2 kg',0.13000000,'ERP',1,1),(5,'ER-A-E','Materiels electriques >= 2 kg et < 4kg',0.21000000,'ERP',1,1),(6,'ER-A-F','Materiels electriques >= 4 kg et < 8 kg',0.42000000,'ERP',1,1),(7,'ER-A-G','Materiels electriques >= 8 kg et < 15 kg',0.84000000,'ERP',1,1),(8,'ER-A-H','Materiels electriques >= 15 kg et < 20 kg',1.25000000,'ERP',1,1),(9,'ER-A-I','Materiels electriques >= 20 kg et < 30 kg',1.88000000,'ERP',1,1),(10,'ER-A-J','Materiels electriques >= 30 kg',3.34000000,'ERP',1,1),(11,'ER-M-1','TV, Moniteurs < 9kg',0.84000000,'ERP',1,1),(12,'ER-M-2','TV, Moniteurs >= 9kg et < 15kg',1.67000000,'ERP',1,1),(13,'ER-M-3','TV, Moniteurs >= 15kg et < 30kg',3.34000000,'ERP',1,1),(14,'ER-M-4','TV, Moniteurs >= 30 kg',6.69000000,'ERP',1,1),(15,'EC-A-A','Materiels electriques  0,2 kg max',0.00840000,'Ecologic',1,1),(16,'EC-A-B','Materiels electriques 0,21 kg min - 0,50 kg max',0.02500000,'Ecologic',1,1),(17,'EC-A-C','Materiels electriques  0,51 kg min - 1 kg max',0.04000000,'Ecologic',1,1),(18,'EC-A-D','Materiels electriques  1,01 kg min - 2,5 kg max',0.13000000,'Ecologic',1,1),(19,'EC-A-E','Materiels electriques  2,51 kg min - 4 kg max',0.21000000,'Ecologic',1,1),(20,'EC-A-F','Materiels electriques 4,01 kg min - 8 kg max',0.42000000,'Ecologic',1,1),(21,'EC-A-G','Materiels electriques  8,01 kg min - 12 kg max',0.63000000,'Ecologic',1,1),(22,'EC-A-H','Materiels electriques 12,01 kg min - 20 kg max',1.05000000,'Ecologic',1,1),(23,'EC-A-I','Materiels electriques  20,01 kg min',1.88000000,'Ecologic',1,1),(24,'EC-M-1','TV, Moniteurs 9 kg max',0.84000000,'Ecologic',1,1),(25,'EC-M-2','TV, Moniteurs 9,01 kg min - 18 kg max',1.67000000,'Ecologic',1,1),(26,'EC-M-3','TV, Moniteurs 18,01 kg min - 36 kg max',3.34000000,'Ecologic',1,1),(27,'EC-M-4','TV, Moniteurs 36,01 kg min',6.69000000,'Ecologic',1,1),(28,'ES-M-1','TV, Moniteurs <= 20 pouces',0.84000000,'Eco-systemes',1,1),(29,'ES-M-2','TV, Moniteurs > 20 pouces et <= 32 pouces',3.34000000,'Eco-systemes',1,1),(30,'ES-M-3','TV, Moniteurs > 32 pouces et autres grands ecrans',6.69000000,'Eco-systemes',1,1),(31,'ES-A-A','Ordinateur fixe, Audio home systems (HIFI), elements hifi separes',0.84000000,'Eco-systemes',1,1),(32,'ES-A-B','Ordinateur portable, CD-RCR, VCR, lecteurs et enregistreurs DVD, instruments de musique et caisses de resonance, haut parleurs...',0.25000000,'Eco-systemes',1,1),(33,'ES-A-C','Imprimante, photocopieur, telecopieur',0.42000000,'Eco-systemes',1,1),(34,'ES-A-D','Accessoires, clavier, souris, PDA, imprimante photo, appareil photo, gps, telephone, repondeur, telephone sans fil, modem, telecommande, casque, camescope, baladeur mp3, radio portable, radio K7 et CD portable, radio reveil',0.08400000,'Eco-systemes',1,1),(35,'ES-A-E','GSM',0.00840000,'Eco-systemes',1,1),(36,'ES-A-F','Jouets et equipements de loisirs et de sports < 0,5 kg',0.04200000,'Eco-systemes',1,1),(37,'ES-A-G','Jouets et equipements de loisirs et de sports > 0,5 kg',0.17000000,'Eco-systemes',1,1),(38,'ES-A-H','Jouets et equipements de loisirs et de sports > 10 kg',1.25000000,'Eco-systemes',1,1);
/*!40000 ALTER TABLE `llx_c_ecotaxe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_effectif`
--

DROP TABLE IF EXISTS `llx_c_effectif`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_effectif` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(30) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_effectif` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_effectif`
--

LOCK TABLES `llx_c_effectif` WRITE;
/*!40000 ALTER TABLE `llx_c_effectif` DISABLE KEYS */;
INSERT INTO `llx_c_effectif` VALUES (0,'EF0','-',1,NULL),(1,'EF1-5','1 - 5',1,NULL),(2,'EF6-10','6 - 10',1,NULL),(3,'EF11-50','11 - 50',1,NULL),(4,'EF51-100','51 - 100',1,NULL),(5,'EF100-500','100 - 500',1,NULL),(6,'EF500-','> 500',1,NULL);
/*!40000 ALTER TABLE `llx_c_effectif` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_email_senderprofile`
--

DROP TABLE IF EXISTS `llx_c_email_senderprofile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_email_senderprofile` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `private` smallint(6) NOT NULL DEFAULT '0',
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `label` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `signature` text,
  `position` smallint(6) DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_email_senderprofile` (`entity`,`label`,`email`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_email_senderprofile`
--

LOCK TABLES `llx_c_email_senderprofile` WRITE;
/*!40000 ALTER TABLE `llx_c_email_senderprofile` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_email_senderprofile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_email_templates`
--

DROP TABLE IF EXISTS `llx_c_email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_email_templates` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `type_template` varchar(32) DEFAULT NULL,
  `lang` varchar(6) DEFAULT '',
  `private` smallint(6) NOT NULL DEFAULT '0',
  `fk_user` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `label` varchar(180) DEFAULT NULL,
  `position` smallint(6) DEFAULT NULL,
  `enabled` varchar(255) DEFAULT '1',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `topic` text,
  `joinfiles` text,
  `content` mediumtext,
  `content_lines` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_email_templates` (`entity`,`label`,`lang`),
  KEY `idx_type` (`type_template`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_email_templates`
--

LOCK TABLES `llx_c_email_templates` WRITE;
/*!40000 ALTER TABLE `llx_c_email_templates` DISABLE KEYS */;
INSERT INTO `llx_c_email_templates` VALUES (1,0,'adherent','member','',0,NULL,NULL,'2018-05-18 18:27:24','(SendAnEMailToMember)',1,'1',1,'__(CardContent)__',NULL,'__(Hello)__,<br><br>\n\n__(ThisIsContentOfYourCard)__<br>\n__(ID)__ : __ID__<br>\n__(Civiliyty)__ : __MEMBER_CIVILITY__<br>\n__(Firstname)__ : __MEMBER_FIRSTNAME__<br>\n__(Lastname)__ : __MEMBER_LASTNAME__<br>\n__(Fullname)__ : __MEMBER_FULLNAME__<br>\n__(Company)__ : __MEMBER_COMPANY__<br>\n__(Address)__ : __MEMBER_ADDRESS__<br>\n__(Zip)__ : __MEMBER_ZIP__<br>\n__(Town)__ : __MEMBER_TOWN__<br>\n__(Country)__ : __MEMBER_COUNTRY__<br>\n__(Email)__ : __MEMBER_EMAIL__<br>\n__(Birthday)__ : __MEMBER_BIRTH__<br>\n__(Photo)__ : __MEMBER_PHOTO__<br>\n__(Login)__ : __MEMBER_LOGIN__<br>\n__(Password)__ : __MEMBER_PASSWORD__<br>\n__(Phone)__ : __MEMBER_PHONE__<br>\n__(PhonePerso)__ : __MEMBER_PHONEPRO__<br>\n__(PhoneMobile)__ : __MEMBER_PHONEMOBILE__<br><br>\n__(Sincerely)__<br>__USER_SIGNATURE__',NULL),(2,0,'banque','thirdparty','',0,NULL,NULL,'2018-05-18 18:27:24','(YourSEPAMandate)',1,'1',0,'__(YourSEPAMandate)__',NULL,'__(Hello)__,<br><br>\n\n__(FindYourSEPAMandate)__ :<br>\n__MYCOMPANY_NAME__<br>\n__MYCOMPANY_FULLADDRESS__<br><br>\n__(Sincerely)__<br>\n__USER_SIGNATURE__',NULL);
/*!40000 ALTER TABLE `llx_c_email_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_exp_tax_cat`
--

DROP TABLE IF EXISTS `llx_c_exp_tax_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_exp_tax_cat` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(48) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `active` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_exp_tax_cat`
--

LOCK TABLES `llx_c_exp_tax_cat` WRITE;
/*!40000 ALTER TABLE `llx_c_exp_tax_cat` DISABLE KEYS */;
INSERT INTO `llx_c_exp_tax_cat` VALUES (1,'ExpAutoCat',1,0),(2,'ExpCycloCat',1,0),(3,'ExpMotoCat',1,0),(4,'ExpAuto3CV',1,1),(5,'ExpAuto4CV',1,1),(6,'ExpAuto5CV',1,1),(7,'ExpAuto6CV',1,1),(8,'ExpAuto7CV',1,1),(9,'ExpAuto8CV',1,1),(10,'ExpAuto9CV',1,0),(11,'ExpAuto10CV',1,0),(12,'ExpAuto11CV',1,0),(13,'ExpAuto12CV',1,0),(14,'ExpAuto3PCV',1,0),(15,'ExpAuto4PCV',1,0),(16,'ExpAuto5PCV',1,0),(17,'ExpAuto6PCV',1,0),(18,'ExpAuto7PCV',1,0),(19,'ExpAuto8PCV',1,0),(20,'ExpAuto9PCV',1,0),(21,'ExpAuto10PCV',1,0),(22,'ExpAuto11PCV',1,0),(23,'ExpAuto12PCV',1,0),(24,'ExpAuto13PCV',1,0),(25,'ExpCyclo',1,0),(26,'ExpMoto12CV',1,0),(27,'ExpMoto345CV',1,0),(28,'ExpMoto5PCV',1,0);
/*!40000 ALTER TABLE `llx_c_exp_tax_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_exp_tax_range`
--

DROP TABLE IF EXISTS `llx_c_exp_tax_range`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_exp_tax_range` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_c_exp_tax_cat` int(11) NOT NULL DEFAULT '1',
  `range_ik` double NOT NULL DEFAULT '0',
  `entity` int(11) NOT NULL DEFAULT '1',
  `active` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_exp_tax_range`
--

LOCK TABLES `llx_c_exp_tax_range` WRITE;
/*!40000 ALTER TABLE `llx_c_exp_tax_range` DISABLE KEYS */;
INSERT INTO `llx_c_exp_tax_range` VALUES (1,4,0,1,1),(2,4,5000,1,1),(3,4,20000,1,1),(4,5,0,1,1),(5,5,5000,1,1),(6,5,20000,1,1),(7,6,0,1,1),(8,6,5000,1,1),(9,6,20000,1,1),(10,7,0,1,1),(11,7,5000,1,1),(12,7,20000,1,1),(13,8,0,1,1),(14,8,5000,1,1),(15,8,20000,1,1);
/*!40000 ALTER TABLE `llx_c_exp_tax_range` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_field_list`
--

DROP TABLE IF EXISTS `llx_c_field_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_field_list` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `element` varchar(64) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `name` varchar(32) NOT NULL,
  `alias` varchar(32) NOT NULL,
  `title` varchar(32) NOT NULL,
  `align` varchar(6) DEFAULT 'left',
  `sort` tinyint(4) NOT NULL DEFAULT '1',
  `search` tinyint(4) NOT NULL DEFAULT '0',
  `enabled` varchar(255) DEFAULT '1',
  `rang` int(11) DEFAULT '0',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_field_list`
--

LOCK TABLES `llx_c_field_list` WRITE;
/*!40000 ALTER TABLE `llx_c_field_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_field_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_format_cards`
--

DROP TABLE IF EXISTS `llx_c_format_cards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_format_cards` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `paper_size` varchar(20) NOT NULL,
  `orientation` varchar(1) NOT NULL,
  `metric` varchar(5) NOT NULL,
  `leftmargin` double(24,8) NOT NULL,
  `topmargin` double(24,8) NOT NULL,
  `nx` int(11) NOT NULL,
  `ny` int(11) NOT NULL,
  `spacex` double(24,8) NOT NULL,
  `spacey` double(24,8) NOT NULL,
  `width` double(24,8) NOT NULL,
  `height` double(24,8) NOT NULL,
  `font_size` int(11) NOT NULL,
  `custom_x` double(24,8) NOT NULL,
  `custom_y` double(24,8) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_format_cards`
--

LOCK TABLES `llx_c_format_cards` WRITE;
/*!40000 ALTER TABLE `llx_c_format_cards` DISABLE KEYS */;
INSERT INTO `llx_c_format_cards` VALUES (1,'5160','Avery-5160, WL-875WX','letter','P','mm',5.58165000,12.70000000,3,10,3.55600000,0.00000000,65.87490000,25.40000000,7,0.00000000,0.00000000,1),(2,'5161','Avery-5161, WL-75WX','letter','P','mm',4.44500000,12.70000000,2,10,3.96800000,0.00000000,101.60000000,25.40000000,7,0.00000000,0.00000000,1),(3,'5162','Avery-5162, WL-100WX','letter','P','mm',3.87350000,22.35200000,2,7,4.95400000,0.00000000,101.60000000,33.78100000,8,0.00000000,0.00000000,1),(4,'5163','Avery-5163, WL-125WX','letter','P','mm',4.57200000,12.70000000,2,5,3.55600000,0.00000000,101.60000000,50.80000000,10,0.00000000,0.00000000,1),(5,'5164','5164 (Letter)','letter','P','in',0.14800000,0.50000000,2,3,0.20310000,0.00000000,4.00000000,3.33000000,12,0.00000000,0.00000000,0),(6,'8600','Avery-8600','letter','P','mm',7.10000000,19.00000000,3,10,9.50000000,3.10000000,66.60000000,25.40000000,7,0.00000000,0.00000000,1),(7,'99012','DYMO 99012 89*36mm','custom','L','mm',1.00000000,1.00000000,1,1,0.00000000,0.00000000,36.00000000,89.00000000,10,36.00000000,89.00000000,1),(8,'99014','DYMO 99014 101*54mm','custom','L','mm',1.00000000,1.00000000,1,1,0.00000000,0.00000000,54.00000000,101.00000000,10,54.00000000,101.00000000,1),(9,'AVERYC32010','Avery-C32010','A4','P','mm',15.00000000,13.00000000,2,5,10.00000000,0.00000000,85.00000000,54.00000000,10,0.00000000,0.00000000,1),(10,'CARD','Dolibarr Business cards','A4','P','mm',15.00000000,15.00000000,2,5,0.00000000,0.00000000,85.00000000,54.00000000,10,0.00000000,0.00000000,1),(11,'L7163','Avery-L7163','A4','P','mm',5.00000000,15.00000000,2,7,2.50000000,0.00000000,99.10000000,38.10000000,8,0.00000000,0.00000000,1);
/*!40000 ALTER TABLE `llx_c_format_cards` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_forme_juridique`
--

DROP TABLE IF EXISTS `llx_c_forme_juridique`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_forme_juridique` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` int(11) NOT NULL,
  `fk_pays` int(11) NOT NULL,
  `libelle` varchar(255) DEFAULT NULL,
  `isvatexempted` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_forme_juridique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_forme_juridique`
--

LOCK TABLES `llx_c_forme_juridique` WRITE;
/*!40000 ALTER TABLE `llx_c_forme_juridique` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_forme_juridique` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_holiday_types`
--

DROP TABLE IF EXISTS `llx_c_holiday_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_holiday_types` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `label` varchar(255) NOT NULL,
  `affect` int(11) NOT NULL,
  `delay` int(11) NOT NULL,
  `newByMonth` double(8,5) NOT NULL DEFAULT '0.00000',
  `fk_country` int(11) DEFAULT NULL,
  `active` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_holiday_types` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_holiday_types`
--

LOCK TABLES `llx_c_holiday_types` WRITE;
/*!40000 ALTER TABLE `llx_c_holiday_types` DISABLE KEYS */;
INSERT INTO `llx_c_holiday_types` VALUES (1,'LEAVE_SICK','Sick leave',0,0,0.00000,NULL,1),(2,'LEAVE_OTHER','Other leave',0,0,0.00000,NULL,1),(3,'LEAVE_PAID','Paid vacation',1,7,0.00000,NULL,0),(4,'LEAVE_RTT_FR','RTT',1,7,0.83000,1,1),(5,'LEAVE_PAID_FR','Paid vacation',1,30,2.08334,1,1);
/*!40000 ALTER TABLE `llx_c_holiday_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_hrm_department`
--

DROP TABLE IF EXISTS `llx_c_hrm_department`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_hrm_department` (
  `rowid` int(11) NOT NULL,
  `pos` tinyint(4) NOT NULL DEFAULT '0',
  `code` varchar(16) NOT NULL,
  `label` varchar(50) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_hrm_department`
--

LOCK TABLES `llx_c_hrm_department` WRITE;
/*!40000 ALTER TABLE `llx_c_hrm_department` DISABLE KEYS */;
INSERT INTO `llx_c_hrm_department` VALUES (1,5,'MANAGEMENT','Management',1),(3,15,'TRAINING','Training',1),(4,20,'IT','Inform. Technology (IT)',0),(5,25,'MARKETING','Marketing',0),(6,30,'SALES','Sales',1),(7,35,'LEGAL','Legal',0),(8,40,'FINANCIAL','Financial accounting',1),(9,45,'HUMANRES','Human resources',1),(10,50,'PURCHASING','Purchasing',1),(12,60,'CUSTOMSERV','Customer service',0),(14,70,'LOGISTIC','Logistics',1),(15,75,'CONSTRUCT','Engineering/design',0),(16,80,'PRODUCTION','Production',1),(17,85,'QUALITY','Quality assurance',0);
/*!40000 ALTER TABLE `llx_c_hrm_department` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_hrm_function`
--

DROP TABLE IF EXISTS `llx_c_hrm_function`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_hrm_function` (
  `rowid` int(11) NOT NULL,
  `pos` tinyint(4) NOT NULL DEFAULT '0',
  `code` varchar(16) NOT NULL,
  `label` varchar(50) DEFAULT NULL,
  `c_level` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_hrm_function`
--

LOCK TABLES `llx_c_hrm_function` WRITE;
/*!40000 ALTER TABLE `llx_c_hrm_function` DISABLE KEYS */;
INSERT INTO `llx_c_hrm_function` VALUES (1,5,'EXECBOARD','Executive board',0,1),(2,10,'MANAGDIR','Managing director',1,1),(3,15,'ACCOUNTMANAG','Account manager',0,1),(4,20,'ENGAGDIR','Engagement director',1,1),(5,25,'DIRECTOR','Director',1,1),(6,30,'PROJMANAG','Project manager',0,1),(7,35,'DEPHEAD','Department head',0,1),(8,40,'SECRETAR','Secretary',0,1),(9,45,'EMPLOYEE','Department employee',0,1);
/*!40000 ALTER TABLE `llx_c_hrm_function` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_incoterms`
--

DROP TABLE IF EXISTS `llx_c_incoterms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_incoterms` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(3) NOT NULL,
  `libelle` varchar(255) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_incoterms` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_incoterms`
--

LOCK TABLES `llx_c_incoterms` WRITE;
/*!40000 ALTER TABLE `llx_c_incoterms` DISABLE KEYS */;
INSERT INTO `llx_c_incoterms` VALUES (1,'EXW','Ex Works, au départ non chargé, non dédouané sortie d\'usine (uniquement adapté aux flux domestiques, nationaux)',1),(2,'FCA','Free Carrier, marchandises dédouanées et chargées dans le pays de départ, chez le vendeur ou chez le commissionnaire de transport de l\'acheteur',1),(3,'FAS','Free Alongside Ship, sur le quai du port de départ',1),(4,'FOB','Free On Board, chargé sur le bateau, les frais de chargement dans celui-ci étant fonction du liner term indiqué par la compagnie maritime (à la charge du vendeur)',1),(5,'CFR','Cost and Freight, chargé dans le bateau, livraison au port de départ, frais payés jusqu\'au port d\'arrivée, sans assurance pour le transport, non déchargé du navire à destination (les frais de déchargement sont inclus ou non au port d\'arrivée)',1),(6,'CIF','Cost, Insurance and Freight, chargé sur le bateau, frais jusqu\'au port d\'arrivée, avec l\'assurance marchandise transportée souscrite par le vendeur pour le compte de l\'acheteur',1),(7,'CPT','Carriage Paid To, livraison au premier transporteur, frais jusqu\'au déchargement du mode de transport, sans assurance pour le transport',1),(8,'CIP','Carriage and Insurance Paid to, idem CPT, avec assurance marchandise transportée souscrite par le vendeur pour le compte de l\'acheteur',1),(9,'DAT','Delivered At Terminal, marchandises (déchargées) livrées sur quai, dans un terminal maritime, fluvial, aérien, routier ou ferroviaire désigné (dédouanement import, et post-acheminement payés par l\'acheteur)',1),(10,'DAP','Delivered At Place, marchandises (non déchargées) mises à disposition de l\'acheteur dans le pays d\'importation au lieu précisé dans le contrat (déchargement, dédouanement import payé par l\'acheteur)',1),(11,'DDP','Delivered Duty Paid, marchandises (non déchargées) livrées à destination finale, dédouanement import et taxes à la charge du vendeur ; l\'acheteur prend en charge uniquement le déchargement (si exclusion des taxes type TVA, le préciser clairement)',1);
/*!40000 ALTER TABLE `llx_c_incoterms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_input_method`
--

DROP TABLE IF EXISTS `llx_c_input_method`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_input_method` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `libelle` varchar(60) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_input_method` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_input_method`
--

LOCK TABLES `llx_c_input_method` WRITE;
/*!40000 ALTER TABLE `llx_c_input_method` DISABLE KEYS */;
INSERT INTO `llx_c_input_method` VALUES (1,'OrderByMail','Courrier',1,NULL),(2,'OrderByFax','Fax',1,NULL),(3,'OrderByEMail','EMail',1,NULL),(4,'OrderByPhone','Téléphone',1,NULL),(5,'OrderByWWW','En ligne',1,NULL);
/*!40000 ALTER TABLE `llx_c_input_method` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_input_reason`
--

DROP TABLE IF EXISTS `llx_c_input_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_input_reason` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `label` varchar(60) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_input_reason` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_input_reason`
--

LOCK TABLES `llx_c_input_reason` WRITE;
/*!40000 ALTER TABLE `llx_c_input_reason` DISABLE KEYS */;
INSERT INTO `llx_c_input_reason` VALUES (1,'SRC_INTE','Web site',1,NULL),(2,'SRC_CAMP_MAIL','Mailing campaign',1,NULL),(3,'SRC_CAMP_PHO','Phone campaign',1,NULL),(4,'SRC_CAMP_FAX','Fax campaign',1,NULL),(5,'SRC_COMM','Commercial contact',1,NULL),(6,'SRC_SHOP','Shop contact',1,NULL),(7,'SRC_CAMP_EMAIL','EMailing campaign',1,NULL),(8,'SRC_WOM','Word of mouth',1,NULL),(9,'SRC_PARTNER','Partner',1,NULL),(10,'SRC_EMPLOYEE','Employee',1,NULL),(11,'SRC_SPONSORING','Sponsorship',1,NULL);
/*!40000 ALTER TABLE `llx_c_input_reason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_lead_status`
--

DROP TABLE IF EXISTS `llx_c_lead_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_lead_status` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) DEFAULT NULL,
  `label` varchar(50) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `percent` double(5,2) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_lead_status_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_lead_status`
--

LOCK TABLES `llx_c_lead_status` WRITE;
/*!40000 ALTER TABLE `llx_c_lead_status` DISABLE KEYS */;
INSERT INTO `llx_c_lead_status` VALUES (1,'PROSP','Prospection',10,0.00,1),(2,'QUAL','Qualification',20,20.00,1),(3,'PROPO','Proposal',30,40.00,1),(4,'NEGO','Negotiation',40,60.00,1),(5,'PENDING','Pending',50,50.00,0),(6,'WON','Won',60,100.00,1),(7,'LOST','Lost',70,0.00,1);
/*!40000 ALTER TABLE `llx_c_lead_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_paiement`
--

DROP TABLE IF EXISTS `llx_c_paiement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_paiement` (
  `id` int(11) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `code` varchar(6) NOT NULL,
  `libelle` varchar(62) DEFAULT NULL,
  `type` smallint(6) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `accountancy_code` varchar(32) DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `uk_c_paiement` (`id`,`entity`,`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_paiement`
--

LOCK TABLES `llx_c_paiement` WRITE;
/*!40000 ALTER TABLE `llx_c_paiement` DISABLE KEYS */;
INSERT INTO `llx_c_paiement` VALUES (0,1,'','-',3,1,NULL,NULL,0),(1,1,'TIP','TIP',2,0,NULL,NULL,0),(2,1,'VIR','Virement',2,1,NULL,NULL,0),(3,1,'PRE','Prélèvement',2,1,NULL,NULL,0),(4,1,'LIQ','Espèces',2,1,NULL,NULL,0),(6,1,'CB','Carte Bancaire',2,1,NULL,NULL,0),(7,1,'CHQ','Chèque',2,1,NULL,NULL,0),(50,1,'VAD','Paiement en ligne',2,0,NULL,NULL,0),(51,1,'TRA','Traite',2,0,NULL,NULL,0),(52,1,'LCR','LCR',2,0,NULL,NULL,0),(53,1,'FAC','Factor',2,0,NULL,NULL,0);
/*!40000 ALTER TABLE `llx_c_paiement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_paper_format`
--

DROP TABLE IF EXISTS `llx_c_paper_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_paper_format` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `label` varchar(50) NOT NULL,
  `width` float(6,2) DEFAULT '0.00',
  `height` float(6,2) DEFAULT '0.00',
  `unit` varchar(5) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_paper_format`
--

LOCK TABLES `llx_c_paper_format` WRITE;
/*!40000 ALTER TABLE `llx_c_paper_format` DISABLE KEYS */;
INSERT INTO `llx_c_paper_format` VALUES (1,'EU4A0','Format 4A0',1682.00,2378.00,'mm',1,NULL),(2,'EU2A0','Format 2A0',1189.00,1682.00,'mm',1,NULL),(3,'EUA0','Format A0',840.00,1189.00,'mm',1,NULL),(4,'EUA1','Format A1',594.00,840.00,'mm',1,NULL),(5,'EUA2','Format A2',420.00,594.00,'mm',1,NULL),(6,'EUA3','Format A3',297.00,420.00,'mm',1,NULL),(7,'EUA4','Format A4',210.00,297.00,'mm',1,NULL),(8,'EUA5','Format A5',148.00,210.00,'mm',1,NULL),(9,'EUA6','Format A6',105.00,148.00,'mm',1,NULL),(100,'USLetter','Format Letter (A)',216.00,279.00,'mm',1,NULL),(105,'USLegal','Format Legal',216.00,356.00,'mm',1,NULL),(110,'USExecutive','Format Executive',190.00,254.00,'mm',1,NULL),(115,'USLedger','Format Ledger/Tabloid (B)',279.00,432.00,'mm',1,NULL),(200,'CAP1','Format Canadian P1',560.00,860.00,'mm',1,NULL),(205,'CAP2','Format Canadian P2',430.00,560.00,'mm',1,NULL),(210,'CAP3','Format Canadian P3',280.00,430.00,'mm',1,NULL),(215,'CAP4','Format Canadian P4',215.00,280.00,'mm',1,NULL),(220,'CAP5','Format Canadian P5',140.00,215.00,'mm',1,NULL),(225,'CAP6','Format Canadian P6',107.00,140.00,'mm',1,NULL);
/*!40000 ALTER TABLE `llx_c_paper_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_payment_term`
--

DROP TABLE IF EXISTS `llx_c_payment_term`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_payment_term` (
  `rowid` int(11) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `code` varchar(16) DEFAULT NULL,
  `sortorder` smallint(6) DEFAULT NULL,
  `active` tinyint(4) DEFAULT '1',
  `libelle` varchar(255) DEFAULT NULL,
  `libelle_facture` text,
  `type_cdr` tinyint(4) DEFAULT NULL,
  `nbjour` smallint(6) DEFAULT NULL,
  `decalage` smallint(6) DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `uk_c_payment_term` (`rowid`,`entity`,`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_payment_term`
--

LOCK TABLES `llx_c_payment_term` WRITE;
/*!40000 ALTER TABLE `llx_c_payment_term` DISABLE KEYS */;
INSERT INTO `llx_c_payment_term` VALUES (1,1,'RECEP',1,1,'Due upon receipt','Due upon receipt',0,1,NULL,NULL,0),(2,1,'30D',2,1,'30 days','Due in 30 days',0,30,NULL,NULL,0),(3,1,'30DENDMONTH',3,1,'30 days end of month','Due in 30 days, end of month',1,30,NULL,NULL,0),(4,1,'60D',4,1,'60 days','Due in 60 days, end of month',0,60,NULL,NULL,0),(5,1,'60DENDMONTH',5,1,'60 days end of month','Due in 60 days, end of month',1,60,NULL,NULL,0),(6,1,'PT_ORDER',6,1,'Due on order','Due on order',0,1,NULL,NULL,0),(7,1,'PT_DELIVERY',7,1,'Due on delivery','Due on delivery',0,1,NULL,NULL,0),(8,1,'PT_5050',8,1,'50 and 50','50% on order, 50% on delivery',0,1,NULL,NULL,0),(9,1,'10D',9,1,'10 days','Due in 10 days',0,10,NULL,NULL,0),(10,1,'10DENDMONTH',10,1,'10 days end of month','Due in 10 days, end of month',1,10,NULL,NULL,0),(11,1,'14D',11,1,'14 days','Due in 14 days',0,14,NULL,NULL,0),(12,1,'14DENDMONTH',12,1,'14 days end of month','Due in 14 days, end of month',1,14,NULL,NULL,0);
/*!40000 ALTER TABLE `llx_c_payment_term` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_price_expression`
--

DROP TABLE IF EXISTS `llx_c_price_expression`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_price_expression` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL,
  `expression` varchar(80) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_price_expression`
--

LOCK TABLES `llx_c_price_expression` WRITE;
/*!40000 ALTER TABLE `llx_c_price_expression` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_price_expression` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_price_global_variable`
--

DROP TABLE IF EXISTS `llx_c_price_global_variable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_price_global_variable` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `description` text,
  `value` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_price_global_variable`
--

LOCK TABLES `llx_c_price_global_variable` WRITE;
/*!40000 ALTER TABLE `llx_c_price_global_variable` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_price_global_variable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_price_global_variable_updater`
--

DROP TABLE IF EXISTS `llx_c_price_global_variable_updater`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_price_global_variable_updater` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `description` text,
  `parameters` text,
  `fk_variable` int(11) NOT NULL,
  `update_interval` int(11) DEFAULT '0',
  `next_update` int(11) DEFAULT '0',
  `last_status` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_price_global_variable_updater`
--

LOCK TABLES `llx_c_price_global_variable_updater` WRITE;
/*!40000 ALTER TABLE `llx_c_price_global_variable_updater` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_price_global_variable_updater` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_propalst`
--

DROP TABLE IF EXISTS `llx_c_propalst`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_propalst` (
  `id` smallint(6) NOT NULL,
  `code` varchar(12) NOT NULL,
  `label` varchar(30) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_propalst` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_propalst`
--

LOCK TABLES `llx_c_propalst` WRITE;
/*!40000 ALTER TABLE `llx_c_propalst` DISABLE KEYS */;
INSERT INTO `llx_c_propalst` VALUES (0,'PR_DRAFT','Brouillon',1),(1,'PR_OPEN','Ouverte',1),(2,'PR_SIGNED','Signée',1),(3,'PR_NOTSIGNED','Non Signée',1),(4,'PR_FAC','Facturée',1);
/*!40000 ALTER TABLE `llx_c_propalst` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_prospectlevel`
--

DROP TABLE IF EXISTS `llx_c_prospectlevel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_prospectlevel` (
  `code` varchar(12) NOT NULL,
  `label` varchar(30) DEFAULT NULL,
  `sortorder` smallint(6) DEFAULT NULL,
  `active` smallint(6) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_prospectlevel`
--

LOCK TABLES `llx_c_prospectlevel` WRITE;
/*!40000 ALTER TABLE `llx_c_prospectlevel` DISABLE KEYS */;
INSERT INTO `llx_c_prospectlevel` VALUES ('PL_HIGH','High',4,1,NULL),('PL_LOW','Low',2,1,NULL),('PL_MEDIUM','Medium',3,1,NULL),('PL_NONE','None',1,1,NULL);
/*!40000 ALTER TABLE `llx_c_prospectlevel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_regions`
--

DROP TABLE IF EXISTS `llx_c_regions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_regions` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code_region` int(11) NOT NULL,
  `fk_pays` int(11) NOT NULL,
  `cheflieu` varchar(50) DEFAULT NULL,
  `tncc` int(11) DEFAULT NULL,
  `nom` varchar(100) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_code_region` (`code_region`),
  KEY `idx_c_regions_fk_pays` (`fk_pays`),
  CONSTRAINT `fk_c_regions_fk_pays` FOREIGN KEY (`fk_pays`) REFERENCES `llx_c_country` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_regions`
--

LOCK TABLES `llx_c_regions` WRITE;
/*!40000 ALTER TABLE `llx_c_regions` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_regions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_revenuestamp`
--

DROP TABLE IF EXISTS `llx_c_revenuestamp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_revenuestamp` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_pays` int(11) NOT NULL,
  `taux` double NOT NULL,
  `revenuestamp_type` varchar(16) NOT NULL DEFAULT 'fixed',
  `note` varchar(128) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=1543 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_revenuestamp`
--

LOCK TABLES `llx_c_revenuestamp` WRITE;
/*!40000 ALTER TABLE `llx_c_revenuestamp` DISABLE KEYS */;
INSERT INTO `llx_c_revenuestamp` VALUES (101,10,0.4,'fixed','Revenue stamp tunisia',1,NULL,NULL),(1541,154,1.5,'percent','Revenue stamp mexico',1,NULL,NULL),(1542,154,3,'percent','Revenue stamp mexico',1,NULL,NULL);
/*!40000 ALTER TABLE `llx_c_revenuestamp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_shipment_mode`
--

DROP TABLE IF EXISTS `llx_c_shipment_mode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_shipment_mode` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `code` varchar(30) NOT NULL,
  `libelle` varchar(50) NOT NULL,
  `description` text,
  `tracking` varchar(255) NOT NULL,
  `active` tinyint(4) DEFAULT '0',
  `module` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_shipment_mode` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_shipment_mode`
--

LOCK TABLES `llx_c_shipment_mode` WRITE;
/*!40000 ALTER TABLE `llx_c_shipment_mode` DISABLE KEYS */;
INSERT INTO `llx_c_shipment_mode` VALUES (1,'2018-05-18 18:27:24','CATCH','At-Store Reclamation','At-Store Reclamation by the customer','',1,NULL),(2,'2018-05-18 18:27:24','TRANS','Generic transporter','Generic transporter','',1,NULL),(3,'2018-05-18 18:27:24','COLSUI','Colissimo Suivi','Colissimo Suivi','http://www.colissimo.fr/portail_colissimo/suivre.do?colispart={TRACKID}',0,NULL),(4,'2018-05-18 18:27:24','LETTREMAX','Lettre Max','Courrier Suivi et Lettre Max','',0,NULL),(5,'2018-05-18 18:27:24','UPS','UPS','United Parcel Service','http://wwwapps.ups.com/etracking/tracking.cgi?InquiryNumber2=&InquiryNumber3=&tracknums_displayed=3&loc=fr_FR&TypeOfInquiryNumber=T&HTMLVersion=4.0&InquiryNumber22=&InquiryNumber32=&track=Track&Suivi.x=64&Suivi.y=7&Suivi=Valider&InquiryNumber1={TRACKID}',0,NULL),(6,'2018-05-18 18:27:24','KIALA','KIALA','Relais Kiala','http://www.kiala.fr/tnt/delivery/{TRACKID}',0,NULL),(7,'2018-05-18 18:27:24','GLS','GLS','General Logistics Systems','https://gls-group.eu/FR/fr/suivi-colis?match={TRACKID}',0,NULL),(8,'2018-05-18 18:27:24','CHRONO','Chronopost','Chronopost','http://www.chronopost.fr/expedier/inputLTNumbersNoJahia.do?listeNumeros={TRACKID}',0,NULL);
/*!40000 ALTER TABLE `llx_c_shipment_mode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_stcomm`
--

DROP TABLE IF EXISTS `llx_c_stcomm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_stcomm` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(30) DEFAULT NULL,
  `picto` varchar(128) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_stcomm` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_stcomm`
--

LOCK TABLES `llx_c_stcomm` WRITE;
/*!40000 ALTER TABLE `llx_c_stcomm` DISABLE KEYS */;
INSERT INTO `llx_c_stcomm` VALUES (-1,'ST_NO','Do not contact',NULL,1),(0,'ST_NEVER','Never contacted',NULL,1),(1,'ST_TODO','To contact',NULL,1),(2,'ST_PEND','Contact in progress',NULL,1),(3,'ST_DONE','Contacted',NULL,1);
/*!40000 ALTER TABLE `llx_c_stcomm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_tva`
--

DROP TABLE IF EXISTS `llx_c_tva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_tva` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_pays` int(11) NOT NULL,
  `code` varchar(10) DEFAULT '',
  `taux` double NOT NULL,
  `localtax1` varchar(20) NOT NULL DEFAULT '0',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2` varchar(20) NOT NULL DEFAULT '0',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `recuperableonly` int(11) NOT NULL DEFAULT '0',
  `note` varchar(128) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_tva_id` (`fk_pays`,`code`,`taux`,`recuperableonly`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_tva`
--

LOCK TABLES `llx_c_tva` WRITE;
/*!40000 ALTER TABLE `llx_c_tva` DISABLE KEYS */;
INSERT INTO `llx_c_tva` VALUES (1,2,'BE',21,'0','0','0','0',0,'Taux de 21 %',1,NULL,NULL);
/*!40000 ALTER TABLE `llx_c_tva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_type_contact`
--

DROP TABLE IF EXISTS `llx_c_type_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_type_contact` (
  `rowid` int(11) NOT NULL,
  `element` varchar(30) NOT NULL,
  `source` varchar(8) NOT NULL DEFAULT 'external',
  `code` varchar(32) NOT NULL,
  `libelle` varchar(64) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_type_contact_id` (`element`,`source`,`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_type_contact`
--

LOCK TABLES `llx_c_type_contact` WRITE;
/*!40000 ALTER TABLE `llx_c_type_contact` DISABLE KEYS */;
INSERT INTO `llx_c_type_contact` VALUES (10,'contrat','internal','SALESREPSIGN','Commercial signataire du contrat',1,NULL,0),(11,'contrat','internal','SALESREPFOLL','Commercial suivi du contrat',1,NULL,0),(20,'contrat','external','BILLING','Contact client facturation contrat',1,NULL,0),(21,'contrat','external','CUSTOMER','Contact client suivi contrat',1,NULL,0),(22,'contrat','external','SALESREPSIGN','Contact client signataire contrat',1,NULL,0),(31,'propal','internal','SALESREPFOLL','Commercial à l\'origine de la propale',1,NULL,0),(40,'propal','external','BILLING','Contact client facturation propale',1,NULL,0),(41,'propal','external','CUSTOMER','Contact client suivi propale',1,NULL,0),(42,'propal','external','SHIPPING','Contact client livraison propale',1,NULL,0),(50,'facture','internal','SALESREPFOLL','Responsable suivi du paiement',1,NULL,0),(60,'facture','external','BILLING','Contact client facturation',1,NULL,0),(61,'facture','external','SHIPPING','Contact client livraison',1,NULL,0),(62,'facture','external','SERVICE','Contact client prestation',1,NULL,0),(70,'invoice_supplier','internal','SALESREPFOLL','Responsable suivi du paiement',1,NULL,0),(71,'invoice_supplier','external','BILLING','Contact fournisseur facturation',1,NULL,0),(72,'invoice_supplier','external','SHIPPING','Contact fournisseur livraison',1,NULL,0),(73,'invoice_supplier','external','SERVICE','Contact fournisseur prestation',1,NULL,0),(80,'agenda','internal','ACTOR','Responsable',1,NULL,0),(81,'agenda','internal','GUEST','Guest',1,NULL,0),(85,'agenda','external','ACTOR','Responsable',1,NULL,0),(86,'agenda','external','GUEST','Guest',1,NULL,0),(91,'commande','internal','SALESREPFOLL','Responsable suivi de la commande',1,NULL,0),(100,'commande','external','BILLING','Contact client facturation commande',1,NULL,0),(101,'commande','external','CUSTOMER','Contact client suivi commande',1,NULL,0),(102,'commande','external','SHIPPING','Contact client livraison commande',1,NULL,0),(120,'fichinter','internal','INTERREPFOLL','Responsable suivi de l\'intervention',1,NULL,0),(121,'fichinter','internal','INTERVENING','Intervenant',1,NULL,0),(130,'fichinter','external','BILLING','Contact client facturation intervention',1,NULL,0),(131,'fichinter','external','CUSTOMER','Contact client suivi de l\'intervention',1,NULL,0),(140,'order_supplier','internal','SALESREPFOLL','Responsable suivi de la commande',1,NULL,0),(141,'order_supplier','internal','SHIPPING','Responsable réception de la commande',1,NULL,0),(142,'order_supplier','external','BILLING','Contact fournisseur facturation commande',1,NULL,0),(143,'order_supplier','external','CUSTOMER','Contact fournisseur suivi commande',1,NULL,0),(145,'order_supplier','external','SHIPPING','Contact fournisseur livraison commande',1,NULL,0),(150,'dolresource','internal','USERINCHARGE','In charge of resource',1,NULL,0),(151,'dolresource','external','THIRDINCHARGE','In charge of resource',1,NULL,0),(160,'project','internal','PROJECTLEADER','Chef de Projet',1,NULL,0),(161,'project','internal','PROJECTCONTRIBUTOR','Intervenant',1,NULL,0),(170,'project','external','PROJECTLEADER','Chef de Projet',1,NULL,0),(171,'project','external','PROJECTCONTRIBUTOR','Intervenant',1,NULL,0),(180,'project_task','internal','TASKEXECUTIVE','Responsable',1,NULL,0),(181,'project_task','internal','TASKCONTRIBUTOR','Intervenant',1,NULL,0),(190,'project_task','external','TASKEXECUTIVE','Responsable',1,NULL,0),(191,'project_task','external','TASKCONTRIBUTOR','Intervenant',1,NULL,0);
/*!40000 ALTER TABLE `llx_c_type_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_type_fees`
--

DROP TABLE IF EXISTS `llx_c_type_fees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_type_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(12) NOT NULL,
  `label` varchar(30) DEFAULT NULL,
  `accountancy_code` varchar(32) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_type_fees` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_type_fees`
--

LOCK TABLES `llx_c_type_fees` WRITE;
/*!40000 ALTER TABLE `llx_c_type_fees` DISABLE KEYS */;
INSERT INTO `llx_c_type_fees` VALUES (1,'TF_OTHER','Other',NULL,1,NULL,0),(2,'TF_TRIP','Transportation',NULL,1,NULL,0),(3,'TF_LUNCH','Lunch',NULL,1,NULL,0),(4,'EX_KME','ExpLabelKm',NULL,1,NULL,0),(5,'EX_FUE','ExpLabelFuelCV',NULL,0,NULL,0),(6,'EX_HOT','ExpLabelHotel',NULL,0,NULL,0),(7,'EX_PAR','ExpLabelParkingCV',NULL,0,NULL,0),(8,'EX_TOL','ExpLabelTollCV',NULL,0,NULL,0),(9,'EX_TAX','ExpLabelVariousTaxes',NULL,0,NULL,0),(10,'EX_IND','ExpLabelIndemnityTransSubscrip',NULL,0,NULL,0),(11,'EX_SUM','ExpLabelMaintenanceSupply',NULL,0,NULL,0),(12,'EX_SUO','ExpLabelOfficeSupplies',NULL,0,NULL,0),(13,'EX_CAR','ExpLabelCarRental',NULL,0,NULL,0),(14,'EX_DOC','ExpLabelDocumentation',NULL,0,NULL,0),(15,'EX_CUR','ExpLabelCustomersReceiving',NULL,0,NULL,0),(16,'EX_OTR','ExpLabelOtherReceiving',NULL,0,NULL,0),(17,'EX_POS','ExpLabelPostage',NULL,0,NULL,0),(18,'EX_CAM','ExpLabelMaintenanceRepairCV',NULL,0,NULL,0),(19,'EX_EMM','ExpLabelEmployeesMeal',NULL,0,NULL,0),(20,'EX_GUM','ExpLabelGuestsMeal',NULL,0,NULL,0),(21,'EX_BRE','ExpLabelBreakfast',NULL,0,NULL,0),(22,'EX_FUE_VP','ExpLabelFuelPV',NULL,0,NULL,0),(23,'EX_TOL_VP','ExpLabelTollPV',NULL,0,NULL,0),(24,'EX_PAR_VP','ExpLabelParkingPV',NULL,0,NULL,0),(25,'EX_CAM_VP','ExpLabelMaintenanceRepairPV',NULL,0,NULL,0);
/*!40000 ALTER TABLE `llx_c_type_fees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_type_resource`
--

DROP TABLE IF EXISTS `llx_c_type_resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_type_resource` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `label` varchar(64) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_type_resource_id` (`label`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_type_resource`
--

LOCK TABLES `llx_c_type_resource` WRITE;
/*!40000 ALTER TABLE `llx_c_type_resource` DISABLE KEYS */;
INSERT INTO `llx_c_type_resource` VALUES (1,'RES_ROOMS','Rooms',1),(2,'RES_CARS','Cars',1);
/*!40000 ALTER TABLE `llx_c_type_resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_typent`
--

DROP TABLE IF EXISTS `llx_c_typent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_typent` (
  `id` int(11) NOT NULL,
  `code` varchar(12) NOT NULL,
  `libelle` varchar(64) DEFAULT NULL,
  `fk_country` int(11) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `module` varchar(32) DEFAULT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_c_typent` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_typent`
--

LOCK TABLES `llx_c_typent` WRITE;
/*!40000 ALTER TABLE `llx_c_typent` DISABLE KEYS */;
INSERT INTO `llx_c_typent` VALUES (0,'TE_UNKNOWN','-',NULL,1,NULL,0),(1,'TE_STARTUP','Start-up',NULL,0,NULL,0),(2,'TE_GROUP','Grand groupe',NULL,1,NULL,0),(3,'TE_MEDIUM','PME/PMI',NULL,1,NULL,0),(4,'TE_SMALL','TPE',NULL,1,NULL,0),(5,'TE_ADMIN','Administration',NULL,1,NULL,0),(6,'TE_WHOLE','Grossiste',NULL,0,NULL,0),(7,'TE_RETAIL','Revendeur',NULL,0,NULL,0),(8,'TE_PRIVATE','Particulier',NULL,1,NULL,0),(100,'TE_OTHER','Autres',NULL,1,NULL,0),(231,'TE_A_RI','Responsable Inscripto (typo A)',23,0,NULL,0),(232,'TE_B_RNI','Responsable No Inscripto (typo B)',23,0,NULL,0),(233,'TE_C_FE','Consumidor Final/Exento (typo C)',23,0,NULL,0);
/*!40000 ALTER TABLE `llx_c_typent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_units`
--

DROP TABLE IF EXISTS `llx_c_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_units` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(3) DEFAULT NULL,
  `label` varchar(50) DEFAULT NULL,
  `short_label` varchar(5) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_c_units_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_units`
--

LOCK TABLES `llx_c_units` WRITE;
/*!40000 ALTER TABLE `llx_c_units` DISABLE KEYS */;
INSERT INTO `llx_c_units` VALUES (1,'P','piece','p',1),(2,'SET','set','se',1),(3,'S','second','s',1),(4,'H','hour','h',1),(5,'D','day','d',1),(6,'KG','kilogram','kg',1),(7,'G','gram','g',1),(8,'M','meter','m',1),(9,'LM','linear meter','lm',1),(10,'M2','square meter','m2',1),(11,'M3','cubic meter','m3',1),(12,'L','liter','l',1);
/*!40000 ALTER TABLE `llx_c_units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_c_ziptown`
--

DROP TABLE IF EXISTS `llx_c_ziptown`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_c_ziptown` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(5) DEFAULT NULL,
  `fk_county` int(11) DEFAULT NULL,
  `fk_pays` int(11) NOT NULL DEFAULT '0',
  `zip` varchar(10) NOT NULL,
  `town` varchar(180) NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_ziptown_fk_pays` (`zip`,`town`,`fk_pays`),
  KEY `idx_c_ziptown_fk_county` (`fk_county`),
  KEY `idx_c_ziptown_fk_pays` (`fk_pays`),
  KEY `idx_c_ziptown_zip` (`zip`),
  CONSTRAINT `fk_c_ziptown_fk_county` FOREIGN KEY (`fk_county`) REFERENCES `llx_c_departements` (`rowid`),
  CONSTRAINT `fk_c_ziptown_fk_pays` FOREIGN KEY (`fk_pays`) REFERENCES `llx_c_country` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_c_ziptown`
--

LOCK TABLES `llx_c_ziptown` WRITE;
/*!40000 ALTER TABLE `llx_c_ziptown` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_c_ziptown` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie`
--

DROP TABLE IF EXISTS `llx_categorie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_parent` int(11) NOT NULL DEFAULT '0',
  `label` varchar(180) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `description` text,
  `color` varchar(8) DEFAULT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_categorie_ref` (`entity`,`fk_parent`,`label`,`type`),
  KEY `idx_categorie_type` (`type`),
  KEY `idx_categorie_label` (`label`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie`
--

LOCK TABLES `llx_categorie` WRITE;
/*!40000 ALTER TABLE `llx_categorie` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_account`
--

DROP TABLE IF EXISTS `llx_categorie_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_account` (
  `fk_categorie` int(11) NOT NULL,
  `fk_account` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_account`),
  KEY `idx_categorie_account_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_account_fk_account` (`fk_account`),
  CONSTRAINT `fk_categorie_account_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_account_fk_account` FOREIGN KEY (`fk_account`) REFERENCES `llx_bank_account` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_account`
--

LOCK TABLES `llx_categorie_account` WRITE;
/*!40000 ALTER TABLE `llx_categorie_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_contact`
--

DROP TABLE IF EXISTS `llx_categorie_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_contact` (
  `fk_categorie` int(11) NOT NULL,
  `fk_socpeople` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_socpeople`),
  KEY `idx_categorie_contact_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_contact_fk_socpeople` (`fk_socpeople`),
  CONSTRAINT `fk_categorie_contact_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_contact_fk_socpeople` FOREIGN KEY (`fk_socpeople`) REFERENCES `llx_socpeople` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_contact`
--

LOCK TABLES `llx_categorie_contact` WRITE;
/*!40000 ALTER TABLE `llx_categorie_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_fournisseur`
--

DROP TABLE IF EXISTS `llx_categorie_fournisseur`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_fournisseur` (
  `fk_categorie` int(11) NOT NULL,
  `fk_soc` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_soc`),
  KEY `idx_categorie_fournisseur_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_fournisseur_fk_societe` (`fk_soc`),
  CONSTRAINT `fk_categorie_fournisseur_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_fournisseur_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_fournisseur`
--

LOCK TABLES `llx_categorie_fournisseur` WRITE;
/*!40000 ALTER TABLE `llx_categorie_fournisseur` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_fournisseur` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_lang`
--

DROP TABLE IF EXISTS `llx_categorie_lang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_lang` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_category` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(5) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_category_lang` (`fk_category`,`lang`),
  CONSTRAINT `fk_category_lang_fk_category` FOREIGN KEY (`fk_category`) REFERENCES `llx_categorie` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_lang`
--

LOCK TABLES `llx_categorie_lang` WRITE;
/*!40000 ALTER TABLE `llx_categorie_lang` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_lang` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_member`
--

DROP TABLE IF EXISTS `llx_categorie_member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_member` (
  `fk_categorie` int(11) NOT NULL,
  `fk_member` int(11) NOT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_member`),
  KEY `idx_categorie_member_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_member_fk_member` (`fk_member`),
  CONSTRAINT `fk_categorie_member_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_member_member_rowid` FOREIGN KEY (`fk_member`) REFERENCES `llx_adherent` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_member`
--

LOCK TABLES `llx_categorie_member` WRITE;
/*!40000 ALTER TABLE `llx_categorie_member` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_member` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_product`
--

DROP TABLE IF EXISTS `llx_categorie_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_product` (
  `fk_categorie` int(11) NOT NULL,
  `fk_product` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_product`),
  KEY `idx_categorie_product_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_product_fk_product` (`fk_product`),
  CONSTRAINT `fk_categorie_product_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_product_product_rowid` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_product`
--

LOCK TABLES `llx_categorie_product` WRITE;
/*!40000 ALTER TABLE `llx_categorie_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_project`
--

DROP TABLE IF EXISTS `llx_categorie_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_project` (
  `fk_categorie` int(11) NOT NULL,
  `fk_project` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_project`),
  KEY `idx_categorie_project_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_project_fk_project` (`fk_project`),
  CONSTRAINT `fk_categorie_project_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_project_fk_project_rowid` FOREIGN KEY (`fk_project`) REFERENCES `llx_projet` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_project`
--

LOCK TABLES `llx_categorie_project` WRITE;
/*!40000 ALTER TABLE `llx_categorie_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_societe`
--

DROP TABLE IF EXISTS `llx_categorie_societe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_societe` (
  `fk_categorie` int(11) NOT NULL,
  `fk_soc` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_soc`),
  KEY `idx_categorie_societe_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_societe_fk_societe` (`fk_soc`),
  CONSTRAINT `fk_categorie_societe_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_societe_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_societe`
--

LOCK TABLES `llx_categorie_societe` WRITE;
/*!40000 ALTER TABLE `llx_categorie_societe` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_societe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categorie_user`
--

DROP TABLE IF EXISTS `llx_categorie_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categorie_user` (
  `fk_categorie` int(11) NOT NULL,
  `fk_user` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`fk_categorie`,`fk_user`),
  KEY `idx_categorie_user_fk_categorie` (`fk_categorie`),
  KEY `idx_categorie_user_fk_user` (`fk_user`),
  CONSTRAINT `fk_categorie_user_categorie_rowid` FOREIGN KEY (`fk_categorie`) REFERENCES `llx_categorie` (`rowid`),
  CONSTRAINT `fk_categorie_user_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categorie_user`
--

LOCK TABLES `llx_categorie_user` WRITE;
/*!40000 ALTER TABLE `llx_categorie_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categorie_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_categories_extrafields`
--

DROP TABLE IF EXISTS `llx_categories_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_categories_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_categories_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_categories_extrafields`
--

LOCK TABLES `llx_categories_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_categories_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_categories_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_chargesociales`
--

DROP TABLE IF EXISTS `llx_chargesociales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_chargesociales` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(16) DEFAULT NULL,
  `date_ech` datetime NOT NULL,
  `libelle` varchar(80) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_creation` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_type` int(11) NOT NULL,
  `fk_account` int(11) DEFAULT NULL,
  `fk_mode_reglement` int(11) DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `paye` smallint(6) NOT NULL DEFAULT '0',
  `periode` date DEFAULT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_chargesociales`
--

LOCK TABLES `llx_chargesociales` WRITE;
/*!40000 ALTER TABLE `llx_chargesociales` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_chargesociales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande`
--

DROP TABLE IF EXISTS `llx_commande`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_client` varchar(255) DEFAULT NULL,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_creation` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `date_commande` date DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_user_cloture` int(11) DEFAULT NULL,
  `source` smallint(6) DEFAULT NULL,
  `fk_statut` smallint(6) DEFAULT '0',
  `amount_ht` double(24,8) DEFAULT '0.00000000',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `facture` tinyint(4) DEFAULT '0',
  `fk_account` int(11) DEFAULT NULL,
  `fk_currency` varchar(3) DEFAULT NULL,
  `fk_cond_reglement` int(11) DEFAULT NULL,
  `fk_mode_reglement` int(11) DEFAULT NULL,
  `date_livraison` date DEFAULT NULL,
  `fk_shipping_method` int(11) DEFAULT NULL,
  `fk_warehouse` int(11) DEFAULT NULL,
  `fk_availability` int(11) DEFAULT NULL,
  `fk_input_reason` int(11) DEFAULT NULL,
  `fk_delivery_address` int(11) DEFAULT NULL,
  `fk_incoterms` int(11) DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_commande_ref` (`ref`,`entity`),
  KEY `idx_commande_fk_soc` (`fk_soc`),
  KEY `idx_commande_fk_user_author` (`fk_user_author`),
  KEY `idx_commande_fk_user_valid` (`fk_user_valid`),
  KEY `idx_commande_fk_user_cloture` (`fk_user_cloture`),
  KEY `idx_commande_fk_projet` (`fk_projet`),
  KEY `idx_commande_fk_account` (`fk_account`),
  KEY `idx_commande_fk_currency` (`fk_currency`),
  CONSTRAINT `fk_commande_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_commande_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_commande_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_commande_fk_user_cloture` FOREIGN KEY (`fk_user_cloture`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_commande_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande`
--

LOCK TABLES `llx_commande` WRITE;
/*!40000 ALTER TABLE `llx_commande` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_extrafields`
--

DROP TABLE IF EXISTS `llx_commande_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande_extrafields`
--

LOCK TABLES `llx_commande_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_commande_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseur`
--

DROP TABLE IF EXISTS `llx_commande_fournisseur`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande_fournisseur` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(180) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_supplier` varchar(255) DEFAULT NULL,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) DEFAULT '0',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_creation` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_approve` datetime DEFAULT NULL,
  `date_approve2` datetime DEFAULT NULL,
  `date_commande` date DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_user_approve` int(11) DEFAULT NULL,
  `fk_user_approve2` int(11) DEFAULT NULL,
  `source` smallint(6) NOT NULL,
  `fk_statut` smallint(6) DEFAULT '0',
  `billed` smallint(6) DEFAULT '0',
  `amount_ht` double(24,8) DEFAULT '0.00000000',
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `date_livraison` datetime DEFAULT NULL,
  `fk_account` int(11) DEFAULT NULL,
  `fk_cond_reglement` int(11) DEFAULT NULL,
  `fk_mode_reglement` int(11) DEFAULT NULL,
  `fk_input_method` int(11) DEFAULT '0',
  `fk_incoterms` int(11) DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_commande_fournisseur_ref` (`ref`,`fk_soc`,`entity`),
  KEY `idx_commande_fournisseur_fk_soc` (`fk_soc`),
  KEY `billed` (`billed`),
  CONSTRAINT `fk_commande_fournisseur_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande_fournisseur`
--

LOCK TABLES `llx_commande_fournisseur` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseur` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseur` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseur_dispatch`
--

DROP TABLE IF EXISTS `llx_commande_fournisseur_dispatch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande_fournisseur_dispatch` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_commande` int(11) DEFAULT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `fk_commandefourndet` int(11) DEFAULT NULL,
  `qty` float DEFAULT NULL,
  `fk_entrepot` int(11) DEFAULT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `batch` varchar(30) DEFAULT NULL,
  `eatby` date DEFAULT NULL,
  `sellby` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_fournisseur_dispatch_fk_commande` (`fk_commande`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande_fournisseur_dispatch`
--

LOCK TABLES `llx_commande_fournisseur_dispatch` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseur_dispatch` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseur_dispatch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseur_extrafields`
--

DROP TABLE IF EXISTS `llx_commande_fournisseur_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande_fournisseur_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_fournisseur_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande_fournisseur_extrafields`
--

LOCK TABLES `llx_commande_fournisseur_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseur_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseur_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseur_log`
--

DROP TABLE IF EXISTS `llx_commande_fournisseur_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande_fournisseur_log` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datelog` datetime NOT NULL,
  `fk_commande` int(11) NOT NULL,
  `fk_statut` smallint(6) NOT NULL,
  `fk_user` int(11) NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande_fournisseur_log`
--

LOCK TABLES `llx_commande_fournisseur_log` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseur_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseur_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseurdet`
--

DROP TABLE IF EXISTS `llx_commande_fournisseurdet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande_fournisseurdet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_commande` int(11) NOT NULL,
  `fk_parent_line` int(11) DEFAULT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `ref` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT '0.000',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int(11) DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int(11) DEFAULT '0',
  `special_code` int(11) DEFAULT '0',
  `rang` int(11) DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `fk_unit` int(11) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `fk_commande_fournisseurdet_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_commande_fournisseurdet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande_fournisseurdet`
--

LOCK TABLES `llx_commande_fournisseurdet` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseurdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseurdet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commande_fournisseurdet_extrafields`
--

DROP TABLE IF EXISTS `llx_commande_fournisseurdet_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commande_fournisseurdet_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commande_fournisseurdet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commande_fournisseurdet_extrafields`
--

LOCK TABLES `llx_commande_fournisseurdet_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_commande_fournisseurdet_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commande_fournisseurdet_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commandedet`
--

DROP TABLE IF EXISTS `llx_commandedet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commandedet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_commande` int(11) NOT NULL,
  `fk_parent_line` int(11) DEFAULT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `fk_remise_except` int(11) DEFAULT NULL,
  `price` double DEFAULT NULL,
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int(11) DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int(11) DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int(11) DEFAULT NULL,
  `special_code` int(11) DEFAULT '0',
  `rang` int(11) DEFAULT '0',
  `fk_unit` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_commandefourndet` int(11) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `idx_commandedet_fk_commande` (`fk_commande`),
  KEY `idx_commandedet_fk_product` (`fk_product`),
  KEY `fk_commandedet_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_commandedet_fk_commande` FOREIGN KEY (`fk_commande`) REFERENCES `llx_commande` (`rowid`),
  CONSTRAINT `fk_commandedet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commandedet`
--

LOCK TABLES `llx_commandedet` WRITE;
/*!40000 ALTER TABLE `llx_commandedet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commandedet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_commandedet_extrafields`
--

DROP TABLE IF EXISTS `llx_commandedet_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_commandedet_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_commandedet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_commandedet_extrafields`
--

LOCK TABLES `llx_commandedet_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_commandedet_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_commandedet_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_comment`
--

DROP TABLE IF EXISTS `llx_comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_comment` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` text NOT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_element` int(11) DEFAULT NULL,
  `element_type` varchar(50) DEFAULT NULL,
  `entity` int(11) DEFAULT '1',
  `import_key` varchar(125) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_comment`
--

LOCK TABLES `llx_comment` WRITE;
/*!40000 ALTER TABLE `llx_comment` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_comment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_const`
--

DROP TABLE IF EXISTS `llx_const`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_const` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(180) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `value` text NOT NULL,
  `type` varchar(6) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `note` text,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_const` (`name`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=466 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_const`
--

LOCK TABLES `llx_const` WRITE;
/*!40000 ALTER TABLE `llx_const` DISABLE KEYS */;
INSERT INTO `llx_const` VALUES (2,'MAIN_FEATURES_LEVEL',0,'0','chaine',1,'Level of features to show: -1=stable+deprecated, 0=stable only (default), 1=stable+experimental, 2=stable+experimental+development','2018-05-18 18:27:24'),(3,'MAILING_LIMIT_SENDBYWEB',0,'25','chaine',1,'Number of targets to defined packet size when sending mass email','2018-05-18 18:27:24'),(4,'MAIN_ENABLE_LOG_TO_HTML',0,'0','chaine',1,'If this option is set to 1, it is possible to see log output at end of HTML sources by adding paramater logtohtml=1 on URL. Module log must also be enabled.','2018-05-18 18:27:24'),(5,'MAIN_SECURITY_CSRF_WITH_TOKEN',0,'0','chaine',1,'If this option is set to 1, a CSRF protection using an antiCSRF token is added.','2018-05-18 18:27:24'),(6,'SYSLOG_HANDLERS',0,'[\"mod_syslog_file\"]','chaine',0,'Which logger to use','2018-05-18 18:27:24'),(7,'SYSLOG_FILE',0,'DOL_DATA_ROOT/dolibarr.log','chaine',0,'Directory where to write log file','2018-05-18 18:27:24'),(8,'SYSLOG_LEVEL',0,'7','chaine',0,'Level of debug info to show','2018-05-18 18:27:24'),(9,'MAIN_UPLOAD_DOC',0,'2048','chaine',0,'Max size for file upload (0 means no upload allowed)','2018-05-18 18:27:24'),(10,'MAIN_ENABLE_OVERWRITE_TRANSLATION',1,'1','chaine',0,'Enable translation overwrite','2018-05-18 18:27:24'),(11,'MAIN_ENABLE_DEFAULT_VALUES',1,'1','chaine',0,'Enable default value overwrite','2018-05-18 18:27:24'),(16,'MAIN_SIZE_LISTE_LIMIT',0,'25','chaine',0,'Longueur maximum des listes','2018-05-18 18:27:24'),(17,'MAIN_SIZE_SHORTLIST_LIMIT',0,'3','chaine',0,'Longueur maximum des listes courtes (fiche client)','2018-05-18 18:27:24'),(18,'MAIN_MENU_STANDARD',0,'eldy_menu.php','chaine',0,'Menu manager for internal users','2018-05-18 18:27:24'),(19,'MAIN_MENUFRONT_STANDARD',0,'eldy_menu.php','chaine',0,'Menu manager for external users','2018-05-18 18:27:24'),(20,'MAIN_MENU_SMARTPHONE',0,'eldy_menu.php','chaine',0,'Menu manager for internal users using smartphones','2018-05-18 18:27:24'),(21,'MAIN_MENUFRONT_SMARTPHONE',0,'eldy_menu.php','chaine',0,'Menu manager for external users using smartphones','2018-05-18 18:27:24'),(22,'MAIN_DELAY_ACTIONS_TODO',1,'7','chaine',0,'Tolérance de retard avant alerte (en jours) sur actions planifiées non réalisées','2018-05-18 18:27:24'),(23,'MAIN_DELAY_ORDERS_TO_PROCESS',1,'2','chaine',0,'Tolérance de retard avant alerte (en jours) sur commandes clients non traitées','2018-05-18 18:27:24'),(24,'MAIN_DELAY_SUPPLIER_ORDERS_TO_PROCESS',1,'7','chaine',0,'Tolérance de retard avant alerte (en jours) sur commandes fournisseurs non traitées','2018-05-18 18:27:24'),(25,'MAIN_DELAY_PROPALS_TO_CLOSE',1,'31','chaine',0,'Tolérance de retard avant alerte (en jours) sur propales à cloturer','2018-05-18 18:27:24'),(26,'MAIN_DELAY_PROPALS_TO_BILL',1,'7','chaine',0,'Tolérance de retard avant alerte (en jours) sur propales non facturées','2018-05-18 18:27:24'),(27,'MAIN_DELAY_CUSTOMER_BILLS_UNPAYED',1,'31','chaine',0,'Tolérance de retard avant alerte (en jours) sur factures client impayées','2018-05-18 18:27:24'),(28,'MAIN_DELAY_SUPPLIER_BILLS_TO_PAY',1,'2','chaine',0,'Tolérance de retard avant alerte (en jours) sur factures fournisseur impayées','2018-05-18 18:27:24'),(29,'MAIN_DELAY_NOT_ACTIVATED_SERVICES',1,'0','chaine',0,'Tolérance de retard avant alerte (en jours) sur services à activer','2018-05-18 18:27:24'),(30,'MAIN_DELAY_RUNNING_SERVICES',1,'0','chaine',0,'Tolérance de retard avant alerte (en jours) sur services expirés','2018-05-18 18:27:24'),(31,'MAIN_DELAY_MEMBERS',1,'31','chaine',0,'Tolérance de retard avant alerte (en jours) sur cotisations adhérent en retard','2018-05-18 18:27:24'),(32,'MAIN_DELAY_TRANSACTIONS_TO_CONCILIATE',1,'62','chaine',0,'Tolérance de retard avant alerte (en jours) sur rapprochements bancaires à faire','2018-05-18 18:27:24'),(33,'MAIN_DELAY_EXPENSEREPORTS_TO_PAY',1,'31','chaine',0,'Tolérance de retard avant alerte (en jours) sur les notes de frais impayées','2018-05-18 18:27:24'),(34,'MAIN_FIX_FOR_BUGGED_MTA',1,'1','chaine',1,'Set constant to fix email ending from PHP with some linux ike system','2018-05-18 18:27:24'),(35,'MAILING_EMAIL_FROM',1,'dolibarr@domain.com','chaine',0,'EMail emmetteur pour les envois d emailings','2018-05-18 18:27:24'),(36,'PRODUCT_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/products','chaine',0,NULL,'2018-05-18 18:27:24'),(37,'CONTRACT_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/contracts','chaine',0,NULL,'2018-05-18 18:27:24'),(38,'USERGROUP_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/usergroups','chaine',0,NULL,'2018-05-18 18:27:24'),(39,'USER_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/users','chaine',0,NULL,'2018-05-18 18:27:24'),(40,'MAIN_MODULE_USER',0,'1',NULL,0,'{\"authorid\":0,\"ip\":\"87.66.160.185\"}','2018-05-18 18:28:06'),(41,'DATABASE_PWD_ENCRYPTED',1,'1','chaine',0,'','2018-05-18 18:28:06'),(42,'MAIN_SECURITY_SALT',0,'20180518182806','chaine',0,'','2018-05-18 18:28:06'),(43,'MAIN_SECURITY_HASH_ALGO',0,'sha1md5','chaine',0,'','2018-05-18 18:28:06'),(44,'MAIN_VERSION_FIRST_INSTALL',0,'7.0.2','chaine',0,'Dolibarr version when first install','2018-05-18 18:28:06'),(45,'MAIN_VERSION_LAST_INSTALL',0,'7.0.2','chaine',0,'Dolibarr version when last install','2018-05-18 18:28:06'),(47,'MAIN_MODULE_HOLIDAY',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:28:49'),(48,'MAIN_MODULE_HOLIDAY_TABS_0',1,'user:+paidholidays:CPTitreMenu:holiday:$user->rights->holiday->read:/holiday/list.php?mainmenu=hrm&id=__ID__','chaine',0,NULL,'2018-05-18 18:28:49'),(49,'MAIN_MODULE_EXPENSEREPORT',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:28:51'),(50,'MAIN_MODULE_EXPENSEREPORT_TABS_0',1,'user:+expensereport:ExpenseReport:expensereport:$user->rights->expensereport->lire:/expensereport/list.php?mainmenu=hrm&id=__ID__','chaine',0,NULL,'2018-05-18 18:28:51'),(51,'EXPENSEREPORT_ADDON_PDF',1,'standard','chaine',0,'Name of manager to build PDF expense reports documents','2018-05-18 18:28:51'),(52,'EXPENSEREPORT_ADDON',1,'mod_expensereport_jade','chaine',0,'Name of manager to generate expense report ref number','2018-05-18 18:28:51'),(53,'MAIN_DELAY_EXPENSEREPORTS',1,'15','chaine',0,'Tolerance delay (in days) before alert for expense reports to approve','2018-05-18 18:28:51'),(54,'MAIN_MODULE_SALARIES',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:28:53'),(55,'SALARIES_ACCOUNTING_ACCOUNT_PAYMENT',1,'421','chaine',0,NULL,'2018-05-18 18:28:53'),(56,'SALARIES_ACCOUNTING_ACCOUNT_CHARGE',1,'641','chaine',0,NULL,'2018-05-18 18:28:53'),(57,'MAIN_MODULE_SOCIETE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:28:56'),(58,'SOCIETE_CODECLIENT_ADDON',1,'mod_codeclient_monkey','chaine',0,'Module to control third parties codes','2018-05-18 18:28:56'),(59,'SOCIETE_CODECOMPTA_ADDON',1,'mod_codecompta_panicum','chaine',0,'Module to control third parties codes','2018-05-18 18:28:56'),(61,'COMPANY_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/thirdparties','chaine',0,NULL,'2018-05-18 18:28:56'),(62,'SOCIETE_ADD_REF_IN_LIST',1,'0','yesno',0,'Display customer ref into select list','2018-05-18 18:28:56'),(63,'MAIN_MODULE_PROPALE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:28:57'),(64,'PROPALE_ADDON_PDF',1,'azur','chaine',0,'Name of the proposal generation manager in PDF format','2018-05-18 18:28:57'),(65,'PROPALE_ADDON',1,'mod_propale_marbre','chaine',0,'Name of proposal numbering manager','2018-05-18 18:28:57'),(66,'PROPALE_VALIDITY_DURATION',1,'15','chaine',0,'Duration of validity of business proposals','2018-05-18 18:28:57'),(67,'PROPALE_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/proposals','chaine',0,NULL,'2018-05-18 18:28:57'),(68,'MAIN_MODULE_COMMANDE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:28:58'),(69,'COMMANDE_ADDON_PDF',1,'einstein','chaine',0,'Name of PDF model of order','2018-05-18 18:28:58'),(70,'COMMANDE_ADDON',1,'mod_commande_marbre','chaine',0,'Name of numbering numerotation rules of order','2018-05-18 18:28:58'),(71,'COMMANDE_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/orders','chaine',0,NULL,'2018-05-18 18:28:58'),(72,'MAIN_MODULE_EXPEDITION',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:29:01'),(73,'EXPEDITION_ADDON_PDF',1,'rouget','chaine',0,'Nom du gestionnaire de generation des bons expeditions en PDF','2018-05-18 18:29:01'),(74,'EXPEDITION_ADDON_NUMBER',1,'mod_expedition_safor','chaine',0,'Name for numbering manager for shipments','2018-05-18 18:29:01'),(75,'EXPEDITION_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/shipment','chaine',0,NULL,'2018-05-18 18:29:01'),(76,'LIVRAISON_ADDON_PDF',1,'typhon','chaine',0,'Nom du gestionnaire de generation des bons de reception en PDF','2018-05-18 18:29:01'),(77,'LIVRAISON_ADDON_NUMBER',1,'mod_livraison_jade','chaine',0,'Nom du gestionnaire de numerotation des bons de reception','2018-05-18 18:29:01'),(78,'LIVRAISON_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/delivery','chaine',0,NULL,'2018-05-18 18:29:01'),(79,'MAIN_SUBMODULE_EXPEDITION',1,'1','chaine',0,'Enable shipments','2018-05-18 18:29:01'),(80,'MAIN_MODULE_CONTRAT',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:29:02'),(81,'CONTRACT_ADDON',1,'mod_contract_serpis','chaine',0,'Nom du gestionnaire de numerotation des contrats','2018-05-18 18:29:02'),(82,'CONTRACT_ADDON_PDF',1,'strato','chaine',0,'Name of PDF model of contract','2018-05-18 18:29:02'),(83,'MAIN_MODULE_FICHEINTER',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 18:29:05'),(84,'FICHEINTER_ADDON_PDF',1,'soleil','chaine',0,NULL,'2018-05-18 18:29:05'),(85,'FICHEINTER_ADDON',1,'pacific','chaine',0,NULL,'2018-05-18 18:29:05'),(87,'MAIN_MODULE_FOURNISSEUR',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:03'),(88,'COMMANDE_SUPPLIER_ADDON_PDF',1,'muscadet','chaine',0,'Nom du gestionnaire de generation des bons de commande en PDF','2018-05-18 19:18:03'),(89,'COMMANDE_SUPPLIER_ADDON_NUMBER',1,'mod_commande_fournisseur_muguet','chaine',0,'Nom du gestionnaire de numerotation des commandes fournisseur','2018-05-18 19:18:03'),(90,'INVOICE_SUPPLIER_ADDON_NUMBER',1,'mod_facture_fournisseur_cactus','chaine',0,'Nom du gestionnaire de numerotation des factures fournisseur','2018-05-18 19:18:03'),(92,'ADHERENT_ADDON_PDF',1,'standard','chaine',0,'Name of PDF model of member','2018-05-18 19:18:08'),(93,'ADHERENT_MAIL_RESIL',1,'Votre adhésion vient d\'être résiliée.\r\nNous espérons vous revoir très bientôt','texte',0,'Mail de résiliation','2018-05-18 19:18:08'),(94,'ADHERENT_MAIL_VALID',1,'Votre adhésion vient d\'être validée. \r\nVoici le rappel de vos coordonnées (toute information erronée entrainera la non validation de votre inscription) :\r\n\r\n__INFOS__\r\n\r\n','texte',0,'Mail de validation','2018-05-18 19:18:08'),(95,'ADHERENT_MAIL_VALID_SUBJECT',1,'Votre adhésion a été validée','chaine',0,'Sujet du mail de validation','2018-05-18 19:18:08'),(96,'ADHERENT_MAIL_RESIL_SUBJECT',1,'Résiliation de votre adhésion','chaine',0,'Sujet du mail de résiliation','2018-05-18 19:18:08'),(97,'ADHERENT_MAIL_FROM',1,'','chaine',0,'From des mails','2018-05-18 19:18:08'),(98,'ADHERENT_MAIL_COTIS',1,'Bonjour __FIRSTNAME__,\r\nCet email confirme que votre cotisation a été reçue\r\net enregistrée','texte',0,'Mail de validation de cotisation','2018-05-18 19:18:08'),(99,'ADHERENT_MAIL_COTIS_SUBJECT',1,'Reçu de votre cotisation','chaine',0,'Sujet du mail de validation de cotisation','2018-05-18 19:18:08'),(100,'ADHERENT_CARD_HEADER_TEXT',1,'__YEAR__','chaine',0,'Texte imprimé sur le haut de la carte adhérent','2018-05-18 19:18:08'),(101,'ADHERENT_CARD_FOOTER_TEXT',1,'__COMPANY__','chaine',0,'Texte imprimé sur le bas de la carte adhérent','2018-05-18 19:18:08'),(102,'ADHERENT_CARD_TEXT',1,'__FULLNAME__\r\nID: __ID__\r\n__EMAIL__\r\n__ADDRESS__\r\n__ZIP__ __TOWN__\r\n__COUNTRY__','texte',0,'Text to print on member cards','2018-05-18 19:18:08'),(103,'ADHERENT_MAILMAN_ADMINPW',1,'','chaine',0,'Mot de passe Admin des liste mailman','2018-05-18 19:18:08'),(104,'ADHERENT_BANK_ACCOUNT',1,'','chaine',0,'ID du Compte banquaire utilise','2018-05-18 19:18:08'),(105,'ADHERENT_BANK_CATEGORIE',1,'','chaine',0,'ID de la catégorie bancaire des cotisations','2018-05-18 19:18:08'),(106,'ADHERENT_ETIQUETTE_TYPE',1,'L7163','chaine',0,'Type of address sheets','2018-05-18 19:18:08'),(107,'ADHERENT_ETIQUETTE_TEXT',1,'__FULLNAME__\n__ADDRESS__\n__ZIP__ __TOWN__\n__COUNTRY%','texte',0,'Text to print on member address sheets','2018-05-18 19:18:08'),(108,'MAIN_MODULE_SUPPLIERPROPOSAL',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:17'),(109,'SUPPLIER_PROPOSAL_ADDON_PDF',1,'aurore','chaine',0,'Name of submodule to generate PDF for supplier quotation request','2018-05-18 19:18:17'),(110,'SUPPLIER_PROPOSAL_ADDON',1,'mod_supplier_proposal_marbre','chaine',0,'Name of submodule to number supplier quotation request','2018-05-18 19:18:17'),(111,'SUPPLIER_PROPOSAL_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/supplier_proposal','chaine',0,NULL,'2018-05-18 19:18:17'),(112,'MAIN_MODULE_INCOTERM',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:19'),(113,'INCOTERM_ACTIVATE',1,'','chaine',0,'Description de INCOTERM_ACTIVATE','2018-05-18 19:18:19'),(114,'MAIN_MODULE_FACTURE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:24'),(115,'FACTURE_ADDON',1,'mod_facture_terre','chaine',0,'Name of numbering numerotation rules of invoice','2018-05-18 19:18:24'),(116,'FACTURE_ADDON_PDF',1,'crabe','chaine',0,'Name of PDF model of invoice','2018-05-18 19:18:24'),(117,'FACTURE_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/invoices','chaine',0,NULL,'2018-05-18 19:18:24'),(118,'MAIN_MODULE_TAX',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:27'),(119,'MAIN_MODULE_LOAN',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:31'),(120,'LOAN_ACCOUNTING_ACCOUNT_CAPITAL',1,'164','chaine',0,NULL,'2018-05-18 19:18:31'),(121,'LOAN_ACCOUNTING_ACCOUNT_INSURANCE',1,'6162','chaine',0,NULL,'2018-05-18 19:18:31'),(122,'MAIN_MODULE_DON',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:34'),(123,'DON_ADDON_MODEL',1,'html_cerfafr','chaine',0,'Nom du gestionnaire de generation de recu de dons','2018-05-18 19:18:34'),(124,'DONATION_ART200',1,'0','yesno',0,'Option Française - Eligibilité Art200 du CGI','2018-05-18 19:18:34'),(125,'DONATION_ART238',1,'0','yesno',0,'Option Française - Eligibilité Art238 bis du CGI','2018-05-18 19:18:34'),(126,'DONATION_ART885',1,'0','yesno',0,'Option Française - Eligibilité Art885-0 V bis du CGI','2018-05-18 19:18:34'),(127,'DONATION_MESSAGE',1,'Thank you','chaine',0,'Message affiché sur le récépissé de versements ou dons','2018-05-18 19:18:34'),(128,'DONATION_ACCOUNTINGACCOUNT',1,'758','chaine',0,'Compte comptable de remise des versements ou dons','2018-05-18 19:18:34'),(129,'MAIN_MODULE_PRELEVEMENT',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:37'),(130,'BANK_ADDON_PDF',1,'sepamandate','chaine',0,'Name of manager to generate SEPA mandate','2018-05-18 19:18:37'),(131,'MAIN_MODULE_BANQUE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:37'),(132,'MAIN_MODULE_MARGIN',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:41'),(133,'MAIN_MODULE_MARGIN_TABS_0',1,'product:+margin:Margins:margins:$user->rights->margins->liretous:/margin/tabs/productMargins.php?id=__ID__','chaine',0,NULL,'2018-05-18 19:18:41'),(134,'MAIN_MODULE_MARGIN_TABS_1',1,'thirdparty:+margin:Margins:margins:empty($user->societe_id) && $user->rights->margins->liretous && ($object->client > 0):/margin/tabs/thirdpartyMargins.php?socid=__ID__','chaine',0,NULL,'2018-05-18 19:18:41'),(135,'MARGIN_TYPE',1,'costprice','chaine',0,'Rule for margin calculation by default','2018-05-18 19:18:41'),(136,'MAIN_MODULE_PRODUCT',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:41'),(137,'PRODUCT_CODEPRODUCT_ADDON',1,'mod_codeproduct_leopard','chaine',0,'Module to control product codes','2018-05-18 19:18:41'),(140,'MAIN_COMPANY_CODE_ALWAYS_REQUIRED',1,'1','chaine',0,'With this constants on, third party code is always required whatever is numbering module behaviour','2018-05-18 19:18:46'),(142,'ACCOUNTING_ACCOUNT_SUSPENSE',1,'471','chaine',0,NULL,'2018-05-18 19:18:46'),(143,'ACCOUNTING_ACCOUNT_TRANSFER_CASH',1,'58','chaine',0,NULL,'2018-05-18 19:18:46'),(144,'CHARTOFACCOUNTS',1,'2','chaine',0,NULL,'2018-05-18 19:18:46'),(145,'ACCOUNTING_EXPORT_MODELCSV',1,'1','chaine',0,NULL,'2018-05-18 19:18:46'),(146,'ACCOUNTING_LENGTH_GACCOUNT',1,'','chaine',0,NULL,'2018-05-18 19:18:46'),(147,'ACCOUNTING_LENGTH_AACCOUNT',1,'','chaine',0,NULL,'2018-05-18 19:18:46'),(148,'ACCOUNTING_LIST_SORT_VENTILATION_TODO',1,'1','yesno',0,NULL,'2018-05-18 19:18:46'),(149,'ACCOUNTING_LIST_SORT_VENTILATION_DONE',1,'1','yesno',0,NULL,'2018-05-18 19:18:46'),(150,'ACCOUNTING_EXPORT_DATE',1,'%d%m%Y','chaine',0,NULL,'2018-05-18 19:18:46'),(151,'ACCOUNTING_EXPORT_SEPARATORCSV',1,',','string',0,NULL,'2018-05-18 19:18:46'),(152,'ACCOUNTING_EXPORT_FORMAT',1,'csv','chaine',0,NULL,'2018-05-18 19:18:46'),(153,'MAIN_MODULE_SERVICE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:55'),(154,'MAIN_MODULE_STOCK',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:18:59'),(155,'STOCK_ALLOW_NEGATIVE_TRANSFER',1,'1','chaine',1,NULL,'2018-05-18 19:18:59'),(157,'MAIN_MODULE_VARIANTS',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:09'),(158,'MAIN_MODULE_PROJET',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:12'),(159,'PROJECT_ADDON_PDF',1,'baleine','chaine',0,'Name of PDF/ODT project manager class','2018-05-18 19:19:12'),(160,'PROJECT_ADDON',1,'mod_project_simple','chaine',0,'Name of Numbering Rule project manager class','2018-05-18 19:19:12'),(161,'PROJECT_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/projects','chaine',0,NULL,'2018-05-18 19:19:12'),(162,'PROJECT_TASK_ADDON_PDF',1,'','chaine',0,'Name of PDF/ODT tasks manager class','2018-05-18 19:19:12'),(163,'PROJECT_TASK_ADDON',1,'mod_task_simple','chaine',0,'Name of Numbering Rule task manager class','2018-05-18 19:19:12'),(164,'PROJECT_TASK_ADDON_PDF_ODT_PATH',1,'DOL_DATA_ROOT/doctemplates/tasks','chaine',0,NULL,'2018-05-18 19:19:12'),(165,'PROJECT_USE_OPPORTUNITIES',1,'1','chaine',0,NULL,'2018-05-18 19:19:12'),(166,'MAIN_DELAY_PROJECT_TO_CLOSE',1,'7','chaine',0,NULL,'2018-05-18 19:19:12'),(167,'MAIN_DELAY_TASKS_TODO',1,'7','chaine',0,NULL,'2018-05-18 19:19:12'),(168,'MAIN_MODULE_AGENDA',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:14'),(169,'MAIN_AGENDA_ACTIONAUTO_COMPANY_CREATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(170,'MAIN_AGENDA_ACTIONAUTO_COMPANY_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(171,'MAIN_AGENDA_ACTIONAUTO_PROPAL_CLASSIFY_BILLED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(172,'MAIN_AGENDA_ACTIONAUTO_PROPAL_CLOSE_REFUSED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(173,'MAIN_AGENDA_ACTIONAUTO_PROPAL_CLOSE_SIGNED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(174,'MAIN_AGENDA_ACTIONAUTO_PROPAL_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(175,'MAIN_AGENDA_ACTIONAUTO_PROPAL_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(176,'MAIN_AGENDA_ACTIONAUTO_ORDER_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(177,'MAIN_AGENDA_ACTIONAUTO_ORDER_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(178,'MAIN_AGENDA_ACTIONAUTO_ORDER_CANCEL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(179,'MAIN_AGENDA_ACTIONAUTO_ORDER_CLASSIFY_BILLED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(180,'MAIN_AGENDA_ACTIONAUTO_ORDER_CLOSE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(181,'MAIN_AGENDA_ACTIONAUTO_BILL_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(182,'MAIN_AGENDA_ACTIONAUTO_BILL_PAYED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(183,'MAIN_AGENDA_ACTIONAUTO_BILL_CANCEL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(184,'MAIN_AGENDA_ACTIONAUTO_BILL_UNVALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(185,'MAIN_AGENDA_ACTIONAUTO_BILL_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(186,'MAIN_AGENDA_ACTIONAUTO_PROPOSAL_SUPPLIER_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(187,'MAIN_AGENDA_ACTIONAUTO_PROPOSAL_SUPPLIER_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(188,'MAIN_AGENDA_ACTIONAUTO_PROPOSAL_SUPPLIER_CLOSE_SIGNED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(189,'MAIN_AGENDA_ACTIONAUTO_PROPOSAL_SUPPLIER_CLOSE_REFUSED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(190,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(191,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_REFUSE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(192,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_RECEIVE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(193,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_SUBMIT',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(194,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_APPROVE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(195,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(196,'MAIN_AGENDA_ACTIONAUTO_ORDER_SUPPLIER_CLASSIFY_BILLED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(197,'MAIN_AGENDA_ACTIONAUTO_BILL_SUPPLIER_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(198,'MAIN_AGENDA_ACTIONAUTO_BILL_SUPPLIER_UNVALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(199,'MAIN_AGENDA_ACTIONAUTO_BILL_SUPPLIER_PAYED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(200,'MAIN_AGENDA_ACTIONAUTO_BILL_SUPPLIER_CANCELED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(201,'MAIN_AGENDA_ACTIONAUTO_BILL_SUPPLIER_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(202,'MAIN_AGENDA_ACTIONAUTO_CONTRACT_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(203,'MAIN_AGENDA_ACTIONAUTO_CONTRACT_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(204,'MAIN_AGENDA_ACTIONAUTO_SHIPPING_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(205,'MAIN_AGENDA_ACTIONAUTO_SHIPPING_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(206,'MAIN_AGENDA_ACTIONAUTO_MEMBER_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(207,'MAIN_AGENDA_ACTIONAUTO_MEMBER_MODIFY',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(208,'MAIN_AGENDA_ACTIONAUTO_MEMBER_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(209,'MAIN_AGENDA_ACTIONAUTO_MEMBER_SUBSCRIPTION_CREATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(210,'MAIN_AGENDA_ACTIONAUTO_MEMBER_SUBSCRIPTION_DELETE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(211,'MAIN_AGENDA_ACTIONAUTO_MEMBER_SUBSCRIPTION_MODIFY',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(212,'MAIN_AGENDA_ACTIONAUTO_MEMBER_RESILIATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(213,'MAIN_AGENDA_ACTIONAUTO_MEMBER_DELETE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(214,'MAIN_AGENDA_ACTIONAUTO_FICHINTER_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(215,'MAIN_AGENDA_ACTIONAUTO_FICHINTER_MODIFY',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(216,'MAIN_AGENDA_ACTIONAUTO_FICHINTER_CLASSIFY_BILLED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(217,'MAIN_AGENDA_ACTIONAUTO_FICHINTER_CLASSIFY_UNBILLED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(218,'MAIN_AGENDA_ACTIONAUTO_FICHINTER_REOPEN',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(219,'MAIN_AGENDA_ACTIONAUTO_FICHINTER_SENTBYMAIL',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(220,'MAIN_AGENDA_ACTIONAUTO_PRODUCT_CREATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(221,'MAIN_AGENDA_ACTIONAUTO_PRODUCT_MODIFY',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(222,'MAIN_AGENDA_ACTIONAUTO_PRODUCT_DELETE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(223,'MAIN_AGENDA_ACTIONAUTO_PROJECT_CREATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(224,'MAIN_AGENDA_ACTIONAUTO_PROJECT_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(225,'MAIN_AGENDA_ACTIONAUTO_PROJECT_MODIFY',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(226,'MAIN_AGENDA_ACTIONAUTO_PROJECT_DELETE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(227,'MAIN_AGENDA_ACTIONAUTO_EXPENSE_REPORT_CREATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(228,'MAIN_AGENDA_ACTIONAUTO_EXPENSE_REPORT_VALIDATE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(229,'MAIN_AGENDA_ACTIONAUTO_EXPENSE_REPORT_APPROVE',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(230,'MAIN_AGENDA_ACTIONAUTO_EXPENSE_REPORT_PAYED',1,'1','chaine',0,NULL,'2018-05-18 19:19:14'),(231,'MAIN_MODULE_RESOURCE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:16'),(232,'MAIN_MODULE_ECM',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:23'),(233,'ECM_AUTO_TREE_ENABLED',1,'1','chaine',0,'Auto tree is enabled by default','2018-05-18 19:19:23'),(234,'MAIN_MODULE_CATEGORIE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:25'),(235,'CATEGORIE_RECURSIV_ADD',1,'0','yesno',0,'Affect parent categories','2018-05-18 19:19:25'),(236,'MAIN_MODULE_FCKEDITOR',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:28'),(237,'FCKEDITOR_ENABLE_SOCIETE',1,'1','yesno',0,'WYSIWIG for description and note (except products/services)','2018-05-18 19:19:28'),(238,'FCKEDITOR_ENABLE_PRODUCTDESC',1,'1','yesno',0,'WYSIWIG for products/services description and note','2018-05-18 19:19:28'),(239,'FCKEDITOR_ENABLE_MAILING',1,'1','yesno',0,'WYSIWIG for mass emailings','2018-05-18 19:19:28'),(240,'FCKEDITOR_ENABLE_DETAILS',1,'1','yesno',0,'WYSIWIG for products details lines for all entities','2018-05-18 19:19:28'),(241,'FCKEDITOR_ENABLE_USERSIGN',1,'1','yesno',0,'WYSIWIG for user signature','2018-05-18 19:19:28'),(242,'FCKEDITOR_ENABLE_MAIL',1,'1','yesno',0,'WYSIWIG for products details lines for all entities','2018-05-18 19:19:28'),(243,'FCKEDITOR_SKIN',1,'moono-lisa','string',0,'Skin by default for fckeditor','2018-05-18 19:19:28'),(244,'MAIN_MODULE_MULTICURRENCY',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:31'),(245,'MAIN_MODULE_MAILING',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:34'),(246,'MAIN_MODULE_BOOKMARK',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:38'),(247,'MAIN_MODULE_BARCODE',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:41'),(248,'MAIN_MODULE_WORKFLOW',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:43'),(249,'MAIN_MODULE_IMPORT',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:44'),(250,'MAIN_MODULE_EXPORT',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:19:47'),(251,'MAIN_MODULE_CASHDESK',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:20:23'),(252,'MAIN_MODULE_WEBSERVICES',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:20:34'),(253,'MAIN_MODULE_API',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:20:38'),(254,'MAIN_MODULE_CLICKTODIAL',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:20:46'),(255,'MAIN_MODULE_NOTIFICATION',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:20:52'),(256,'MAIN_MODULE_OAUTH',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:20:57'),(257,'MAIN_MODULE_PRINTING',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:21:02'),(258,'MAIN_MODULE_SYSLOG',0,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:21:07'),(259,'MAIN_MODULE_CRON',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:21:09'),(260,'CRON_KEY',0,'','chaine',0,'CRON KEY','2018-05-18 19:21:09'),(261,'BLOCKEDLOG_ENTITY_FINGERPRINT',1,'7545a3ca6b951a0efa5be8e1df5901a8669a85dd4bcaf8d302be45e1a33faec5','chaine',0,'Numeric Unique Fingerprint','2018-05-18 19:21:14'),(262,'MAIN_MODULE_BLOCKEDLOG',1,'1',NULL,0,'{\"authorid\":\"1\",\"ip\":\"87.66.160.185\"}','2018-05-18 19:21:14'),(263,'BLOCKEDLOG_DISABLE_NOT_ALLOWED_FOR_COUNTRY',1,'FR','chaine',0,'This is list of country code where the module may be mandatory','2018-05-18 19:21:14'),(294,'MAIN_LANG_DEFAULT',1,'fr_BE','chaine',0,'','2018-05-18 19:38:57'),(295,'MAIN_MULTILANGS',1,'1','chaine',0,'','2018-05-18 19:38:57'),(296,'MAIN_THEME',1,'md','chaine',0,'','2018-05-18 19:38:57'),(297,'THEME_ELDY_USE_HOVER',1,'0','chaine',0,'','2018-05-18 19:38:57'),(298,'MAIN_SIZE_LISTE_LIMIT',1,'25','chaine',0,'','2018-05-18 19:38:57'),(299,'MAIN_SIZE_SHORTLIST_LIMIT',1,'3','chaine',0,'','2018-05-18 19:38:57'),(300,'MAIN_DISABLE_JAVASCRIPT',1,'0','chaine',0,'','2018-05-18 19:38:57'),(301,'MAIN_BUTTON_HIDE_UNAUTHORIZED',1,'0','chaine',0,'','2018-05-18 19:38:57'),(302,'MAIN_START_WEEK',1,'1','chaine',0,'','2018-05-18 19:38:57'),(303,'MAIN_DEFAULT_WORKING_DAYS',1,'1-5','chaine',0,'','2018-05-18 19:38:57'),(304,'MAIN_DEFAULT_WORKING_HOURS',1,'9-18','chaine',0,'','2018-05-18 19:38:57'),(305,'MAIN_SHOW_LOGO',1,'1','chaine',0,'','2018-05-18 19:38:57'),(306,'MAIN_FIRSTNAME_NAME_POSITION',1,'0','chaine',0,'','2018-05-18 19:38:57'),(307,'MAIN_HELPCENTER_DISABLELINK',0,'0','chaine',0,'','2018-05-18 19:38:57'),(308,'MAIN_HELP_DISABLELINK',0,'0','chaine',0,'','2018-05-18 19:38:57'),(309,'MAIN_BUGTRACK_ENABLELINK',1,'0','chaine',0,'','2018-05-18 19:38:57'),(316,'MAIN_INFO_SOCIETE_LOGO',1,'Diapositive06.jpg','chaine',0,'','2018-05-22 05:59:29'),(317,'MAIN_INFO_SOCIETE_LOGO_SMALL',1,'Diapositive06_small.jpg','chaine',0,'','2018-05-22 05:59:29'),(318,'MAIN_INFO_SOCIETE_LOGO_MINI',1,'Diapositive06_mini.jpg','chaine',0,'','2018-05-22 05:59:29'),(360,'BANK_REPORT_LAST_NUM_RELEVE',1,'1','chaine',0,'','2018-06-12 09:41:16'),(361,'BANKADDON_PDF',1,'sepamandate','chaine',0,'','2018-06-12 09:41:20'),(363,'FACTURE_RIB_NUMBER',1,'1','chaine',0,'','2018-06-12 09:45:31'),(364,'FACTURE_CHQ_NUMBER',1,'-1','chaine',0,'','2018-06-12 09:45:31'),(365,'MAIN_MODULE_ACCOUNTING',1,'1',NULL,0,'{\"authorid\":\"2\",\"ip\":\"77.111.247.59\"}','2018-06-12 11:38:23'),(366,'MAIN_BANK_ACCOUNTANCY_CODE_ALWAYS_REQUIRED',1,'1','chaine',0,'With this constants on, bank account number is always required','2018-06-12 11:38:23'),(367,'MAIN_INFO_SOCIETE_COUNTRY',1,'2:BE:Belgique','chaine',0,'','2018-06-12 11:42:10'),(368,'MAIN_INFO_SOCIETE_NOM',1,'Loca Box','chaine',0,'','2018-06-12 11:42:10'),(369,'MAIN_INFO_SOCIETE_ADDRESS',1,'62 Rue des Trois Arbres','chaine',0,'','2018-06-12 11:42:10'),(370,'MAIN_INFO_SOCIETE_TOWN',1,'Bruxelles','chaine',0,'','2018-06-12 11:42:10'),(371,'MAIN_INFO_SOCIETE_ZIP',1,'1180','chaine',0,'','2018-06-12 11:42:10'),(372,'MAIN_INFO_SOCIETE_STATE',1,'0','chaine',0,'','2018-06-12 11:42:10'),(373,'MAIN_MONNAIE',1,'EUR','chaine',0,'','2018-06-12 11:42:10'),(374,'MAIN_INFO_SOCIETE_TEL',1,'+3228808440','chaine',0,'','2018-06-12 11:42:10'),(375,'MAIN_INFO_SOCIETE_FAX',1,'+3228808441','chaine',0,'','2018-06-12 11:42:10'),(376,'MAIN_INFO_SOCIETE_MAIL',1,'info@loca-box.be','chaine',0,'','2018-06-12 11:42:10'),(377,'MAIN_INFO_SOCIETE_MANAGERS',1,'Chokri Abdelkafi','chaine',0,'','2018-06-12 11:42:10'),(378,'MAIN_INFO_SOCIETE_FORME_JURIDIQUE',1,'0','chaine',0,'','2018-06-12 11:42:10'),(379,'MAIN_INFO_TVAINTRA',1,'BE0689921012','chaine',0,'','2018-06-12 11:42:10'),(380,'SOCIETE_FISCAL_MONTH_START',1,'1','chaine',0,'','2018-06-12 11:42:10'),(381,'FACTURE_TVAOPTION',1,'1','chaine',0,'','2018-06-12 11:42:10'),(454,'MAIN_DISABLE_ALL_MAILS',1,'0','chaine',0,'','2018-09-17 10:10:15'),(455,'MAIN_MAIL_SENDMODE',1,'smtps','chaine',0,'','2018-09-17 10:10:15'),(456,'MAIN_MAIL_SMTP_PORT',1,'465','chaine',0,'','2018-09-17 10:10:15'),(457,'MAIN_MAIL_SMTP_SERVER',1,'SSL0.ovh.net','chaine',0,'','2018-09-17 10:10:15'),(458,'MAIN_MAIL_SMTPS_ID',1,'info@loca-box.be','chaine',0,'','2018-09-17 10:10:15'),(459,'MAIN_MAIL_SMTPS_PW',1,'4626locabox4626','chaine',0,'','2018-09-17 10:10:15'),(460,'MAIN_MAIL_EMAIL_TLS',1,'1','chaine',0,'','2018-09-17 10:10:15'),(461,'MAIN_MAIL_EMAIL_STARTTLS',1,'0','chaine',0,'','2018-09-17 10:10:15'),(462,'MAIN_MAIL_EMAIL_FROM',1,'info@loca-box.be','chaine',0,'','2018-09-17 10:10:15'),(463,'MAIN_MAIL_ERRORS_TO',1,'info@loca-box.be','chaine',0,'','2018-09-17 10:10:15'),(464,'MAIN_MAIL_AUTOCOPY_TO',1,'info@loca-box.be','chaine',0,'','2018-09-17 10:10:15'),(465,'MAIN_MAIL_DEFAULT_FROMTYPE',1,'company','chaine',0,'','2018-09-17 10:10:15');
/*!40000 ALTER TABLE `llx_const` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contrat`
--

DROP TABLE IF EXISTS `llx_contrat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_contrat` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) DEFAULT NULL,
  `ref_customer` varchar(255) DEFAULT NULL,
  `ref_supplier` varchar(255) DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `date_contrat` datetime DEFAULT NULL,
  `statut` smallint(6) DEFAULT '0',
  `mise_en_service` datetime DEFAULT NULL,
  `fin_validite` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `fk_commercial_signature` int(11) DEFAULT NULL,
  `fk_commercial_suivi` int(11) DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL DEFAULT '0',
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_mise_en_service` int(11) DEFAULT NULL,
  `fk_user_cloture` int(11) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_contrat_ref` (`ref`,`entity`),
  KEY `idx_contrat_fk_soc` (`fk_soc`),
  KEY `idx_contrat_fk_user_author` (`fk_user_author`),
  CONSTRAINT `fk_contrat_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_contrat_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_contrat`
--

LOCK TABLES `llx_contrat` WRITE;
/*!40000 ALTER TABLE `llx_contrat` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_contrat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contrat_extrafields`
--

DROP TABLE IF EXISTS `llx_contrat_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_contrat_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_contrat_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_contrat_extrafields`
--

LOCK TABLES `llx_contrat_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_contrat_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_contrat_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contratdet`
--

DROP TABLE IF EXISTS `llx_contratdet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_contratdet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_contrat` int(11) NOT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `statut` smallint(6) DEFAULT '0',
  `label` text,
  `description` text,
  `fk_remise_except` int(11) DEFAULT NULL,
  `date_commande` datetime DEFAULT NULL,
  `date_ouverture_prevue` datetime DEFAULT NULL,
  `date_ouverture` datetime DEFAULT NULL,
  `date_fin_validite` datetime DEFAULT NULL,
  `date_cloture` datetime DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT '0.000',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double NOT NULL,
  `remise_percent` double DEFAULT '0',
  `subprice` double(24,8) DEFAULT '0.00000000',
  `price_ht` double DEFAULT NULL,
  `remise` double DEFAULT '0',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `product_type` int(11) DEFAULT '1',
  `info_bits` int(11) DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT NULL,
  `fk_product_fournisseur_price` int(11) DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL DEFAULT '0',
  `fk_user_ouverture` int(11) DEFAULT NULL,
  `fk_user_cloture` int(11) DEFAULT NULL,
  `commentaire` text,
  `fk_unit` int(11) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `idx_contratdet_fk_contrat` (`fk_contrat`),
  KEY `idx_contratdet_fk_product` (`fk_product`),
  KEY `idx_contratdet_date_ouverture_prevue` (`date_ouverture_prevue`),
  KEY `idx_contratdet_date_ouverture` (`date_ouverture`),
  KEY `idx_contratdet_date_fin_validite` (`date_fin_validite`),
  KEY `fk_contratdet_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_contratdet_fk_contrat` FOREIGN KEY (`fk_contrat`) REFERENCES `llx_contrat` (`rowid`),
  CONSTRAINT `fk_contratdet_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`),
  CONSTRAINT `fk_contratdet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_contratdet`
--

LOCK TABLES `llx_contratdet` WRITE;
/*!40000 ALTER TABLE `llx_contratdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_contratdet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contratdet_extrafields`
--

DROP TABLE IF EXISTS `llx_contratdet_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_contratdet_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_contratdet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_contratdet_extrafields`
--

LOCK TABLES `llx_contratdet_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_contratdet_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_contratdet_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_contratdet_log`
--

DROP TABLE IF EXISTS `llx_contratdet_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_contratdet_log` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_contratdet` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `statut` smallint(6) NOT NULL,
  `fk_user_author` int(11) NOT NULL,
  `commentaire` text,
  PRIMARY KEY (`rowid`),
  KEY `idx_contratdet_log_fk_contratdet` (`fk_contratdet`),
  KEY `idx_contratdet_log_date` (`date`),
  CONSTRAINT `fk_contratdet_log_fk_contratdet` FOREIGN KEY (`fk_contratdet`) REFERENCES `llx_contratdet` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_contratdet_log`
--

LOCK TABLES `llx_contratdet_log` WRITE;
/*!40000 ALTER TABLE `llx_contratdet_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_contratdet_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_cronjob`
--

DROP TABLE IF EXISTS `llx_cronjob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_cronjob` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `jobtype` varchar(10) NOT NULL,
  `label` text NOT NULL,
  `command` varchar(255) DEFAULT NULL,
  `classesname` varchar(255) DEFAULT NULL,
  `objectname` varchar(255) DEFAULT NULL,
  `methodename` varchar(255) DEFAULT NULL,
  `params` text,
  `md5params` varchar(32) DEFAULT NULL,
  `module_name` varchar(255) DEFAULT NULL,
  `priority` int(11) DEFAULT '0',
  `datelastrun` datetime DEFAULT NULL,
  `datenextrun` datetime DEFAULT NULL,
  `datestart` datetime DEFAULT NULL,
  `dateend` datetime DEFAULT NULL,
  `datelastresult` datetime DEFAULT NULL,
  `lastresult` text,
  `lastoutput` text,
  `unitfrequency` varchar(255) NOT NULL DEFAULT '3600',
  `frequency` int(11) NOT NULL DEFAULT '0',
  `maxrun` int(11) NOT NULL DEFAULT '0',
  `nbrun` int(11) DEFAULT NULL,
  `autodelete` int(11) DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '1',
  `processing` int(11) NOT NULL DEFAULT '0',
  `test` varchar(255) DEFAULT '1',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_mod` int(11) DEFAULT NULL,
  `fk_mailing` int(11) DEFAULT NULL,
  `note` text,
  `libname` varchar(255) DEFAULT NULL,
  `entity` int(11) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_cronjob_status` (`status`),
  KEY `idx_cronjob_datelastrun` (`datelastrun`),
  KEY `idx_cronjob_datenextrun` (`datenextrun`),
  KEY `idx_cronjob_datestart` (`datestart`),
  KEY `idx_cronjob_dateend` (`dateend`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_cronjob`
--

LOCK TABLES `llx_cronjob` WRITE;
/*!40000 ALTER TABLE `llx_cronjob` DISABLE KEYS */;
INSERT INTO `llx_cronjob` VALUES (1,'2018-05-18 19:18:24','2018-05-18 19:18:24','method','RecurringInvoices',NULL,'compta/facture/class/facture-rec.class.php','FactureRec','createRecurringInvoices',NULL,NULL,'facture',50,NULL,NULL,'2018-05-18 19:18:24',NULL,NULL,NULL,NULL,'86400',1,0,NULL,0,1,0,'1',NULL,NULL,NULL,'Generate recurring invoices',NULL,1),(2,'2018-05-18 19:19:14','2018-05-18 19:19:14','method','SendEmailsReminders',NULL,'comm/action/class/actioncomm.class.php','ActionComm','sendEmailsReminder',NULL,NULL,'agenda',10,NULL,NULL,'2018-05-18 19:19:14',NULL,NULL,NULL,NULL,'60',10,0,NULL,0,1,0,'1',NULL,NULL,NULL,'SendEMailsReminder',NULL,1),(3,'2018-05-18 19:21:09','2018-05-18 19:21:09','method','PurgeDeleteTemporaryFilesShort',NULL,'core/class/utils.class.php','Utils','purgeFiles',NULL,NULL,'cron',50,NULL,NULL,'2018-05-18 19:21:09',NULL,NULL,NULL,NULL,'604800',2,0,NULL,0,1,0,'1',NULL,NULL,NULL,'PurgeDeleteTemporaryFiles',NULL,0),(4,'2018-05-18 19:21:09','2018-05-18 19:21:09','method','MakeLocalDatabaseDumpShort',NULL,'core/class/utils.class.php','Utils','dumpDatabase','none,auto,1,auto,10',NULL,'cron',90,NULL,NULL,'2018-05-18 19:21:09',NULL,NULL,NULL,NULL,'604800',1,0,NULL,0,0,0,'1',NULL,NULL,NULL,'MakeLocalDatabaseDump',NULL,0);
/*!40000 ALTER TABLE `llx_cronjob` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_default_values`
--

DROP TABLE IF EXISTS `llx_default_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_default_values` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `type` varchar(10) DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `page` varchar(255) DEFAULT NULL,
  `param` varchar(255) DEFAULT NULL,
  `value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_default_values` (`type`,`entity`,`user_id`,`page`,`param`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_default_values`
--

LOCK TABLES `llx_default_values` WRITE;
/*!40000 ALTER TABLE `llx_default_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_default_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_deplacement`
--

DROP TABLE IF EXISTS `llx_deplacement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_deplacement` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `dated` datetime DEFAULT NULL,
  `fk_user` int(11) NOT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `type` varchar(12) NOT NULL,
  `fk_statut` int(11) NOT NULL DEFAULT '1',
  `km` double DEFAULT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `fk_projet` int(11) DEFAULT '0',
  `note_private` text,
  `note_public` text,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_deplacement`
--

LOCK TABLES `llx_deplacement` WRITE;
/*!40000 ALTER TABLE `llx_deplacement` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_deplacement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_document_model`
--

DROP TABLE IF EXISTS `llx_document_model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_document_model` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(50) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `type` varchar(20) NOT NULL,
  `libelle` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_document_model` (`nom`,`type`,`entity`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_document_model`
--

LOCK TABLES `llx_document_model` WRITE;
/*!40000 ALTER TABLE `llx_document_model` DISABLE KEYS */;
INSERT INTO `llx_document_model` VALUES (1,'standard',1,'expensereport',NULL,NULL),(2,'azur',1,'propal',NULL,NULL),(3,'einstein',1,'order',NULL,NULL),(4,'rouget',1,'shipping',NULL,NULL),(5,'typhon',1,'delivery',NULL,NULL),(6,'strato',1,'contract',NULL,NULL),(7,'soleil',1,'ficheinter',NULL,NULL),(8,'generic_user_odt',1,'user',NULL,NULL),(9,'muscadet',1,'order_supplier',NULL,NULL),(10,'standard',1,'member',NULL,NULL),(11,'aurore',1,'supplier_proposal',NULL,NULL),(12,'crabe',1,'invoice',NULL,NULL),(13,'html_cerfafr',1,'donation',NULL,NULL),(15,'',1,'task',NULL,NULL),(16,'sepamandate',1,'bankaccount','sepamandate',NULL);
/*!40000 ALTER TABLE `llx_document_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_don`
--

DROP TABLE IF EXISTS `llx_don`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_don` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_statut` smallint(6) NOT NULL DEFAULT '0',
  `datedon` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_payment` int(11) DEFAULT NULL,
  `paid` smallint(6) NOT NULL DEFAULT '0',
  `firstname` varchar(50) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `societe` varchar(50) DEFAULT NULL,
  `address` text,
  `zip` varchar(30) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `fk_country` int(11) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(24) DEFAULT NULL,
  `phone_mobile` varchar(24) DEFAULT NULL,
  `public` smallint(6) NOT NULL DEFAULT '1',
  `fk_projet` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_don`
--

LOCK TABLES `llx_don` WRITE;
/*!40000 ALTER TABLE `llx_don` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_don` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_don_extrafields`
--

DROP TABLE IF EXISTS `llx_don_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_don_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_don_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_don_extrafields`
--

LOCK TABLES `llx_don_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_don_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_don_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_ecm_directories`
--

DROP TABLE IF EXISTS `llx_ecm_directories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_ecm_directories` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(64) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_parent` int(11) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `cachenbofdoc` int(11) NOT NULL DEFAULT '0',
  `fullpath` varchar(750) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `date_c` datetime DEFAULT NULL,
  `date_m` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_c` int(11) DEFAULT NULL,
  `fk_user_m` int(11) DEFAULT NULL,
  `acl` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_ecm_directories` (`label`,`fk_parent`,`entity`),
  KEY `idx_ecm_directories_fk_user_c` (`fk_user_c`),
  KEY `idx_ecm_directories_fk_user_m` (`fk_user_m`),
  CONSTRAINT `fk_ecm_directories_fk_user_c` FOREIGN KEY (`fk_user_c`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_ecm_directories_fk_user_m` FOREIGN KEY (`fk_user_m`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_ecm_directories`
--

LOCK TABLES `llx_ecm_directories` WRITE;
/*!40000 ALTER TABLE `llx_ecm_directories` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_ecm_directories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_ecm_files`
--

DROP TABLE IF EXISTS `llx_ecm_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_ecm_files` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) DEFAULT NULL,
  `label` varchar(128) NOT NULL,
  `share` varchar(128) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `filepath` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `src_object_type` varchar(32) DEFAULT NULL,
  `src_object_id` int(11) DEFAULT NULL,
  `fullpath_orig` varchar(750) DEFAULT NULL,
  `description` text,
  `keywords` varchar(750) DEFAULT NULL,
  `cover` text,
  `position` int(11) DEFAULT NULL,
  `gen_or_uploaded` varchar(12) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `date_c` datetime DEFAULT NULL,
  `date_m` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_c` int(11) DEFAULT NULL,
  `fk_user_m` int(11) DEFAULT NULL,
  `acl` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_ecm_files` (`filepath`,`filename`),
  KEY `idx_ecm_files_label` (`label`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_ecm_files`
--

LOCK TABLES `llx_ecm_files` WRITE;
/*!40000 ALTER TABLE `llx_ecm_files` DISABLE KEYS */;
INSERT INTO `llx_ecm_files` VALUES (1,'7380ef2da24bb80bc544dd716e727297','394aa9f22060cdaa13bad236c9fdb2a6',NULL,1,'facture/(PROV2)','(PROV2).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-06-12 09:58:45','2018-06-12 11:51:40',1,1,NULL),(2,'475e990092b20bd7eb4038defce65117','705464c8e73a800aa035aef08551fab3',NULL,1,'facture/FA1806-0001','FA1806-0001.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-06-12 11:51:46','2018-07-06 09:45:21',2,1,NULL),(3,'b8adc379e00fad6b98d921d2fdb43cd6','f351a0c6d7833280b80d8393affcc81f',NULL,1,'facture/(PROV3)','(PROV3).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-06 09:24:37','2018-07-06 07:24:37',1,NULL,NULL),(4,'44f6a5b55988ad0edfc933e3882ca1fc','fb0f7a24497f4e30afa906bb44598622',NULL,1,'facture/FA1807-0002','FA1807-0002.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-06 09:24:41','2018-07-06 09:45:37',1,1,NULL),(5,'b0aee02b4104652221ebf712da26c6d1','558ac8a00b43355e4021d0efb8df574d',NULL,1,'facture/(PROV4)','(PROV4).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-06 09:39:45','2018-07-06 09:40:57',1,1,NULL),(6,'c4357effe15faf0f9614e8395687e557','a0fe26c7af98be106f5cf0357d10d561',NULL,1,'facture/FA1807-0003','FA1807-0003.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-06 09:41:00','2018-07-20 06:45:20',1,1,NULL),(7,'1781d376ad4469090efa8cb924840437','1064dd9a7e83a4c6151d96fe2fb7fcf3',NULL,1,'facture/(PROV5)','(PROV5).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-20 06:42:50','2018-07-20 04:42:50',1,NULL,NULL),(8,'88e275cd76c423a7b217eec30f384432','49602fc4b601d7689deb17ae3b341072',NULL,1,'facture/FA1807-0004','FA1807-0004.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-20 06:42:56','2018-08-24 09:08:47',1,1,NULL),(9,'3ec973180c7de490e1d1deb243745753','81429de1c2519ac25c68e3f294ebb9f1',NULL,1,'facture/(PROV6)','(PROV6).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-20 06:44:14','2018-07-20 04:44:14',1,NULL,NULL),(10,'a42af608cc9e592768a048ad0d85d63e','0089095cddcf523b576e0cbc3d1147a3',NULL,1,'facture/FA1807-0005','FA1807-0005.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-20 06:44:17','2018-08-24 09:08:47',1,1,NULL),(11,'bd8ad0330f79670b4923a4463669b2b5','0d5a707ea8ace477ceadc30d7602eaa6',NULL,1,'facture/(PROV7)','(PROV7).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-30 10:09:43','2018-07-30 08:09:43',1,NULL,NULL),(12,'71601ecad28bc7c392928a66a342f1a8','e789015c548c1c6d5f35fb4ce5e4f7d4',NULL,1,'facture/FA1807-0006','FA1807-0006.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-07-30 10:09:48','2018-07-30 08:09:48',1,NULL,NULL),(13,'328a65d344daa36b84846a08afc45d62','e9e8264de71031e4004c2a6bf3a84816',NULL,1,'facture/(PROV9)','(PROV9).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-08-24 08:59:25','2018-08-24 06:59:25',1,NULL,NULL),(14,'8b86d58492d050e24677dbe1ec172ac5','698a3b5ef06540072f6c29583dda2092',NULL,1,'facture/AV1808-0001','AV1808-0001.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-08-24 08:59:35','2018-08-24 09:09:04',1,1,NULL),(15,'c52cfea197a5b3f1a4c0ce095901c500','7a89479925a6a86e6adda166ccde97b3',NULL,1,'facture/(PROV10)','(PROV10).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-08-24 09:04:32','2018-08-24 07:04:32',1,NULL,NULL),(16,'12f312c619de1053070e2684af25d8c4','7ed1f8a563cef0ab23a3e2574848bbd5',NULL,1,'facture/FA1808-0007','FA1808-0007.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-08-24 09:04:55','2018-10-04 09:35:44',1,1,NULL),(17,'7c6504902cef1f922439bfdfe3cd1a3d','fde397cda397766c39a9f8952c570dc9',NULL,1,'facture/(PROV11)','(PROV11).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-10 10:54:02','2018-09-10 08:54:02',1,NULL,NULL),(20,'16e955f634e96771b9a069354fbd3232','875639c37b6401a6aa7e7e627f5fc0a4',NULL,1,'facture/(PROV15)','(PROV15).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:32:32','2018-09-19 09:32:32',1,NULL,NULL),(21,'bca00069fcf6f0b584f35f6dbdafb0fd','8184a25603d74351bf5a476f7e13dcf7',NULL,1,'facture/AV1809-0002','AV1809-0002.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:32:39','2018-10-04 09:36:50',1,1,NULL),(22,'baa9f3483b47bc040c4d1ac8fcc98782','97def13259162cee562acc4b46c13ea5',NULL,1,'facture/(PROV14)','(PROV14).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:34:11','2018-09-19 11:35:15',1,1,NULL),(23,'c14ee824a096988384bec8d9cae0aca2','a3428713f046c6903a23a4b301676f44',NULL,1,'facture/FA1809-0008','FA1809-0008.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:35:18','2018-10-04 09:36:33',1,1,NULL),(24,'9b9df2732e662b614a904740b88180b0','cabf433ff3840b09466912e8ea9e60ba',NULL,1,'facture/(PROV16)','(PROV16).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:35:48','2018-09-19 09:35:48',1,NULL,NULL),(25,'0c74928e99a88d3b18b7433471cd0055','462b04b0dda445c2f6677fcddb3341a6',NULL,1,'facture/FA1809-0009','FA1809-0009.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:35:51','2018-10-04 09:36:33',1,1,NULL),(26,'21390ed7c8f4a6518424d4d2b79aa326','c4088d708a0ef7da6678ecf73f5a10c2',NULL,1,'facture/(PROV17)','(PROV17).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:36:23','2018-09-19 09:36:23',1,NULL,NULL),(27,'cd1395888545697901dd7034972f0f4b','0585f916be93f8ffffaed7a978dcd24c',NULL,1,'facture/FA1809-0010','FA1809-0010.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-19 11:36:27','2018-10-04 09:36:33',1,1,NULL),(28,'d8cbaf60b3ec8c4fd28419dc168627c6','5a3fec34656c780c4e375b59a1a42058',NULL,1,'facture/(PROV18)','(PROV18).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-20 12:22:31','2018-09-20 10:22:31',1,NULL,NULL),(29,'195b7662053b9c63ca5a89c5c41c9648','42a36e66268fa8ef2a690d04f526436f',NULL,1,'facture/FA1809-0011','FA1809-0011.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-09-20 12:22:38','2018-10-04 09:34:50',1,1,NULL),(30,'38f6797f94c568be4100a3dc67a100b1','51f9a67e753bd2727ef2fbfa6eeed94d',NULL,1,'facture/(PROV19)','(PROV19).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-10-04 09:26:33','2018-10-04 07:26:33',1,NULL,NULL),(31,'aa49e4244ff143b37b51e7899374904c','8482ce73ffeff537dea9f5399d7b4c82',NULL,1,'facture/FA1810-0012','FA1810-0012.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-10-04 09:26:37','2018-10-04 07:26:37',1,NULL,NULL),(32,'3ef2c61a7dd3e3f802740142b549fcbb','095c92190820f19c8ace14e3608ee9e8',NULL,1,'facture/(PROV20)','(PROV20).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-12 08:51:18','2018-11-12 07:51:18',1,NULL,NULL),(33,'bcac1d7ad70ac7133cd5fbba468bff5a','c63935a3b04dc7288c67b0d209331c44',NULL,1,'facture/FA1810-0013','FA1810-0013.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-12 08:51:22','2018-11-12 07:51:22',1,NULL,NULL),(34,'08c4a80f77df73caf30e8a2ed5d43445','90ec223ce7de018f93c2772592900d2d',NULL,1,'facture/(PROV21)','(PROV21).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-12 08:59:33','2018-11-12 07:59:33',1,NULL,NULL),(35,'3ee9aa3846eb4e86e43c68d5e347890e','204fc4af08e78ff6bab8c82e70aff684',NULL,1,'facture/FA1810-0014','FA1810-0014.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-12 08:59:39','2018-11-12 07:59:39',1,NULL,NULL),(36,'b4e36afed9d87f161694e6451478b140','04ce083f50c61cac5bcf441af3998a86',NULL,1,'facture/(PROV22)','(PROV22).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-12 09:01:44','2018-11-12 08:01:44',1,NULL,NULL),(37,'06dfed830f42c5c659f2fa17dc80bbe9','f95e05015c0c78b85684548ec666bc68',NULL,1,'facture/FA1810-0015','FA1810-0015.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-12 09:01:47','2018-11-12 08:01:47',1,NULL,NULL),(38,'80fe410c3885107ff2534c27dcef025f','132d80ce65ad3e16c1ddd38a2cd719ac',NULL,1,'facture/(PROV23)','(PROV23).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-20 11:20:14','2018-11-20 10:20:14',1,NULL,NULL),(39,'f87653d1cc89348a7effe471afc2c05a','6a17ecf10468cdfb20fd365c33a7845a',NULL,1,'facture/FA1811-0016','FA1811-0016.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-20 11:20:30','2018-12-07 10:21:46',1,1,NULL),(40,'cf4f44afc793b58d365c684218c03567','4a104afaa2a3f7dc61b80382a0142206',NULL,1,'facture/(PROV24)','(PROV24).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-21 10:47:19','2018-11-21 09:47:19',1,NULL,NULL),(41,'d44781492f0d00574bae7e904ff66eb4','51a4969423ff066e24f3c43e38b9f517',NULL,1,'facture/FA1811-0017','FA1811-0017.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-11-21 10:47:23','2018-11-21 10:50:28',1,1,NULL),(42,'6002385231b5a54a9d55de82b31b3a94','ced053424b244c6bfff1aece3b4f4486',NULL,1,'facture/(PROV25)','(PROV25).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 09:13:12','2018-12-07 08:13:12',1,NULL,NULL),(43,'0a5c754b191c34968ce44847fc294d1e','1b4c9f7d5a6378f74c3fb4620dbc95c7',NULL,1,'facture/FA1812-0018','FA1812-0018.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 09:13:16','2018-12-07 08:13:16',1,NULL,NULL),(44,'a298cafc648180d33e626227a797a5d5','35fcbb8351e5db2299c9135545a52cee',NULL,1,'facture/(PROV26)','(PROV26).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 09:17:07','2018-12-07 08:17:07',1,NULL,NULL),(45,'6cceed990dccd987ea96b3713bbaa5e3','43367004641af0342b52afb7a4c2c5c0',NULL,1,'facture/FA1812-0019','FA1812-0019.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 09:17:11','2018-12-07 08:17:11',1,NULL,NULL),(46,'ef71c7480c6b887f9efb15809bac8f46','67e6bc9138374339efff863220b0306e',NULL,1,'facture/(PROV27)','(PROV27).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 11:00:42','2018-12-07 10:00:42',1,NULL,NULL),(47,'d963d8883352fa890764e9dc6cec916a','a54f6893709da34ba01b52e15b756d42',NULL,1,'facture/FA1812-0020','FA1812-0020.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 11:00:47','2018-12-07 10:00:47',1,NULL,NULL),(48,'129ffdb8af6d1b2eb04e3506c3685300','0eea606484b9d3bb79a25f151c82d0ad',NULL,1,'facture/(PROV28)','(PROV28).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 11:38:56','2018-12-07 10:38:56',1,NULL,NULL),(49,'deb741669e0f285fb34ce719c3198ef9','b44091d5887cda26d6356bd8c71a0d05',NULL,1,'facture/FA1812-0021','FA1812-0021.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2018-12-07 11:39:05','2018-12-07 10:39:05',1,NULL,NULL),(50,'5e3dbac6885cd6b16ec5ba901b4d8c36','d446a7bd710f66afd04428bcdaf878d4',NULL,1,'facture/(PROV29)','(PROV29).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:12:24','2019-01-07 10:12:24',1,NULL,NULL),(51,'6ce7ffd7d4b3a2c39ff0db419f3683dd','f8488b95131d2cf90ea66439709d8496',NULL,1,'facture/FA1901-0022','FA1901-0022.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:12:28','2019-01-07 10:12:28',1,NULL,NULL),(52,'ce8e859f1d34edb22eabea084102eada','9885cd5d9f52f9f2e2b072a19a12df0c',NULL,1,'facture/(PROV30)','(PROV30).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:21:21','2019-01-07 10:21:21',1,NULL,NULL),(53,'c6230d1b4275dc7f5ca3ccb6d488f2b1','a507ccd2fcbb5425076e5aa52cf00d5d',NULL,1,'facture/FA1901-0023','FA1901-0023.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:21:24','2019-01-07 10:21:24',1,NULL,NULL),(54,'31e630c3680bc6ffe669024a53ad6c3e','7afa5f14265541552666c93e7bb33714',NULL,1,'facture/(PROV31)','(PROV31).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:26:12','2019-01-07 10:26:12',1,NULL,NULL),(55,'a314ec8d78f2636069312aec9dd8e936','a3b6e4c0939f52276ff4639609484b17',NULL,1,'facture/FA1901-0024','FA1901-0024.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:26:18','2019-01-07 10:26:18',1,NULL,NULL),(56,'318adf2ebcf9b7a1e4c71debeaf5d741','f7b4ee4cb7f1d5bc9a56e891d63143bd',NULL,1,'facture/(PROV32)','(PROV32).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:26:54','2019-01-07 10:26:54',1,NULL,NULL),(57,'15edea10619899ae97f024cbaa06ea17','deb73f9bcefa1737683e719d24bca8e6',NULL,1,'facture/FA1901-0025','FA1901-0025.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-07 11:26:58','2019-01-07 10:26:58',1,NULL,NULL),(58,'b679d0a0fa581579a8c3e886f8508319','7d483e9670673533730a23899356cb47',NULL,1,'facture/(PROV33)','(PROV33).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-10 10:58:30','2019-01-10 09:58:30',1,NULL,NULL),(59,'d7121d9578aaf2c10e441fab000cf640','baab593fc63a3a1f7de5ac95e8f8efc7',NULL,1,'facture/FA1901-0026','FA1901-0026.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-10 10:58:42','2019-01-10 09:58:42',1,NULL,NULL),(60,'18825b19037e47d6f46b22c8f4623494','255c6db1bb71c815e5dd5fce6c3365f3',NULL,1,'facture/(PROV34)','(PROV34).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-15 08:21:36','2019-01-15 08:23:36',1,1,NULL),(61,'79a738be14c54c77a7b24b5269c16c98','da4ce62e4e068be845b13b0373b5d7ab',NULL,1,'facture/FA1901-0027','FA1901-0027.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-01-15 08:23:43','2019-01-15 07:23:43',1,NULL,NULL),(62,'0778d60276865efec255f07e800a755c','8f5ba67ec44b732ea4a4464278413d2c',NULL,1,'facture/(PROV35)','(PROV35).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:40:52','2019-02-05 10:40:52',1,NULL,NULL),(63,'f0e6955df3f98c39f2be0cb53d3b07f0','534485e5d6b005feab8ecefcb1d43109',NULL,1,'facture/FA1902-0028','FA1902-0028.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:40:57','2019-02-05 10:40:57',1,NULL,NULL),(64,'50a13c965a5862cda3d8397c40143acf','f92c811c6629228de2853bb228d0b8b8',NULL,1,'facture/(PROV36)','(PROV36).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:42:16','2019-02-05 10:42:16',1,NULL,NULL),(65,'9af608a2c4d08339964c37d5b182c6ae','58aa19fac431fcab3fad74b65d4f0ec7',NULL,1,'facture/FA1902-0029','FA1902-0029.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:42:20','2019-02-05 10:42:20',1,NULL,NULL),(66,'21fa7798892236ab6aa779415b285f85','b49ea9dcb23508fbe751021bb754c5d2',NULL,1,'facture/(PROV37)','(PROV37).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:43:08','2019-02-05 10:43:08',1,NULL,NULL),(67,'05ec6701a946286b5036e7aff44d4aa3','788903780389c560a9ec4c744e810b5d',NULL,1,'facture/FA1902-0030','FA1902-0030.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:43:11','2019-02-05 10:43:11',1,NULL,NULL),(68,'efd75c1e55c0555bd0b18453a52c2d3b','82f2e19f2ff0c52c3632929789d87ab9',NULL,1,'facture/(PROV38)','(PROV38).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:44:05','2019-02-05 10:44:05',1,NULL,NULL),(69,'a4feb02dfe39947c689ec49c8532fafa','0e45c6903c2001bd98d37cb22ab63c22',NULL,1,'facture/FA1902-0031','FA1902-0031.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:44:09','2019-02-05 10:44:09',1,NULL,NULL),(70,'90cfadecd886b9a25539d11038196fe1','929dd7322cc6802364b0eaf628968179',NULL,1,'facture/(PROV39)','(PROV39).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:48:56','2019-02-05 10:48:56',1,NULL,NULL),(71,'bbd4a7183df2d6a4e7f65da3db0a5be9','9cdd64252a59c21751d00719a38d1e5e',NULL,1,'facture/FA1902-0032','FA1902-0032.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 11:49:00','2019-02-05 11:55:55',1,1,NULL),(72,'55b11ea21fec6a0fbc78727691942f2a','d30262d27719045d37b2537287331924',NULL,1,'facture/(PROV40)','(PROV40).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 12:36:09','2019-02-05 11:36:09',1,NULL,NULL),(73,'bd6d4c0990827a0c1d022f97598a3c41','905a076dc90a9b01756902a3334423e3',NULL,1,'facture/FA1902-0033','FA1902-0033.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 12:36:14','2019-02-05 11:36:14',1,NULL,NULL),(74,'ae3ac18d9cc137931ba4d298e72ec95f','6c2998906295db315462ef1eeb8e92ce',NULL,1,'facture/(PROV41)','(PROV41).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 12:37:42','2019-02-05 11:37:42',1,NULL,NULL),(75,'e022fe334e522851859714217235134f','ef63fcd011b70addcfbbee823ff591f0',NULL,1,'facture/FA1902-0034','FA1902-0034.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-05 12:37:46','2019-02-05 12:43:48',1,1,NULL),(76,'c5b55cdfc7b4e70f228e62ccdf02393c','780785e5053c1f98adba6bd25872ac4a',NULL,1,'facture/(PROV42)','(PROV42).pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-14 11:54:46','2019-02-14 10:54:46',1,NULL,NULL),(77,'e4a212da3c33e1a4911200a0bc36108e','bd5d3e1aea1940b79010d589d3fc4b3a',NULL,1,'facture/FA1902-0035','FA1902-0035.pdf',NULL,NULL,'','',NULL,NULL,1,'generated',NULL,'2019-02-14 11:54:52','2019-02-14 10:54:52',1,NULL,NULL);
/*!40000 ALTER TABLE `llx_ecm_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_element_contact`
--

DROP TABLE IF EXISTS `llx_element_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_element_contact` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datecreate` datetime DEFAULT NULL,
  `statut` smallint(6) DEFAULT '5',
  `element_id` int(11) NOT NULL,
  `fk_c_type_contact` int(11) NOT NULL,
  `fk_socpeople` int(11) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_contact_idx1` (`element_id`,`fk_c_type_contact`,`fk_socpeople`),
  KEY `fk_element_contact_fk_c_type_contact` (`fk_c_type_contact`),
  KEY `idx_element_contact_fk_socpeople` (`fk_socpeople`),
  CONSTRAINT `fk_element_contact_fk_c_type_contact` FOREIGN KEY (`fk_c_type_contact`) REFERENCES `llx_c_type_contact` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_element_contact`
--

LOCK TABLES `llx_element_contact` WRITE;
/*!40000 ALTER TABLE `llx_element_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_element_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_element_element`
--

DROP TABLE IF EXISTS `llx_element_element`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_element_element` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_source` int(11) NOT NULL,
  `sourcetype` varchar(32) NOT NULL,
  `fk_target` int(11) NOT NULL,
  `targettype` varchar(32) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_element_idx1` (`fk_source`,`sourcetype`,`fk_target`,`targettype`),
  KEY `idx_element_element_fk_target` (`fk_target`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_element_element`
--

LOCK TABLES `llx_element_element` WRITE;
/*!40000 ALTER TABLE `llx_element_element` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_element_element` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_element_resources`
--

DROP TABLE IF EXISTS `llx_element_resources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_element_resources` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `element_id` int(11) DEFAULT NULL,
  `element_type` varchar(64) DEFAULT NULL,
  `resource_id` int(11) DEFAULT NULL,
  `resource_type` varchar(64) DEFAULT NULL,
  `busy` int(11) DEFAULT NULL,
  `mandatory` int(11) DEFAULT NULL,
  `duree` double DEFAULT NULL,
  `fk_user_create` int(11) DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_element_resources_idx1` (`resource_id`,`resource_type`,`element_id`,`element_type`),
  KEY `idx_element_element_element_id` (`element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_element_resources`
--

LOCK TABLES `llx_element_resources` WRITE;
/*!40000 ALTER TABLE `llx_element_resources` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_element_resources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_entrepot`
--

DROP TABLE IF EXISTS `llx_entrepot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_entrepot` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `entity` int(11) NOT NULL DEFAULT '1',
  `description` text,
  `lieu` varchar(64) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `fk_departement` int(11) DEFAULT NULL,
  `fk_pays` int(11) DEFAULT '0',
  `statut` tinyint(4) DEFAULT '1',
  `fk_user_author` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_parent` int(11) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_entrepot_label` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_entrepot`
--

LOCK TABLES `llx_entrepot` WRITE;
/*!40000 ALTER TABLE `llx_entrepot` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_entrepot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_establishment`
--

DROP TABLE IF EXISTS `llx_establishment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_establishment` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `name` varchar(50) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `zip` varchar(25) DEFAULT NULL,
  `town` varchar(50) DEFAULT NULL,
  `fk_state` int(11) DEFAULT '0',
  `fk_country` int(11) DEFAULT '0',
  `profid1` varchar(20) DEFAULT NULL,
  `profid2` varchar(20) DEFAULT NULL,
  `profid3` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `fk_user_author` int(11) NOT NULL,
  `fk_user_mod` int(11) DEFAULT NULL,
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_establishment`
--

LOCK TABLES `llx_establishment` WRITE;
/*!40000 ALTER TABLE `llx_establishment` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_establishment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_event_element`
--

DROP TABLE IF EXISTS `llx_event_element`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_event_element` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_source` int(11) NOT NULL,
  `fk_target` int(11) NOT NULL,
  `targettype` varchar(32) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_event_element`
--

LOCK TABLES `llx_event_element` WRITE;
/*!40000 ALTER TABLE `llx_event_element` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_event_element` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_events`
--

DROP TABLE IF EXISTS `llx_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_events` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` varchar(32) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `dateevent` datetime DEFAULT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `description` varchar(250) NOT NULL,
  `ip` varchar(250) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `fk_object` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_events_dateevent` (`dateevent`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_events`
--

LOCK TABLES `llx_events` WRITE;
/*!40000 ALTER TABLE `llx_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expedition`
--

DROP TABLE IF EXISTS `llx_expedition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expedition` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_customer` varchar(255) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `date_delivery` datetime DEFAULT NULL,
  `date_expedition` datetime DEFAULT NULL,
  `fk_address` int(11) DEFAULT NULL,
  `fk_shipping_method` int(11) DEFAULT NULL,
  `tracking_number` varchar(50) DEFAULT NULL,
  `fk_statut` smallint(6) DEFAULT '0',
  `billed` smallint(6) DEFAULT '0',
  `height` float DEFAULT NULL,
  `width` float DEFAULT NULL,
  `size_units` int(11) DEFAULT NULL,
  `size` float DEFAULT NULL,
  `weight_units` int(11) DEFAULT NULL,
  `weight` float DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_incoterms` int(11) DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_expedition_uk_ref` (`ref`,`entity`),
  KEY `idx_expedition_fk_soc` (`fk_soc`),
  KEY `idx_expedition_fk_user_author` (`fk_user_author`),
  KEY `idx_expedition_fk_user_valid` (`fk_user_valid`),
  KEY `idx_expedition_fk_shipping_method` (`fk_shipping_method`),
  CONSTRAINT `fk_expedition_fk_shipping_method` FOREIGN KEY (`fk_shipping_method`) REFERENCES `llx_c_shipment_mode` (`rowid`),
  CONSTRAINT `fk_expedition_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_expedition_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_expedition_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expedition`
--

LOCK TABLES `llx_expedition` WRITE;
/*!40000 ALTER TABLE `llx_expedition` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expedition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expedition_extrafields`
--

DROP TABLE IF EXISTS `llx_expedition_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expedition_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_expedition_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expedition_extrafields`
--

LOCK TABLES `llx_expedition_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_expedition_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expedition_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expeditiondet`
--

DROP TABLE IF EXISTS `llx_expeditiondet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expeditiondet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_expedition` int(11) NOT NULL,
  `fk_origin_line` int(11) DEFAULT NULL,
  `fk_entrepot` int(11) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `rang` int(11) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_expeditiondet_fk_expedition` (`fk_expedition`),
  CONSTRAINT `fk_expeditiondet_fk_expedition` FOREIGN KEY (`fk_expedition`) REFERENCES `llx_expedition` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expeditiondet`
--

LOCK TABLES `llx_expeditiondet` WRITE;
/*!40000 ALTER TABLE `llx_expeditiondet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expeditiondet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expeditiondet_batch`
--

DROP TABLE IF EXISTS `llx_expeditiondet_batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expeditiondet_batch` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_expeditiondet` int(11) NOT NULL,
  `eatby` date DEFAULT NULL,
  `sellby` date DEFAULT NULL,
  `batch` varchar(30) DEFAULT NULL,
  `qty` double NOT NULL DEFAULT '0',
  `fk_origin_stock` int(11) NOT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_fk_expeditiondet` (`fk_expeditiondet`),
  CONSTRAINT `fk_expeditiondet_batch_fk_expeditiondet` FOREIGN KEY (`fk_expeditiondet`) REFERENCES `llx_expeditiondet` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expeditiondet_batch`
--

LOCK TABLES `llx_expeditiondet_batch` WRITE;
/*!40000 ALTER TABLE `llx_expeditiondet_batch` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expeditiondet_batch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expeditiondet_extrafields`
--

DROP TABLE IF EXISTS `llx_expeditiondet_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expeditiondet_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_expeditiondet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expeditiondet_extrafields`
--

LOCK TABLES `llx_expeditiondet_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_expeditiondet_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expeditiondet_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expensereport`
--

DROP TABLE IF EXISTS `llx_expensereport`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expensereport` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `ref_number_int` int(11) DEFAULT NULL,
  `ref_ext` int(11) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `date_debut` date NOT NULL,
  `date_fin` date NOT NULL,
  `date_create` datetime NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_approve` datetime DEFAULT NULL,
  `date_refuse` datetime DEFAULT NULL,
  `date_cancel` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_author` int(11) NOT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_user_validator` int(11) DEFAULT NULL,
  `fk_user_approve` int(11) DEFAULT NULL,
  `fk_user_refuse` int(11) DEFAULT NULL,
  `fk_user_cancel` int(11) DEFAULT NULL,
  `fk_statut` int(11) NOT NULL,
  `fk_c_paiement` int(11) DEFAULT NULL,
  `paid` smallint(6) NOT NULL DEFAULT '0',
  `note_public` text,
  `note_private` text,
  `detail_refuse` varchar(255) DEFAULT NULL,
  `detail_cancel` varchar(255) DEFAULT NULL,
  `integration_compta` int(11) DEFAULT NULL,
  `fk_bank_account` int(11) DEFAULT NULL,
  `model_pdf` varchar(50) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_expensereport_uk_ref` (`ref`,`entity`),
  KEY `idx_expensereport_date_debut` (`date_debut`),
  KEY `idx_expensereport_date_fin` (`date_fin`),
  KEY `idx_expensereport_fk_statut` (`fk_statut`),
  KEY `idx_expensereport_fk_user_author` (`fk_user_author`),
  KEY `idx_expensereport_fk_user_valid` (`fk_user_valid`),
  KEY `idx_expensereport_fk_user_approve` (`fk_user_approve`),
  KEY `idx_expensereport_fk_refuse` (`fk_user_approve`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expensereport`
--

LOCK TABLES `llx_expensereport` WRITE;
/*!40000 ALTER TABLE `llx_expensereport` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expensereport` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expensereport_det`
--

DROP TABLE IF EXISTS `llx_expensereport_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expensereport_det` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_expensereport` int(11) NOT NULL,
  `fk_c_type_fees` int(11) NOT NULL,
  `fk_c_exp_tax_cat` int(11) DEFAULT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `comments` text NOT NULL,
  `product_type` int(11) DEFAULT '-1',
  `qty` double NOT NULL,
  `value_unit` double NOT NULL,
  `remise_percent` double DEFAULT NULL,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `total_ht` double(24,8) NOT NULL DEFAULT '0.00000000',
  `total_tva` double(24,8) NOT NULL DEFAULT '0.00000000',
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) NOT NULL DEFAULT '0.00000000',
  `date` date NOT NULL,
  `info_bits` int(11) DEFAULT '0',
  `special_code` int(11) DEFAULT '0',
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_facture` int(11) DEFAULT '0',
  `fk_code_ventilation` int(11) DEFAULT '0',
  `rang` int(11) DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `rule_warning_message` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expensereport_det`
--

LOCK TABLES `llx_expensereport_det` WRITE;
/*!40000 ALTER TABLE `llx_expensereport_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expensereport_det` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expensereport_extrafields`
--

DROP TABLE IF EXISTS `llx_expensereport_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expensereport_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_expensereport_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expensereport_extrafields`
--

LOCK TABLES `llx_expensereport_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_expensereport_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expensereport_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expensereport_ik`
--

DROP TABLE IF EXISTS `llx_expensereport_ik`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expensereport_ik` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_c_exp_tax_cat` int(11) NOT NULL DEFAULT '0',
  `fk_range` int(11) NOT NULL DEFAULT '0',
  `coef` double NOT NULL DEFAULT '0',
  `ikoffset` double NOT NULL DEFAULT '0',
  `active` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expensereport_ik`
--

LOCK TABLES `llx_expensereport_ik` WRITE;
/*!40000 ALTER TABLE `llx_expensereport_ik` DISABLE KEYS */;
INSERT INTO `llx_expensereport_ik` VALUES (1,NULL,'2018-05-18 18:27:24',4,1,0.41,0,1),(2,NULL,'2018-05-18 18:27:24',4,2,0.244,824,1),(3,NULL,'2018-05-18 18:27:24',4,3,0.286,0,1),(4,NULL,'2018-05-18 18:27:24',5,4,0.493,0,1),(5,NULL,'2018-05-18 18:27:24',5,5,0.277,1082,1),(6,NULL,'2018-05-18 18:27:24',5,6,0.332,0,1),(7,NULL,'2018-05-18 18:27:24',6,7,0.543,0,1),(8,NULL,'2018-05-18 18:27:24',6,8,0.305,1180,1),(9,NULL,'2018-05-18 18:27:24',6,9,0.364,0,1),(10,NULL,'2018-05-18 18:27:24',7,10,0.568,0,1),(11,NULL,'2018-05-18 18:27:24',7,11,0.32,1244,1),(12,NULL,'2018-05-18 18:27:24',7,12,0.382,0,1),(13,NULL,'2018-05-18 18:27:24',8,13,0.595,0,1),(14,NULL,'2018-05-18 18:27:24',8,14,0.337,1288,1),(15,NULL,'2018-05-18 18:27:24',8,15,0.401,0,1);
/*!40000 ALTER TABLE `llx_expensereport_ik` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_expensereport_rules`
--

DROP TABLE IF EXISTS `llx_expensereport_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_expensereport_rules` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `dates` datetime NOT NULL,
  `datee` datetime NOT NULL,
  `amount` double(24,8) NOT NULL,
  `restrictive` tinyint(4) NOT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `fk_usergroup` int(11) DEFAULT NULL,
  `fk_c_type_fees` int(11) NOT NULL,
  `code_expense_rules_type` varchar(50) NOT NULL,
  `is_for_all` tinyint(4) DEFAULT '0',
  `entity` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_expensereport_rules`
--

LOCK TABLES `llx_expensereport_rules` WRITE;
/*!40000 ALTER TABLE `llx_expensereport_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_expensereport_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_export_compta`
--

DROP TABLE IF EXISTS `llx_export_compta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_export_compta` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(12) NOT NULL,
  `date_export` datetime NOT NULL,
  `fk_user` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_export_compta`
--

LOCK TABLES `llx_export_compta` WRITE;
/*!40000 ALTER TABLE `llx_export_compta` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_export_compta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_export_model`
--

DROP TABLE IF EXISTS `llx_export_model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_export_model` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_user` int(11) NOT NULL DEFAULT '0',
  `label` varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL,
  `field` text NOT NULL,
  `filter` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_export_model` (`label`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_export_model`
--

LOCK TABLES `llx_export_model` WRITE;
/*!40000 ALTER TABLE `llx_export_model` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_export_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_extrafields`
--

DROP TABLE IF EXISTS `llx_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `elementtype` varchar(64) NOT NULL DEFAULT 'member',
  `label` varchar(255) NOT NULL,
  `type` varchar(8) DEFAULT NULL,
  `size` varchar(8) DEFAULT NULL,
  `fieldcomputed` text,
  `fielddefault` varchar(255) DEFAULT NULL,
  `fieldunique` int(11) DEFAULT '0',
  `fieldrequired` int(11) DEFAULT '0',
  `perms` varchar(255) DEFAULT NULL,
  `enabled` varchar(255) DEFAULT NULL,
  `pos` int(11) DEFAULT '0',
  `alwayseditable` int(11) DEFAULT '0',
  `param` text,
  `list` int(11) DEFAULT '1',
  `langs` varchar(64) DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_extrafields_name` (`name`,`entity`,`elementtype`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_extrafields`
--

LOCK TABLES `llx_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture`
--

DROP TABLE IF EXISTS `llx_facture`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `facnumber` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_client` varchar(255) DEFAULT NULL,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `increment` varchar(10) DEFAULT NULL,
  `fk_soc` int(11) NOT NULL,
  `datec` datetime DEFAULT NULL,
  `datef` date DEFAULT NULL,
  `date_pointoftax` date DEFAULT NULL,
  `date_valid` date DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `paye` smallint(6) NOT NULL DEFAULT '0',
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `close_code` varchar(16) DEFAULT NULL,
  `close_note` varchar(128) DEFAULT NULL,
  `tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `revenuestamp` double(24,8) DEFAULT '0.00000000',
  `total` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_statut` smallint(6) NOT NULL DEFAULT '0',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_fac_rec_source` int(11) DEFAULT NULL,
  `fk_facture_source` int(11) DEFAULT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `fk_account` int(11) DEFAULT NULL,
  `fk_currency` varchar(3) DEFAULT NULL,
  `fk_cond_reglement` int(11) NOT NULL DEFAULT '1',
  `fk_mode_reglement` int(11) DEFAULT NULL,
  `date_lim_reglement` date DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_incoterms` int(11) DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `situation_cycle_ref` smallint(6) DEFAULT NULL,
  `situation_counter` smallint(6) DEFAULT NULL,
  `situation_final` smallint(6) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_facture_uk_facnumber` (`facnumber`,`entity`),
  KEY `idx_facture_fk_soc` (`fk_soc`),
  KEY `idx_facture_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_fk_user_valid` (`fk_user_valid`),
  KEY `idx_facture_fk_facture_source` (`fk_facture_source`),
  KEY `idx_facture_fk_projet` (`fk_projet`),
  KEY `idx_facture_fk_account` (`fk_account`),
  KEY `idx_facture_fk_currency` (`fk_currency`),
  KEY `idx_facture_fk_statut` (`fk_statut`),
  CONSTRAINT `fk_facture_fk_facture_source` FOREIGN KEY (`fk_facture_source`) REFERENCES `llx_facture` (`rowid`),
  CONSTRAINT `fk_facture_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_facture_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_facture_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_facture_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture`
--

LOCK TABLES `llx_facture` WRITE;
/*!40000 ALTER TABLE `llx_facture` DISABLE KEYS */;
INSERT INTO `llx_facture` VALUES (2,'FA1806-0001',1,NULL,NULL,NULL,0,NULL,2,'2018-06-12 09:57:59','2018-06-12',NULL,'2018-06-12','2018-07-06 09:45:20',1,0.00000000,NULL,NULL,0,NULL,NULL,840.00000000,0.00000000,0.00000000,0.00000000,4000.00000000,4840.00000000,2,1,NULL,2,NULL,NULL,NULL,NULL,NULL,1,0,'2018-06-13',NULL,NULL,'crabe','facture/FA1806-0001/FA1806-0001.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,4000.00000000,840.00000000,4840.00000000),(3,'FA1807-0002',1,NULL,NULL,NULL,0,NULL,3,'2018-07-06 09:23:53','2018-07-06',NULL,'2018-07-06','2018-09-19 11:32:24',1,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,2,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-07-07',NULL,NULL,'crabe','facture/FA1807-0002/FA1807-0002.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(4,'FA1807-0003',1,NULL,NULL,NULL,0,NULL,4,'2018-07-06 09:39:04','2018-07-06',NULL,'2018-07-06','2018-07-20 06:45:20',1,0.00000000,NULL,NULL,0,NULL,NULL,13.88000000,0.00000000,0.00000000,0.00000000,66.12000000,80.00000000,2,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-07-07',NULL,NULL,'crabe','facture/FA1807-0003/FA1807-0003.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,66.12000000,13.88000000,80.00000000),(5,'FA1807-0004',1,NULL,NULL,NULL,0,NULL,5,'2018-07-20 06:42:24','2018-07-20',NULL,'2018-07-20','2018-08-24 09:08:46',1,0.00000000,NULL,NULL,0,NULL,NULL,189.00000000,0.00000000,0.00000000,0.00000000,900.00000000,1089.00000000,2,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-07-21',NULL,NULL,'crabe','facture/FA1807-0004/FA1807-0004.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,900.00000000,189.00000000,1089.00000000),(6,'FA1807-0005',1,NULL,NULL,NULL,0,NULL,5,'2018-07-20 06:43:39','2018-07-20',NULL,'2018-07-20','2018-08-24 09:08:47',1,0.00000000,NULL,NULL,0,NULL,NULL,94.50000000,0.00000000,0.00000000,0.00000000,450.00000000,544.50000000,2,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-07-21',NULL,NULL,'crabe','facture/FA1807-0005/FA1807-0005.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,450.00000000,94.50000000,544.50000000),(7,'FA1807-0006',1,NULL,NULL,NULL,0,NULL,6,'2018-07-30 10:08:44','2018-07-30',NULL,'2018-07-30','2018-07-30 10:09:48',0,0.00000000,NULL,NULL,0,NULL,NULL,16.80000000,0.00000000,0.00000000,0.00000000,80.00000000,96.80000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-07-31',NULL,NULL,'crabe','facture/FA1807-0006/FA1807-0006.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,80.00000000,16.80000000,96.80000000),(9,'AV1808-0001',1,NULL,NULL,NULL,2,NULL,5,'2018-08-24 08:59:24','2018-08-24',NULL,'2018-08-24','2018-08-24 09:09:03',1,0.00000000,NULL,NULL,0,NULL,NULL,-189.00000000,0.00000000,0.00000000,0.00000000,-900.00000000,-1089.00000000,2,1,NULL,1,NULL,5,NULL,NULL,NULL,0,0,'2018-08-24',NULL,NULL,'crabe','facture/AV1808-0001/AV1808-0001.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,-900.00000000,-189.00000000,-1089.00000000),(10,'FA1808-0007',1,NULL,NULL,NULL,0,NULL,7,'2018-08-24 09:03:47','2018-08-24',NULL,'2018-08-24','2018-10-04 09:35:44',1,0.00000000,NULL,NULL,0,NULL,NULL,94.50000000,0.00000000,0.00000000,0.00000000,450.00000000,544.50000000,2,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-08-25',NULL,NULL,'crabe','facture/FA1808-0007/FA1808-0007.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,450.00000000,94.50000000,544.50000000),(14,'FA1809-0008',1,NULL,NULL,NULL,0,NULL,3,'2018-09-19 11:29:50','2018-09-19',NULL,'2018-09-19','2018-10-04 09:36:33',1,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,2,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-09-20',NULL,NULL,'crabe','facture/FA1809-0008/FA1809-0008.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(15,'AV1809-0002',1,NULL,NULL,NULL,2,NULL,3,'2018-09-19 11:32:32','2018-09-19',NULL,'2018-09-19','2018-10-04 09:36:50',1,0.00000000,NULL,NULL,0,NULL,NULL,-42.00000000,0.00000000,0.00000000,0.00000000,-200.00000000,-242.00000000,2,1,NULL,1,NULL,3,NULL,NULL,NULL,0,0,'2018-09-19',NULL,NULL,'crabe','facture/AV1809-0002/AV1809-0002.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,-200.00000000,-42.00000000,-242.00000000),(16,'FA1809-0009',1,NULL,NULL,NULL,0,NULL,3,'2018-09-19 11:35:37','2018-09-19',NULL,'2018-09-19','2018-09-19 11:37:09',0,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-09-20',NULL,NULL,'crabe','facture/FA1809-0009/FA1809-0009.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(17,'FA1809-0010',1,NULL,NULL,NULL,0,NULL,3,'2018-09-19 11:36:07','2018-09-19',NULL,'2018-09-19','2018-09-19 11:36:27',0,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-09-20',NULL,NULL,'crabe','facture/FA1809-0010/FA1809-0010.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(18,'FA1809-0011',1,NULL,NULL,NULL,0,NULL,8,'2018-09-20 12:21:28','2018-09-20',NULL,'2018-09-20','2018-10-04 09:34:50',1,0.00000000,NULL,NULL,0,NULL,NULL,867.77000000,0.00000000,0.00000000,0.00000000,4132.23000000,5000.00000000,2,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-09-21',NULL,NULL,'crabe','facture/FA1809-0011/FA1809-0011.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,4132.23000000,867.77000000,5000.00000000),(19,'FA1810-0012',1,NULL,NULL,NULL,0,NULL,3,'2018-10-04 09:26:17','2018-10-04',NULL,'2018-10-04','2018-10-04 09:26:37',0,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-10-05',NULL,NULL,'crabe','facture/FA1810-0012/FA1810-0012.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(20,'FA1810-0013',1,NULL,NULL,NULL,0,NULL,3,'2018-11-12 08:50:54','2018-10-31',NULL,'2018-11-12','2018-11-12 08:51:22',0,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-11-13',NULL,NULL,'crabe','facture/FA1810-0013/FA1810-0013.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(21,'FA1810-0014',1,NULL,NULL,NULL,0,NULL,9,'2018-11-12 08:58:26','2018-10-31',NULL,'2018-11-12','2018-11-12 08:59:39',0,0.00000000,NULL,NULL,0,NULL,NULL,52.50000000,0.00000000,0.00000000,0.00000000,250.00000000,302.50000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-11-01',NULL,NULL,'crabe','facture/FA1810-0014/FA1810-0014.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,250.00000000,52.50000000,302.50000000),(22,'FA1810-0015',1,NULL,NULL,NULL,0,NULL,8,'2018-11-12 09:01:25','2018-10-31',NULL,'2018-11-12','2018-11-12 09:01:47',0,0.00000000,NULL,NULL,0,NULL,NULL,546.00000000,0.00000000,0.00000000,0.00000000,2600.00000000,3146.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-11-13',NULL,NULL,'crabe','facture/FA1810-0015/FA1810-0015.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,2600.00000000,546.00000000,3146.00000000),(23,'FA1811-0016',1,NULL,NULL,NULL,0,NULL,10,'2018-11-20 11:19:02','2018-11-20',NULL,'2018-11-20','2018-11-20 11:20:30',0,0.00000000,NULL,NULL,0,NULL,NULL,96.60000000,0.00000000,0.00000000,0.00000000,460.00000000,556.60000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-11-21',NULL,NULL,'crabe','facture/FA1811-0016/FA1811-0016.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,460.00000000,96.60000000,556.60000000),(24,'FA1811-0017',1,NULL,NULL,NULL,0,NULL,11,'2018-11-21 10:46:16','2018-11-21',NULL,'2018-11-21','2018-11-21 10:50:28',0,0.00000000,NULL,NULL,0,NULL,NULL,31.50000000,0.00000000,0.00000000,0.00000000,150.00000000,181.50000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-11-22',NULL,NULL,'crabe','facture/FA1811-0017/FA1811-0017.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,150.00000000,31.50000000,181.50000000),(25,'FA1812-0018',1,NULL,NULL,NULL,0,NULL,3,'2018-12-07 09:13:00','2018-12-07',NULL,'2018-12-07','2018-12-07 09:13:16',0,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-12-08',NULL,NULL,'crabe','facture/FA1812-0018/FA1812-0018.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(26,'FA1812-0019',1,NULL,NULL,NULL,0,NULL,9,'2018-12-07 09:16:51','2018-12-07',NULL,'2018-12-07','2018-12-07 09:17:11',0,0.00000000,NULL,NULL,0,NULL,NULL,52.50000000,0.00000000,0.00000000,0.00000000,250.00000000,302.50000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-12-08',NULL,NULL,'crabe','facture/FA1812-0019/FA1812-0019.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,250.00000000,52.50000000,302.50000000),(27,'FA1812-0020',1,NULL,NULL,NULL,0,NULL,12,'2018-12-07 11:00:11','2018-12-07',NULL,'2018-12-07','2018-12-07 11:00:47',0,0.00000000,NULL,NULL,0,NULL,NULL,25.20000000,0.00000000,0.00000000,0.00000000,120.00000000,145.20000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-12-08',NULL,NULL,'crabe','facture/FA1812-0020/FA1812-0020.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,120.00000000,25.20000000,145.20000000),(28,'FA1812-0021',1,NULL,NULL,NULL,0,NULL,8,'2018-12-07 11:38:37','2018-12-07',NULL,'2018-12-07','2018-12-07 11:39:05',0,0.00000000,NULL,NULL,0,NULL,NULL,1081.50000000,0.00000000,0.00000000,0.00000000,5150.00000000,6231.50000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2018-12-08',NULL,NULL,'crabe','facture/FA1812-0021/FA1812-0021.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,5150.00000000,1081.50000000,6231.50000000),(29,'FA1901-0022',1,NULL,NULL,NULL,0,NULL,10,'2019-01-07 11:11:53','2019-01-07',NULL,'2019-01-07','2019-01-07 11:12:28',0,0.00000000,NULL,NULL,0,NULL,NULL,25.20000000,0.00000000,0.00000000,0.00000000,120.00000000,145.20000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-01-08',NULL,NULL,'crabe','facture/FA1901-0022/FA1901-0022.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,120.00000000,25.20000000,145.20000000),(30,'FA1901-0023',1,NULL,NULL,NULL,0,NULL,13,'2019-01-07 11:20:52','2019-01-07',NULL,'2019-01-07','2019-01-07 11:21:24',0,0.00000000,NULL,NULL,0,NULL,NULL,126.00000000,0.00000000,0.00000000,0.00000000,600.00000000,726.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-01-08',NULL,NULL,'crabe','facture/FA1901-0023/FA1901-0023.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,600.00000000,126.00000000,726.00000000),(31,'FA1901-0024',1,NULL,NULL,NULL,0,NULL,9,'2019-01-07 11:25:57','2019-01-07',NULL,'2019-01-07','2019-01-07 11:26:18',0,0.00000000,NULL,NULL,0,NULL,NULL,52.50000000,0.00000000,0.00000000,0.00000000,250.00000000,302.50000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-01-08',NULL,NULL,'crabe','facture/FA1901-0024/FA1901-0024.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,250.00000000,52.50000000,302.50000000),(32,'FA1901-0025',1,NULL,NULL,NULL,0,NULL,3,'2019-01-07 11:26:43','2019-01-07',NULL,'2019-01-07','2019-01-07 11:26:58',0,0.00000000,NULL,NULL,0,NULL,NULL,42.00000000,0.00000000,0.00000000,0.00000000,200.00000000,242.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-01-08',NULL,NULL,'crabe','facture/FA1901-0025/FA1901-0025.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,200.00000000,42.00000000,242.00000000),(33,'FA1901-0026',1,NULL,NULL,NULL,0,NULL,14,'2019-01-10 10:57:24','2019-01-10',NULL,'2019-01-10','2019-01-10 10:58:42',0,0.00000000,NULL,NULL,0,NULL,NULL,49.00000000,0.00000000,0.00000000,0.00000000,233.33000000,282.33000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-01-11',NULL,NULL,'crabe','facture/FA1901-0026/FA1901-0026.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,233.33000000,49.00000000,282.33000000),(34,'FA1901-0027',1,NULL,NULL,NULL,0,NULL,8,'2019-01-15 08:21:21','2019-01-15',NULL,'2019-01-15','2019-01-15 08:23:43',0,0.00000000,NULL,NULL,0,NULL,NULL,867.77000000,0.00000000,0.00000000,0.00000000,4132.23000000,5000.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-01-16',NULL,NULL,'crabe','facture/FA1901-0027/FA1901-0027.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,4132.23000000,867.77000000,5000.00000000),(35,'FA1902-0028',1,NULL,NULL,NULL,0,NULL,10,'2019-02-05 11:40:25','2019-02-05',NULL,'2019-02-05','2019-02-05 11:40:57',0,0.00000000,NULL,NULL,0,NULL,NULL,50.40000000,0.00000000,0.00000000,0.00000000,240.00000000,290.40000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-06',NULL,NULL,'crabe','facture/FA1902-0028/FA1902-0028.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,240.00000000,50.40000000,290.40000000),(36,'FA1902-0029',1,NULL,NULL,NULL,0,NULL,13,'2019-02-05 11:41:54','2019-02-05',NULL,'2019-02-05','2019-02-05 11:42:20',0,0.00000000,NULL,NULL,0,NULL,NULL,252.00000000,0.00000000,0.00000000,0.00000000,1200.00000000,1452.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-06',NULL,NULL,'crabe','facture/FA1902-0029/FA1902-0029.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,1200.00000000,252.00000000,1452.00000000),(37,'FA1902-0030',1,NULL,NULL,NULL,0,NULL,9,'2019-02-05 11:42:48','2019-02-05',NULL,'2019-02-05','2019-02-05 11:43:12',0,0.00000000,NULL,NULL,0,NULL,NULL,105.00000000,0.00000000,0.00000000,0.00000000,500.00000000,605.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-06',NULL,NULL,'crabe','facture/FA1902-0030/FA1902-0030.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,500.00000000,105.00000000,605.00000000),(38,'FA1902-0031',1,NULL,NULL,NULL,0,NULL,3,'2019-02-05 11:43:38','2019-02-05',NULL,'2019-02-05','2019-02-05 11:44:09',0,0.00000000,NULL,NULL,0,NULL,NULL,84.00000000,0.00000000,0.00000000,0.00000000,400.00000000,484.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-06',NULL,NULL,'crabe','facture/FA1902-0031/FA1902-0031.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,400.00000000,84.00000000,484.00000000),(39,'FA1902-0032',1,NULL,NULL,NULL,0,NULL,14,'2019-02-05 11:48:32','2019-02-05',NULL,'2019-02-05','2019-02-05 11:55:55',0,0.00000000,NULL,NULL,0,NULL,NULL,147.00000000,0.00000000,0.00000000,0.00000000,700.00000000,847.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-06',NULL,NULL,'crabe','facture/FA1902-0032/FA1902-0032.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,700.00000000,147.00000000,847.00000000),(40,'FA1902-0033',1,NULL,NULL,NULL,0,NULL,15,'2019-02-05 12:35:16','2019-02-05',NULL,'2019-02-05','2019-02-05 12:36:14',0,0.00000000,NULL,NULL,0,NULL,NULL,25.20000000,0.00000000,0.00000000,0.00000000,120.00000000,145.20000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-06',NULL,NULL,'crabe','facture/FA1902-0033/FA1902-0033.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,120.00000000,25.20000000,145.20000000),(41,'FA1902-0034',1,NULL,NULL,NULL,0,NULL,15,'2019-02-05 12:36:32','2019-02-05',NULL,'2019-02-05','2019-02-05 12:43:48',0,0.00000000,NULL,NULL,0,NULL,NULL,12.15000000,0.00000000,0.00000000,0.00000000,57.85000000,70.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-06',NULL,NULL,'crabe','facture/FA1902-0034/FA1902-0034.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,57.85000000,12.15000000,70.00000000),(42,'FA1902-0035',1,NULL,NULL,NULL,0,NULL,8,'2019-02-14 11:53:58','2019-02-14',NULL,'2019-02-14','2019-02-14 11:54:52',0,0.00000000,NULL,NULL,0,NULL,NULL,1722.00000000,0.00000000,0.00000000,0.00000000,8200.00000000,9922.00000000,1,1,NULL,1,NULL,NULL,NULL,NULL,NULL,1,0,'2019-02-15',NULL,NULL,'crabe','facture/FA1902-0035/FA1902-0035.pdf',0,'',NULL,NULL,0,NULL,NULL,1,'EUR',1.00000000,8200.00000000,1722.00000000,9922.00000000);
/*!40000 ALTER TABLE `llx_facture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_extrafields`
--

DROP TABLE IF EXISTS `llx_facture_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture_extrafields`
--

LOCK TABLES `llx_facture_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_facture_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_fourn`
--

DROP TABLE IF EXISTS `llx_facture_fourn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture_fourn` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(180) NOT NULL,
  `ref_supplier` varchar(180) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `ref_ext` varchar(255) DEFAULT NULL,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `fk_soc` int(11) NOT NULL,
  `datec` datetime DEFAULT NULL,
  `datef` date DEFAULT NULL,
  `date_pointoftax` date DEFAULT NULL,
  `date_valid` date DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `libelle` varchar(255) DEFAULT NULL,
  `paye` smallint(6) NOT NULL DEFAULT '0',
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `remise` double(24,8) DEFAULT '0.00000000',
  `close_code` varchar(16) DEFAULT NULL,
  `close_note` varchar(128) DEFAULT NULL,
  `tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `total` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `total_tva` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_statut` smallint(6) NOT NULL DEFAULT '0',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_facture_source` int(11) DEFAULT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `fk_account` int(11) DEFAULT NULL,
  `fk_cond_reglement` int(11) DEFAULT NULL,
  `fk_mode_reglement` int(11) DEFAULT NULL,
  `date_lim_reglement` date DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `fk_incoterms` int(11) DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_facture_fourn_ref` (`ref`,`entity`),
  UNIQUE KEY `uk_facture_fourn_ref_supplier` (`ref_supplier`,`fk_soc`,`entity`),
  KEY `idx_facture_fourn_date_lim_reglement` (`date_lim_reglement`),
  KEY `idx_facture_fourn_fk_soc` (`fk_soc`),
  KEY `idx_facture_fourn_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_fourn_fk_user_valid` (`fk_user_valid`),
  KEY `idx_facture_fourn_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_facture_fourn_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_facture_fourn_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_facture_fourn_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_facture_fourn_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture_fourn`
--

LOCK TABLES `llx_facture_fourn` WRITE;
/*!40000 ALTER TABLE `llx_facture_fourn` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_fourn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_fourn_det`
--

DROP TABLE IF EXISTS `llx_facture_fourn_det`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture_fourn_det` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_facture_fourn` int(11) NOT NULL,
  `fk_parent_line` int(11) DEFAULT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `ref` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `pu_ht` double(24,8) DEFAULT NULL,
  `pu_ttc` double(24,8) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT NULL,
  `tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `product_type` int(11) DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int(11) DEFAULT '0',
  `fk_code_ventilation` int(11) NOT NULL DEFAULT '0',
  `special_code` int(11) DEFAULT '0',
  `rang` int(11) DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `fk_unit` int(11) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_fourn_det_fk_facture` (`fk_facture_fourn`),
  KEY `idx_facture_fourn_det_fk_product` (`fk_product`),
  KEY `idx_facture_fourn_det_fk_code_ventilation` (`fk_code_ventilation`),
  KEY `fk_facture_fourn_det_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_facture_fourn_det_fk_facture` FOREIGN KEY (`fk_facture_fourn`) REFERENCES `llx_facture_fourn` (`rowid`),
  CONSTRAINT `fk_facture_fourn_det_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture_fourn_det`
--

LOCK TABLES `llx_facture_fourn_det` WRITE;
/*!40000 ALTER TABLE `llx_facture_fourn_det` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_fourn_det` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_fourn_det_extrafields`
--

DROP TABLE IF EXISTS `llx_facture_fourn_det_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture_fourn_det_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_fourn_det_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture_fourn_det_extrafields`
--

LOCK TABLES `llx_facture_fourn_det_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_facture_fourn_det_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_fourn_det_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_fourn_extrafields`
--

DROP TABLE IF EXISTS `llx_facture_fourn_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture_fourn_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_fourn_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture_fourn_extrafields`
--

LOCK TABLES `llx_facture_fourn_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_facture_fourn_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_fourn_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_rec`
--

DROP TABLE IF EXISTS `llx_facture_rec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture_rec` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `titre` varchar(100) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_soc` int(11) NOT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `suspended` int(11) DEFAULT '0',
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `remise` double DEFAULT '0',
  `remise_percent` double DEFAULT '0',
  `remise_absolue` double DEFAULT '0',
  `vat_src_code` varchar(10) DEFAULT '',
  `tva` double(24,8) DEFAULT '0.00000000',
  `localtax1` double(24,8) DEFAULT '0.00000000',
  `localtax2` double(24,8) DEFAULT '0.00000000',
  `revenuestamp` double(24,8) DEFAULT '0.00000000',
  `total` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT '0.00000000',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `fk_cond_reglement` int(11) DEFAULT '0',
  `fk_mode_reglement` int(11) DEFAULT '0',
  `date_lim_reglement` date DEFAULT NULL,
  `fk_account` int(11) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `modelpdf` varchar(255) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  `usenewprice` int(11) DEFAULT '0',
  `frequency` int(11) DEFAULT NULL,
  `unit_frequency` varchar(2) DEFAULT 'm',
  `date_when` datetime DEFAULT NULL,
  `date_last_gen` datetime DEFAULT NULL,
  `nb_gen_done` int(11) DEFAULT NULL,
  `nb_gen_max` int(11) DEFAULT NULL,
  `auto_validate` int(11) DEFAULT '0',
  `generate_pdf` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_facture_rec_uk_titre` (`titre`,`entity`),
  KEY `idx_facture_rec_fk_soc` (`fk_soc`),
  KEY `idx_facture_rec_fk_user_author` (`fk_user_author`),
  KEY `idx_facture_rec_fk_projet` (`fk_projet`),
  CONSTRAINT `fk_facture_rec_fk_projet` FOREIGN KEY (`fk_projet`) REFERENCES `llx_projet` (`rowid`),
  CONSTRAINT `fk_facture_rec_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_facture_rec_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture_rec`
--

LOCK TABLES `llx_facture_rec` WRITE;
/*!40000 ALTER TABLE `llx_facture_rec` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_rec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facture_rec_extrafields`
--

DROP TABLE IF EXISTS `llx_facture_rec_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facture_rec_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facture_rec_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facture_rec_extrafields`
--

LOCK TABLES `llx_facture_rec_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_facture_rec_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facture_rec_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facturedet`
--

DROP TABLE IF EXISTS `llx_facturedet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facturedet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_facture` int(11) NOT NULL,
  `fk_parent_line` int(11) DEFAULT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `fk_remise_except` int(11) DEFAULT NULL,
  `subprice` double(24,8) DEFAULT NULL,
  `price` double(24,8) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT NULL,
  `total_tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `product_type` int(11) DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `info_bits` int(11) DEFAULT '0',
  `buy_price_ht` double(24,8) DEFAULT '0.00000000',
  `fk_product_fournisseur_price` int(11) DEFAULT NULL,
  `fk_code_ventilation` int(11) NOT NULL DEFAULT '0',
  `special_code` int(11) DEFAULT '0',
  `rang` int(11) DEFAULT '0',
  `fk_contract_line` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `situation_percent` double DEFAULT NULL,
  `fk_prev_id` int(11) DEFAULT NULL,
  `fk_unit` int(11) DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_fk_remise_except` (`fk_remise_except`,`fk_facture`),
  KEY `idx_facturedet_fk_facture` (`fk_facture`),
  KEY `idx_facturedet_fk_product` (`fk_product`),
  KEY `idx_facturedet_fk_code_ventilation` (`fk_code_ventilation`),
  KEY `fk_facturedet_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_facturedet_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`),
  CONSTRAINT `fk_facturedet_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facturedet`
--

LOCK TABLES `llx_facturedet` WRITE;
/*!40000 ALTER TABLE `llx_facturedet` DISABLE KEYS */;
INSERT INTO `llx_facturedet` VALUES (1,2,NULL,NULL,NULL,'LOCATION D ESPACE DE STOCKAGE','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,4000.00000000,NULL,4000.00000000,840.00000000,0.00000000,0.00000000,4840.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,2,1,'EUR',4000.00000000,4000.00000000,840.00000000,4840.00000000),(2,3,NULL,NULL,NULL,'Location espace de stackage X4 pour le mois de Juin','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(3,4,NULL,NULL,NULL,'Location espace de stockage C2 du 1er au 31 Juillet 2018','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,66.11570000,NULL,66.12000000,13.88000000,0.00000000,0.00000000,80.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',66.11570000,66.12000000,13.88000000,80.00000000),(4,5,NULL,NULL,NULL,'Location d espace de stokage pour les mois de Mai et Juin 2018','BE',21.000,0.000,'0',0.000,'0',2,0,0,NULL,450.00000000,NULL,900.00000000,189.00000000,0.00000000,0.00000000,1089.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',450.00000000,900.00000000,189.00000000,1089.00000000),(5,6,NULL,NULL,NULL,'Location d espace de stokage pour les mois deJuillet 2018','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,450.00000000,NULL,450.00000000,94.50000000,0.00000000,0.00000000,544.50000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',450.00000000,450.00000000,94.50000000,544.50000000),(6,7,NULL,NULL,NULL,'LOCATION D UN BOX DE STOKAGE&nbsp;<br />\r\nlot : d2','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,80.00000000,NULL,80.00000000,16.80000000,0.00000000,0.00000000,96.80000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',80.00000000,80.00000000,16.80000000,96.80000000),(8,9,NULL,NULL,NULL,'Location d espace de stokage pour les mois de Mai et Juin 2018','BE',21.000,0.000,'0',0.000,'0',2,0,0,NULL,-450.00000000,NULL,-900.00000000,-189.00000000,0.00000000,0.00000000,-1089.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',-450.00000000,-900.00000000,-189.00000000,-1089.00000000),(9,10,NULL,NULL,NULL,'Location espace de stokage pour le mois de Juin 2018','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,450.00000000,NULL,450.00000000,94.50000000,0.00000000,0.00000000,544.50000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',450.00000000,450.00000000,94.50000000,544.50000000),(12,14,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois de Juillet&nbsp; 2018<br />\r\n<br />\r\nPay&eacute; par virement','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(13,15,NULL,NULL,NULL,'Location espace de stackage X4 pour le mois de Juin','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,-200.00000000,NULL,-200.00000000,-42.00000000,0.00000000,0.00000000,-242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',-200.00000000,-200.00000000,-42.00000000,-242.00000000),(14,16,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois de Aout&nbsp; 2018<br />\r\n<br />\r\nRe&ccedil;u virement de 200 euros&nbsp;<br />\r\nSolde &agrave; payer : 42 euros','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(15,17,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois de Sepotembre&nbsp; 2018<br />\r\n<br />\r\n&nbsp;','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(16,18,NULL,NULL,NULL,'Location espace de stockage','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,4132.23000000,NULL,4132.23000000,867.77000000,0.00000000,0.00000000,5000.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',4132.23000000,4132.23000000,867.77000000,5000.00000000),(17,19,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois d&#39;Octobre&nbsp; &nbsp;2018<br />\r\n<br />\r\n&nbsp;','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(18,20,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois de Novembre&nbsp; 2018<br />\r\n<br />\r\n&nbsp;','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(19,21,NULL,NULL,NULL,'Location box X1 Novembre 2018','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,250.00000000,NULL,250.00000000,52.50000000,0.00000000,0.00000000,302.50000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',250.00000000,250.00000000,52.50000000,302.50000000),(20,22,NULL,NULL,NULL,'Location espace de stockage','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,2600.00000000,NULL,2600.00000000,546.00000000,0.00000000,0.00000000,3146.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',2600.00000000,2600.00000000,546.00000000,3146.00000000),(21,23,NULL,NULL,NULL,'Main d Oeuvre&nbsp; 200 euros<br />\r\nLocation camion : 100 euros<br />\r\nloyer novembre + decembre 160 euros','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,460.00000000,NULL,460.00000000,96.60000000,0.00000000,0.00000000,556.60000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',460.00000000,460.00000000,96.60000000,556.60000000),(22,24,NULL,NULL,NULL,'loyer Novembre et decembre 2018 box C7','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,150.00000000,NULL,150.00000000,31.50000000,0.00000000,0.00000000,181.50000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',150.00000000,150.00000000,31.50000000,181.50000000),(23,25,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois de Decembre&nbsp; 2018<br />\r\n<br />\r\n&nbsp;','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(24,26,NULL,NULL,NULL,'Location box X1 Decembre 2018','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,250.00000000,NULL,250.00000000,52.50000000,0.00000000,0.00000000,302.50000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',250.00000000,250.00000000,52.50000000,302.50000000),(25,27,NULL,NULL,NULL,'Location box D11 decembre 2018','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,120.00000000,NULL,120.00000000,25.20000000,0.00000000,0.00000000,145.20000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',120.00000000,120.00000000,25.20000000,145.20000000),(26,28,NULL,NULL,NULL,'transport&nbsp;','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,5150.00000000,NULL,5150.00000000,1081.50000000,0.00000000,0.00000000,6231.50000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',5150.00000000,5150.00000000,1081.50000000,6231.50000000),(27,29,NULL,NULL,NULL,'<br />\r\nloyer Janvier 120 euros','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,120.00000000,NULL,120.00000000,25.20000000,0.00000000,0.00000000,145.20000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',120.00000000,120.00000000,25.20000000,145.20000000),(28,30,NULL,NULL,NULL,'Location box de stockage Y3','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,600.00000000,NULL,600.00000000,126.00000000,0.00000000,0.00000000,726.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',600.00000000,600.00000000,126.00000000,726.00000000),(29,31,NULL,NULL,NULL,'Location box X1 Janvier 2019','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,250.00000000,NULL,250.00000000,52.50000000,0.00000000,0.00000000,302.50000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',250.00000000,250.00000000,52.50000000,302.50000000),(30,32,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois de JAnvier 2019<br />\r\n<br />\r\n&nbsp;','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,200.00000000,NULL,200.00000000,42.00000000,0.00000000,0.00000000,242.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,200.00000000,42.00000000,242.00000000),(31,33,NULL,NULL,NULL,'Location box Y3 Janvier 2019','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,233.33000000,NULL,233.33000000,49.00000000,0.00000000,0.00000000,282.33000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',233.33000000,233.33000000,49.00000000,282.33000000),(32,34,NULL,NULL,NULL,'Location espace de stockage','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,4132.23000000,NULL,4132.23000000,867.77000000,0.00000000,0.00000000,5000.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',4132.23000000,4132.23000000,867.77000000,5000.00000000),(33,35,NULL,NULL,NULL,'<br />\r\nloyer Fevrier et Mars 2019 :&nbsp; 240 euros','BE',21.000,0.000,'0',0.000,'0',2,0,0,NULL,120.00000000,NULL,240.00000000,50.40000000,0.00000000,0.00000000,290.40000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',120.00000000,240.00000000,50.40000000,290.40000000),(34,36,NULL,NULL,NULL,'Location box de stockage Y3 pour Fevrier et Mars 2019','BE',21.000,0.000,'0',0.000,'0',2,0,0,NULL,600.00000000,NULL,1200.00000000,252.00000000,0.00000000,0.00000000,1452.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',600.00000000,1200.00000000,252.00000000,1452.00000000),(35,37,NULL,NULL,NULL,'Location box X1 Fevrier et Mars 2019','BE',21.000,0.000,'0',0.000,'0',2,0,0,NULL,250.00000000,NULL,500.00000000,105.00000000,0.00000000,0.00000000,605.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',250.00000000,500.00000000,105.00000000,605.00000000),(36,38,NULL,NULL,NULL,'Location espace de stockage X4 pour le mois de Fevrier&#39; et Mars 2019<br />\r\n<br />\r\n&nbsp;','BE',21.000,0.000,'0',0.000,'0',2,0,0,NULL,200.00000000,NULL,400.00000000,84.00000000,0.00000000,0.00000000,484.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',200.00000000,400.00000000,84.00000000,484.00000000),(37,39,NULL,NULL,NULL,'Location box Y3 Fevrier et Mars 2019','BE',21.000,0.000,'0',0.000,'0',2,0,0,NULL,350.00000000,NULL,700.00000000,147.00000000,0.00000000,0.00000000,847.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',350.00000000,700.00000000,147.00000000,847.00000000),(38,40,NULL,NULL,NULL,'Demenagement rue Egide walschaert 33 - st Gilles vers Av Floreal 53 Uccle','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,120.00000000,NULL,120.00000000,25.20000000,0.00000000,0.00000000,145.20000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',120.00000000,120.00000000,25.20000000,145.20000000),(39,41,NULL,NULL,NULL,'Box 11m3 pour le compte de Monsieur Bouyer David James','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,57.85000000,NULL,57.85000000,12.15000000,0.00000000,0.00000000,70.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',57.85000000,57.85000000,12.15000000,70.00000000),(40,42,NULL,NULL,NULL,'transport + location espace de stokage','BE',21.000,0.000,'0',0.000,'0',1,0,0,NULL,8200.00000000,NULL,8200.00000000,1722.00000000,0.00000000,0.00000000,9922.00000000,1,NULL,NULL,0,0.00000000,NULL,0,0,1,NULL,NULL,100,NULL,NULL,1,1,1,'EUR',8200.00000000,8200.00000000,1722.00000000,9922.00000000);
/*!40000 ALTER TABLE `llx_facturedet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facturedet_extrafields`
--

DROP TABLE IF EXISTS `llx_facturedet_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facturedet_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facturedet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facturedet_extrafields`
--

LOCK TABLES `llx_facturedet_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_facturedet_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facturedet_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facturedet_rec`
--

DROP TABLE IF EXISTS `llx_facturedet_rec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facturedet_rec` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_facture` int(11) NOT NULL,
  `fk_parent_line` int(11) DEFAULT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `product_type` int(11) DEFAULT '0',
  `label` varchar(255) DEFAULT NULL,
  `description` text,
  `vat_src_code` varchar(10) DEFAULT '',
  `tva_tx` double(6,3) DEFAULT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) DEFAULT NULL,
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `remise_percent` double DEFAULT '0',
  `remise` double DEFAULT '0',
  `subprice` double(24,8) DEFAULT NULL,
  `price` double(24,8) DEFAULT NULL,
  `total_ht` double(24,8) DEFAULT NULL,
  `total_tva` double(24,8) DEFAULT NULL,
  `total_localtax1` double(24,8) DEFAULT '0.00000000',
  `total_localtax2` double(24,8) DEFAULT '0.00000000',
  `total_ttc` double(24,8) DEFAULT NULL,
  `info_bits` int(11) DEFAULT '0',
  `special_code` int(10) unsigned DEFAULT '0',
  `rang` int(11) DEFAULT '0',
  `fk_contract_line` int(11) DEFAULT NULL,
  `fk_unit` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_subprice` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ht` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_tva` double(24,8) DEFAULT '0.00000000',
  `multicurrency_total_ttc` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  KEY `fk_facturedet_rec_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_facturedet_rec_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facturedet_rec`
--

LOCK TABLES `llx_facturedet_rec` WRITE;
/*!40000 ALTER TABLE `llx_facturedet_rec` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facturedet_rec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_facturedet_rec_extrafields`
--

DROP TABLE IF EXISTS `llx_facturedet_rec_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_facturedet_rec_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_facturedet_rec_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_facturedet_rec_extrafields`
--

LOCK TABLES `llx_facturedet_rec_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_facturedet_rec_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_facturedet_rec_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_fichinter`
--

DROP TABLE IF EXISTS `llx_fichinter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_fichinter` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_soc` int(11) NOT NULL,
  `fk_projet` int(11) DEFAULT '0',
  `fk_contrat` int(11) DEFAULT '0',
  `ref` varchar(30) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `datei` date DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_statut` smallint(6) DEFAULT '0',
  `dateo` date DEFAULT NULL,
  `datee` date DEFAULT NULL,
  `datet` date DEFAULT NULL,
  `duree` double DEFAULT NULL,
  `description` text,
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_fichinter_ref` (`ref`,`entity`),
  KEY `idx_fichinter_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_fichinter_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_fichinter`
--

LOCK TABLES `llx_fichinter` WRITE;
/*!40000 ALTER TABLE `llx_fichinter` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_fichinter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_fichinter_extrafields`
--

DROP TABLE IF EXISTS `llx_fichinter_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_fichinter_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_ficheinter_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_fichinter_extrafields`
--

LOCK TABLES `llx_fichinter_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_fichinter_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_fichinter_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_fichinterdet`
--

DROP TABLE IF EXISTS `llx_fichinterdet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_fichinterdet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_fichinter` int(11) DEFAULT NULL,
  `fk_parent_line` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `description` text,
  `duree` int(11) DEFAULT NULL,
  `rang` int(11) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_fichinterdet_fk_fichinter` (`fk_fichinter`),
  CONSTRAINT `fk_fichinterdet_fk_fichinter` FOREIGN KEY (`fk_fichinter`) REFERENCES `llx_fichinter` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_fichinterdet`
--

LOCK TABLES `llx_fichinterdet` WRITE;
/*!40000 ALTER TABLE `llx_fichinterdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_fichinterdet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_fichinterdet_extrafields`
--

DROP TABLE IF EXISTS `llx_fichinterdet_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_fichinterdet_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_ficheinterdet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_fichinterdet_extrafields`
--

LOCK TABLES `llx_fichinterdet_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_fichinterdet_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_fichinterdet_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_holiday`
--

DROP TABLE IF EXISTS `llx_holiday`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_holiday` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_user` int(11) NOT NULL,
  `fk_user_create` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_type` int(11) NOT NULL,
  `date_create` datetime NOT NULL,
  `description` varchar(255) NOT NULL,
  `date_debut` date NOT NULL,
  `date_fin` date NOT NULL,
  `halfday` int(11) DEFAULT '0',
  `statut` int(11) NOT NULL DEFAULT '1',
  `fk_validator` int(11) NOT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `date_refuse` datetime DEFAULT NULL,
  `fk_user_refuse` int(11) DEFAULT NULL,
  `date_cancel` datetime DEFAULT NULL,
  `fk_user_cancel` int(11) DEFAULT NULL,
  `detail_refuse` varchar(250) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_holiday_entity` (`entity`),
  KEY `idx_holiday_fk_user` (`fk_user`),
  KEY `idx_holiday_fk_user_create` (`fk_user_create`),
  KEY `idx_holiday_date_create` (`date_create`),
  KEY `idx_holiday_date_debut` (`date_debut`),
  KEY `idx_holiday_date_fin` (`date_fin`),
  KEY `idx_holiday_fk_validator` (`fk_validator`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_holiday`
--

LOCK TABLES `llx_holiday` WRITE;
/*!40000 ALTER TABLE `llx_holiday` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_holiday` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_holiday_config`
--

DROP TABLE IF EXISTS `llx_holiday_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_holiday_config` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `value` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_holiday_config` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_holiday_config`
--

LOCK TABLES `llx_holiday_config` WRITE;
/*!40000 ALTER TABLE `llx_holiday_config` DISABLE KEYS */;
INSERT INTO `llx_holiday_config` VALUES (1,'lastUpdate','20180518183128');
/*!40000 ALTER TABLE `llx_holiday_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_holiday_logs`
--

DROP TABLE IF EXISTS `llx_holiday_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_holiday_logs` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `date_action` datetime NOT NULL,
  `fk_user_action` int(11) NOT NULL,
  `fk_user_update` int(11) NOT NULL,
  `fk_type` int(11) NOT NULL,
  `type_action` varchar(255) NOT NULL,
  `prev_solde` varchar(255) NOT NULL,
  `new_solde` varchar(255) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_holiday_logs`
--

LOCK TABLES `llx_holiday_logs` WRITE;
/*!40000 ALTER TABLE `llx_holiday_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_holiday_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_holiday_users`
--

DROP TABLE IF EXISTS `llx_holiday_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_holiday_users` (
  `fk_user` int(11) NOT NULL,
  `fk_type` int(11) NOT NULL,
  `nb_holiday` double NOT NULL DEFAULT '0',
  UNIQUE KEY `uk_holiday_users` (`fk_user`,`fk_type`,`nb_holiday`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_holiday_users`
--

LOCK TABLES `llx_holiday_users` WRITE;
/*!40000 ALTER TABLE `llx_holiday_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_holiday_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_import_model`
--

DROP TABLE IF EXISTS `llx_import_model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_import_model` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_user` int(11) NOT NULL DEFAULT '0',
  `label` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `field` text NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_import_model` (`label`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_import_model`
--

LOCK TABLES `llx_import_model` WRITE;
/*!40000 ALTER TABLE `llx_import_model` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_import_model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_inventory`
--

DROP TABLE IF EXISTS `llx_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_inventory` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) DEFAULT '0',
  `ref` varchar(48) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_warehouse` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `date_inventory` datetime DEFAULT NULL,
  `date_validation` datetime DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_inventory_ref` (`ref`,`entity`),
  KEY `idx_inventory_tms` (`tms`),
  KEY `idx_inventory_date_creation` (`date_creation`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_inventory`
--

LOCK TABLES `llx_inventory` WRITE;
/*!40000 ALTER TABLE `llx_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_inventorydet`
--

DROP TABLE IF EXISTS `llx_inventorydet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_inventorydet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_inventory` int(11) DEFAULT '0',
  `fk_warehouse` int(11) DEFAULT '0',
  `fk_product` int(11) DEFAULT '0',
  `batch` varchar(30) DEFAULT NULL,
  `qty_view` double DEFAULT NULL,
  `qty_stock` double DEFAULT NULL,
  `qty_regulated` double DEFAULT NULL,
  `pmp` double DEFAULT '0',
  `pa` double DEFAULT '0',
  `new_pmp` double DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_inventorydet_tms` (`tms`),
  KEY `idx_inventorydet_datec` (`datec`),
  KEY `idx_inventorydet_fk_inventory` (`fk_inventory`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_inventorydet`
--

LOCK TABLES `llx_inventorydet` WRITE;
/*!40000 ALTER TABLE `llx_inventorydet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_inventorydet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_links`
--

DROP TABLE IF EXISTS `llx_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_links` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datea` datetime NOT NULL,
  `url` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `objecttype` varchar(255) NOT NULL,
  `objectid` int(11) NOT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_links` (`objectid`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_links`
--

LOCK TABLES `llx_links` WRITE;
/*!40000 ALTER TABLE `llx_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_livraison`
--

DROP TABLE IF EXISTS `llx_livraison`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_livraison` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `fk_soc` int(11) NOT NULL,
  `ref_ext` varchar(255) DEFAULT NULL,
  `ref_int` varchar(255) DEFAULT NULL,
  `ref_customer` varchar(255) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `date_delivery` datetime DEFAULT NULL,
  `fk_address` int(11) DEFAULT NULL,
  `fk_statut` smallint(6) DEFAULT '0',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `note_private` text,
  `note_public` text,
  `model_pdf` varchar(255) DEFAULT NULL,
  `last_main_doc` varchar(255) DEFAULT NULL,
  `fk_incoterms` int(11) DEFAULT NULL,
  `location_incoterms` varchar(255) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_livraison_uk_ref` (`ref`,`entity`),
  KEY `idx_livraison_fk_soc` (`fk_soc`),
  KEY `idx_livraison_fk_user_author` (`fk_user_author`),
  KEY `idx_livraison_fk_user_valid` (`fk_user_valid`),
  CONSTRAINT `fk_livraison_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_livraison_fk_user_author` FOREIGN KEY (`fk_user_author`) REFERENCES `llx_user` (`rowid`),
  CONSTRAINT `fk_livraison_fk_user_valid` FOREIGN KEY (`fk_user_valid`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_livraison`
--

LOCK TABLES `llx_livraison` WRITE;
/*!40000 ALTER TABLE `llx_livraison` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_livraison` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_livraison_extrafields`
--

DROP TABLE IF EXISTS `llx_livraison_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_livraison_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_livraison_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_livraison_extrafields`
--

LOCK TABLES `llx_livraison_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_livraison_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_livraison_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_livraisondet`
--

DROP TABLE IF EXISTS `llx_livraisondet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_livraisondet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_livraison` int(11) DEFAULT NULL,
  `fk_origin_line` int(11) DEFAULT NULL,
  `fk_product` int(11) DEFAULT NULL,
  `description` text,
  `qty` double DEFAULT NULL,
  `subprice` double(24,8) DEFAULT '0.00000000',
  `total_ht` double(24,8) DEFAULT '0.00000000',
  `rang` int(11) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  KEY `idx_livraisondet_fk_expedition` (`fk_livraison`),
  CONSTRAINT `fk_livraisondet_fk_livraison` FOREIGN KEY (`fk_livraison`) REFERENCES `llx_livraison` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_livraisondet`
--

LOCK TABLES `llx_livraisondet` WRITE;
/*!40000 ALTER TABLE `llx_livraisondet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_livraisondet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_livraisondet_extrafields`
--

DROP TABLE IF EXISTS `llx_livraisondet_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_livraisondet_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_livraisondet_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_livraisondet_extrafields`
--

LOCK TABLES `llx_livraisondet_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_livraisondet_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_livraisondet_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_loan`
--

DROP TABLE IF EXISTS `llx_loan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_loan` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `label` varchar(80) NOT NULL,
  `fk_bank` int(11) DEFAULT NULL,
  `capital` double(24,8) NOT NULL DEFAULT '0.00000000',
  `datestart` date DEFAULT NULL,
  `dateend` date DEFAULT NULL,
  `nbterm` double DEFAULT NULL,
  `rate` double NOT NULL,
  `note_private` text,
  `note_public` text,
  `capital_position` double(24,8) DEFAULT '0.00000000',
  `date_position` date DEFAULT NULL,
  `paid` smallint(6) NOT NULL DEFAULT '0',
  `accountancy_account_capital` varchar(32) DEFAULT NULL,
  `accountancy_account_insurance` varchar(32) DEFAULT NULL,
  `accountancy_account_interest` varchar(32) DEFAULT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_loan`
--

LOCK TABLES `llx_loan` WRITE;
/*!40000 ALTER TABLE `llx_loan` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_loan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_loan_schedule`
--

DROP TABLE IF EXISTS `llx_loan_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_loan_schedule` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_loan` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` datetime DEFAULT NULL,
  `amount_capital` double(24,8) DEFAULT '0.00000000',
  `amount_insurance` double(24,8) DEFAULT '0.00000000',
  `amount_interest` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int(11) NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `fk_bank` int(11) NOT NULL,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_loan_schedule`
--

LOCK TABLES `llx_loan_schedule` WRITE;
/*!40000 ALTER TABLE `llx_loan_schedule` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_loan_schedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_localtax`
--

DROP TABLE IF EXISTS `llx_localtax`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_localtax` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `localtaxtype` tinyint(4) DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` date DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `note` text,
  `fk_bank` int(11) DEFAULT NULL,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_localtax`
--

LOCK TABLES `llx_localtax` WRITE;
/*!40000 ALTER TABLE `llx_localtax` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_localtax` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_mailing`
--

DROP TABLE IF EXISTS `llx_mailing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_mailing` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `statut` smallint(6) DEFAULT '0',
  `titre` varchar(128) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `sujet` varchar(128) DEFAULT NULL,
  `body` mediumtext,
  `bgcolor` varchar(8) DEFAULT NULL,
  `bgimage` varchar(255) DEFAULT NULL,
  `cible` varchar(60) DEFAULT NULL,
  `nbemail` int(11) DEFAULT NULL,
  `email_from` varchar(160) DEFAULT NULL,
  `email_replyto` varchar(160) DEFAULT NULL,
  `email_errorsto` varchar(160) DEFAULT NULL,
  `tag` varchar(128) DEFAULT NULL,
  `date_creat` datetime DEFAULT NULL,
  `date_valid` datetime DEFAULT NULL,
  `date_appro` datetime DEFAULT NULL,
  `date_envoi` datetime DEFAULT NULL,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_valid` int(11) DEFAULT NULL,
  `fk_user_appro` int(11) DEFAULT NULL,
  `extraparams` varchar(255) DEFAULT NULL,
  `joined_file1` varchar(255) DEFAULT NULL,
  `joined_file2` varchar(255) DEFAULT NULL,
  `joined_file3` varchar(255) DEFAULT NULL,
  `joined_file4` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_mailing`
--

LOCK TABLES `llx_mailing` WRITE;
/*!40000 ALTER TABLE `llx_mailing` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_mailing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_mailing_cibles`
--

DROP TABLE IF EXISTS `llx_mailing_cibles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_mailing_cibles` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_mailing` int(11) NOT NULL,
  `fk_contact` int(11) NOT NULL,
  `lastname` varchar(160) DEFAULT NULL,
  `firstname` varchar(160) DEFAULT NULL,
  `email` varchar(160) NOT NULL,
  `other` varchar(255) DEFAULT NULL,
  `tag` varchar(128) DEFAULT NULL,
  `statut` smallint(6) NOT NULL DEFAULT '0',
  `source_url` varchar(255) DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `source_type` varchar(16) DEFAULT NULL,
  `date_envoi` datetime DEFAULT NULL,
  `error_text` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_mailing_cibles` (`fk_mailing`,`email`),
  KEY `idx_mailing_cibles_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_mailing_cibles`
--

LOCK TABLES `llx_mailing_cibles` WRITE;
/*!40000 ALTER TABLE `llx_mailing_cibles` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_mailing_cibles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_menu`
--

DROP TABLE IF EXISTS `llx_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_menu` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `menu_handler` varchar(16) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `module` varchar(64) DEFAULT NULL,
  `type` varchar(4) NOT NULL,
  `mainmenu` varchar(100) NOT NULL,
  `leftmenu` varchar(100) DEFAULT NULL,
  `fk_menu` int(11) NOT NULL,
  `fk_mainmenu` varchar(100) DEFAULT NULL,
  `fk_leftmenu` varchar(100) DEFAULT NULL,
  `position` int(11) NOT NULL,
  `url` varchar(255) NOT NULL,
  `target` varchar(100) DEFAULT NULL,
  `titre` varchar(255) NOT NULL,
  `langs` varchar(100) DEFAULT NULL,
  `level` smallint(6) DEFAULT NULL,
  `perms` text,
  `enabled` varchar(255) DEFAULT '1',
  `usertype` int(11) NOT NULL DEFAULT '0',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `idx_menu_uk_menu` (`menu_handler`,`fk_menu`,`position`,`url`,`entity`),
  KEY `idx_menu_menuhandler_type` (`menu_handler`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_menu`
--

LOCK TABLES `llx_menu` WRITE;
/*!40000 ALTER TABLE `llx_menu` DISABLE KEYS */;
INSERT INTO `llx_menu` VALUES (1,'all',1,'supplier_proposal','left','commercial','supplier_proposalsubmenu',-1,'commercial',NULL,300,'/supplier_proposal/index.php','','SupplierProposalsShort','supplier_proposal',NULL,'$user->rights->supplier_proposal->lire','$conf->supplier_proposal->enabled',2,'2018-05-18 19:18:17'),(2,'all',1,'supplier_proposal','left','commercial',NULL,-1,'commercial','supplier_proposalsubmenu',301,'/supplier_proposal/card.php?action=create&amp;leftmenu=supplier_proposals','','SupplierProposalNew','supplier_proposal',NULL,'$user->rights->supplier_proposal->creer','$conf->supplier_proposal->enabled',2,'2018-05-18 19:18:17'),(3,'all',1,'supplier_proposal','left','commercial',NULL,-1,'commercial','supplier_proposalsubmenu',302,'/supplier_proposal/list.php?leftmenu=supplier_proposals','','List','supplier_proposal',NULL,'$user->rights->supplier_proposal->lire','$conf->supplier_proposal->enabled',2,'2018-05-18 19:18:17'),(4,'all',1,'supplier_proposal','left','commercial',NULL,-1,'commercial','supplier_proposalsubmenu',303,'/comm/propal/stats/index.php?leftmenu=supplier_proposals&amp;mode=supplier','','Statistics','supplier_proposal',NULL,'$user->rights->supplier_proposal->lire','$conf->supplier_proposal->enabled',2,'2018-05-18 19:18:17'),(5,'all',1,'margins','left','billing','margins',-1,'billing',NULL,100,'/margin/index.php','','Margins','margins',NULL,'$user->rights->margins->liretous','$conf->margin->enabled',2,'2018-05-18 19:18:41'),(6,'all',1,'variants','left','products','product',-1,'products','product',100,'/variants/list.php','','VariantAttributes','products',NULL,'1','$conf->product->enabled',0,'2018-05-18 19:19:09'),(7,'all',1,'agenda','top','agenda',NULL,0,NULL,NULL,15,'/comm/action/index.php','','TMenuAgenda','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(8,'all',1,'agenda','left','agenda',NULL,7,NULL,NULL,100,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda','','Actions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(9,'all',1,'agenda','left','agenda',NULL,8,NULL,NULL,101,'/comm/action/card.php?mainmenu=agenda&amp;leftmenu=agenda&amp;action=create','','NewAction','commercial',NULL,'($user->rights->agenda->myactions->create||$user->rights->agenda->allactions->create)','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(10,'all',1,'agenda','left','agenda',NULL,8,NULL,NULL,140,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda','','Agenda','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(11,'all',1,'agenda','left','agenda',NULL,10,NULL,NULL,141,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo&amp;filter=mine','','MenuToDoMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(12,'all',1,'agenda','left','agenda',NULL,10,NULL,NULL,142,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done&amp;filter=mine','','MenuDoneMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(13,'all',1,'agenda','left','agenda',NULL,10,NULL,NULL,143,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo&amp;filtert=-1','','MenuToDoActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2018-05-18 19:19:14'),(14,'all',1,'agenda','left','agenda',NULL,10,NULL,NULL,144,'/comm/action/index.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done&amp;filtert=-1','','MenuDoneActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2018-05-18 19:19:14'),(15,'all',1,'agenda','left','agenda',NULL,8,NULL,NULL,110,'/comm/action/list.php?mainmenu=agenda&amp;leftmenu=agenda','','List','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(16,'all',1,'agenda','left','agenda',NULL,15,NULL,NULL,111,'/comm/action/list.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo&amp;filter=mine','','MenuToDoMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(17,'all',1,'agenda','left','agenda',NULL,15,NULL,NULL,112,'/comm/action/list.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done&amp;filter=mine','','MenuDoneMyActions','agenda',NULL,'$user->rights->agenda->myactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(18,'all',1,'agenda','left','agenda',NULL,15,NULL,NULL,113,'/comm/action/list.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=todo&amp;filtert=-1','','MenuToDoActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2018-05-18 19:19:14'),(19,'all',1,'agenda','left','agenda',NULL,15,NULL,NULL,114,'/comm/action/list.php?mainmenu=agenda&amp;leftmenu=agenda&amp;status=done&amp;filtert=-1','','MenuDoneActions','agenda',NULL,'$user->rights->agenda->allactions->read','$user->rights->agenda->allactions->read',2,'2018-05-18 19:19:14'),(20,'all',1,'agenda','left','agenda',NULL,8,NULL,NULL,160,'/comm/action/rapport/index.php?mainmenu=agenda&amp;leftmenu=agenda','','Reportings','agenda',NULL,'$user->rights->agenda->allactions->read','$conf->agenda->enabled',2,'2018-05-18 19:19:14'),(21,'all',1,'resource','left','tools','resource',-1,'tools',NULL,100,'/resource/list.php','','MenuResourceIndex','resource',NULL,'$user->rights->resource->read','1',0,'2018-05-18 19:19:16'),(22,'all',1,'resource','left','tools','resource_add',-1,'tools','resource',101,'/resource/card.php?action=create','','MenuResourceAdd','resource',NULL,'$user->rights->resource->write','1',0,'2018-05-18 19:19:16'),(23,'all',1,'resource','left','tools','resource_list',-1,'tools','resource',102,'/resource/list.php','','List','resource',NULL,'$user->rights->resource->read','1',0,'2018-05-18 19:19:16'),(24,'all',1,'ecm','top','ecm',NULL,0,NULL,NULL,100,'/ecm/index.php','','MenuECM','ecm',NULL,'$user->rights->ecm->read || $user->rights->ecm->upload || $user->rights->ecm->setup','$conf->ecm->enabled',2,'2018-05-18 19:19:23'),(25,'all',1,'ecm','left','ecm','ecm',-1,'ecm',NULL,101,'/ecm/index.php?mainmenu=ecm&leftmenu=ecm','','ECMArea','ecm',NULL,'$user->rights->ecm->read || $user->rights->ecm->upload','$user->rights->ecm->read || $user->rights->ecm->upload',2,'2018-05-18 19:19:23'),(26,'all',1,'ecm','left','ecm','ecm_manual',-1,'ecm','ecm',102,'/ecm/index.php?action=file_manager&mainmenu=ecm&leftmenu=ecm','','ECMSectionsManual','ecm',NULL,'$user->rights->ecm->read || $user->rights->ecm->upload','$user->rights->ecm->read || $user->rights->ecm->upload',2,'2018-05-18 19:19:23'),(27,'all',1,'ecm','left','ecm',NULL,-1,'ecm','ecm',103,'/ecm/index_auto.php?action=file_manager&mainmenu=ecm&leftmenu=ecm','','ECMSectionsAuto','ecm',NULL,'$user->rights->ecm->read || $user->rights->ecm->upload','($user->rights->ecm->read || $user->rights->ecm->upload) && ! empty($conf->global->ECM_AUTO_TREE_ENABLED)',2,'2018-05-18 19:19:23'),(28,'all',1,'barcode','left','tools','barcodeprint',-1,'tools',NULL,200,'/barcode/printsheet.php?mainmenu=tools&leftmenu=barcodeprint','','BarCodePrintsheet','products',NULL,'($conf->global->MAIN_USE_ADVANCED_PERMS && $user->rights->barcode->lire_advance) || (! $conf->global->MAIN_USE_ADVANCED_PERMS)','$conf->barcode->enabled',2,'2018-05-18 19:19:41'),(29,'all',1,'barcode','left','home',NULL,-1,'home','admintools',300,'/barcode/codeinit.php?mainmenu=home&leftmenu=admintools','','MassBarcodeInit','products',NULL,'($conf->global->MAIN_USE_ADVANCED_PERMS && $user->rights->barcode->creer_advance) || (! $conf->global->MAIN_USE_ADVANCED_PERMS)','$conf->barcode->enabled && preg_match(\'/^admintools/\',$leftmenu)',0,'2018-05-18 19:19:41'),(30,'all',1,'cashdesk','top','cashdesk',NULL,0,NULL,NULL,900,'/cashdesk/index.php?user=__LOGIN__','pointofsale','CashDeskMenu','cashdesk',NULL,'$user->rights->cashdesk->use','$conf->cashdesk->enabled',0,'2018-05-18 19:20:23'),(31,'all',1,'printing','left','home',NULL,-1,'home','admintools',300,'/printing/index.php?mainmenu=home&leftmenu=admintools','','MenuDirectPrinting','printing',NULL,'$user->rights->printing->read','$conf->printing->enabled && preg_match(\'/^admintools/\', $leftmenu)',0,'2018-05-18 19:21:02'),(32,'all',1,'cron','left','home',NULL,-1,'home','admintools',200,'/cron/list.php?status=-2&leftmenu=admintools','','CronList','cron',NULL,'$user->rights->cron->read','$conf->cron->enabled && preg_match(\'/^admintools/\', $leftmenu)',2,'2018-05-18 19:21:09'),(33,'all',1,'blockedlog','left','tools','blockedlogbrowser',-1,'tools',NULL,200,'/blockedlog/admin/blockedlog_list.php?mainmenu=tools&leftmenu=blockedlogbrowser','','BrowseBlockedLog','blockedlog',NULL,'$user->rights->blockedlog->read','$conf->blockedlog->enabled',2,'2018-05-18 19:21:14');
/*!40000 ALTER TABLE `llx_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_multicurrency`
--

DROP TABLE IF EXISTS `llx_multicurrency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_multicurrency` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `date_create` datetime DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `entity` int(11) DEFAULT '1',
  `fk_user` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_multicurrency`
--

LOCK TABLES `llx_multicurrency` WRITE;
/*!40000 ALTER TABLE `llx_multicurrency` DISABLE KEYS */;
INSERT INTO `llx_multicurrency` VALUES (1,'2018-05-18 19:19:31','EUR','Euros (EUR)',1,1);
/*!40000 ALTER TABLE `llx_multicurrency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_multicurrency_rate`
--

DROP TABLE IF EXISTS `llx_multicurrency_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_multicurrency_rate` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `date_sync` datetime DEFAULT NULL,
  `rate` double NOT NULL DEFAULT '0',
  `fk_multicurrency` int(11) NOT NULL,
  `entity` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_multicurrency_rate`
--

LOCK TABLES `llx_multicurrency_rate` WRITE;
/*!40000 ALTER TABLE `llx_multicurrency_rate` DISABLE KEYS */;
INSERT INTO `llx_multicurrency_rate` VALUES (1,'2018-05-18 19:19:31',1,1,1);
/*!40000 ALTER TABLE `llx_multicurrency_rate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_notify`
--

DROP TABLE IF EXISTS `llx_notify`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_notify` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `daten` datetime DEFAULT NULL,
  `fk_action` int(11) NOT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `fk_contact` int(11) DEFAULT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `type` varchar(16) DEFAULT 'email',
  `type_target` varchar(16) DEFAULT NULL,
  `objet_type` varchar(24) NOT NULL,
  `objet_id` int(11) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_notify`
--

LOCK TABLES `llx_notify` WRITE;
/*!40000 ALTER TABLE `llx_notify` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_notify` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_notify_def`
--

DROP TABLE IF EXISTS `llx_notify_def`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_notify_def` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` date DEFAULT NULL,
  `fk_action` int(11) NOT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `fk_contact` int(11) DEFAULT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `type` varchar(16) DEFAULT 'email',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_notify_def`
--

LOCK TABLES `llx_notify_def` WRITE;
/*!40000 ALTER TABLE `llx_notify_def` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_notify_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_notify_def_object`
--

DROP TABLE IF EXISTS `llx_notify_def_object`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_notify_def_object` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `objet_type` varchar(16) DEFAULT NULL,
  `objet_id` int(11) NOT NULL,
  `type_notif` varchar(16) DEFAULT 'browser',
  `date_notif` datetime DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `moreparam` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_notify_def_object`
--

LOCK TABLES `llx_notify_def_object` WRITE;
/*!40000 ALTER TABLE `llx_notify_def_object` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_notify_def_object` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_oauth_state`
--

DROP TABLE IF EXISTS `llx_oauth_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_oauth_state` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(36) DEFAULT NULL,
  `state` varchar(128) DEFAULT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `fk_adherent` int(11) DEFAULT NULL,
  `entity` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_oauth_state`
--

LOCK TABLES `llx_oauth_state` WRITE;
/*!40000 ALTER TABLE `llx_oauth_state` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_oauth_state` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_oauth_token`
--

DROP TABLE IF EXISTS `llx_oauth_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_oauth_token` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(36) DEFAULT NULL,
  `token` text,
  `fk_user` int(11) DEFAULT NULL,
  `fk_adherent` int(11) DEFAULT NULL,
  `entity` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_oauth_token`
--

LOCK TABLES `llx_oauth_token` WRITE;
/*!40000 ALTER TABLE `llx_oauth_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_oauth_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_onlinesignature`
--

DROP TABLE IF EXISTS `llx_onlinesignature`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_onlinesignature` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `object_type` varchar(32) NOT NULL,
  `object_id` int(11) NOT NULL,
  `datec` datetime NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name` varchar(255) NOT NULL,
  `ip` varchar(128) DEFAULT NULL,
  `pathoffile` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_onlinesignature`
--

LOCK TABLES `llx_onlinesignature` WRITE;
/*!40000 ALTER TABLE `llx_onlinesignature` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_onlinesignature` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_opensurvey_comments`
--

DROP TABLE IF EXISTS `llx_opensurvey_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_opensurvey_comments` (
  `id_comment` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_sondage` char(16) NOT NULL,
  `comment` text NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `usercomment` text,
  PRIMARY KEY (`id_comment`),
  KEY `idx_id_comment` (`id_comment`),
  KEY `idx_id_sondage` (`id_sondage`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_opensurvey_comments`
--

LOCK TABLES `llx_opensurvey_comments` WRITE;
/*!40000 ALTER TABLE `llx_opensurvey_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_opensurvey_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_opensurvey_formquestions`
--

DROP TABLE IF EXISTS `llx_opensurvey_formquestions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_opensurvey_formquestions` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `id_sondage` varchar(16) DEFAULT NULL,
  `question` text,
  `available_answers` text,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_opensurvey_formquestions`
--

LOCK TABLES `llx_opensurvey_formquestions` WRITE;
/*!40000 ALTER TABLE `llx_opensurvey_formquestions` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_opensurvey_formquestions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_opensurvey_sondage`
--

DROP TABLE IF EXISTS `llx_opensurvey_sondage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_opensurvey_sondage` (
  `id_sondage` varchar(16) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `commentaires` text,
  `mail_admin` varchar(128) DEFAULT NULL,
  `nom_admin` varchar(64) DEFAULT NULL,
  `fk_user_creat` int(11) NOT NULL,
  `titre` text NOT NULL,
  `date_fin` datetime DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  `format` varchar(2) NOT NULL,
  `mailsonde` tinyint(4) NOT NULL DEFAULT '0',
  `allow_comments` tinyint(4) NOT NULL DEFAULT '1',
  `allow_spy` tinyint(4) NOT NULL DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sujet` text,
  PRIMARY KEY (`id_sondage`),
  KEY `idx_date_fin` (`date_fin`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_opensurvey_sondage`
--

LOCK TABLES `llx_opensurvey_sondage` WRITE;
/*!40000 ALTER TABLE `llx_opensurvey_sondage` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_opensurvey_sondage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_opensurvey_user_formanswers`
--

DROP TABLE IF EXISTS `llx_opensurvey_user_formanswers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_opensurvey_user_formanswers` (
  `fk_user_survey` int(11) NOT NULL,
  `fk_question` int(11) NOT NULL,
  `reponses` text
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_opensurvey_user_formanswers`
--

LOCK TABLES `llx_opensurvey_user_formanswers` WRITE;
/*!40000 ALTER TABLE `llx_opensurvey_user_formanswers` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_opensurvey_user_formanswers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_opensurvey_user_studs`
--

DROP TABLE IF EXISTS `llx_opensurvey_user_studs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_opensurvey_user_studs` (
  `id_users` int(11) NOT NULL AUTO_INCREMENT,
  `nom` varchar(64) NOT NULL,
  `id_sondage` varchar(16) NOT NULL,
  `reponses` varchar(100) NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_users`),
  KEY `idx_opensurvey_user_studs_id_users` (`id_users`),
  KEY `idx_opensurvey_user_studs_nom` (`nom`),
  KEY `idx_opensurvey_user_studs_id_sondage` (`id_sondage`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_opensurvey_user_studs`
--

LOCK TABLES `llx_opensurvey_user_studs` WRITE;
/*!40000 ALTER TABLE `llx_opensurvey_user_studs` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_opensurvey_user_studs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_overwrite_trans`
--

DROP TABLE IF EXISTS `llx_overwrite_trans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_overwrite_trans` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `lang` varchar(5) DEFAULT NULL,
  `transkey` varchar(128) DEFAULT NULL,
  `transvalue` text,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_overwrite_trans` (`lang`,`transkey`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_overwrite_trans`
--

LOCK TABLES `llx_overwrite_trans` WRITE;
/*!40000 ALTER TABLE `llx_overwrite_trans` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_overwrite_trans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiement`
--

DROP TABLE IF EXISTS `llx_paiement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_paiement` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  `fk_paiement` int(11) NOT NULL,
  `num_paiement` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL DEFAULT '0',
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `statut` smallint(6) NOT NULL DEFAULT '0',
  `fk_export_compta` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_paiement`
--

LOCK TABLES `llx_paiement` WRITE;
/*!40000 ALTER TABLE `llx_paiement` DISABLE KEYS */;
INSERT INTO `llx_paiement` VALUES (1,'PAY1807-0001',1,'2018-07-06 09:45:20','2018-07-06 09:45:21','2018-07-06 12:00:00',4840.00000000,4840.00000000,2,'','',2,1,NULL,0,0),(2,'PAY1807-0002',1,'2018-07-06 09:45:36','2018-07-06 09:45:37','2018-07-06 12:00:00',242.00000000,242.00000000,2,'','',3,1,NULL,0,0),(3,'PAY1807-0003',1,'2018-07-20 06:45:20','2018-07-20 06:45:20','2018-07-20 12:00:00',80.00000000,80.00000000,2,'','',4,1,NULL,0,0),(4,'PAY1808-0004',1,'2018-08-24 09:08:46','2018-08-24 09:08:47','2018-08-24 12:00:00',1633.50000000,1633.50000000,2,'','',5,1,NULL,0,0),(5,'PAY1808-0005',1,'2018-08-24 09:09:03','2018-08-24 09:09:04','2018-08-24 12:00:00',-1089.00000000,-1089.00000000,2,'','',6,1,NULL,0,0),(6,'PAY1810-0006',1,'2018-10-04 09:34:50','2018-10-04 09:34:50','2018-10-04 12:00:00',5000.00000000,5000.00000000,2,'','',7,1,NULL,0,0),(7,'PAY1810-0007',1,'2018-10-04 09:35:44','2018-10-04 09:35:44','2018-10-04 12:00:00',544.50000000,544.50000000,2,'','',8,1,NULL,0,0),(8,'PAY1810-0008',1,'2018-10-04 09:36:33','2018-10-04 09:36:33','2018-10-04 12:00:00',642.00000000,642.00000000,2,'','',9,1,NULL,0,0),(9,'PAY1810-0009',1,'2018-10-04 09:36:50','2018-10-04 09:36:50','2018-10-04 12:00:00',-242.00000000,-242.00000000,2,'','',10,1,NULL,0,0),(10,'PAY1812-0010',1,'2018-12-07 10:21:45','2018-12-07 10:21:46','2018-12-07 12:00:00',556.00000000,556.00000000,2,'','',11,1,NULL,0,0);
/*!40000 ALTER TABLE `llx_paiement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiement_facture`
--

DROP TABLE IF EXISTS `llx_paiement_facture`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_paiement_facture` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_paiement` int(11) DEFAULT NULL,
  `fk_facture` int(11) DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_paiement_facture` (`fk_paiement`,`fk_facture`),
  KEY `idx_paiement_facture_fk_facture` (`fk_facture`),
  KEY `idx_paiement_facture_fk_paiement` (`fk_paiement`),
  CONSTRAINT `fk_paiement_facture_fk_facture` FOREIGN KEY (`fk_facture`) REFERENCES `llx_facture` (`rowid`),
  CONSTRAINT `fk_paiement_facture_fk_paiement` FOREIGN KEY (`fk_paiement`) REFERENCES `llx_paiement` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_paiement_facture`
--

LOCK TABLES `llx_paiement_facture` WRITE;
/*!40000 ALTER TABLE `llx_paiement_facture` DISABLE KEYS */;
INSERT INTO `llx_paiement_facture` VALUES (1,1,2,4840.00000000,NULL,1.00000000,4840.00000000),(2,2,3,242.00000000,NULL,1.00000000,242.00000000),(3,3,4,80.00000000,NULL,1.00000000,80.00000000),(4,4,5,1089.00000000,NULL,1.00000000,1089.00000000),(5,4,6,544.50000000,NULL,1.00000000,544.50000000),(6,5,9,-1089.00000000,NULL,1.00000000,-1089.00000000),(7,6,18,5000.00000000,NULL,1.00000000,5000.00000000),(8,7,10,544.50000000,NULL,1.00000000,544.50000000),(9,8,14,242.00000000,NULL,1.00000000,242.00000000),(10,8,16,200.00000000,NULL,1.00000000,200.00000000),(11,8,17,200.00000000,NULL,1.00000000,200.00000000),(12,9,15,-242.00000000,NULL,1.00000000,-242.00000000),(13,10,23,556.00000000,NULL,1.00000000,556.00000000);
/*!40000 ALTER TABLE `llx_paiement_facture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiementcharge`
--

DROP TABLE IF EXISTS `llx_paiementcharge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_paiementcharge` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_charge` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_typepaiement` int(11) NOT NULL,
  `num_paiement` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_paiementcharge`
--

LOCK TABLES `llx_paiementcharge` WRITE;
/*!40000 ALTER TABLE `llx_paiementcharge` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_paiementcharge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiementfourn`
--

DROP TABLE IF EXISTS `llx_paiementfourn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_paiementfourn` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) DEFAULT NULL,
  `entity` int(11) DEFAULT '1',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_paiement` int(11) NOT NULL,
  `num_paiement` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL,
  `statut` smallint(6) NOT NULL DEFAULT '0',
  `model_pdf` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_paiementfourn`
--

LOCK TABLES `llx_paiementfourn` WRITE;
/*!40000 ALTER TABLE `llx_paiementfourn` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_paiementfourn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_paiementfourn_facturefourn`
--

DROP TABLE IF EXISTS `llx_paiementfourn_facturefourn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_paiementfourn_facturefourn` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_paiementfourn` int(11) DEFAULT NULL,
  `fk_facturefourn` int(11) DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_amount` double(24,8) DEFAULT '0.00000000',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_paiementfourn_facturefourn` (`fk_paiementfourn`,`fk_facturefourn`),
  KEY `idx_paiementfourn_facturefourn_fk_facture` (`fk_facturefourn`),
  KEY `idx_paiementfourn_facturefourn_fk_paiement` (`fk_paiementfourn`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_paiementfourn_facturefourn`
--

LOCK TABLES `llx_paiementfourn_facturefourn` WRITE;
/*!40000 ALTER TABLE `llx_paiementfourn_facturefourn` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_paiementfourn_facturefourn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_payment_donation`
--

DROP TABLE IF EXISTS `llx_payment_donation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_payment_donation` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_donation` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int(11) NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_payment_donation`
--

LOCK TABLES `llx_payment_donation` WRITE;
/*!40000 ALTER TABLE `llx_payment_donation` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_payment_donation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_payment_expensereport`
--

DROP TABLE IF EXISTS `llx_payment_expensereport`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_payment_expensereport` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_expensereport` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int(11) NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note` text,
  `fk_bank` int(11) NOT NULL,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_payment_expensereport`
--

LOCK TABLES `llx_payment_expensereport` WRITE;
/*!40000 ALTER TABLE `llx_payment_expensereport` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_payment_expensereport` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_payment_loan`
--

DROP TABLE IF EXISTS `llx_payment_loan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_payment_loan` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_loan` int(11) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datep` datetime DEFAULT NULL,
  `amount_capital` double(24,8) DEFAULT '0.00000000',
  `amount_insurance` double(24,8) DEFAULT '0.00000000',
  `amount_interest` double(24,8) DEFAULT '0.00000000',
  `fk_typepayment` int(11) NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `note_private` text,
  `note_public` text,
  `fk_bank` int(11) NOT NULL,
  `fk_user_creat` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_payment_loan`
--

LOCK TABLES `llx_payment_loan` WRITE;
/*!40000 ALTER TABLE `llx_payment_loan` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_payment_loan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_payment_salary`
--

DROP TABLE IF EXISTS `llx_payment_salary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_payment_salary` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `fk_user` int(11) NOT NULL,
  `datep` date DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `salary` double(24,8) DEFAULT NULL,
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fk_typepayment` int(11) NOT NULL,
  `num_payment` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `datesp` date DEFAULT NULL,
  `dateep` date DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `note` text,
  `fk_bank` int(11) DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_payment_salary_ref` (`num_payment`),
  KEY `idx_payment_salary_user` (`fk_user`,`entity`),
  KEY `idx_payment_salary_datep` (`datep`),
  KEY `idx_payment_salary_datesp` (`datesp`),
  KEY `idx_payment_salary_dateep` (`dateep`),
  CONSTRAINT `fk_payment_salary_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_payment_salary`
--

LOCK TABLES `llx_payment_salary` WRITE;
/*!40000 ALTER TABLE `llx_payment_salary` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_payment_salary` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_payment_various`
--

DROP TABLE IF EXISTS `llx_payment_various`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_payment_various` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `num_payment` varchar(50) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `datep` date DEFAULT NULL,
  `datev` date DEFAULT NULL,
  `sens` smallint(6) NOT NULL DEFAULT '0',
  `amount` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fk_typepayment` int(11) NOT NULL,
  `accountancy_code` varchar(32) DEFAULT NULL,
  `fk_projet` int(11) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `note` text,
  `fk_bank` int(11) DEFAULT NULL,
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_payment_various`
--

LOCK TABLES `llx_payment_various` WRITE;
/*!40000 ALTER TABLE `llx_payment_various` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_payment_various` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_bons`
--

DROP TABLE IF EXISTS `llx_prelevement_bons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_prelevement_bons` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(12) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `statut` smallint(6) DEFAULT '0',
  `credite` smallint(6) DEFAULT '0',
  `note` text,
  `date_trans` datetime DEFAULT NULL,
  `method_trans` smallint(6) DEFAULT NULL,
  `fk_user_trans` int(11) DEFAULT NULL,
  `date_credit` datetime DEFAULT NULL,
  `fk_user_credit` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_prelevement_bons_ref` (`ref`,`entity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_prelevement_bons`
--

LOCK TABLES `llx_prelevement_bons` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_bons` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_bons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_facture`
--

DROP TABLE IF EXISTS `llx_prelevement_facture`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_prelevement_facture` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_facture` int(11) NOT NULL,
  `fk_prelevement_lignes` int(11) NOT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevement_facture_fk_prelevement_lignes` (`fk_prelevement_lignes`),
  CONSTRAINT `fk_prelevement_facture_fk_prelevement_lignes` FOREIGN KEY (`fk_prelevement_lignes`) REFERENCES `llx_prelevement_lignes` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_prelevement_facture`
--

LOCK TABLES `llx_prelevement_facture` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_facture` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_facture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_facture_demande`
--

DROP TABLE IF EXISTS `llx_prelevement_facture_demande`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_prelevement_facture_demande` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_facture` int(11) NOT NULL,
  `amount` double(24,8) NOT NULL,
  `date_demande` datetime NOT NULL,
  `traite` smallint(6) DEFAULT '0',
  `date_traite` datetime DEFAULT NULL,
  `fk_prelevement_bons` int(11) DEFAULT NULL,
  `fk_user_demande` int(11) NOT NULL,
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_prelevement_facture_demande`
--

LOCK TABLES `llx_prelevement_facture_demande` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_facture_demande` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_facture_demande` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_lignes`
--

DROP TABLE IF EXISTS `llx_prelevement_lignes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_prelevement_lignes` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_prelevement_bons` int(11) DEFAULT NULL,
  `fk_soc` int(11) NOT NULL,
  `statut` smallint(6) DEFAULT '0',
  `client_nom` varchar(255) DEFAULT NULL,
  `amount` double(24,8) DEFAULT '0.00000000',
  `code_banque` varchar(128) DEFAULT NULL,
  `code_guichet` varchar(6) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `cle_rib` varchar(5) DEFAULT NULL,
  `note` text,
  PRIMARY KEY (`rowid`),
  KEY `idx_prelevement_lignes_fk_prelevement_bons` (`fk_prelevement_bons`),
  CONSTRAINT `fk_prelevement_lignes_fk_prelevement_bons` FOREIGN KEY (`fk_prelevement_bons`) REFERENCES `llx_prelevement_bons` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_prelevement_lignes`
--

LOCK TABLES `llx_prelevement_lignes` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_lignes` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_lignes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_prelevement_rejet`
--

DROP TABLE IF EXISTS `llx_prelevement_rejet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_prelevement_rejet` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_prelevement_lignes` int(11) DEFAULT NULL,
  `date_rejet` datetime DEFAULT NULL,
  `motif` int(11) DEFAULT NULL,
  `date_creation` datetime DEFAULT NULL,
  `fk_user_creation` int(11) DEFAULT NULL,
  `note` text,
  `afacturer` tinyint(4) DEFAULT '0',
  `fk_facture` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_prelevement_rejet`
--

LOCK TABLES `llx_prelevement_rejet` WRITE;
/*!40000 ALTER TABLE `llx_prelevement_rejet` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_prelevement_rejet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_printing`
--

DROP TABLE IF EXISTS `llx_printing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_printing` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datec` datetime DEFAULT NULL,
  `printer_name` text NOT NULL,
  `printer_location` text NOT NULL,
  `printer_id` varchar(255) NOT NULL,
  `copy` int(11) NOT NULL DEFAULT '1',
  `module` varchar(16) NOT NULL,
  `driver` varchar(16) NOT NULL,
  `userid` int(11) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_printing`
--

LOCK TABLES `llx_printing` WRITE;
/*!40000 ALTER TABLE `llx_printing` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_printing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product`
--

DROP TABLE IF EXISTS `llx_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(128) NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  `ref_ext` varchar(128) DEFAULT NULL,
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_parent` int(11) DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  `note_public` text,
  `note` text,
  `customcode` varchar(32) DEFAULT NULL,
  `fk_country` int(11) DEFAULT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `price_ttc` double(24,8) DEFAULT '0.00000000',
  `price_min` double(24,8) DEFAULT '0.00000000',
  `price_min_ttc` double(24,8) DEFAULT '0.00000000',
  `price_base_type` varchar(3) DEFAULT 'HT',
  `cost_price` double(24,8) DEFAULT NULL,
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) DEFAULT NULL,
  `recuperableonly` int(11) NOT NULL DEFAULT '0',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `fk_user_author` int(11) DEFAULT NULL,
  `fk_user_modif` int(11) DEFAULT NULL,
  `tosell` tinyint(4) DEFAULT '1',
  `tobuy` tinyint(4) DEFAULT '1',
  `onportal` tinyint(4) DEFAULT '0',
  `tobatch` tinyint(4) NOT NULL DEFAULT '0',
  `fk_product_type` int(11) DEFAULT '0',
  `duration` varchar(6) DEFAULT NULL,
  `seuil_stock_alerte` int(11) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `barcode` varchar(180) DEFAULT NULL,
  `fk_barcode_type` int(11) DEFAULT NULL,
  `accountancy_code_sell` varchar(32) DEFAULT NULL,
  `accountancy_code_sell_intra` varchar(32) DEFAULT NULL,
  `accountancy_code_sell_export` varchar(32) DEFAULT NULL,
  `accountancy_code_buy` varchar(32) DEFAULT NULL,
  `partnumber` varchar(32) DEFAULT NULL,
  `weight` float DEFAULT NULL,
  `weight_units` tinyint(4) DEFAULT NULL,
  `length` float DEFAULT NULL,
  `length_units` tinyint(4) DEFAULT NULL,
  `width` float DEFAULT NULL,
  `width_units` tinyint(4) DEFAULT NULL,
  `height` float DEFAULT NULL,
  `height_units` tinyint(4) DEFAULT NULL,
  `surface` float DEFAULT NULL,
  `surface_units` tinyint(4) DEFAULT NULL,
  `volume` float DEFAULT NULL,
  `volume_units` tinyint(4) DEFAULT NULL,
  `stock` double DEFAULT NULL,
  `pmp` double(24,8) NOT NULL DEFAULT '0.00000000',
  `fifo` double(24,8) DEFAULT NULL,
  `lifo` double(24,8) DEFAULT NULL,
  `canvas` varchar(32) DEFAULT NULL,
  `finished` tinyint(4) DEFAULT NULL,
  `hidden` tinyint(4) DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  `model_pdf` varchar(255) DEFAULT NULL,
  `fk_price_expression` int(11) DEFAULT NULL,
  `desiredstock` int(11) DEFAULT '0',
  `fk_unit` int(11) DEFAULT NULL,
  `price_autogen` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_ref` (`ref`,`entity`),
  UNIQUE KEY `uk_product_barcode` (`barcode`,`fk_barcode_type`,`entity`),
  KEY `idx_product_label` (`label`),
  KEY `idx_product_barcode` (`barcode`),
  KEY `idx_product_import_key` (`import_key`),
  KEY `idx_product_seuil_stock_alerte` (`seuil_stock_alerte`),
  KEY `idx_product_fk_country` (`fk_country`),
  KEY `idx_product_fk_user_author` (`fk_user_author`),
  KEY `idx_product_fk_barcode_type` (`fk_barcode_type`),
  KEY `fk_product_fk_unit` (`fk_unit`),
  CONSTRAINT `fk_product_barcode_type` FOREIGN KEY (`fk_barcode_type`) REFERENCES `llx_c_barcode_type` (`rowid`),
  CONSTRAINT `fk_product_fk_country` FOREIGN KEY (`fk_country`) REFERENCES `llx_c_country` (`rowid`),
  CONSTRAINT `fk_product_fk_unit` FOREIGN KEY (`fk_unit`) REFERENCES `llx_c_units` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product`
--

LOCK TABLES `llx_product` WRITE;
/*!40000 ALTER TABLE `llx_product` DISABLE KEYS */;
INSERT INTO `llx_product` VALUES (1,'A_1_Box37',1,NULL,'2018-05-22 06:08:53','2018-05-22 06:13:19',0,'Box A1 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',1,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(2,'A_3_Box37',1,NULL,'2018-05-22 06:12:14','2018-05-22 06:13:32',0,'Box A3 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(3,'A_5_Box37',1,NULL,'2018-05-22 06:14:04','2018-05-22 06:14:19',0,'Box A5 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(4,'A_7_Box37',1,NULL,'2018-05-22 06:14:35','2018-05-22 06:14:49',0,'Box A7 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(5,'A_9_Box37',1,NULL,'2018-05-22 06:15:26','2018-05-22 06:15:35',0,'Box A9 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(6,'A_11_Box37',1,NULL,'2018-05-22 06:15:46','2018-05-22 06:16:02',0,'Box A11 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(7,'A_13_Box37',1,NULL,'2018-05-22 06:16:14','2018-05-22 06:16:24',0,'Box A13 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(8,'A_15_Box37',1,NULL,'2018-05-22 06:16:34','2018-05-22 06:16:45',0,'Box A15 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(9,'A_17_Box37',1,NULL,'2018-05-22 06:16:58','2018-05-22 06:17:08',0,'Box A17 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(10,'A_19_Box37',1,NULL,'2018-05-22 06:17:18','2018-05-22 06:17:35',0,'Box A19 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(11,'A_21_Box37',1,NULL,'2018-05-22 06:17:44','2018-05-22 06:17:56',0,'Box A21 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(12,'A_23_Box37',1,NULL,'2018-05-22 06:18:08','2018-05-22 06:18:19',0,'Box A23 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(13,'A_25_Box37',1,NULL,'2018-05-22 06:20:00','2018-05-22 06:20:10',0,'Box A25 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(14,'A_27_Box37',1,NULL,'2018-05-22 06:21:22','2018-05-22 06:21:35',0,'Box A27 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(15,'A_29_Box37',1,NULL,'2018-05-22 06:21:45','2018-05-22 06:21:54',0,'Box A29 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(16,'A_31_Box37',1,NULL,'2018-05-22 06:24:41','2018-05-22 06:25:24',0,'Box A31 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(17,'A_33_Box37',1,NULL,'2018-05-22 06:25:37','2018-05-22 06:25:46',0,'Box A33 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(18,'A_35_Box37',1,NULL,'2018-05-22 06:25:55','2018-05-22 06:26:08',0,'Box A35 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(19,'A_37_Box37',1,NULL,'2018-05-22 06:26:16','2018-05-22 06:26:28',0,'Box A39 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(20,'A_39_Box37',1,NULL,'2018-05-22 06:26:36','2018-05-22 06:26:47',0,'Box A39 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(21,'A_2_Box40',1,NULL,'2018-05-22 06:27:51','2018-05-22 06:54:02',0,'Box A2 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(22,'A_4_Box40',1,NULL,'2018-05-22 06:30:01','2018-05-22 06:54:27',0,'Box A4 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(23,'A_6_Box40',1,NULL,'2018-05-22 06:30:23','2018-05-22 06:54:55',0,'Box A6  4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(24,'A_8_Box40',1,NULL,'2018-05-22 06:30:48','2018-05-22 06:51:25',0,'Box A8 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(25,'A_10_Box40',1,NULL,'2018-05-22 06:31:09','2018-05-22 07:19:58',0,'Box A10 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,40,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(26,'A_12_Box40',1,NULL,'2018-05-22 06:33:17','2018-05-22 07:19:40',0,'Box A12 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(27,'A_14_Box40',1,NULL,'2018-05-22 06:33:37','2018-05-22 07:20:32',0,'Box A14 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,40,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(28,'A_16_Box40',1,NULL,'2018-05-22 06:33:55','2018-05-22 07:21:10',0,'Box A16 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,40,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(29,'A_18_Box40',1,NULL,'2018-05-22 06:34:17','2018-05-22 07:21:47',0,'Box A18 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(30,'A_20_Box40',1,NULL,'2018-05-22 06:34:36','2018-05-22 07:22:47',0,'Box A20 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(31,'A_22_Box40',1,NULL,'2018-05-22 06:38:10','2018-05-22 07:23:20',0,'Box A22 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(32,'A_24_Box40',1,NULL,'2018-05-22 06:38:49','2018-05-22 07:23:58',0,'Box A24 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(33,'A_26_Box40',1,NULL,'2018-05-22 06:39:17','2018-05-22 07:24:29',0,'Box A26 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(34,'A_28_Box40',1,NULL,'2018-05-22 06:39:40','2018-05-22 07:25:03',0,'Box A28 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(35,'A_30_Box40',1,NULL,'2018-05-22 06:40:30','2018-05-22 07:25:40',0,'Box A30 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(36,'A_32_Box40',1,NULL,'2018-05-22 06:41:20','2018-05-22 07:26:13',0,'Box A32 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(37,'A_34_Box40',1,NULL,'2018-05-22 06:41:43','2018-05-22 07:26:47',0,'Box A34 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(38,'A_36_Box40',1,NULL,'2018-05-22 06:42:35','2018-05-22 07:27:21',0,'Box A36 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(39,'A_38_Box40',1,NULL,'2018-05-22 06:43:13','2018-05-22 07:27:55',0,'Box A38 4 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(40,'B_1_Box40',1,NULL,'2018-05-22 07:28:47','2018-05-22 07:29:02',0,'Box B1 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(41,'B_3_Box40',1,NULL,'2018-05-22 07:29:27','2018-05-22 07:29:38',0,'Box B3 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(42,'B_5_Box40',1,NULL,'2018-05-22 07:30:30','2018-05-22 07:30:41',0,'Box B5 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(43,'B_7_Box40',1,NULL,'2018-05-22 07:30:58','2018-05-22 07:31:09',0,'Box B7 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(44,'B_9_Box40',1,NULL,'2018-05-22 07:31:17','2018-05-22 07:31:29',0,'Box B9 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(45,'B_11_Box40',1,NULL,'2018-05-22 07:31:37','2018-05-22 07:31:45',0,'Box B11 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(46,'B_13_Box40',1,NULL,'2018-05-22 07:31:54','2018-05-22 07:32:05',0,'Box B13 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(47,'B_15_Box40',1,NULL,'2018-05-22 07:32:17','2018-05-22 07:32:26',0,'Box B15 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(48,'B_17_Box40',1,NULL,'2018-05-22 07:32:37','2018-05-22 07:32:48',0,'Box B17 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(49,'B_19_Box40',1,NULL,'2018-05-22 07:33:00','2018-05-22 07:33:10',0,'Box B19 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(50,'B_21_Box40',1,NULL,'2018-05-22 07:33:35','2018-05-22 07:33:45',0,'Box B21 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(51,'B_23_Box40',1,NULL,'2018-05-22 07:33:54','2018-05-22 07:34:02',0,'Box B23 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(52,'B_25_Box40',1,NULL,'2018-05-22 07:34:13','2018-05-22 07:34:25',0,'Box B25 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(53,'B_27_Box40',1,NULL,'2018-05-22 07:34:36','2018-05-22 07:34:43',0,'Box B27 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(54,'B_29_Box40',1,NULL,'2018-05-22 07:34:53','2018-05-22 07:35:06',0,'Box B29 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(55,'B_31_Box40',1,NULL,'2018-05-22 07:35:14','2018-05-22 07:35:23',0,'Box B31 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(56,'B_33_Box40',1,NULL,'2018-05-22 07:35:32','2018-05-22 07:35:40',0,'Box B33 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(57,'B_35_Box40',1,NULL,'2018-05-22 07:35:52','2018-05-22 07:36:02',0,'Box B35 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(58,'B_37_Box40',1,NULL,'2018-05-22 07:36:17','2018-05-22 07:36:31',0,'Box B37 4m³','Box de Acces securise&nbsp;<br />\r\nVolume de 4 m&sup3;',NULL,'','',2,40.00000000,40.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,4,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(59,'B_2_Box37',1,NULL,'2018-05-22 07:37:19','2018-05-22 07:37:33',0,'Box B2 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(60,'B_4_Box37',1,NULL,'2018-05-22 07:37:42','2018-05-22 07:37:52',0,'Box B4 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(61,'B_6_Box37',1,NULL,'2018-05-22 07:37:59','2018-05-22 07:38:09',0,'Box B6 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(62,'B_8_Box37',1,NULL,'2018-05-22 07:38:20','2018-05-22 07:38:29',0,'Box B8 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(63,'B_10_Box37',1,NULL,'2018-05-22 07:38:37','2018-05-22 07:38:46',0,'Box B10 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(64,'B_12_Box37',1,NULL,'2018-05-22 07:39:02','2018-05-22 07:39:11',0,'Box B12 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(65,'B_14_Box37',1,NULL,'2018-05-22 07:39:19','2018-05-22 07:39:27',0,'Box B14 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(66,'B_16_Box37',1,NULL,'2018-05-22 07:39:35','2018-05-22 07:39:43',0,'Box B16 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(67,'B_18_Box37',1,NULL,'2018-05-22 07:39:51','2018-05-22 07:40:01',0,'Box B18 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(68,'B_20_Box37',1,NULL,'2018-05-22 07:40:24','2018-05-22 07:40:33',0,'Box B20 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(69,'B_22_Box37',1,NULL,'2018-05-22 07:40:41','2018-05-22 07:40:49',0,'Box B22 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(70,'B_24_Box37',1,NULL,'2018-05-22 07:40:59','2018-05-22 07:41:07',0,'Box B24 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(71,'B_26_Box37',1,NULL,'2018-05-22 07:41:18','2018-05-22 07:41:24',0,'Box B26 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(72,'B_28_Box37',1,NULL,'2018-05-22 07:41:33','2018-05-22 07:41:40',0,'Box B28 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(73,'B_30_Box37',1,NULL,'2018-05-22 07:41:49','2018-05-22 07:41:59',0,'Box B30 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(74,'B_32_Box37',1,NULL,'2018-05-22 07:42:07','2018-05-22 07:42:14',0,'Box B32 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(75,'B_34_Box37',1,NULL,'2018-05-22 07:42:23','2018-05-22 07:42:35',0,'Box B34 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(76,'B_36_Box37',1,NULL,'2018-05-22 07:42:47','2018-05-22 07:42:55',0,'Box B36 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(77,'B_38_Box37',1,NULL,'2018-05-22 07:43:10','2018-05-22 07:43:19',0,'Box B38 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,'','',2,35.00000000,35.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,3.7,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(78,'C_1_Box11',1,NULL,'2018-05-22 07:54:02','2018-05-22 07:54:42',0,'Box C1 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(79,'C_3_Box11',1,NULL,'2018-05-22 07:56:21','2018-05-22 07:56:35',0,'Box C3 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(80,'C_2_Box11',1,NULL,'2018-05-22 07:56:52','2018-05-22 07:57:01',0,'Box C2 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(81,'C_4_Box11',1,NULL,'2018-05-22 07:57:09','2018-05-22 07:57:18',0,'Box C4 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(82,'D_1_Box11',1,NULL,'2018-05-22 07:57:35','2018-05-22 07:57:46',0,'Box D1 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(83,'D_3_Box11',1,NULL,'2018-05-22 07:57:56','2018-05-22 07:58:04',0,'Box D3 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(84,'D_2_Box11',1,NULL,'2018-05-22 07:58:18','2018-05-22 07:58:27',0,'Box D2 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(85,'D_4_Box11',1,NULL,'2018-05-22 07:58:35','2018-05-22 07:58:43',0,'Box D4 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(86,'E_1_Box11',1,NULL,'2018-05-22 07:58:56','2018-05-22 07:59:08',0,'Box E1 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(87,'E_3_Box11',1,NULL,'2018-05-22 07:59:18','2018-05-22 07:59:26',0,'Box E3 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(88,'E_2_Box11',1,NULL,'2018-05-22 07:59:40','2018-05-22 07:59:46',0,'Box E2 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(89,'E_4_Box11',1,NULL,'2018-05-22 07:59:54','2018-05-22 08:00:01',0,'Box E4 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(90,'F_1_Box11',1,NULL,'2018-05-22 08:00:16','2018-05-22 08:00:26',0,'Box F1 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(91,'F_3_Box11',1,NULL,'2018-05-22 08:00:35','2018-05-22 08:00:43',0,'Box F3 11 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 11 m&sup3;',NULL,'','',2,80.00000000,80.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,11,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(92,'C_5_Box18',1,NULL,'2018-05-22 08:01:24','2018-05-22 08:01:55',0,'Box C5 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(93,'C_7_Box18',1,NULL,'2018-05-22 08:02:11','2018-05-22 08:02:20',0,'Box C7 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(94,'C_9_Box18',1,NULL,'2018-05-22 08:02:30','2018-05-22 08:02:37',0,'Box C9 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,0,0,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(95,'C_11_Box18',1,NULL,'2018-05-22 08:02:44','2018-05-22 08:02:52',0,'Box C11 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(96,'C_13_Box18',1,NULL,'2018-05-22 08:03:03','2018-05-22 08:03:12',0,'Box C13 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(97,'C_6_Box18',1,NULL,'2018-05-22 08:03:39','2018-05-22 08:03:47',0,'Box C6 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(98,'C_8_Box18',1,NULL,'2018-05-22 08:03:53','2018-05-22 08:04:03',0,'Box C8 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(99,'C_10_Box18',1,NULL,'2018-05-22 08:04:13','2018-05-22 08:04:21',0,'Box C10 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(100,'C_12_Box18',1,NULL,'2018-05-22 08:04:42','2018-05-22 08:04:50',0,'Box C12 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(101,'C_14_Box18',1,NULL,'2018-05-22 08:05:00','2018-05-22 08:05:07',0,'Box C14 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(102,'D_5_Box18',1,NULL,'2018-05-22 08:05:36','2018-05-22 08:05:47',0,'Box D5 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(103,'D_7_Box18',1,NULL,'2018-05-22 08:05:59','2018-05-22 08:06:08',0,'Box D7 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(104,'D_9_Box18',1,NULL,'2018-05-22 08:06:16','2018-05-22 08:06:23',0,'Box D9 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(105,'D_11_Box18',1,NULL,'2018-05-22 08:06:31','2018-05-22 08:06:40',0,'Box D11 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(106,'D_13_Box18',1,NULL,'2018-05-22 08:06:49','2018-05-22 08:06:57',0,'Box D13 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(107,'D_6_Box18',1,NULL,'2018-05-22 08:15:41','2018-05-22 08:15:50',0,'Box D6 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(108,'D_8_Box18',1,NULL,'2018-05-22 08:15:57','2018-05-22 08:16:05',0,'Box D8 18 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(109,'D_10_Box18',1,NULL,'2018-05-22 08:16:13','2018-05-22 08:16:20',0,'Box D8 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(110,'D_12_Box18',1,NULL,'2018-05-22 08:16:30','2018-05-22 08:16:39',0,'Box D12 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(111,'D_14_Box18',1,NULL,'2018-05-22 08:16:56','2018-05-22 08:17:05',0,'Box D14 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(112,'E_5_Box18',1,NULL,'2018-05-22 08:17:28','2018-05-22 08:17:37',0,'Box E5 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(113,'E_7_Box18',1,NULL,'2018-05-22 08:17:45','2018-05-22 08:17:53',0,'Box E7 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(114,'E_9_Box18',1,NULL,'2018-05-22 08:18:05','2018-05-22 08:18:11',0,'Box E9 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(115,'E_11_Box18',1,NULL,'2018-05-22 08:18:18','2018-05-22 08:18:25',0,'Box E11 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(116,'E_13_Box18',1,NULL,'2018-05-22 08:18:35','2018-05-22 08:18:44',0,'Box E13 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(117,'E_6_Box18',1,NULL,'2018-05-22 08:19:03','2018-05-22 08:19:12',0,'Box E6 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(118,'E_8_Box18',1,NULL,'2018-05-22 08:20:29','2018-05-22 08:20:42',0,'Box E8 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(119,'E_10_Box18',1,NULL,'2018-05-22 08:20:58','2018-05-22 08:21:05',0,'Box E10 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(120,'E_12_Box18',1,NULL,'2018-05-22 08:21:14','2018-05-22 08:21:25',0,'Box E12 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(121,'E_14_Box18',1,NULL,'2018-05-22 08:21:35','2018-05-22 08:21:43',0,'Box E14 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(122,'F_3_Box18',1,NULL,'2018-05-22 08:22:03','2018-05-22 08:22:13',0,'Box F3 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(123,'F_5_Box18',1,NULL,'2018-05-22 08:22:20','2018-05-22 08:22:29',0,'Box F5 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(124,'F_7_Box18',1,NULL,'2018-05-22 08:22:38','2018-05-22 08:22:46',0,'Box F7 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(125,'F_9_Box18',1,NULL,'2018-05-22 08:22:55','2018-05-22 08:23:01',0,'Box F9 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(126,'F_11_Box18',1,NULL,'2018-05-22 08:23:10','2018-05-22 08:23:19',0,'Box F11 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0),(127,'F_13_Box18',1,NULL,'2018-05-22 08:24:08','2018-05-22 08:24:15',0,'Box F13 10 m³','Box de Acces securise&nbsp;<br />\r\nVolume de 18 m&sup3;',NULL,'','',2,120.00000000,120.00000000,0.00000000,0.00000000,'TTC',NULL,NULL,0.000,0,0.000,'0',0.000,'0',2,2,1,1,0,0,0,'',NULL,NULL,NULL,NULL,'','','','',NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,0,18,0,NULL,0.00000000,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `llx_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_association`
--

DROP TABLE IF EXISTS `llx_product_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_association` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_product_pere` int(11) NOT NULL DEFAULT '0',
  `fk_product_fils` int(11) NOT NULL DEFAULT '0',
  `qty` double DEFAULT NULL,
  `incdec` int(11) DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_association` (`fk_product_pere`,`fk_product_fils`),
  KEY `idx_product_association_fils` (`fk_product_fils`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_association`
--

LOCK TABLES `llx_product_association` WRITE;
/*!40000 ALTER TABLE `llx_product_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_attribute`
--

DROP TABLE IF EXISTS `llx_product_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_attribute` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `rang` int(11) NOT NULL DEFAULT '0',
  `entity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_attribute_ref` (`ref`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_attribute`
--

LOCK TABLES `llx_product_attribute` WRITE;
/*!40000 ALTER TABLE `llx_product_attribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_attribute_combination`
--

DROP TABLE IF EXISTS `llx_product_attribute_combination`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_attribute_combination` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_product_parent` int(11) NOT NULL,
  `fk_product_child` int(11) NOT NULL,
  `variation_price` float NOT NULL,
  `variation_price_percentage` int(11) DEFAULT NULL,
  `variation_weight` float NOT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_attribute_combination`
--

LOCK TABLES `llx_product_attribute_combination` WRITE;
/*!40000 ALTER TABLE `llx_product_attribute_combination` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_attribute_combination` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_attribute_combination2val`
--

DROP TABLE IF EXISTS `llx_product_attribute_combination2val`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_attribute_combination2val` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_prod_combination` int(11) NOT NULL,
  `fk_prod_attr` int(11) NOT NULL,
  `fk_prod_attr_val` int(11) NOT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_attribute_combination2val`
--

LOCK TABLES `llx_product_attribute_combination2val` WRITE;
/*!40000 ALTER TABLE `llx_product_attribute_combination2val` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_attribute_combination2val` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_attribute_value`
--

DROP TABLE IF EXISTS `llx_product_attribute_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_attribute_value` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_product_attribute` int(11) NOT NULL,
  `ref` varchar(180) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `entity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_attribute_value` (`fk_product_attribute`,`ref`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_attribute_value`
--

LOCK TABLES `llx_product_attribute_value` WRITE;
/*!40000 ALTER TABLE `llx_product_attribute_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_attribute_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_batch`
--

DROP TABLE IF EXISTS `llx_product_batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_batch` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_product_stock` int(11) NOT NULL,
  `eatby` datetime DEFAULT NULL,
  `sellby` datetime DEFAULT NULL,
  `batch` varchar(30) NOT NULL,
  `qty` double NOT NULL DEFAULT '0',
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_batch` (`fk_product_stock`,`batch`),
  KEY `idx_fk_product_stock` (`fk_product_stock`),
  KEY `idx_batch` (`batch`),
  CONSTRAINT `fk_product_batch_fk_product_stock` FOREIGN KEY (`fk_product_stock`) REFERENCES `llx_product_stock` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_batch`
--

LOCK TABLES `llx_product_batch` WRITE;
/*!40000 ALTER TABLE `llx_product_batch` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_batch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_customer_price`
--

DROP TABLE IF EXISTS `llx_product_customer_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_customer_price` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_product` int(11) NOT NULL,
  `fk_soc` int(11) NOT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `price_ttc` double(24,8) DEFAULT '0.00000000',
  `price_min` double(24,8) DEFAULT '0.00000000',
  `price_min_ttc` double(24,8) DEFAULT '0.00000000',
  `price_base_type` varchar(3) DEFAULT 'HT',
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) DEFAULT NULL,
  `recuperableonly` int(11) NOT NULL DEFAULT '0',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `fk_user` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_customer_price_fk_product_fk_soc` (`fk_product`,`fk_soc`),
  KEY `idx_product_customer_price_fk_user` (`fk_user`),
  KEY `idx_product_customer_price_fk_soc` (`fk_soc`),
  CONSTRAINT `fk_product_customer_price_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`),
  CONSTRAINT `fk_product_customer_price_fk_soc` FOREIGN KEY (`fk_soc`) REFERENCES `llx_societe` (`rowid`),
  CONSTRAINT `fk_product_customer_price_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_customer_price`
--

LOCK TABLES `llx_product_customer_price` WRITE;
/*!40000 ALTER TABLE `llx_product_customer_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_customer_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_customer_price_log`
--

DROP TABLE IF EXISTS `llx_product_customer_price_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_customer_price_log` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `fk_product` int(11) NOT NULL,
  `fk_soc` int(11) NOT NULL DEFAULT '0',
  `price` double(24,8) DEFAULT '0.00000000',
  `price_ttc` double(24,8) DEFAULT '0.00000000',
  `price_min` double(24,8) DEFAULT '0.00000000',
  `price_min_ttc` double(24,8) DEFAULT '0.00000000',
  `price_base_type` varchar(3) DEFAULT 'HT',
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) DEFAULT NULL,
  `recuperableonly` int(11) NOT NULL DEFAULT '0',
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `fk_user` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_customer_price_log`
--

LOCK TABLES `llx_product_customer_price_log` WRITE;
/*!40000 ALTER TABLE `llx_product_customer_price_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_customer_price_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_extrafields`
--

DROP TABLE IF EXISTS `llx_product_extrafields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_extrafields` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_object` int(11) NOT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  KEY `idx_product_extrafields` (`fk_object`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_extrafields`
--

LOCK TABLES `llx_product_extrafields` WRITE;
/*!40000 ALTER TABLE `llx_product_extrafields` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_extrafields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_fournisseur_price`
--

DROP TABLE IF EXISTS `llx_product_fournisseur_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_fournisseur_price` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `entity` int(11) NOT NULL DEFAULT '1',
  `datec` datetime DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fk_product` int(11) DEFAULT NULL,
  `fk_soc` int(11) DEFAULT NULL,
  `ref_fourn` varchar(30) DEFAULT NULL,
  `fk_availability` int(11) DEFAULT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `quantity` double DEFAULT NULL,
  `remise_percent` double NOT NULL DEFAULT '0',
  `remise` double NOT NULL DEFAULT '0',
  `unitprice` double(24,8) DEFAULT '0.00000000',
  `charges` double(24,8) DEFAULT '0.00000000',
  `unitcharges` double(24,8) DEFAULT '0.00000000',
  `default_vat_code` varchar(10) DEFAULT NULL,
  `tva_tx` double(6,3) NOT NULL,
  `localtax1_tx` double(6,3) DEFAULT '0.000',
  `localtax1_type` varchar(10) NOT NULL DEFAULT '0',
  `localtax2_tx` double(6,3) DEFAULT '0.000',
  `localtax2_type` varchar(10) NOT NULL DEFAULT '0',
  `info_bits` int(11) NOT NULL DEFAULT '0',
  `fk_user` int(11) DEFAULT NULL,
  `fk_supplier_price_expression` int(11) DEFAULT NULL,
  `import_key` varchar(14) DEFAULT NULL,
  `delivery_time_days` int(11) DEFAULT NULL,
  `supplier_reputation` varchar(10) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_price` double(24,8) DEFAULT NULL,
  `multicurrency_price_ttc` double(24,8) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_fournisseur_price_ref` (`ref_fourn`,`fk_soc`,`quantity`,`entity`),
  KEY `idx_product_fournisseur_price_fk_user` (`fk_user`),
  KEY `idx_product_fourn_price_fk_product` (`fk_product`,`entity`),
  KEY `idx_product_fourn_price_fk_soc` (`fk_soc`,`entity`),
  CONSTRAINT `fk_product_fournisseur_price_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`),
  CONSTRAINT `fk_product_fournisseur_price_fk_user` FOREIGN KEY (`fk_user`) REFERENCES `llx_user` (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_fournisseur_price`
--

LOCK TABLES `llx_product_fournisseur_price` WRITE;
/*!40000 ALTER TABLE `llx_product_fournisseur_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_fournisseur_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_fournisseur_price_log`
--

DROP TABLE IF EXISTS `llx_product_fournisseur_price_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_fournisseur_price_log` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `datec` datetime DEFAULT NULL,
  `fk_product_fournisseur` int(11) NOT NULL,
  `price` double(24,8) DEFAULT '0.00000000',
  `quantity` double DEFAULT NULL,
  `fk_user` int(11) DEFAULT NULL,
  `fk_multicurrency` int(11) DEFAULT NULL,
  `multicurrency_code` varchar(255) DEFAULT NULL,
  `multicurrency_tx` double(24,8) DEFAULT '1.00000000',
  `multicurrency_price` double(24,8) DEFAULT NULL,
  `multicurrency_price_ttc` double(24,8) DEFAULT NULL,
  PRIMARY KEY (`rowid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_fournisseur_price_log`
--

LOCK TABLES `llx_product_fournisseur_price_log` WRITE;
/*!40000 ALTER TABLE `llx_product_fournisseur_price_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `llx_product_fournisseur_price_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `llx_product_lang`
--

DROP TABLE IF EXISTS `llx_product_lang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `llx_product_lang` (
  `rowid` int(11) NOT NULL AUTO_INCREMENT,
  `fk_product` int(11) NOT NULL DEFAULT '0',
  `lang` varchar(5) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL,
  `description` text,
  `note` text,
  `import_key` varchar(14) DEFAULT NULL,
  PRIMARY KEY (`rowid`),
  UNIQUE KEY `uk_product_lang` (`fk_product`,`lang`),
  CONSTRAINT `fk_product_lang_fk_product` FOREIGN KEY (`fk_product`) REFERENCES `llx_product` (`rowid`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `llx_product_lang`
--

LOCK TABLES `llx_product_lang` WRITE;
/*!40000 ALTER TABLE `llx_product_lang` DISABLE KEYS */;
INSERT INTO `llx_product_lang` VALUES (1,1,'fr_BE','Box A1 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(2,2,'fr_BE','Box A3 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(3,3,'fr_BE','Box A5 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(4,4,'fr_BE','Box A7 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(5,5,'fr_BE','Box A9 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(6,6,'fr_BE','Box A11 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(7,7,'fr_BE','Box A13 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(8,8,'fr_BE','Box A15 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(9,9,'fr_BE','Box A17 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(10,10,'fr_BE','Box A19 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(11,11,'fr_BE','Box A21 3,7m³','Box de Acces securise&nbsp;<br />\r\nVolume de 3,7 m&sup3;',NULL,NULL),(12,12,'fr_BE','Box 